/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.v4.widget;

import android.content.Context;
import android.os.Build;
import android.view.animation.Interpolator;
import android.widget.Scroller;
import com.dcloud.android.v4.widget.ScrollerCompatGingerbread;
import com.dcloud.android.v4.widget.ScrollerCompatIcs;

public class ScrollerCompat {
    static final ScrollerCompatImpl IMPL;
    Object mScroller;

    public static ScrollerCompat create(Context context) {
        return ScrollerCompat.create(context, null);
    }

    public static ScrollerCompat create(Context context, Interpolator interpolator) {
        return new ScrollerCompat(context, interpolator);
    }

    ScrollerCompat(Context context, Interpolator interpolator) {
        this.mScroller = IMPL.createScroller(context, interpolator);
    }

    static {
        int n5 = Build.VERSION.SDK_INT;
        IMPL = n5 >= 14 ? new ScrollerCompatImplIcs() : (n5 >= 9 ? new ScrollerCompatImplGingerbread() : new ScrollerCompatImplBase());
    }

    public boolean isFinished() {
        return IMPL.isFinished(this.mScroller);
    }

    public int getCurrX() {
        return IMPL.getCurrX(this.mScroller);
    }

    public int getCurrY() {
        return IMPL.getCurrY(this.mScroller);
    }

    public int getFinalX() {
        return IMPL.getFinalX(this.mScroller);
    }

    public int getFinalY() {
        return IMPL.getFinalY(this.mScroller);
    }

    public float getCurrVelocity() {
        return IMPL.getCurrVelocity(this.mScroller);
    }

    public boolean computeScrollOffset() {
        return IMPL.computeScrollOffset(this.mScroller);
    }

    public void startScroll(int n5, int n6, int n7, int n8) {
        IMPL.startScroll(this.mScroller, n5, n6, n7, n8);
    }

    public void startScroll(int n5, int n6, int n7, int n8, int n9) {
        IMPL.startScroll(this.mScroller, n5, n6, n7, n8, n9);
    }

    public void fling(int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        IMPL.fling(this.mScroller, n5, n6, n7, n8, n9, n10, n11, n12);
    }

    public void fling(int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14) {
        IMPL.fling(this.mScroller, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14);
    }

    public void abortAnimation() {
        IMPL.abortAnimation(this.mScroller);
    }

    public void notifyHorizontalEdgeReached(int n5, int n6, int n7) {
        IMPL.notifyHorizontalEdgeReached(this.mScroller, n5, n6, n7);
    }

    public void notifyVerticalEdgeReached(int n5, int n6, int n7) {
        IMPL.notifyVerticalEdgeReached(this.mScroller, n5, n6, n7);
    }

    public boolean isOverScrolled() {
        return IMPL.isOverScrolled(this.mScroller);
    }

    static interface ScrollerCompatImpl {
        public Object createScroller(Context var1, Interpolator var2);

        public boolean isFinished(Object var1);

        public int getCurrX(Object var1);

        public int getCurrY(Object var1);

        public float getCurrVelocity(Object var1);

        public boolean computeScrollOffset(Object var1);

        public void startScroll(Object var1, int var2, int var3, int var4, int var5);

        public void startScroll(Object var1, int var2, int var3, int var4, int var5, int var6);

        public void fling(Object var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9);

        public void fling(Object var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

        public void abortAnimation(Object var1);

        public void notifyHorizontalEdgeReached(Object var1, int var2, int var3, int var4);

        public void notifyVerticalEdgeReached(Object var1, int var2, int var3, int var4);

        public boolean isOverScrolled(Object var1);

        public int getFinalX(Object var1);

        public int getFinalY(Object var1);
    }

    static class ScrollerCompatImplIcs
    extends ScrollerCompatImplGingerbread {
        ScrollerCompatImplIcs() {
        }

        @Override
        public float getCurrVelocity(Object object) {
            return ScrollerCompatIcs.getCurrVelocity(object);
        }
    }

    static class ScrollerCompatImplGingerbread
    implements ScrollerCompatImpl {
        ScrollerCompatImplGingerbread() {
        }

        @Override
        public Object createScroller(Context context, Interpolator interpolator) {
            return ScrollerCompatGingerbread.createScroller(context, interpolator);
        }

        @Override
        public boolean isFinished(Object object) {
            return ScrollerCompatGingerbread.isFinished(object);
        }

        @Override
        public int getCurrX(Object object) {
            return ScrollerCompatGingerbread.getCurrX(object);
        }

        @Override
        public int getCurrY(Object object) {
            return ScrollerCompatGingerbread.getCurrY(object);
        }

        @Override
        public float getCurrVelocity(Object object) {
            return 0.0f;
        }

        @Override
        public boolean computeScrollOffset(Object object) {
            return ScrollerCompatGingerbread.computeScrollOffset(object);
        }

        @Override
        public void startScroll(Object object, int n5, int n6, int n7, int n8) {
            ScrollerCompatGingerbread.startScroll(object, n5, n6, n7, n8);
        }

        @Override
        public void startScroll(Object object, int n5, int n6, int n7, int n8, int n9) {
            ScrollerCompatGingerbread.startScroll(object, n5, n6, n7, n8, n9);
        }

        @Override
        public void fling(Object object, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
            ScrollerCompatGingerbread.fling(object, n5, n6, n7, n8, n9, n10, n11, n12);
        }

        @Override
        public void fling(Object object, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14) {
            ScrollerCompatGingerbread.fling(object, n5, n6, n7, n8, n9, n10, n11, n12, n13, n14);
        }

        @Override
        public void abortAnimation(Object object) {
            ScrollerCompatGingerbread.abortAnimation(object);
        }

        @Override
        public void notifyHorizontalEdgeReached(Object object, int n5, int n6, int n7) {
            ScrollerCompatGingerbread.notifyHorizontalEdgeReached(object, n5, n6, n7);
        }

        @Override
        public void notifyVerticalEdgeReached(Object object, int n5, int n6, int n7) {
            ScrollerCompatGingerbread.notifyVerticalEdgeReached(object, n5, n6, n7);
        }

        @Override
        public boolean isOverScrolled(Object object) {
            return ScrollerCompatGingerbread.isOverScrolled(object);
        }

        @Override
        public int getFinalX(Object object) {
            return ScrollerCompatGingerbread.getFinalX(object);
        }

        @Override
        public int getFinalY(Object object) {
            return ScrollerCompatGingerbread.getFinalY(object);
        }
    }

    static class ScrollerCompatImplBase
    implements ScrollerCompatImpl {
        ScrollerCompatImplBase() {
        }

        @Override
        public Object createScroller(Context context, Interpolator interpolator) {
            if (interpolator != null) {
                return new Scroller(context, interpolator);
            }
            return new Scroller(context);
        }

        @Override
        public boolean isFinished(Object object) {
            return ((Scroller)object).isFinished();
        }

        @Override
        public int getCurrX(Object object) {
            return ((Scroller)object).getCurrX();
        }

        @Override
        public int getCurrY(Object object) {
            return ((Scroller)object).getCurrY();
        }

        @Override
        public float getCurrVelocity(Object object) {
            return 0.0f;
        }

        @Override
        public boolean computeScrollOffset(Object object) {
            return ((Scroller)object).computeScrollOffset();
        }

        @Override
        public void startScroll(Object object, int n5, int n6, int n7, int n8) {
            ((Scroller)object).startScroll(n5, n6, n7, n8);
        }

        @Override
        public void startScroll(Object object, int n5, int n6, int n7, int n8, int n9) {
            ((Scroller)object).startScroll(n5, n6, n7, n8, n9);
        }

        @Override
        public void fling(Object object, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
            ((Scroller)object).fling(n5, n6, n7, n8, n9, n10, n11, n12);
        }

        @Override
        public void fling(Object object, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14) {
            ((Scroller)object).fling(n5, n6, n7, n8, n9, n10, n11, n12);
        }

        @Override
        public void abortAnimation(Object object) {
            ((Scroller)object).abortAnimation();
        }

        @Override
        public void notifyHorizontalEdgeReached(Object object, int n5, int n6, int n7) {
        }

        @Override
        public void notifyVerticalEdgeReached(Object object, int n5, int n6, int n7) {
        }

        @Override
        public boolean isOverScrolled(Object object) {
            return false;
        }

        @Override
        public int getFinalX(Object object) {
            return ((Scroller)object).getFinalX();
        }

        @Override
        public int getFinalY(Object object) {
            return ((Scroller)object).getFinalY();
        }
    }
}

