/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.http2;

import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okhttp3.internal.http2.Header;
import dc.squareup.okhttp3.internal.http2.Huffman;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSink;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.ByteString;
import dc.squareup.okio.Okio;
import dc.squareup.okio.Source;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

final class Hpack {
    private static final int PREFIX_4_BITS = 15;
    private static final int PREFIX_5_BITS = 31;
    private static final int PREFIX_6_BITS = 63;
    private static final int PREFIX_7_BITS = 127;
    static final Header[] STATIC_HEADER_TABLE;
    static final Map<ByteString, Integer> NAME_TO_FIRST_INDEX;

    private Hpack() {
    }

    private static Map<ByteString, Integer> nameToFirstIndex() {
        LinkedHashMap<Header[], Integer> linkedHashMap;
        LinkedHashMap<Header[], Integer> linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap<Header[], Integer>(STATIC_HEADER_TABLE.length);
        int n5 = 0;
        while (true) {
            Object object = STATIC_HEADER_TABLE;
            if (n5 >= STATIC_HEADER_TABLE.length) break;
            if (!linkedHashMap2.containsKey(object[n5].name)) {
                object = object[n5].name;
                linkedHashMap2.put((Header[])object, n5);
            }
            ++n5;
        }
        return Collections.unmodifiableMap(linkedHashMap2);
    }

    static ByteString checkLowercase(ByteString byteString) throws IOException {
        int n5 = byteString.size();
        for (int i5 = 0; i5 < n5; ++i5) {
            byte by = byteString.getByte(i5);
            if (by < 65 || by > 90) continue;
            throw new IOException("PROTOCOL_ERROR response malformed: mixed case name: " + byteString.utf8());
        }
        return byteString;
    }

    static {
        Header header;
        Header header2;
        Header header3;
        Header header4;
        Header header5;
        Header header6;
        Header header7;
        Header header8;
        Header header9;
        Header header10;
        Header header11;
        Header header12;
        Header header13;
        Header header14;
        Header header15;
        Header header16;
        Header header17;
        Header header18;
        Header header19;
        Header header20;
        Header header21;
        Header header22;
        Header header23;
        Header header24;
        Header header25;
        Header header26;
        Header header27;
        Header header28;
        Header header29;
        Header header30;
        Header header31;
        Header header32;
        Header header33;
        Header header34;
        Header header35;
        Header header36;
        Header header37;
        Header header38;
        Header header39;
        Header header40;
        Header header41;
        Header header42;
        Header header43;
        Header header44;
        Header header45;
        Header header46;
        Header header47;
        Header header48;
        Header header49;
        Header header50;
        Header header51;
        Header header52;
        Header header53;
        Header header54;
        Header header55;
        Header header56;
        Header header57;
        Header header58;
        Header header59;
        Header header60;
        Header header61;
        Header header62 = header61;
        header61 = new Header(Header.TARGET_AUTHORITY, "");
        Header header63 = header60;
        Object object = Header.TARGET_METHOD;
        header60 = new Header((ByteString)object, "GET");
        Header header64 = header59;
        header59 = new Header((ByteString)object, "POST");
        object = header58;
        Object object2 = Header.TARGET_PATH;
        header58 = new Header((ByteString)object2, "/");
        Header header65 = header57;
        header57 = new Header((ByteString)object2, "/index.html");
        object2 = header56;
        Object object3 = Header.TARGET_SCHEME;
        header56 = new Header((ByteString)object3, "http");
        Header header66 = header55;
        header55 = new Header((ByteString)object3, "https");
        object3 = header54;
        Object object4 = Header.RESPONSE_STATUS;
        header54 = new Header((ByteString)object4, "200");
        Header header67 = header53;
        header53 = new Header((ByteString)object4, "204");
        Header header68 = header52;
        header52 = new Header((ByteString)object4, "206");
        Header header69 = header51;
        header51 = new Header((ByteString)object4, "304");
        Header header70 = header50;
        header50 = new Header((ByteString)object4, "400");
        Header header71 = header49;
        header49 = new Header((ByteString)object4, "404");
        Header header72 = header48;
        header48 = new Header((ByteString)object4, "500");
        object4 = header47;
        header47 = new Header("accept-charset", "");
        Header header73 = header46;
        header46 = new Header("accept-encoding", "gzip, deflate");
        Header header74 = header45;
        header45 = new Header("accept-language", "");
        Header header75 = header44;
        header44 = new Header("accept-ranges", "");
        Header header76 = header43;
        header43 = new Header("accept", "");
        Header header77 = header42;
        header42 = new Header("access-control-allow-origin", "");
        Header header78 = header41;
        header41 = new Header("age", "");
        Header header79 = header40;
        header40 = new Header("allow", "");
        Header header80 = header39;
        header39 = new Header("authorization", "");
        Header header81 = header38;
        header38 = new Header("cache-control", "");
        Header header82 = header37;
        header37 = new Header("content-disposition", "");
        Header header83 = header36;
        header36 = new Header("content-encoding", "");
        Header header84 = header35;
        header35 = new Header("content-language", "");
        Header header85 = header34;
        header34 = new Header("content-length", "");
        Header header86 = header33;
        header33 = new Header("content-location", "");
        Header header87 = header32;
        header32 = new Header("content-range", "");
        Header header88 = header31;
        header31 = new Header("content-type", "");
        Header header89 = header30;
        header30 = new Header("cookie", "");
        Header header90 = header29;
        header29 = new Header("date", "");
        Header header91 = header28;
        header28 = new Header("etag", "");
        Header header92 = header27;
        header27 = new Header("expect", "");
        Header header93 = header26;
        header26 = new Header("expires", "");
        Header header94 = header25;
        header25 = new Header("from", "");
        Header header95 = header24;
        header24 = new Header("host", "");
        Header header96 = header23;
        header23 = new Header("if-match", "");
        Header header97 = header22;
        header22 = new Header("if-modified-since", "");
        Header header98 = header21;
        header21 = new Header("if-none-match", "");
        Header header99 = header20;
        header20 = new Header("if-range", "");
        Header header100 = header19;
        header19 = new Header("if-unmodified-since", "");
        Header header101 = header18;
        header18 = new Header("last-modified", "");
        Header header102 = header17;
        header17 = new Header("link", "");
        Header header103 = header16;
        header16 = new Header("location", "");
        Header header104 = header15;
        header15 = new Header("max-forwards", "");
        Header header105 = header14;
        header14 = new Header("proxy-authenticate", "");
        Header header106 = header13;
        header13 = new Header("proxy-authorization", "");
        Header header107 = header12;
        header12 = new Header("range", "");
        Header header108 = header11;
        header11 = new Header("referer", "");
        Header header109 = header10;
        header10 = new Header("refresh", "");
        Header header110 = header9;
        header9 = new Header("retry-after", "");
        Header header111 = header8;
        header8 = new Header("server", "");
        Header header112 = header7;
        header7 = new Header("set-cookie", "");
        Header header113 = header6;
        header6 = new Header("strict-transport-security", "");
        Header header114 = header5;
        header5 = new Header("transfer-encoding", "");
        Header header115 = header4;
        header4 = new Header("user-agent", "");
        Header header116 = header3;
        header3 = new Header("vary", "");
        Header header117 = header2;
        header2 = new Header("via", "");
        Header header118 = header;
        header = new Header("www-authenticate", "");
        Header[] headerArray = new Header[61];
        Header[] headerArray2 = headerArray;
        headerArray[0] = header62;
        headerArray2[1] = header63;
        headerArray2[2] = header64;
        headerArray2[3] = object;
        headerArray2[4] = header65;
        headerArray2[5] = object2;
        headerArray2[6] = header66;
        headerArray2[7] = object3;
        headerArray2[8] = header67;
        headerArray2[9] = header68;
        headerArray2[10] = header69;
        headerArray2[11] = header70;
        headerArray2[12] = header71;
        headerArray2[13] = header72;
        headerArray2[14] = object4;
        headerArray2[15] = header73;
        headerArray2[16] = header74;
        headerArray2[17] = header75;
        headerArray2[18] = header76;
        headerArray2[19] = header77;
        headerArray2[20] = header78;
        headerArray2[21] = header79;
        headerArray2[22] = header80;
        headerArray2[23] = header81;
        headerArray2[24] = header82;
        headerArray2[25] = header83;
        headerArray2[26] = header84;
        headerArray2[27] = header85;
        headerArray2[28] = header86;
        headerArray2[29] = header87;
        headerArray2[30] = header88;
        headerArray2[31] = header89;
        headerArray2[32] = header90;
        headerArray2[33] = header91;
        headerArray2[34] = header92;
        headerArray2[35] = header93;
        headerArray2[36] = header94;
        headerArray2[37] = header95;
        headerArray2[38] = header96;
        headerArray2[39] = header97;
        headerArray2[40] = header98;
        headerArray2[41] = header99;
        headerArray2[42] = header100;
        headerArray2[43] = header101;
        headerArray2[44] = header102;
        headerArray2[45] = header103;
        headerArray2[46] = header104;
        headerArray2[47] = header105;
        headerArray2[48] = header106;
        headerArray2[49] = header107;
        headerArray2[50] = header108;
        headerArray2[51] = header109;
        headerArray2[52] = header110;
        headerArray2[53] = header111;
        headerArray2[54] = header112;
        headerArray2[55] = header113;
        headerArray2[56] = header114;
        headerArray2[57] = header115;
        headerArray2[58] = header116;
        headerArray2[59] = header117;
        headerArray2[60] = header118;
        STATIC_HEADER_TABLE = headerArray2;
        NAME_TO_FIRST_INDEX = Hpack.nameToFirstIndex();
    }

    static final class Writer {
        private static final int SETTINGS_HEADER_TABLE_SIZE = 4096;
        private static final int SETTINGS_HEADER_TABLE_SIZE_LIMIT = 16384;
        private final Buffer out;
        private final boolean useCompression;
        private int smallestHeaderTableSizeSetting;
        private boolean emitDynamicTableSizeUpdate;
        int headerTableSizeSetting;
        int maxDynamicTableByteCount;
        Header[] dynamicTable;
        int nextHeaderIndex;
        int headerCount;
        int dynamicTableByteCount;

        Writer(Buffer buffer) {
            this(4096, true, buffer);
        }

        Writer(int n5, boolean bl, Buffer buffer) {
            Header[] headerArray = headerArray6;
            Header[] headerArray2 = headerArray6;
            Header[] headerArray3 = headerArray6;
            Header[] headerArray4 = headerArray6;
            Header[] headerArray5 = headerArray6;
            headerArray5.smallestHeaderTableSizeSetting = Integer.MAX_VALUE;
            Header[] headerArray6 = new Header[8];
            v5.dynamicTable = headerArray6;
            headerArray5.nextHeaderIndex = headerArray6.length - 1;
            v5.headerCount = 0;
            headerArray5.dynamicTableByteCount = 0;
            headerArray4.headerTableSizeSetting = n5;
            headerArray3.maxDynamicTableByteCount = n5;
            headerArray2.useCompression = bl;
            headerArray.out = buffer;
        }

        private void clearDynamicTable() {
            Writer writer = this;
            Arrays.fill(writer.dynamicTable, null);
            writer.nextHeaderIndex = writer.dynamicTable.length - 1;
            writer.headerCount = 0;
            writer.dynamicTableByteCount = 0;
        }

        private int evictToRecoverBytes(int n5) {
            int n6 = 0;
            if (n5 > 0) {
                int n7;
                int n8;
                for (n8 = this.dynamicTable.length - 1; n8 >= (n7 = this.nextHeaderIndex) && n5 > 0; --n8) {
                    Writer writer = this;
                    int n9 = n5;
                    n5 = this.dynamicTable[n8].hpackSize;
                    n7 = n9 - n5;
                    writer.dynamicTableByteCount -= n5;
                    --writer.headerCount;
                    ++n6;
                    n5 = n7;
                }
                Writer writer = this;
                int n10 = n7;
                n5 = n10 + 1;
                n8 = n10 + 1 + n6;
                n7 = this.headerCount;
                System.arraycopy(writer.dynamicTable, n5, writer.dynamicTable, n8, n7);
                int n11 = this.nextHeaderIndex;
                int n12 = n11 + 1;
                Arrays.fill(writer.dynamicTable, n12, n11 + 1 + n6, null);
                writer.nextHeaderIndex += n6;
                return n6;
            }
            return n6;
        }

        private void insertIntoDynamicTable(Header header) {
            int n5 = header.hpackSize;
            int n6 = this.maxDynamicTableByteCount;
            if (n5 > n6) {
                this.clearDynamicTable();
                return;
            }
            Writer writer = this;
            writer.evictToRecoverBytes(writer.dynamicTableByteCount + n5 - n6);
            Header[] headerArray = this.dynamicTable;
            if (writer.headerCount + 1 > this.dynamicTable.length) {
                Header[] headerArray2 = headerArray;
                headerArray = new Header[headerArray.length * 2];
                int n7 = headerArray2.length;
                int n8 = headerArray.length;
                System.arraycopy(headerArray2, 0, headerArray, n7, n8);
                this.nextHeaderIndex = this.dynamicTable.length - 1;
                this.dynamicTable = headerArray;
            }
            Writer writer2 = this;
            int n9 = writer2.nextHeaderIndex;
            writer2.nextHeaderIndex = n9 - 1;
            writer2.dynamicTable[n9] = header;
            ++writer2.headerCount;
            writer2.dynamicTableByteCount += n5;
        }

        private void adjustDynamicTableByteCount() {
            int n5 = this.maxDynamicTableByteCount;
            int n6 = this.dynamicTableByteCount;
            if (n5 < n6) {
                if (n5 == 0) {
                    this.clearDynamicTable();
                    return;
                }
                this.evictToRecoverBytes(n6 - n5);
                return;
            }
        }

        /*
         * Unable to fully structure code
         */
        void writeHeaders(List<Header> var1_1) throws IOException {
            if (this.emitDynamicTableSizeUpdate) {
                var2_2 = this.smallestHeaderTableSizeSetting;
                if (var2_2 < this.maxDynamicTableByteCount) {
                    this.writeInt(var2_2, 31, 32);
                }
                this.emitDynamicTableSizeUpdate = false;
                this.smallestHeaderTableSizeSetting = 0x7FFFFFFF;
                this.writeInt(this.maxDynamicTableByteCount, 31, 32);
            }
            var3_3 = var1_1.size();
            for (var2_2 = 0; var2_2 < var3_3; ++var2_2) {
                block13: {
                    var4_4 = var1_1.get(var2_2);
                    var5_5 = var4_4.name.toAsciiLowercase();
                    var6_6 = var4_4.value;
                    var7_7 = -1;
                    var8_8 = -1;
                    var9_9 = Hpack.NAME_TO_FIRST_INDEX.get(var5_5);
                    if (var9_9 == null) break block13;
                    var8_8 = var9_9;
                    var9_10 = var8_8 + 1;
                    if (var9_10 <= 1 || var9_10 >= 8) ** GOTO lbl-1000
                    var10_12 = Hpack.STATIC_HEADER_TABLE;
                    if (Util.equal(Hpack.STATIC_HEADER_TABLE[var8_8].value, var6_6)) {
                        var8_8 = var9_10;
                        var7_7 = var9_10;
                    } else if (Util.equal(var10_12[var9_10].value, var6_6)) {
                        var7_7 = var8_8 + 2;
                        var8_8 = var9_10;
                    } else lbl-1000:
                    // 2 sources

                    {
                        var8_8 = var9_10;
                    }
                }
                if (var7_7 == -1) {
                    var10_13 = this.dynamicTable.length;
                    for (var9_11 = this.nextHeaderIndex + 1; var9_11 < var10_13; ++var9_11) {
                        if (!Util.equal(this.dynamicTable[var9_11].name, var5_5)) continue;
                        if (Util.equal(this.dynamicTable[var9_11].value, var6_6)) {
                            var7_7 = var9_11 - this.nextHeaderIndex + Hpack.STATIC_HEADER_TABLE.length;
                            break;
                        }
                        if (var8_8 != -1) continue;
                        var8_8 = var9_11 - this.nextHeaderIndex + Hpack.STATIC_HEADER_TABLE.length;
                    }
                }
                if (var7_7 != -1) {
                    this.writeInt(var7_7, 127, 128);
                    continue;
                }
                if (var8_8 == -1) {
                    this.out.writeByte(64);
                    this.writeByteString(var5_5);
                    this.writeByteString(var6_6);
                    this.insertIntoDynamicTable(var4_4);
                    continue;
                }
                if (var5_5.startsWith(Header.PSEUDO_PREFIX) && !Header.TARGET_AUTHORITY.equals(var5_5)) {
                    this.writeInt(var8_8, 15, 0);
                    this.writeByteString(var6_6);
                    continue;
                }
                this.writeInt(var8_8, 63, 64);
                this.writeByteString(var6_6);
                this.insertIntoDynamicTable(var4_4);
            }
        }

        void writeInt(int n5, int n6, int n7) {
            if (n5 < n6) {
                this.out.writeByte(n7 | n5);
                return;
            }
            this.out.writeByte(n7 | n6);
            n5 -= n6;
            while (n5 >= 128) {
                int n8 = n5;
                this.out.writeByte((n5 &= 0x7F) | 0x80);
                n5 = n8 >>> 7;
            }
            this.out.writeByte(n5);
        }

        void writeByteString(ByteString byteString) throws IOException {
            if (((Writer)object).useCompression && Huffman.get().encodedLength(byteString) < byteString.size()) {
                Buffer buffer;
                Writer writer = object;
                Object object = buffer;
                buffer = new Buffer();
                Huffman.get().encode(byteString, (BufferedSink)object);
                object = buffer.readByteString();
                writer.writeInt(((ByteString)object).size(), 127, 128);
                writer.out.write((ByteString)object);
                return;
            }
            Writer writer = object;
            writer.writeInt(byteString.size(), 127, 0);
            writer.out.write(byteString);
        }

        void setHeaderTableSizeSetting(int n5) {
            this.headerTableSizeSetting = n5;
            int n6 = this.maxDynamicTableByteCount;
            if (n6 == (n5 = Math.min(n5, 16384))) {
                return;
            }
            if (n5 < n6) {
                this.smallestHeaderTableSizeSetting = Math.min(this.smallestHeaderTableSizeSetting, n5);
            }
            this.emitDynamicTableSizeUpdate = true;
            this.maxDynamicTableByteCount = n5;
            this.adjustDynamicTableByteCount();
        }
    }

    static final class Reader {
        private final List<Header> headerList;
        private final BufferedSource source;
        private final int headerTableSizeSetting;
        private int maxDynamicTableByteCount;
        Header[] dynamicTable;
        int nextHeaderIndex;
        int headerCount;
        int dynamicTableByteCount;

        Reader(int n5, Source source) {
            int n6 = n5;
            this(n6, n6, source);
        }

        Reader(int n5, int n6, Source source) {
            Header[] headerArray = headerArray5;
            Header[] headerArray2 = headerArray5;
            Header[] headerArray3 = headerArray5;
            Header[] headerArray4 = headerArray5;
            headerArray4.headerList = new ArrayList<Header>();
            Header[] headerArray5 = new Header[8];
            v4.dynamicTable = headerArray5;
            headerArray4.nextHeaderIndex = headerArray5.length - 1;
            v4.headerCount = 0;
            headerArray4.dynamicTableByteCount = 0;
            headerArray3.headerTableSizeSetting = n5;
            headerArray2.maxDynamicTableByteCount = n6;
            headerArray.source = Okio.buffer(source);
        }

        private void adjustDynamicTableByteCount() {
            int n5 = this.maxDynamicTableByteCount;
            int n6 = this.dynamicTableByteCount;
            if (n5 < n6) {
                if (n5 == 0) {
                    this.clearDynamicTable();
                    return;
                }
                this.evictToRecoverBytes(n6 - n5);
                return;
            }
        }

        private void clearDynamicTable() {
            Reader reader = this;
            Arrays.fill(reader.dynamicTable, null);
            reader.nextHeaderIndex = reader.dynamicTable.length - 1;
            reader.headerCount = 0;
            reader.dynamicTableByteCount = 0;
        }

        private int evictToRecoverBytes(int n5) {
            int n6 = 0;
            if (n5 > 0) {
                int n7;
                int n8;
                for (n8 = this.dynamicTable.length - 1; n8 >= (n7 = this.nextHeaderIndex) && n5 > 0; --n8) {
                    Reader reader = this;
                    int n9 = n5;
                    n5 = this.dynamicTable[n8].hpackSize;
                    n7 = n9 - n5;
                    reader.dynamicTableByteCount -= n5;
                    --reader.headerCount;
                    ++n6;
                    n5 = n7;
                }
                Reader reader = this;
                int n10 = n7;
                int n11 = n10 + 1;
                n5 = n10 + 1 + n6;
                n8 = this.headerCount;
                System.arraycopy(reader.dynamicTable, n11, reader.dynamicTable, n5, n8);
                reader.nextHeaderIndex += n6;
                return n6;
            }
            return n6;
        }

        private void readIndexedHeader(int n5) throws IOException {
            if (((Reader)((Object)header)).isStaticHeader(n5)) {
                Reader reader = header;
                Header header = STATIC_HEADER_TABLE[n5];
                reader.headerList.add(header);
                return;
            }
            int n6 = ((Reader)((Object)header)).dynamicTableIndex(n5 - STATIC_HEADER_TABLE.length);
            if (n6 >= 0) {
                Header[] headerArray = ((Reader)((Object)header)).dynamicTable;
                if (n6 < ((Reader)((Object)header)).dynamicTable.length) {
                    ((Reader)((Object)header)).headerList.add(headerArray[n6]);
                    return;
                }
            }
            throw new IOException("Header index too large " + (n5 + 1));
        }

        private int dynamicTableIndex(int n5) {
            return this.nextHeaderIndex + 1 + n5;
        }

        private void readLiteralHeaderWithoutIndexingIndexedName(int n5) throws IOException {
            Reader reader = byteString;
            ByteString byteString = reader.getName(n5);
            ByteString byteString2 = reader.readByteString();
            reader.headerList.add(new Header(byteString, byteString2));
        }

        private void readLiteralHeaderWithoutIndexingNewName() throws IOException {
            Reader reader = byteString;
            ByteString byteString = Hpack.checkLowercase(reader.readByteString());
            ByteString byteString2 = reader.readByteString();
            reader.headerList.add(new Header(byteString, byteString2));
        }

        private void readLiteralHeaderWithIncrementalIndexingIndexedName(int n5) throws IOException {
            Header header;
            Reader reader = byteString;
            ByteString byteString = reader.getName(n5);
            ByteString byteString2 = reader.readByteString();
            Header header2 = header;
            header = new Header(byteString, byteString2);
            reader.insertIntoDynamicTable(-1, header2);
        }

        private void readLiteralHeaderWithIncrementalIndexingNewName() throws IOException {
            Header header;
            Reader reader = byteString;
            ByteString byteString = Hpack.checkLowercase(reader.readByteString());
            ByteString byteString2 = reader.readByteString();
            Header header2 = header;
            header = new Header(byteString, byteString2);
            reader.insertIntoDynamicTable(-1, header2);
        }

        private ByteString getName(int n5) throws IOException {
            if (headerArray.isStaticHeader(n5)) {
                return Hpack.STATIC_HEADER_TABLE[n5].name;
            }
            int n6 = headerArray.dynamicTableIndex(n5 - STATIC_HEADER_TABLE.length);
            if (n6 >= 0) {
                Header[] headerArray = headerArray.dynamicTable;
                if (n6 < headerArray.dynamicTable.length) {
                    return headerArray[n6].name;
                }
            }
            throw new IOException("Header index too large " + (n5 + 1));
        }

        private boolean isStaticHeader(int n5) {
            return n5 >= 0 && n5 <= STATIC_HEADER_TABLE.length - 1;
        }

        private void insertIntoDynamicTable(int n5, Header header) {
            int n6;
            this.headerList.add(header);
            int n7 = header.hpackSize;
            if (n5 != -1) {
                n7 -= this.dynamicTable[this.dynamicTableIndex((int)n5)].hpackSize;
            }
            if (n7 > (n6 = this.maxDynamicTableByteCount)) {
                this.clearDynamicTable();
                return;
            }
            n6 = this.evictToRecoverBytes(this.dynamicTableByteCount + n7 - n6);
            if (n5 == -1) {
                Header[] headerArray = this.dynamicTable;
                if (this.headerCount + 1 > this.dynamicTable.length) {
                    Header[] headerArray2 = headerArray;
                    headerArray = new Header[headerArray.length * 2];
                    n6 = headerArray2.length;
                    int n8 = headerArray.length;
                    System.arraycopy(headerArray2, 0, headerArray, n6, n8);
                    this.nextHeaderIndex = this.dynamicTable.length - 1;
                    this.dynamicTable = headerArray;
                }
                int n9 = this.nextHeaderIndex;
                this.nextHeaderIndex = n9 - 1;
                this.dynamicTable[n9] = header;
                ++this.headerCount;
            } else {
                this.dynamicTable[n5 + (this.dynamicTableIndex((int)n5) + n6)] = header;
            }
            this.dynamicTableByteCount += n7;
        }

        private int readByte() throws IOException {
            return this.source.readByte() & 0xFF;
        }

        int maxDynamicTableByteCount() {
            return this.maxDynamicTableByteCount;
        }

        void readHeaders() throws IOException {
            while (!this.source.exhausted()) {
                int n5 = this.source.readByte();
                int n6 = n5 & 0xFF;
                if (n6 != 128) {
                    if ((n5 & 0x80) == 128) {
                        Reader reader = this;
                        reader.readIndexedHeader(reader.readInt(n6, 127) - 1);
                        continue;
                    }
                    if (n6 == 64) {
                        this.readLiteralHeaderWithIncrementalIndexingNewName();
                        continue;
                    }
                    if ((n5 & 0x40) == 64) {
                        Reader reader = this;
                        reader.readLiteralHeaderWithIncrementalIndexingIndexedName(reader.readInt(n6, 63) - 1);
                        continue;
                    }
                    if ((n5 & 0x20) == 32) {
                        this.maxDynamicTableByteCount = n5 = this.readInt(n6, 31);
                        if (n5 >= 0 && n5 <= this.headerTableSizeSetting) {
                            this.adjustDynamicTableByteCount();
                            continue;
                        }
                        throw new IOException("Invalid dynamic table size update " + this.maxDynamicTableByteCount);
                    }
                    if (n6 != 16 && n6 != 0) {
                        Reader reader = this;
                        reader.readLiteralHeaderWithoutIndexingIndexedName(reader.readInt(n6, 15) - 1);
                        continue;
                    }
                    this.readLiteralHeaderWithoutIndexingNewName();
                    continue;
                }
                throw new IOException("index == 0");
            }
        }

        public List<Header> getAndResetHeaderList() {
            ArrayList<Header> arrayList = new ArrayList<Header>(this.headerList);
            this.headerList.clear();
            return arrayList;
        }

        int readInt(int n5, int n6) throws IOException {
            int n7;
            if ((n5 &= n6) < n6) {
                return n5;
            }
            n5 = 0;
            while (((n7 = this.readByte()) & 0x80) != 0) {
                n6 += (n7 & 0x7F) << n5;
                n5 += 7;
            }
            return n6 + (n7 << n5);
        }

        ByteString readByteString() throws IOException {
            int n5 = this.readByte();
            boolean bl = (n5 & 0x80) == 128;
            n5 = this.readInt(n5, 127);
            if (bl) {
                return ByteString.of(Huffman.get().decode(this.source.readByteArray(n5)));
            }
            return this.source.readByteString(n5);
        }
    }
}

