/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.richtext.node;

import android.content.Context;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.dom.WXCustomStyleSpan;
import com.taobao.weex.ui.component.richtext.node.RichTextNodeManager;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXResourceUtils;
import io.dcloud.feature.uniapp.dom.AbsStyle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public abstract class RichTextNode {
    public static final String TYPE = "type";
    public static final String STYLE = "style";
    public static final String ATTR = "attr";
    public static final String CHILDREN = "children";
    public static final String VALUE = "value";
    public static final String ITEM_CLICK = "itemclick";
    public static final String PSEUDO_REF = "pseudoRef";
    private static final int MAX_LEVEL = 255;
    protected final Context mContext;
    protected final String mInstanceId;
    protected final String mComponentRef;
    protected final String mRef;
    protected Map<String, Object> style;
    protected Map<String, Object> attr;
    protected List<RichTextNode> children;

    protected RichTextNode(Context context, String string2, String string3) {
        this.mContext = context;
        this.mInstanceId = string2;
        this.mComponentRef = string3;
        this.mRef = null;
    }

    protected RichTextNode(Context context, String string2, String string3, String string4, Map<String, Object> map, Map<String, Object> map2) {
        LinkedList linkedList;
        ((RichTextNode)((Object)linkedList2)).mContext = context;
        ((RichTextNode)((Object)linkedList2)).mInstanceId = string2;
        ((RichTextNode)((Object)linkedList2)).mComponentRef = string3;
        ((RichTextNode)((Object)linkedList2)).mRef = string4;
        if (map != null) {
            ((RichTextNode)((Object)linkedList2)).style = map;
        } else {
            ArrayMap arrayMap;
            context = arrayMap;
            arrayMap = new ArrayMap(0);
            ((RichTextNode)((Object)linkedList2)).style = context;
        }
        if (map2 != null) {
            ((RichTextNode)((Object)linkedList2)).attr = map2;
        } else {
            ArrayMap arrayMap;
            context = arrayMap;
            arrayMap = new ArrayMap(0);
            ((RichTextNode)((Object)linkedList2)).attr = context;
        }
        RichTextNode richTextNode = linkedList2;
        LinkedList linkedList2 = linkedList;
        linkedList = new LinkedList();
        richTextNode.children = linkedList2;
    }

    @NonNull
    public static Spannable parse(@NonNull Context context, @NonNull String string2, @NonNull String string3, String string4) {
        if ((string4 = JSON.parseArray((String)string4)) != null && !string4.isEmpty()) {
            ArrayList<RichTextNode> arrayList;
            ArrayList<RichTextNode> arrayList2 = arrayList;
            arrayList = new ArrayList<RichTextNode>(string4.size());
            for (int i = 0; i < string4.size(); ++i) {
                Object object = string4.getJSONObject(i);
                if (object == null || (object = RichTextNodeManager.createRichTextNode(context, string2, string3, object)) == null) continue;
                arrayList2.add((RichTextNode)object);
            }
            return RichTextNode.parse(arrayList2);
        }
        return new SpannableString((CharSequence)"");
    }

    public static int createSpanFlag(int n) {
        return RichTextNode.createPriorityFlag(n) | 0x11;
    }

    private static int createPriorityFlag(int n) {
        if (n <= 255) {
            return 255 - n << 16;
        }
        return 0xFF0000;
    }

    @NonNull
    private static Spannable parse(@NonNull List<RichTextNode> spannableStringBuilder) {
        SpannableStringBuilder spannableStringBuilder2;
        SpannableStringBuilder spannableStringBuilder3 = spannableStringBuilder;
        spannableStringBuilder = spannableStringBuilder2;
        spannableStringBuilder2 = new SpannableStringBuilder();
        Iterator iterator = spannableStringBuilder3.iterator();
        while (iterator.hasNext()) {
            spannableStringBuilder.append((CharSequence)((RichTextNode)iterator.next()).toSpan(1));
        }
        return spannableStringBuilder;
    }

    @Nullable
    private WXCustomStyleSpan createCustomStyleSpan() {
        int n = -1;
        int n2 = -1;
        String string2 = null;
        if (this.style.containsKey("fontWeight")) {
            n = AbsStyle.getFontWeight(this.style);
        }
        if (this.style.containsKey("fontStyle")) {
            n2 = AbsStyle.getFontStyle(this.style);
        }
        if (this.style.containsKey("fontFamily")) {
            string2 = AbsStyle.getFontFamily(this.style);
        }
        if (n == -1 && n2 == -1 && string2 == null) {
            return null;
        }
        return new WXCustomStyleSpan(n2, n, string2);
    }

    public abstract String toString();

    protected abstract boolean isInternalNode();

    public String getRef() {
        return this.mRef;
    }

    final void parse(@NonNull Context context, @NonNull String string2, @NonNull String string3, JSONObject jSONObject) {
        ArrayList arrayList;
        Object object;
        JSONObject jSONObject2 = jSONObject.getJSONObject(STYLE);
        if (jSONObject2 != null) {
            ArrayMap arrayMap;
            object = arrayMap;
            object();
            ((RichTextNode)((Object)arrayList2)).style = object;
            arrayMap.putAll(jSONObject2);
        } else {
            ArrayMap arrayMap;
            jSONObject2 = arrayMap;
            arrayMap = new ArrayMap(0);
            ((RichTextNode)((Object)arrayList2)).style = jSONObject2;
        }
        jSONObject2 = jSONObject.getJSONObject(ATTR);
        if (jSONObject2 != null) {
            ArrayMap arrayMap;
            ArrayMap arrayMap2 = object = arrayMap;
            arrayMap2(jSONObject2.size());
            ((RichTextNode)((Object)arrayList2)).attr = arrayMap2;
            arrayMap.putAll(jSONObject2);
        } else {
            ArrayMap arrayMap;
            jSONObject2 = arrayMap;
            arrayMap = new ArrayMap(0);
            ((RichTextNode)((Object)arrayList2)).attr = jSONObject2;
        }
        jSONObject = jSONObject.getJSONArray(CHILDREN);
        if (jSONObject != null) {
            ((RichTextNode)((Object)arrayList2)).children = new ArrayList<RichTextNode>(jSONObject.size());
            for (int i = 0; i < jSONObject.size(); ++i) {
                object = jSONObject.getJSONObject(i);
                if ((object = RichTextNodeManager.createRichTextNode(context, string2, string3, (JSONObject)object)) == null) continue;
                ((RichTextNode)((Object)arrayList2)).children.add((RichTextNode)object);
            }
            return;
        }
        RichTextNode richTextNode = arrayList2;
        ArrayList arrayList2 = arrayList;
        arrayList = new ArrayList(0);
        richTextNode.children = arrayList2;
    }

    public void addChildNode(RichTextNode richTextNode) {
        if (this.children == null) {
            LinkedList<RichTextNode> linkedList;
            LinkedList<RichTextNode> linkedList2 = linkedList;
            linkedList = new LinkedList<RichTextNode>();
            this.children = linkedList2;
        }
        if (richTextNode != null && this.isInternalNode()) {
            this.children.add(richTextNode);
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeChildNode(String string2) {
        List<RichTextNode> list = this.children;
        if (list == null || list.isEmpty() || TextUtils.isEmpty((CharSequence)string2)) return;
        try {
            for (RichTextNode richTextNode : this.children) {
                if (!TextUtils.equals((CharSequence)richTextNode.mRef, (CharSequence)string2)) continue;
                this.children.remove(richTextNode);
            }
        }
        catch (Exception exception) {
            WXLogUtils.getStackTrace(exception);
            return;
        }
        {
            continue;
            return;
        }
    }

    public void updateStyles(Map<String, Object> map) {
        if (map != null && !map.isEmpty()) {
            this.style.putAll(map);
            return;
        }
    }

    public void updateAttrs(Map<String, Object> map) {
        if (this.attr != null && !map.isEmpty()) {
            this.attr.putAll(map);
            return;
        }
    }

    protected void updateSpans(SpannableStringBuilder spannableStringBuilder, int n) {
        WXSDKInstance wXSDKInstance = WXSDKManager.getInstance().getSDKInstance(this.mInstanceId);
        if (this.style != null && wXSDKInstance != null) {
            int n2;
            LinkedList<WXCustomStyleSpan> linkedList;
            LinkedList<WXCustomStyleSpan> linkedList2 = linkedList;
            linkedList = new LinkedList<WXCustomStyleSpan>();
            WXCustomStyleSpan wXCustomStyleSpan = this.createCustomStyleSpan();
            if (wXCustomStyleSpan != null) {
                linkedList2.add(wXCustomStyleSpan);
            }
            if (this.style.containsKey("fontSize")) {
                WXSDKInstance wXSDKInstance2 = wXSDKInstance;
                int n3 = wXSDKInstance2.getDefaultFontSize();
                linkedList2.add((WXCustomStyleSpan)new AbsoluteSizeSpan(AbsStyle.getFontSize(this.style, n3, wXSDKInstance2.getInstanceViewPortWidthWithFloat())));
            }
            if (this.style.containsKey("backgroundColor") && (n2 = WXResourceUtils.getColor(this.style.get("backgroundColor").toString(), 0)) != 0) {
                BackgroundColorSpan backgroundColorSpan;
                wXCustomStyleSpan = backgroundColorSpan;
                backgroundColorSpan = new BackgroundColorSpan(n2);
                linkedList2.add(wXCustomStyleSpan);
            }
            if (this.style.containsKey("color")) {
                linkedList2.add((WXCustomStyleSpan)new ForegroundColorSpan(WXResourceUtils.getColor(AbsStyle.getTextColor(this.style))));
            }
            int n4 = RichTextNode.createSpanFlag(n);
            Iterator iterator = linkedList2.iterator();
            while (iterator.hasNext()) {
                SpannableStringBuilder spannableStringBuilder2 = spannableStringBuilder;
                wXSDKInstance = iterator.next();
                int n5 = spannableStringBuilder2.length();
                spannableStringBuilder2.setSpan((Object)wXSDKInstance, 0, n5, n4);
            }
        }
    }

    public Spannable toSpan(int n) {
        Object object;
        SpannableStringBuilder spannableStringBuilder;
        SpannableStringBuilder spannableStringBuilder2 = spannableStringBuilder;
        spannableStringBuilder2();
        spannableStringBuilder.append((CharSequence)this.toString());
        if (this.isInternalNode() && (object = this.children) != null) {
            object = object.iterator();
            while (object.hasNext()) {
                spannableStringBuilder2.append((CharSequence)((RichTextNode)object.next()).toSpan(n + 1));
            }
        }
        this.updateSpans(spannableStringBuilder2, n);
        return spannableStringBuilder2;
    }

    public RichTextNode findRichNode(String string2) {
        Object object = ((RichTextNode)((Object)iterator)).mRef;
        if (object != null && TextUtils.equals((CharSequence)object, (CharSequence)string2)) {
            return iterator;
        }
        object = ((RichTextNode)((Object)iterator)).children;
        if (object != null && !object.isEmpty()) {
            Iterator<RichTextNode> iterator = ((RichTextNode)((Object)iterator)).children.iterator();
            while (iterator.hasNext()) {
                object = ((RichTextNode)iterator.next()).findRichNode(string2);
                if (object == null) continue;
                return object;
            }
        }
        return null;
    }
}

