/*
 * Decompiled with CFR 0.152.
 */
package androidtranscoder.engine;

import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.media.MediaMetadataRetriever;
import android.media.MediaMuxer;
import android.os.Build;
import android.util.Log;
import androidtranscoder.engine.InvalidOutputFormatException;
import androidtranscoder.engine.MediaFormatValidator;
import androidtranscoder.engine.PassThroughTrackTranscoder;
import androidtranscoder.engine.QueuedMuxer;
import androidtranscoder.engine.TrackTranscoder;
import androidtranscoder.engine.VideoTrackTranscoder;
import androidtranscoder.format.MediaFormatStrategy;
import androidtranscoder.utils.ISO6709LocationParser;
import androidtranscoder.utils.MediaExtractorUtils;
import java.io.FileDescriptor;
import java.io.IOException;

public class MediaTranscoderEngine {
    private static final String TAG = "MediaTranscoderEngine";
    private static final double PROGRESS_UNKNOWN = -1.0;
    private static final long SLEEP_TO_WAIT_TRACK_TRANSCODERS = 10L;
    private static final long PROGRESS_INTERVAL_STEPS = 10L;
    private FileDescriptor mInputFileDescriptor;
    private TrackTranscoder mVideoTrackTranscoder;
    private TrackTranscoder mAudioTrackTranscoder;
    private MediaExtractor mExtractor;
    private MediaMuxer mMuxer;
    private volatile double mProgress;
    private ProgressCallback mProgressCallback;
    private long mDurationUs;

    private void setupMetadata() throws IOException {
        MediaMetadataRetriever mediaMetadataRetriever;
        MediaMetadataRetriever mediaMetadataRetriever2 = mediaMetadataRetriever;
        mediaMetadataRetriever2();
        mediaMetadataRetriever.setDataSource(this.mInputFileDescriptor);
        String string2 = mediaMetadataRetriever.extractMetadata(24);
        try {
            this.mMuxer.setOrientationHint(Integer.parseInt(string2));
        }
        catch (NumberFormatException numberFormatException) {}
        if (Build.VERSION.SDK_INT >= 19 && (string2 = mediaMetadataRetriever2.extractMetadata(23)) != null) {
            float[] fArray = new ISO6709LocationParser().parse(string2);
            if (fArray != null) {
                float f5 = fArray[0];
                this.mMuxer.setLocation(f5, fArray[1]);
            } else {
                Log.d((String)TAG, (String)("Failed to parse the location metadata: " + string2));
            }
        }
        MediaTranscoderEngine mediaTranscoderEngine = this;
        long l5 = Long.parseLong(mediaMetadataRetriever2.extractMetadata(9));
        try {
            mediaTranscoderEngine.mDurationUs = l5 * 1000L;
        }
        catch (NumberFormatException numberFormatException) {
            this.mDurationUs = -1L;
        }
        Log.d((String)TAG, (String)("Duration (us): " + this.mDurationUs));
    }

    private void setupTrackTranscoders(MediaFormatStrategy object) {
        QueuedMuxer.Listener listener;
        QueuedMuxer queuedMuxer;
        MediaExtractorUtils.TrackResult trackResult = MediaExtractorUtils.getFirstVideoAndAudioTrack(object5.mExtractor);
        Object object2 = object.createVideoOutputFormat(trackResult.mVideoTrackFormat);
        object = object.createAudioOutputFormat(trackResult.mAudioTrackFormat);
        if (object2 == null && object == null) {
            throw new InvalidOutputFormatException("MediaFormatStrategy returned pass-through for both video and audio. No transcoding is necessary.");
        }
        object = queuedMuxer;
        Object object3 = object5.mMuxer;
        Object object4 = listener;
        listener = new QueuedMuxer.Listener(){

            @Override
            public void onDetermineOutputFormat() {
                1 v02 = this;
                MediaFormatValidator.validateVideoOutputFormat(v02.MediaTranscoderEngine.this.mVideoTrackTranscoder.getDeterminedFormat());
                MediaFormatValidator.validateAudioOutputFormat(v02.MediaTranscoderEngine.this.mAudioTrackTranscoder.getDeterminedFormat());
            }
        };
        queuedMuxer = new QueuedMuxer((MediaMuxer)object3, (QueuedMuxer.Listener)object4);
        if (object2 == null) {
            PassThroughTrackTranscoder passThroughTrackTranscoder;
            object2 = passThroughTrackTranscoder;
            object3 = object5.mExtractor;
            object4 = QueuedMuxer.SampleType.VIDEO;
            passThroughTrackTranscoder = new PassThroughTrackTranscoder((MediaExtractor)object3, trackResult.mVideoTrackIndex, (QueuedMuxer)object, (QueuedMuxer.SampleType)((Object)object4));
            object5.mVideoTrackTranscoder = object2;
        } else {
            VideoTrackTranscoder videoTrackTranscoder;
            object3 = videoTrackTranscoder;
            object4 = object5.mExtractor;
            videoTrackTranscoder = new VideoTrackTranscoder((MediaExtractor)object4, trackResult.mVideoTrackIndex, (MediaFormat)object2, (QueuedMuxer)object);
            object5.mVideoTrackTranscoder = object3;
        }
        MediaTranscoderEngine mediaTranscoderEngine = object5;
        mediaTranscoderEngine.mVideoTrackTranscoder.setup();
        Object object5 = object5.mExtractor;
        int n5 = trackResult.mAudioTrackIndex;
        MediaTranscoderEngine mediaTranscoderEngine2 = object5;
        object5 = QueuedMuxer.SampleType.AUDIO;
        object5.mAudioTrackTranscoder = new PassThroughTrackTranscoder((MediaExtractor)mediaTranscoderEngine2, n5, (QueuedMuxer)object, (QueuedMuxer.SampleType)((Object)object5));
        object5.mAudioTrackTranscoder.setup();
        mediaTranscoderEngine.mExtractor.selectTrack(trackResult.mVideoTrackIndex);
        mediaTranscoderEngine.mExtractor.selectTrack(trackResult.mAudioTrackIndex);
    }

    private void runPipelines() throws InterruptedException {
        long l5 = 0L;
        if (this.mDurationUs <= 0L) {
            double d6 = -1.0;
            this.mProgress = -1.0;
            ProgressCallback progressCallback = this.mProgressCallback;
            if (progressCallback != null) {
                progressCallback.onProgress(d6);
            }
        }
        while (!this.mVideoTrackTranscoder.isFinished() || !this.mAudioTrackTranscoder.isFinished()) {
            boolean bl = this.mVideoTrackTranscoder.stepPipeline() || this.mAudioTrackTranscoder.stepPipeline();
            if (this.mDurationUs > 0L && ++l5 % 10L == 0L) {
                double d7;
                double d8;
                if (this.mVideoTrackTranscoder.isFinished()) {
                    d8 = 1.0;
                } else {
                    d8 = (double)this.mVideoTrackTranscoder.getWrittenPresentationTimeUs() / (double)this.mDurationUs;
                    d8 = Math.min(1.0, d8);
                }
                if (this.mAudioTrackTranscoder.isFinished()) {
                    d7 = 1.0;
                } else {
                    d7 = (double)this.mAudioTrackTranscoder.getWrittenPresentationTimeUs() / (double)this.mDurationUs;
                    d7 = Math.min(1.0, d7);
                }
                this.mProgress = d8 = (d8 + d7) / 2.0;
                ProgressCallback progressCallback = this.mProgressCallback;
                if (progressCallback != null) {
                    progressCallback.onProgress(d8);
                }
            }
            if (bl) continue;
            Thread.sleep(10L);
        }
        return;
    }

    public void setDataSource(FileDescriptor fileDescriptor) {
        this.mInputFileDescriptor = fileDescriptor;
    }

    public ProgressCallback getProgressCallback() {
        return this.mProgressCallback;
    }

    public void setProgressCallback(ProgressCallback progressCallback) {
        this.mProgressCallback = progressCallback;
    }

    public double getProgress() {
        return this.mProgress;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transcodeVideo(String object, MediaFormatStrategy object2) throws IOException, InterruptedException {
        block24: {
            MediaMuxer mediaMuxer;
            MediaExtractor mediaExtractor;
            if (object == null) throw new NullPointerException("Output path cannot be null.");
            if (this.mInputFileDescriptor == null) throw new IllegalStateException("Data source is not set.");
            MediaExtractor mediaExtractor2 = mediaExtractor;
            this.mExtractor = mediaExtractor2;
            new MediaExtractor().setDataSource(this.mInputFileDescriptor);
            mediaExtractor2 = mediaMuxer;
            mediaMuxer = new MediaMuxer((String)object, 0);
            this.mMuxer = mediaExtractor2;
            this.setupMetadata();
            this.setupTrackTranscoders((MediaFormatStrategy)object2);
            this.runPipelines();
            this.mMuxer.stop();
            try {
                object = this.mVideoTrackTranscoder;
                if (object != null) {
                    object.release();
                    this.mVideoTrackTranscoder = null;
                }
                if ((object = this.mAudioTrackTranscoder) != null) {
                    object.release();
                    this.mAudioTrackTranscoder = null;
                }
                if ((object = this.mExtractor) == null) break block24;
            }
            catch (RuntimeException runtimeException) {
                throw new Error("Could not shutdown extractor, codecs and muxer pipeline.", runtimeException);
            }
            object.release();
            this.mExtractor = null;
        }
        try {
            object = this.mMuxer;
            if (object == null) return;
            object.release();
            this.mMuxer = null;
            return;
        }
        catch (RuntimeException runtimeException) {}
        Log.e((String)TAG, (String)"Failed to release muxer.", (Throwable)runtimeException);
        return;
        catch (Throwable throwable) {
            block25: {
                try {
                    object2 = this.mVideoTrackTranscoder;
                    if (object2 != null) {
                        object2.release();
                        this.mVideoTrackTranscoder = null;
                    }
                    if ((object2 = this.mAudioTrackTranscoder) != null) {
                        object2.release();
                        this.mAudioTrackTranscoder = null;
                    }
                    if ((object2 = this.mExtractor) == null) break block25;
                }
                catch (RuntimeException runtimeException) {
                    throw new Error("Could not shutdown extractor, codecs and muxer pipeline.", runtimeException);
                }
                object2.release();
                this.mExtractor = null;
            }
            try {
                object2 = this.mMuxer;
                if (object2 == null) throw throwable;
                object2.release();
                this.mMuxer = null;
                throw throwable;
            }
            catch (RuntimeException runtimeException) {
                Log.e((String)TAG, (String)"Failed to release muxer.", (Throwable)runtimeException);
            }
            throw throwable;
        }
    }

    public static interface ProgressCallback {
        public void onProgress(double var1);
    }
}

