/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.widget.photoview;

import android.content.Context;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.VelocityTracker;
import android.view.ViewConfiguration;
import com.dcloud.android.widget.photoview.OnGestureListener;
import com.dcloud.android.widget.photoview.Util;

class CustomGestureDetector {
    private static final int INVALID_POINTER_ID = -1;
    private int mActivePointerId;
    private int mActivePointerIndex;
    private final ScaleGestureDetector mDetector;
    private VelocityTracker mVelocityTracker;
    private boolean mIsDragging;
    private float mLastTouchX;
    private float mLastTouchY;
    private final float mTouchSlop;
    private final float mMinimumVelocity;
    private OnGestureListener mListener;

    CustomGestureDetector(Context context, OnGestureListener object) {
        ScaleGestureDetector.OnScaleGestureListener onScaleGestureListener;
        CustomGestureDetector customGestureDetector = this;
        OnGestureListener onGestureListener = object;
        CustomGestureDetector customGestureDetector2 = this;
        this.mActivePointerId = -1;
        this.mActivePointerIndex = 0;
        object = ViewConfiguration.get((Context)context);
        customGestureDetector2.mMinimumVelocity = object.getScaledMinimumFlingVelocity();
        customGestureDetector2.mTouchSlop = object.getScaledTouchSlop();
        customGestureDetector.mListener = onGestureListener;
        object = onScaleGestureListener;
        onScaleGestureListener = new ScaleGestureDetector.OnScaleGestureListener(){

            public boolean onScale(ScaleGestureDetector scaleGestureDetector) {
                float f5 = scaleGestureDetector.getScaleFactor();
                if (!Float.isNaN(f5) && !Float.isInfinite(f5)) {
                    ScaleGestureDetector scaleGestureDetector2 = scaleGestureDetector;
                    float f6 = scaleGestureDetector2.getFocusX();
                    CustomGestureDetector.this.mListener.onScale(f5, f6, scaleGestureDetector2.getFocusY());
                    return true;
                }
                return false;
            }

            public boolean onScaleBegin(ScaleGestureDetector scaleGestureDetector) {
                return true;
            }

            public void onScaleEnd(ScaleGestureDetector scaleGestureDetector) {
            }
        };
        customGestureDetector.mDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)object);
    }

    private float getActiveX(MotionEvent motionEvent) {
        try {
            return motionEvent.getX(this.mActivePointerIndex);
        }
        catch (Exception exception) {
            return motionEvent.getX();
        }
    }

    private float getActiveY(MotionEvent motionEvent) {
        try {
            return motionEvent.getY(this.mActivePointerIndex);
        }
        catch (Exception exception) {
            return motionEvent.getY();
        }
    }

    private boolean processTouchEvent(MotionEvent motionEvent) {
        switch (motionEvent.getAction() & 0xFF) {
            default: {
                break;
            }
            case 6: {
                MotionEvent motionEvent2 = motionEvent;
                int n5 = Util.getPointerIndex(motionEvent2.getAction());
                if (motionEvent2.getPointerId(n5) != this.mActivePointerId) break;
                n5 = n5 == 0 ? 1 : 0;
                MotionEvent motionEvent3 = motionEvent;
                this.mActivePointerId = motionEvent3.getPointerId(n5);
                this.mLastTouchX = motionEvent3.getX(n5);
                this.mLastTouchY = motionEvent3.getY(n5);
                break;
            }
            case 3: {
                this.mActivePointerId = -1;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                if (velocityTracker == null) break;
                velocityTracker.recycle();
                this.mVelocityTracker = null;
                break;
            }
            case 2: {
                float f5 = this.getActiveX(motionEvent);
                float f6 = this.getActiveY(motionEvent);
                float f7 = f5 - this.mLastTouchX;
                float f8 = f6 - this.mLastTouchY;
                if (!this.mIsDragging) {
                    float f9 = f7;
                    float f10 = f8;
                    boolean bl = Math.sqrt(f9 * f9 + f10 * f10) >= (double)this.mTouchSlop;
                    this.mIsDragging = bl;
                }
                if (!this.mIsDragging) break;
                this.mListener.onDrag(f7, f8);
                this.mLastTouchX = f5;
                this.mLastTouchY = f6;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                if (velocityTracker == null) break;
                velocityTracker.addMovement(motionEvent);
                break;
            }
            case 1: {
                VelocityTracker velocityTracker;
                this.mActivePointerId = -1;
                if (this.mIsDragging && this.mVelocityTracker != null) {
                    float f11;
                    this.mLastTouchX = this.getActiveX(motionEvent);
                    this.mLastTouchY = this.getActiveY(motionEvent);
                    this.mVelocityTracker.addMovement(motionEvent);
                    this.mVelocityTracker.computeCurrentVelocity(1000);
                    float f12 = this.mVelocityTracker.getXVelocity();
                    float f13 = this.mVelocityTracker.getYVelocity();
                    if (Math.max(Math.abs(f11), Math.abs(f13)) >= this.mMinimumVelocity) {
                        float f14 = f13;
                        float f15 = f12;
                        f12 = this.mLastTouchX;
                        f13 = this.mLastTouchY;
                        float f16 = -f15;
                        float f17 = -f14;
                        this.mListener.onFling(f12, f13, f16, f17);
                    }
                }
                if ((velocityTracker = this.mVelocityTracker) == null) break;
                velocityTracker.recycle();
                this.mVelocityTracker = null;
                break;
            }
            case 0: {
                VelocityTracker velocityTracker;
                this.mActivePointerId = motionEvent.getPointerId(0);
                this.mVelocityTracker = velocityTracker = VelocityTracker.obtain();
                if (velocityTracker != null) {
                    velocityTracker.addMovement(motionEvent);
                }
                this.mLastTouchX = this.getActiveX(motionEvent);
                this.mLastTouchY = this.getActiveY(motionEvent);
                this.mIsDragging = false;
            }
        }
        int n6 = this.mActivePointerId;
        if (n6 == -1) {
            n6 = 0;
        }
        this.mActivePointerIndex = motionEvent.findPointerIndex(n6);
        return true;
    }

    public boolean isScaling() {
        return this.mDetector.isInProgress();
    }

    public boolean isDragging() {
        return this.mIsDragging;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        MotionEvent motionEvent2;
        CustomGestureDetector customGestureDetector;
        try {
            customGestureDetector = this;
            motionEvent2 = motionEvent;
            this.mDetector.onTouchEvent(motionEvent);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return true;
        }
        return customGestureDetector.processTouchEvent(motionEvent2);
    }
}

