/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.common.reedsolomon;

import com.dcloud.zxing2.common.reedsolomon.GenericGFPoly;

public final class GenericGF {
    public static final GenericGF AZTEC_DATA_12 = new GenericGF(4201, 4096, 1);
    public static final GenericGF AZTEC_DATA_10 = new GenericGF(1033, 1024, 1);
    public static final GenericGF AZTEC_DATA_6 = new GenericGF(67, 64, 1);
    public static final GenericGF AZTEC_PARAM = new GenericGF(19, 16, 1);
    public static final GenericGF QR_CODE_FIELD_256 = new GenericGF(285, 256, 0);
    public static final GenericGF DATA_MATRIX_FIELD_256;
    public static final GenericGF AZTEC_DATA_8;
    public static final GenericGF MAXICODE_FIELD_64;
    private final int[] expTable;
    private final int[] logTable;
    private final GenericGFPoly zero;
    private final GenericGFPoly one;
    private final int size;
    private final int primitive;
    private final int generatorBase;

    public GenericGF(int n5, int n6, int n7) {
        GenericGFPoly genericGFPoly;
        GenericGFPoly genericGFPoly2;
        this.primitive = n5;
        this.size = n6;
        this.generatorBase = n7;
        this.expTable = new int[n6];
        this.logTable = new int[n6];
        n7 = 1;
        for (int i5 = 0; i5 < n6; ++i5) {
            this.expTable[i5] = n7;
            if ((n7 *= 2) < n6) continue;
            n7 = (n7 ^ n5) & n6 - 1;
        }
        for (n5 = 0; n5 < n6 - 1; ++n5) {
            this.logTable[this.expTable[n5]] = n5;
        }
        GenericGF genericGF = this;
        GenericGFPoly genericGFPoly3 = genericGFPoly2;
        int[] nArray = new int[1];
        int[] nArray2 = nArray;
        nArray[0] = 0;
        genericGFPoly2 = new GenericGFPoly(this, nArray2);
        genericGF.zero = genericGFPoly3;
        genericGFPoly3 = genericGFPoly;
        int[] nArray3 = new int[1];
        nArray2 = nArray3;
        nArray3[0] = 1;
        genericGFPoly = new GenericGFPoly(this, nArray2);
        genericGF.one = genericGFPoly3;
    }

    static int addOrSubtract(int n5, int n6) {
        return n5 ^ n6;
    }

    static {
        AZTEC_DATA_8 = DATA_MATRIX_FIELD_256 = new GenericGF(301, 256, 1);
        MAXICODE_FIELD_64 = AZTEC_DATA_6;
    }

    GenericGFPoly getZero() {
        return this.zero;
    }

    GenericGFPoly getOne() {
        return this.one;
    }

    GenericGFPoly buildMonomial(int n5, int n6) {
        if (n5 >= 0) {
            if (n6 == 0) {
                return this.zero;
            }
            int[] nArray = new int[n5 + 1];
            int[] nArray2 = nArray;
            nArray[0] = n6;
            return new GenericGFPoly(this, nArray2);
        }
        throw new IllegalArgumentException();
    }

    int exp(int n5) {
        return this.expTable[n5];
    }

    int log(int n5) {
        if (n5 != 0) {
            return this.logTable[n5];
        }
        throw new IllegalArgumentException();
    }

    int inverse(int n5) {
        if (n5 != 0) {
            return this.expTable[this.size - this.logTable[n5] - 1];
        }
        throw new ArithmeticException();
    }

    int multiply(int n5, int n6) {
        if (n5 != 0 && n6 != 0) {
            int[] nArray = this.logTable;
            return this.expTable[(this.logTable[n5] + nArray[n6]) % (this.size - 1)];
        }
        return 0;
    }

    public int getSize() {
        return this.size;
    }

    public int getGeneratorBase() {
        return this.generatorBase;
    }

    public String toString() {
        return "GF(0x" + Integer.toHexString(this.primitive) + ',' + this.size + ')';
    }
}

