/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.oned;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.EncodeHintType;
import com.dcloud.zxing2.FormatException;
import com.dcloud.zxing2.WriterException;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.oned.EAN13Reader;
import com.dcloud.zxing2.oned.OneDimensionalCodeWriter;
import com.dcloud.zxing2.oned.UPCEANReader;
import com.dcloud.zxing2.oned.UPCEANWriter;
import java.util.Map;

public final class EAN13Writer
extends UPCEANWriter {
    private static final int CODE_WIDTH = 95;

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n5, int n6, Map<EncodeHintType, ?> map) throws WriterException {
        if (barcodeFormat == BarcodeFormat.EAN_13) {
            return super.encode(string2, barcodeFormat, n5, n6, map);
        }
        throw new IllegalArgumentException("Can only encode EAN_13, but got " + (Object)((Object)barcodeFormat));
    }

    @Override
    public boolean[] encode(String string2) {
        if (string2.length() == 13) {
            block7: {
                if (!UPCEANReader.checkStandardUPCEANChecksum(string2)) break block7;
                int n5 = EAN13Reader.FIRST_DIGIT_ENCODINGS[Integer.parseInt(string2.substring(0, 1))];
                boolean[] blArray = new boolean[95];
                int n6 = OneDimensionalCodeWriter.appendPattern(blArray, 0, UPCEANReader.START_END_PATTERN, true);
                int n7 = 1;
                while (n7 <= 6) {
                    int n8 = n7;
                    int n9 = n8 + 1;
                    int n10 = Integer.parseInt(string2.substring(n8, n9));
                    if ((n5 >> 6 - n7 & 1) == 1) {
                        n10 += 10;
                    }
                    n6 += OneDimensionalCodeWriter.appendPattern(blArray, n6, UPCEANReader.L_AND_G_PATTERNS[n10], false);
                    n7 = n9;
                }
                n5 = n6 + OneDimensionalCodeWriter.appendPattern(blArray, n6, UPCEANReader.MIDDLE_PATTERN, false);
                n6 = 7;
                while (n6 <= 12) {
                    n5 += OneDimensionalCodeWriter.appendPattern(blArray, n5, UPCEANReader.L_PATTERNS[Integer.parseInt(string2.substring(n6++, n6))], true);
                }
                OneDimensionalCodeWriter.appendPattern(blArray, n5, UPCEANReader.START_END_PATTERN, true);
                return blArray;
            }
            try {
                throw new IllegalArgumentException("Contents do not pass checksum");
            }
            catch (FormatException formatException) {
                throw new IllegalArgumentException("Illegal contents");
            }
        }
        throw new IllegalArgumentException("Requested contents should be 13 digits long, but got " + string2.length());
    }
}

