/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import androidx.annotation.Nullable;
import dc.squareup.okio.Segment;

final class SegmentPool {
    static final long MAX_SIZE = 65536L;
    @Nullable
    static Segment next;
    static long byteCount;

    private SegmentPool() {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Segment take() {
        Class<SegmentPool> clazz = SegmentPool.class;
        synchronized (SegmentPool.class) {
            try {
                Segment segment = next;
                if (segment != null) {
                    next = segment.next;
                    segment.next = null;
                    byteCount = byteCount - 8192L;
                    // ** MonitorExit[var0] (shouldn't be in output)
                    return segment;
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return new Segment();
            }
            catch (Throwable throwable) {}
            {
                // ** MonitorExit[var0] (shouldn't be in output)
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void recycle(Segment segment) {
        if (segment.next == null && segment.prev == null) {
            if (segment.shared) {
                return;
            }
            Class<SegmentPool> clazz = SegmentPool.class;
            synchronized (SegmentPool.class) {
                int n5;
                try {
                    long l5 = byteCount;
                    if (l5 + 8192L > 65536L) {
                        // ** MonitorExit[var1_2] (shouldn't be in output)
                        return;
                    }
                    byteCount = l5 + 8192L;
                    segment.next = next;
                    n5 = 0;
                }
                catch (Throwable throwable) {}
                segment.limit = 0;
                segment.pos = n5;
                next = segment;
                // ** MonitorExit[var1_2] (shouldn't be in output)
                return;
                throw throwable;
            }
        }
        throw new IllegalArgumentException();
    }
}

