/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.nativeObj.photoview.subscaleview;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import io.dcloud.common.util.ExifInterface;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class BitmapUtil {
    public static Bitmap getRotatedBitmapFromFile(File file) throws IOException {
        int n5 = new ExifInterface(file.getAbsolutePath()).getAttributeInt("Orientation", 1);
        return BitmapUtil.getRotatedBitmap(BitmapFactory.decodeFile((String)file.getAbsolutePath()), n5);
    }

    public static Bitmap getRotatedBitmapFromBitmap(Bitmap object) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream;
        Bitmap bitmap = object;
        object = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)object);
        return BitmapUtil.getRotatedBitmap(bitmap, new ExifInterface(new ByteArrayInputStream(((ByteArrayOutputStream)object).toByteArray())).getAttributeInt("Orientation", 1));
    }

    public static Bitmap getRotatedBitmap(Bitmap bitmap, int n5) {
        Matrix matrix;
        if (bitmap == null) {
            return null;
        }
        Matrix matrix2 = matrix;
        matrix = new Matrix();
        switch (n5) {
            default: {
                return bitmap;
            }
            case 8: {
                matrix2.setRotate(-90.0f);
                break;
            }
            case 7: {
                Matrix matrix3 = matrix2;
                matrix3.setRotate(-90.0f);
                matrix3.postScale(-1.0f, 1.0f);
                break;
            }
            case 6: {
                matrix2.setRotate(90.0f);
                break;
            }
            case 5: {
                Matrix matrix4 = matrix2;
                matrix4.setRotate(90.0f);
                matrix4.postScale(-1.0f, 1.0f);
                break;
            }
            case 4: {
                matrix2.setScale(1.0f, -1.0f);
                break;
            }
            case 3: {
                matrix2.setRotate(180.0f);
                break;
            }
            case 2: {
                matrix2.setScale(-1.0f, 1.0f);
            }
        }
        Bitmap bitmap2 = bitmap;
        int n6 = bitmap2.getWidth();
        int n7 = bitmap2.getHeight();
        return Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)n6, (int)n7, (Matrix)matrix2, (boolean)true);
    }

    public static boolean needRatationWithExif(File file) {
        try {
            int n5 = new ExifInterface(file).getAttributeInt("Orientation", 1);
            return n5 != 1 && n5 != 0;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

