/*
 * Decompiled with CFR 0.152.
 */
package com.nostra13.dcloudimageloader.core.display;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.widget.ImageView;
import com.nostra13.dcloudimageloader.core.assist.LoadedFrom;
import com.nostra13.dcloudimageloader.core.display.BitmapDisplayer;
import com.nostra13.dcloudimageloader.core.imageaware.ImageAware;
import com.nostra13.dcloudimageloader.core.imageaware.ImageViewAware;
import com.nostra13.dcloudimageloader.utils.L;

public class RoundedBitmapDisplayer
implements BitmapDisplayer {
    private final int roundPixels;

    public RoundedBitmapDisplayer(int roundPixels) {
        this.roundPixels = roundPixels;
    }

    @Override
    public Bitmap display(Bitmap bitmap, ImageAware imageAware, LoadedFrom loadedFrom) {
        if (!(imageAware instanceof ImageViewAware)) {
            throw new IllegalArgumentException("ImageAware should wrap ImageView. ImageViewAware is expected.");
        }
        Bitmap roundedBitmap = RoundedBitmapDisplayer.roundCorners(bitmap, (ImageViewAware)imageAware, this.roundPixels);
        imageAware.setImageBitmap(roundedBitmap);
        return roundedBitmap;
    }

    public static Bitmap roundCorners(Bitmap bitmap, ImageViewAware imageAware, int roundPixels) {
        Bitmap roundBitmap;
        int height;
        int width;
        Rect destRect;
        Rect srcRect;
        ImageView.ScaleType scaleType;
        ImageView imageView = imageAware.getWrappedView();
        if (imageView == null) {
            L.w("View is collected probably. Can't round bitmap corners without view properties.", new Object[0]);
            return bitmap;
        }
        int bw = bitmap.getWidth();
        int bh = bitmap.getHeight();
        int vw = imageAware.getWidth();
        int vh = imageAware.getHeight();
        if (vw <= 0) {
            vw = bw;
        }
        if (vh <= 0) {
            vh = bh;
        }
        if ((scaleType = imageView.getScaleType()) == null) {
            return bitmap;
        }
        switch (scaleType.ordinal()) {
            case 1: {
                int destWidth;
                int destHeight;
                float e = (float)vw / (float)vh;
                float bRation = (float)bw / (float)bh;
                if (e > bRation) {
                    destHeight = Math.min(vh, bh);
                    destWidth = (int)((float)bw / ((float)bh / (float)destHeight));
                } else {
                    destWidth = Math.min(vw, bw);
                    destHeight = (int)((float)bh / ((float)bw / (float)destWidth));
                }
                int x = (vw - destWidth) / 2;
                int y = (vh - destHeight) / 2;
                srcRect = new Rect(0, 0, bw, bh);
                destRect = new Rect(x, y, x + destWidth, y + destHeight);
                width = vw;
                height = vh;
                break;
            }
            default: {
                float e = (float)vw / (float)vh;
                float bRation = (float)bw / (float)bh;
                if (e > bRation) {
                    width = (int)((float)bw / ((float)bh / (float)vh));
                    height = vh;
                } else {
                    width = vw;
                    height = (int)((float)bh / ((float)bw / (float)vw));
                }
                srcRect = new Rect(0, 0, bw, bh);
                destRect = new Rect(0, 0, width, height);
                break;
            }
            case 5: {
                int y;
                int x;
                int srcHeight;
                int srcWidth;
                float e = (float)vw / (float)vh;
                float bRation = (float)bw / (float)bh;
                if (e > bRation) {
                    srcWidth = bw;
                    srcHeight = (int)((float)vh * ((float)bw / (float)vw));
                    x = 0;
                    y = (bh - srcHeight) / 2;
                } else {
                    srcWidth = (int)((float)vw * ((float)bh / (float)vh));
                    srcHeight = bh;
                    x = (bw - srcWidth) / 2;
                    y = 0;
                }
                width = srcWidth;
                height = srcHeight;
                srcRect = new Rect(x, y, x + srcWidth, y + srcHeight);
                destRect = new Rect(0, 0, srcWidth, srcHeight);
                break;
            }
            case 6: {
                width = vw;
                height = vh;
                srcRect = new Rect(0, 0, bw, bh);
                destRect = new Rect(0, 0, vw, vh);
                break;
            }
            case 7: 
            case 8: {
                width = Math.min(vw, bw);
                height = Math.min(vh, bh);
                int x = (bw - width) / 2;
                int y = (bh - height) / 2;
                srcRect = new Rect(x, y, x + width, y + height);
                destRect = new Rect(0, 0, width, height);
            }
        }
        try {
            roundBitmap = RoundedBitmapDisplayer.getRoundedCornerBitmap(bitmap, roundPixels, srcRect, destRect, width, height);
        }
        catch (OutOfMemoryError var22) {
            L.e(var22, "Can't create bitmap with rounded corners. Not enough memory.", new Object[0]);
            roundBitmap = bitmap;
        }
        return roundBitmap;
    }

    private static Bitmap getRoundedCornerBitmap(Bitmap bitmap, int roundPixels, Rect srcRect, Rect destRect, int width, int height) {
        Bitmap output = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(output);
        Paint paint = new Paint();
        RectF destRectF = new RectF(destRect);
        paint.setAntiAlias(true);
        canvas.drawARGB(0, 0, 0, 0);
        paint.setColor(-16777216);
        canvas.drawRoundRect(destRectF, (float)roundPixels, (float)roundPixels, paint);
        paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
        canvas.drawBitmap(bitmap, srcRect, destRectF, paint);
        return output;
    }
}

