/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.media.video.ijkplayer.utils;

import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.util.DisplayMetrics;
import android.view.Window;
import android.view.WindowManager;

public final class WindowUtils {
    private WindowUtils() {
        throw new Error("Do not need instantiate!");
    }

    public static int getDisplayRotation(Activity activity) {
        switch (activity.getWindowManager().getDefaultDisplay().getRotation()) {
            case 0: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        return 0;
    }

    public static final boolean isLandscape(Context context) {
        return context.getResources().getConfiguration().orientation == 2;
    }

    public static final boolean isPortrait(Context context) {
        return context.getResources().getConfiguration().orientation == 1;
    }

    public static void dimBackground(float from, float to, Activity context) {
        final Window window = context.getWindow();
        ValueAnimator valueAnimator = ValueAnimator.ofFloat((float[])new float[]{from, to});
        valueAnimator.setDuration(500L);
        valueAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animation) {
                WindowManager.LayoutParams params = window.getAttributes();
                params.alpha = ((Float)animation.getAnimatedValue()).floatValue();
                window.setAttributes(params);
            }
        });
        valueAnimator.start();
    }

    public static int getScreenOrientation(Activity activity) {
        int orientation;
        int rotation = activity.getWindowManager().getDefaultDisplay().getRotation();
        DisplayMetrics dm = new DisplayMetrics();
        activity.getWindowManager().getDefaultDisplay().getMetrics(dm);
        int width = dm.widthPixels;
        int height = dm.heightPixels;
        if ((rotation == 0 || rotation == 2) && height > width || (rotation == 1 || rotation == 3) && width > height) {
            switch (rotation) {
                case 0: {
                    orientation = 1;
                    break;
                }
                case 1: {
                    orientation = 0;
                    break;
                }
                case 2: {
                    orientation = 9;
                    break;
                }
                case 3: {
                    orientation = 8;
                    break;
                }
                default: {
                    orientation = 1;
                    break;
                }
            }
        } else {
            switch (rotation) {
                case 0: {
                    orientation = 0;
                    break;
                }
                case 1: {
                    orientation = 1;
                    break;
                }
                case 2: {
                    orientation = 8;
                    break;
                }
                case 3: {
                    orientation = 9;
                    break;
                }
                default: {
                    orientation = 0;
                }
            }
        }
        return orientation;
    }
}

