/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.helper;

import android.app.Activity;
import android.graphics.Rect;
import android.os.Build;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.annotation.Nullable;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.lang.ref.WeakReference;

public class SoftKeyboardDetector {
    private static final int KEYBOARD_VISIBLE_THRESHOLD_DIP = 100;

    public static Unregister registerKeyboardEventListener(Activity activity, final OnKeyboardEventListener onKeyboardEventListener) {
        if (activity != null && onKeyboardEventListener != null) {
            ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener;
            int n;
            View view;
            if (activity.getWindow() != null && (view = activity.getWindow().getAttributes()) != null && ((n = view.softInputMode) == 48 || n == 32)) {
                WXLogUtils.e("SoftKeyboard detector can't work with softInputMode is SOFT_INPUT_ADJUST_NOTHING or SOFT_INPUT_ADJUST_PAN");
                return null;
            }
            view = SoftKeyboardDetector.getActivityRoot(activity);
            if (view == null) {
                WXLogUtils.e("Activity root is null!");
                return null;
            }
            ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener2 = onGlobalLayoutListener;
            onGlobalLayoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){
                private final Rect visibleFrame = new Rect();
                private final int threshold = WXViewUtils.dip2px(100.0f);
                private boolean wasKeyboardOpened = false;

                public void onGlobalLayout() {
                    1 v0 = this;
                    v0.view.getWindowVisibleDisplayFrame(this.visibleFrame);
                    boolean bl = v0.view.getRootView().getHeight() - this.visibleFrame.height() > this.threshold;
                    if (bl == this.wasKeyboardOpened) {
                        return;
                    }
                    this.wasKeyboardOpened = bl;
                    onKeyboardEventListener.onKeyboardEvent(bl);
                }
            };
            view.getViewTreeObserver().addOnGlobalLayoutListener(onGlobalLayoutListener2);
            return new DefaultUnRegister(activity, onGlobalLayoutListener2);
        }
        WXLogUtils.e("Activity or listener is null!");
        return null;
    }

    public static boolean isKeyboardVisible(Activity activity) {
        Rect rect;
        Activity activity2 = activity;
        activity = rect;
        rect = new Rect();
        View view = SoftKeyboardDetector.getActivityRoot(activity2);
        if (view != null) {
            View view2 = view;
            view2.getWindowVisibleDisplayFrame((Rect)activity);
            return view2.getRootView().getHeight() - activity.height() > WXViewUtils.dip2px(100.0f);
        }
        return false;
    }

    @Nullable
    public static View getActivityRoot(Activity activity) {
        if (activity != null) {
            return activity.findViewById(0x1020002);
        }
        return null;
    }

    public static interface OnKeyboardEventListener {
        public void onKeyboardEvent(boolean var1);
    }

    public static final class DefaultUnRegister
    implements Unregister {
        private WeakReference<Activity> activityRef;
        private WeakReference<ViewTreeObserver.OnGlobalLayoutListener> listenerRef;

        public DefaultUnRegister(Activity activity, ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener) {
            WeakReference<ViewTreeObserver.OnGlobalLayoutListener> weakReference;
            WeakReference<Activity> weakReference2;
            Object object = weakReference2;
            weakReference2 = new WeakReference<Activity>(activity);
            v1.activityRef = object;
            object = weakReference;
            weakReference = new WeakReference<ViewTreeObserver.OnGlobalLayoutListener>(onGlobalLayoutListener);
            v1.listenerRef = object;
        }

        @Override
        public void execute() {
            Activity activity = (Activity)this.activityRef.get();
            ViewTreeObserver.OnGlobalLayoutListener onGlobalLayoutListener = (ViewTreeObserver.OnGlobalLayoutListener)this.listenerRef.get();
            if (activity != null && onGlobalLayoutListener != null && (activity = SoftKeyboardDetector.getActivityRoot(activity)) != null) {
                if (Build.VERSION.SDK_INT >= 16) {
                    activity.getViewTreeObserver().removeOnGlobalLayoutListener(onGlobalLayoutListener);
                } else {
                    activity.getViewTreeObserver().removeGlobalOnLayoutListener(onGlobalLayoutListener);
                }
            }
            DefaultUnRegister defaultUnRegister = this;
            defaultUnRegister.activityRef.clear();
            defaultUnRegister.listenerRef.clear();
        }
    }

    public static interface Unregister {
        public void execute();
    }
}

