/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.border;

import android.graphics.Canvas;
import android.graphics.Paint;
import androidx.annotation.NonNull;
import com.taobao.weex.dom.CSSShorthand;
import com.taobao.weex.ui.view.border.BorderCorner;

class BorderEdge {
    @NonNull
    private BorderCorner mPreCorner;
    @NonNull
    private BorderCorner mPostCorner;
    private CSSShorthand.EDGE mEdge;
    private float mBorderWidth;

    BorderEdge() {
    }

    BorderEdge set(@NonNull BorderCorner borderCorner, @NonNull BorderCorner borderCorner2, float f, CSSShorthand.EDGE eDGE) {
        this.mPreCorner = borderCorner;
        this.mPostCorner = borderCorner2;
        this.mBorderWidth = f;
        this.mEdge = eDGE;
        return this;
    }

    void drawEdge(@NonNull Canvas canvas, @NonNull Paint paint) {
        BorderEdge borderEdge = this;
        paint.setStrokeWidth(this.mBorderWidth);
        BorderCorner borderCorner = borderEdge.mPreCorner;
        borderCorner.drawRoundedCorner(canvas, paint, borderCorner.getAngleBisectorDegree());
        paint.setStrokeWidth(borderEdge.mBorderWidth);
        BorderEdge borderEdge2 = this;
        float f = borderEdge2.mPreCorner.getRoundCornerEndY();
        float f2 = borderEdge2.mPostCorner.getRoundCornerStartX();
        float f3 = borderEdge2.mPostCorner.getRoundCornerStartY();
        canvas.drawLine(this.mPreCorner.getRoundCornerEndX(), f, f2, f3, paint);
        BorderCorner borderCorner2 = this.mPostCorner;
        borderCorner2.drawRoundedCorner(canvas, paint, borderCorner2.getAngleBisectorDegree() - 45.0f);
    }

    public CSSShorthand.EDGE getEdge() {
        return this.mEdge;
    }

    public float getBorderWidth() {
        return this.mBorderWidth;
    }
}

