/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import androidx.annotation.NonNull;
import com.taobao.weex.utils.WXLogUtils;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class FunctionParser<K, V> {
    public static final char SPACE = ' ';
    private Mapper<K, V> mapper;
    private Lexer lexer;

    public FunctionParser(@NonNull String string2, @NonNull Mapper<K, V> mapper) {
        Lexer lexer;
        Lexer lexer2 = lexer;
        lexer = new Lexer(string2);
        v1.lexer = lexer2;
        v1.mapper = mapper;
    }

    private LinkedHashMap<K, V> definition() {
        LinkedHashMap<K, V> linkedHashMap;
        LinkedHashMap<K, V> linkedHashMap2 = linkedHashMap;
        linkedHashMap = new LinkedHashMap<K, V>();
        do {
            ((AbstractMap)linkedHashMap2).putAll(this.function());
        } while (this.lexer.getCurrentToken() == Token.FUNC_NAME);
        return linkedHashMap2;
    }

    private Map<K, V> function() {
        LinkedList<String> linkedList;
        LinkedList<String> linkedList2 = linkedList;
        FunctionParser functionParser = this;
        linkedList2();
        String string2 = functionParser.match(Token.FUNC_NAME);
        functionParser.match(Token.LEFT_PARENT);
        linkedList.add(functionParser.match(Token.PARAM_VALUE));
        while (true) {
            Token token = Token.COMMA;
            if (this.lexer.getCurrentToken() != token) break;
            FunctionParser functionParser2 = this;
            functionParser2.match(token);
            linkedList2.add(functionParser2.match(Token.PARAM_VALUE));
        }
        FunctionParser functionParser3 = this;
        functionParser3.match(Token.RIGHT_PARENT);
        return functionParser3.mapper.map(string2, linkedList2);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String match(Token token) {
        String string2;
        try {
            if (token != this.lexer.getCurrentToken()) return "";
        }
        catch (Exception exception) {
            WXLogUtils.e((Object)((Object)token) + "Token doesn't match" + this.lexer.source);
            return "";
        }
        {
            string2 = this.lexer.getCurrentTokenValue();
            this.lexer.moveOn();
        }
        return string2;
    }

    public LinkedHashMap<K, V> parse() {
        FunctionParser functionParser = this;
        functionParser.lexer.moveOn();
        return functionParser.definition();
    }

    private static class Lexer {
        private static final String LEFT_PARENT = "(";
        private static final String RIGHT_PARENT = ")";
        private static final String COMMA = ",";
        private static final char A_LOWER = 'a';
        private static final char Z_LOWER = 'z';
        private static final char A_UPPER = 'A';
        private static final char Z_UPPER = 'Z';
        private static final char ZERO = '0';
        private static final char NINE = '9';
        private static final char DOT = '.';
        private static final char MINUS = '-';
        private static final char PLUS = '+';
        private String source;
        private Token current;
        private String value;
        private int pointer = 0;

        private Lexer(String string2) {
            this.source = string2;
        }

        private Token getCurrentToken() {
            return this.current;
        }

        private String getCurrentTokenValue() {
            return this.value;
        }

        private boolean moveOn() {
            int n;
            int n2 = this.pointer;
            while (this.pointer < this.source.length()) {
                char c = this.source.charAt(this.pointer);
                n = c;
                if (c == ' ') {
                    n = this.pointer;
                    this.pointer = n + 1;
                    if (n2 != n) break;
                    ++n2;
                    continue;
                }
                if (!this.isCharacterOrDigit((char)n) && n != 46 && n != 37 && n != 45 && n != 43) {
                    n = this.pointer;
                    if (n2 != n) break;
                    this.pointer = n + 1;
                    break;
                }
                ++this.pointer;
            }
            if (n2 != (n = this.pointer)) {
                Lexer lexer = this;
                lexer.moveOn(lexer.source.substring(n2, n));
                return true;
            }
            Lexer lexer = this;
            lexer.current = null;
            lexer.value = null;
            return false;
        }

        private void moveOn(String string2) {
            if (LEFT_PARENT.equals(string2)) {
                Lexer lexer = this;
                lexer.current = Token.LEFT_PARENT;
                lexer.value = LEFT_PARENT;
                return;
            }
            if (RIGHT_PARENT.equals(string2)) {
                Lexer lexer = this;
                lexer.current = Token.RIGHT_PARENT;
                lexer.value = RIGHT_PARENT;
                return;
            }
            if (COMMA.equals(string2)) {
                Lexer lexer = this;
                lexer.current = Token.COMMA;
                lexer.value = COMMA;
                return;
            }
            if (this.isFuncName(string2)) {
                this.current = Token.FUNC_NAME;
                this.value = string2;
                return;
            }
            this.current = Token.PARAM_VALUE;
            this.value = string2;
        }

        private boolean isFuncName(CharSequence charSequence) {
            for (int i = 0; i < charSequence.length(); ++i) {
                char c = charSequence.charAt(i);
                if ('a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || c == '-') continue;
                return false;
            }
            return true;
        }

        private boolean isCharacterOrDigit(char c) {
            return '0' <= c && c <= '9' || 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z';
        }
    }

    public static interface Mapper<K, V> {
        public Map<K, V> map(String var1, List<String> var2);
    }

    private static enum Token {
        FUNC_NAME,
        PARAM_VALUE,
        LEFT_PARENT,
        RIGHT_PARENT,
        COMMA;

    }

    private static class WXInterpretationException
    extends RuntimeException {
        private WXInterpretationException(String string2) {
            super(string2);
        }
    }
}

