/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.uts.gson;

import io.dcloud.uts.UTSNumber;
import io.dcloud.uts.gson.JsonParseException;
import io.dcloud.uts.gson.ToNumberStrategy;
import io.dcloud.uts.gson.stream.JsonReader;
import io.dcloud.uts.gson.stream.MalformedJsonException;
import java.io.IOException;
import java.math.BigDecimal;

public enum ToNumberPolicy implements ToNumberStrategy
{
    DOUBLE{

        @Override
        public Double readNumber(JsonReader in) throws IOException {
            return in.nextDouble();
        }
    }
    ,
    LAZILY_PARSED_NUMBER{

        @Override
        public Number readNumber(JsonReader in) throws IOException {
            return UTSNumber.INSTANCE.from(in.nextString());
        }
    }
    ,
    LONG_OR_DOUBLE{

        @Override
        public Number readNumber(JsonReader in) throws IOException, JsonParseException {
            String value = in.nextString();
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException longE) {
                try {
                    Double d = Double.valueOf(value);
                    if ((d.isInfinite() || d.isNaN()) && !in.isLenient()) {
                        throw new MalformedJsonException("JSON forbids NaN and infinities: " + d + "; at path " + in.getPath());
                    }
                    return d;
                }
                catch (NumberFormatException doubleE) {
                    throw new JsonParseException("Cannot parse " + value + "; at path " + in.getPath(), doubleE);
                }
            }
        }
    }
    ,
    UTS_Number{

        @Override
        public Number readNumber(JsonReader in) throws IOException, JsonParseException {
            String value = in.nextString();
            Double number = UTSNumber.INSTANCE.from(value).doubleValue();
            if (!(in.isLenient() || !UTSNumber.INSTANCE.isNaN(number) && UTSNumber.INSTANCE.isFinite(number))) {
                throw new MalformedJsonException("JSON forbids NaN and infinities: " + value + "; at path " + in.getPath());
            }
            return number;
        }
    }
    ,
    BIG_DECIMAL{

        @Override
        public BigDecimal readNumber(JsonReader in) throws IOException {
            String value = in.nextString();
            try {
                return new BigDecimal(value);
            }
            catch (NumberFormatException e) {
                throw new JsonParseException("Cannot parse " + value + "; at path " + in.getPath(), e);
            }
        }
    };

}

