/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.client.result;

import com.dcloud.zxing2.Result;
import com.dcloud.zxing2.client.result.ResultParser;
import com.dcloud.zxing2.client.result.URIParsedResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class URIResultParser
extends ResultParser {
    private static final Pattern URL_WITH_PROTOCOL_PATTERN = Pattern.compile("[a-zA-Z][a-zA-Z0-9+-.]+:");
    private static final Pattern URL_WITHOUT_PROTOCOL_PATTERN = Pattern.compile("([a-zA-Z0-9\\-]+\\.)+[a-zA-Z]{2,}(:\\d{1,5})?(/|\\?|$)");

    static boolean isBasicallyValidURI(String object) {
        if (((String)object).contains(" ")) {
            return false;
        }
        Matcher matcher = URL_WITH_PROTOCOL_PATTERN.matcher((CharSequence)object);
        if (matcher.find() && matcher.start() == 0) {
            return true;
        }
        return ((Matcher)(object = URL_WITHOUT_PROTOCOL_PATTERN.matcher((CharSequence)object))).find() && ((Matcher)object).start() == 0;
    }

    @Override
    public URIParsedResult parse(Result result) {
        Object object = ResultParser.getMassagedText(result);
        if (!((String)object).startsWith("URL:") && !((String)object).startsWith("URI:")) {
            if (URIResultParser.isBasicallyValidURI((String)(object = ((String)object).trim()))) {
                return new URIParsedResult((String)object, null);
            }
            return null;
        }
        return new URIParsedResult(((String)object).substring(4).trim(), null);
    }
}

