/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.qrcode;

import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.EncodeHintType;
import com.dcloud.zxing2.Writer;
import com.dcloud.zxing2.WriterException;
import com.dcloud.zxing2.common.BitMatrix;
import com.dcloud.zxing2.qrcode.decoder.ErrorCorrectionLevel;
import com.dcloud.zxing2.qrcode.encoder.ByteMatrix;
import com.dcloud.zxing2.qrcode.encoder.Encoder;
import com.dcloud.zxing2.qrcode.encoder.QRCode;
import java.util.Map;

public final class QRCodeWriter
implements Writer {
    private static final int QUIET_ZONE_SIZE = 4;

    private static BitMatrix renderResult(QRCode object, int n5, int n6, int n7) {
        if ((object = ((QRCode)object).getMatrix()) != null) {
            BitMatrix bitMatrix;
            int n8 = n6;
            int n9 = n5;
            Object object2 = object;
            n5 = ((ByteMatrix)object2).getWidth();
            n6 = ((ByteMatrix)object2).getHeight();
            int n10 = n5 + (n7 *= 2);
            n7 = n6 + n7;
            int n11 = Math.max(n9, n10);
            int n12 = Math.max(n8, n7);
            n7 = Math.min(n11 / n10, n12 / n7);
            n10 = (n11 - n5 * n7) / 2;
            int n13 = (n12 - n6 * n7) / 2;
            BitMatrix bitMatrix2 = bitMatrix;
            bitMatrix = new BitMatrix(n11, n12);
            n11 = 0;
            while (n11 < n6) {
                n12 = 0;
                int n14 = n10;
                while (n12 < n5) {
                    if (((ByteMatrix)object).get(n12, n11) == 1) {
                        int n15 = n7;
                        bitMatrix2.setRegion(n14, n13, n15, n15);
                    }
                    ++n12;
                    n14 += n7;
                }
                ++n11;
                n13 += n7;
            }
            return bitMatrix2;
        }
        throw new IllegalStateException();
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n5, int n6) throws WriterException {
        return this.encode(string2, barcodeFormat, n5, n6, null);
    }

    @Override
    public BitMatrix encode(String string2, BarcodeFormat barcodeFormat, int n5, int n6, Map<EncodeHintType, ?> map) throws WriterException {
        if (!string2.isEmpty()) {
            if (barcodeFormat == BarcodeFormat.QR_CODE) {
                if (n5 >= 0 && n6 >= 0) {
                    Object object = ErrorCorrectionLevel.L;
                    int n7 = 4;
                    if (map != null) {
                        EncodeHintType encodeHintType = EncodeHintType.ERROR_CORRECTION;
                        if (map.containsKey((Object)encodeHintType)) {
                            object = ErrorCorrectionLevel.valueOf(map.get((Object)encodeHintType).toString());
                        }
                        if (map.containsKey((Object)(encodeHintType = EncodeHintType.MARGIN))) {
                            n7 = Integer.parseInt(map.get((Object)encodeHintType).toString());
                        }
                    }
                    return QRCodeWriter.renderResult(Encoder.encode(string2, (ErrorCorrectionLevel)((Object)object), map), n5, n6, n7);
                }
                throw new IllegalArgumentException("Requested dimensions are too small: " + n5 + 'x' + n6);
            }
            throw new IllegalArgumentException("Can only encode QR_CODE, but got " + (Object)((Object)barcodeFormat));
        }
        throw new IllegalArgumentException("Found empty contents");
    }
}

