/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal;

import androidx.annotation.Nullable;
import dc.squareup.okhttp3.Headers;
import dc.squareup.okhttp3.HttpUrl;
import dc.squareup.okhttp3.RequestBody;
import dc.squareup.okhttp3.ResponseBody;
import dc.squareup.okhttp3.internal.Internal;
import dc.squareup.okhttp3.internal.http2.Header;
import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSource;
import dc.squareup.okio.ByteString;
import dc.squareup.okio.Source;
import java.io.Closeable;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.IDN;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;

public final class Util {
    public static final byte[] EMPTY_BYTE_ARRAY;
    public static final String[] EMPTY_STRING_ARRAY;
    public static final ResponseBody EMPTY_RESPONSE;
    public static final RequestBody EMPTY_REQUEST;
    private static final ByteString UTF_8_BOM;
    private static final ByteString UTF_16_BE_BOM;
    private static final ByteString UTF_16_LE_BOM;
    private static final ByteString UTF_32_BE_BOM;
    private static final ByteString UTF_32_LE_BOM;
    public static final Charset UTF_8;
    public static final Charset ISO_8859_1;
    private static final Charset UTF_16_BE;
    private static final Charset UTF_16_LE;
    private static final Charset UTF_32_BE;
    private static final Charset UTF_32_LE;
    public static final TimeZone UTC;
    public static final Comparator<String> NATURAL_ORDER;
    private static final Method addSuppressedExceptionMethod;
    private static final Pattern VERIFY_AS_IP_ADDRESS;

    public static void addSuppressedIfPossible(Throwable throwable, Throwable throwable2) {
        block5: {
            Object[] objectArray = addSuppressedExceptionMethod;
            if (addSuppressedExceptionMethod != null) {
                Object[] objectArray2 = objectArray;
                Object[] objectArray3 = new Object[1];
                objectArray = objectArray3;
                try {
                    objectArray3[0] = throwable2;
                    objectArray2.invoke((Object)throwable, objectArray);
                }
                catch (IllegalAccessException illegalAccessException) {
                    break block5;
                }
                catch (InvocationTargetException invocationTargetException) {}
                return;
            }
        }
    }

    private Util() {
    }

    public static void checkOffsetAndCount(long l5, long l6, long l7) {
        if ((l6 | l7) >= 0L && l6 <= l5 && l5 - l6 >= l7) {
            return;
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public static boolean equal(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
        {
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
                return;
            }
            catch (Exception exception) {
                return;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
        }
    }

    public static void closeQuietly(Socket object) {
        block5: {
            if (object != null) {
                try {
                    ((Socket)object).close();
                    return;
                }
                catch (Exception exception) {
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (AssertionError assertionError) {
                    object = assertionError;
                    if (Util.isAndroidGetsocknameError(assertionError)) break block5;
                    throw object;
                }
            }
        }
    }

    public static void closeQuietly(ServerSocket serverSocket) {
        if (serverSocket != null) {
            try {
                serverSocket.close();
                return;
            }
            catch (Exception exception) {
                return;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
        }
    }

    public static boolean discard(Source source, int n5, TimeUnit timeUnit) {
        try {
            return Util.skipAll(source, n5, timeUnit);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean skipAll(Source source, int n5, TimeUnit timeUnit) throws IOException {
        long l5;
        long l6;
        block9: {
            Throwable throwable2;
            block8: {
                Buffer buffer;
                l6 = System.nanoTime();
                l5 = source.timeout().hasDeadline() ? source.timeout().deadlineNanoTime() - l6 : Long.MAX_VALUE;
                source.timeout().deadlineNanoTime(l6 + Math.min(l5, timeUnit.toNanos(n5)));
                Buffer buffer2 = buffer;
                try {
                    buffer = new Buffer();
                    while (source.read(buffer2, 8192L) != -1L) {
                        buffer2.clear();
                    }
                }
                catch (Throwable throwable2) {
                    break block8;
                }
                catch (InterruptedIOException interruptedIOException) {
                    break block9;
                }
                boolean bl = true;
                if (l5 == Long.MAX_VALUE) {
                    source.timeout().clearDeadline();
                    return bl;
                }
                source.timeout().deadlineNanoTime(l6 + l5);
                return bl;
            }
            if (l5 == Long.MAX_VALUE) {
                source.timeout().clearDeadline();
                throw throwable2;
            }
            source.timeout().deadlineNanoTime(l6 + l5);
            throw throwable2;
        }
        n5 = 0;
        if (l5 == Long.MAX_VALUE) {
            source.timeout().clearDeadline();
            return n5 != 0;
        }
        source.timeout().deadlineNanoTime(l6 + l5);
        return n5 != 0;
    }

    public static <T> List<T> immutableList(List<T> list) {
        return Collections.unmodifiableList(new ArrayList<T>(list));
    }

    public static <K, V> Map<K, V> immutableMap(Map<K, V> map) {
        if (map.isEmpty()) {
            return Collections.EMPTY_MAP;
        }
        return Collections.unmodifiableMap(new LinkedHashMap<K, V>(map));
    }

    public static <T> List<T> immutableList(T ... TArray) {
        return Collections.unmodifiableList(Arrays.asList((Object[])TArray.clone()));
    }

    public static ThreadFactory threadFactory(final String string2, final boolean bl) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, string2);
                thread.setDaemon(bl);
                return thread;
            }
        };
    }

    public static String[] intersect(Comparator<? super String> comparator, String[] stringArray, String[] stringArray2) {
        ArrayList<String> arrayList;
        ArrayList<String> arrayList2 = arrayList;
        arrayList = new ArrayList<String>();
        block0: for (String string2 : stringArray) {
            int n5 = stringArray2.length;
            for (int i5 = 0; i5 < n5; ++i5) {
                if (comparator.compare(string2, stringArray2[i5]) != 0) continue;
                arrayList2.add(string2);
                continue block0;
            }
        }
        ArrayList<String> arrayList3 = arrayList2;
        return arrayList3.toArray(new String[arrayList3.size()]);
    }

    public static boolean nonEmptyIntersection(Comparator<String> comparator, String[] stringArray, String[] stringArray2) {
        if (stringArray != null && stringArray2 != null && stringArray.length != 0 && stringArray2.length != 0) {
            for (String string2 : stringArray) {
                int n5 = stringArray2.length;
                for (int i5 = 0; i5 < n5; ++i5) {
                    if (comparator.compare(string2, stringArray2[i5]) != 0) continue;
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public static String hostHeader(HttpUrl httpUrl, boolean bl) {
        String string2 = httpUrl.host().contains(":") ? "[" + httpUrl.host() + "]" : httpUrl.host();
        if (!bl && httpUrl.port() == HttpUrl.defaultPort(httpUrl.scheme())) {
            return string2;
        }
        return string2 + ":" + httpUrl.port();
    }

    public static boolean isAndroidGetsocknameError(AssertionError assertionError) {
        return ((Throwable)((Object)assertionError)).getCause() != null && ((Throwable)((Object)assertionError)).getMessage() != null && ((Throwable)((Object)assertionError)).getMessage().contains("getsockname failed");
    }

    public static int indexOf(Comparator<String> comparator, String[] stringArray, String string2) {
        int n5 = stringArray.length;
        for (int i5 = 0; i5 < n5; ++i5) {
            if (comparator.compare(stringArray[i5], string2) != 0) continue;
            return i5;
        }
        return -1;
    }

    public static String[] concat(String[] stringArray, String string2) {
        int n5 = stringArray.length;
        String[] stringArray2 = new String[n5 + 1];
        String[] stringArray3 = stringArray2;
        int n6 = stringArray.length;
        System.arraycopy(stringArray, 0, stringArray3, 0, n6);
        stringArray2[n5] = string2;
        return stringArray2;
    }

    public static int skipLeadingAsciiWhitespace(String string2, int n5, int n6) {
        while (n5 < n6) {
            char c6 = string2.charAt(n5);
            if (c6 != '\t' && c6 != '\n' && c6 != '\f' && c6 != '\r' && c6 != ' ') {
                return n5;
            }
            ++n5;
        }
        return n6;
    }

    public static int skipTrailingAsciiWhitespace(String string2, int n5, int n6) {
        --n6;
        while (n6 >= n5) {
            char c6 = string2.charAt(n6);
            if (c6 != '\t' && c6 != '\n' && c6 != '\f' && c6 != '\r' && c6 != ' ') {
                return n6 + 1;
            }
            --n6;
        }
        return n5;
    }

    public static String trimSubstring(String string2, int n5, int n6) {
        String string3 = string2;
        int n7 = Util.skipLeadingAsciiWhitespace(string3, n5, n6);
        return string3.substring(n7, Util.skipTrailingAsciiWhitespace(string3, n7, n6));
    }

    public static int delimiterOffset(String string2, int n5, int n6, String string3) {
        while (n5 < n6) {
            if (string3.indexOf(string2.charAt(n5)) != -1) {
                return n5;
            }
            ++n5;
        }
        return n6;
    }

    public static int delimiterOffset(String string2, int n5, int n6, char c6) {
        while (n5 < n6) {
            if (string2.charAt(n5) == c6) {
                return n5;
            }
            ++n5;
        }
        return n6;
    }

    public static String canonicalizeHost(String string2) {
        block10: {
            if (string2.contains(":")) {
                Object object;
                if (string2.startsWith("[") && string2.endsWith("]")) {
                    String string3 = string2;
                    object = Util.decodeIpv6(string3, 1, string3.length() - 1);
                } else {
                    String string4 = string2;
                    object = Util.decodeIpv6(string4, 0, string4.length());
                }
                if (object == null) {
                    return null;
                }
                byte[] byArray = ((InetAddress)object).getAddress();
                object = byArray;
                if (byArray.length == 16) {
                    return Util.inet6AddressToAscii((byte[])object);
                }
                throw new AssertionError((Object)("Invalid IPv6 address: '" + string2 + "'"));
            }
            try {
                string2 = IDN.toASCII(string2).toLowerCase(Locale.US);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
            if (!string2.isEmpty()) break block10;
            return null;
        }
        if (Util.containsInvalidHostnameAsciiCodes(string2)) {
            return null;
        }
        return string2;
    }

    private static boolean containsInvalidHostnameAsciiCodes(String string2) {
        for (int i5 = 0; i5 < string2.length(); ++i5) {
            char c6 = string2.charAt(i5);
            if (c6 > '\u001f' && c6 < '\u007f') {
                if (" #%/:?@[\\]".indexOf(c6) == -1) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    public static int indexOfControlOrNonAscii(String string2) {
        int n5 = string2.length();
        for (int i5 = 0; i5 < n5; ++i5) {
            char c6 = string2.charAt(i5);
            if (c6 > '\u001f' && c6 < '\u007f') {
                continue;
            }
            return i5;
        }
        return -1;
    }

    public static boolean verifyAsIpAddress(String string2) {
        return VERIFY_AS_IP_ADDRESS.matcher(string2).matches();
    }

    public static String format(String string2, Object ... objectArray) {
        return String.format(Locale.US, string2, objectArray);
    }

    public static Charset bomAwareCharset(BufferedSource bufferedSource, Charset charset) throws IOException {
        ByteString byteString = UTF_8_BOM;
        if (bufferedSource.rangeEquals(0L, byteString)) {
            bufferedSource.skip(byteString.size());
            return UTF_8;
        }
        byteString = UTF_16_BE_BOM;
        if (bufferedSource.rangeEquals(0L, byteString)) {
            bufferedSource.skip(byteString.size());
            return UTF_16_BE;
        }
        byteString = UTF_16_LE_BOM;
        if (bufferedSource.rangeEquals(0L, byteString)) {
            bufferedSource.skip(byteString.size());
            return UTF_16_LE;
        }
        byteString = UTF_32_BE_BOM;
        if (bufferedSource.rangeEquals(0L, byteString)) {
            bufferedSource.skip(byteString.size());
            return UTF_32_BE;
        }
        byteString = UTF_32_LE_BOM;
        if (bufferedSource.rangeEquals(0L, byteString)) {
            bufferedSource.skip(byteString.size());
            return UTF_32_LE;
        }
        return charset;
    }

    public static int checkDuration(String string2, long l5, TimeUnit timeUnit) {
        if (l5 >= 0L) {
            if (timeUnit != null) {
                long l6 = timeUnit.toMillis(l5);
                if (l6 <= Integer.MAX_VALUE) {
                    if (l6 == 0L && l5 > 0L) {
                        throw new IllegalArgumentException(string2 + " too small.");
                    }
                    return (int)l6;
                }
                throw new IllegalArgumentException(string2 + " too large.");
            }
            throw new NullPointerException("unit == null");
        }
        throw new IllegalArgumentException(string2 + " < 0");
    }

    public static AssertionError assertionError(String string2, Exception exception) {
        AssertionError assertionError;
        AssertionError assertionError2 = assertionError;
        try {
            ((Throwable)((Object)new AssertionError((Object)string2))).initCause(exception);
        }
        catch (IllegalStateException illegalStateException) {
            return assertionError2;
        }
        return assertionError2;
    }

    public static int decodeHexDigit(char c6) {
        if (c6 >= '0' && c6 <= '9') {
            return c6 - 48;
        }
        if (c6 >= 'a' && c6 <= 'f') {
            return c6 - 87;
        }
        if (c6 >= 'A' && c6 <= 'F') {
            return c6 - 55;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static InetAddress decodeIpv6(String string2, int n5, int n6) {
        int n7 = 16;
        byte[] byArray = new byte[16];
        int n8 = 0;
        int n9 = -1;
        int n10 = -1;
        while (n5 < n6) {
            int n11;
            int n12;
            block16: {
                if (n8 == n7) {
                    return null;
                }
                n12 = n5 + 2;
                if (n12 <= n6 && string2.regionMatches(n5, "::", 0, 2)) {
                    if (n9 != -1) {
                        return null;
                    }
                    n9 = n8 + 2;
                    if (n12 == n6) {
                        n8 = n9;
                        break;
                    }
                    n8 = n9;
                    n10 = n12;
                } else {
                    if (n8 != 0) {
                        if (string2.regionMatches(n5, ":", 0, 1)) {
                            n10 = ++n5;
                            break block16;
                        } else {
                            if (!string2.regionMatches(n5, ".", 0, 1)) return null;
                            int n13 = n8 - 2;
                            if (!Util.decodeIpv4Suffix(string2, n10, n6, byArray, n13)) {
                                return null;
                            }
                            n8 += 2;
                            break;
                        }
                    }
                    n10 = n5;
                }
            }
            n12 = n5 = 0;
            for (n5 = n10; n5 < n6 && (n11 = Util.decodeHexDigit(string2.charAt(n5))) != -1; ++n5) {
                n12 = (n12 << 4) + n11;
            }
            n11 = n5 - n10;
            if (n11 == 0) return null;
            if (n11 > 4) {
                return null;
            }
            int n14 = n12;
            int n15 = n12;
            n12 = n8 + 1;
            byArray[n8] = (byte)(n15 >>> 8 & 0xFF);
            n8 += 2;
            byArray[n12] = (byte)(n14 & 0xFF);
        }
        if (n8 != n7) {
            if (n9 == -1) {
                return null;
            }
            int n16 = n9;
            int n17 = n8 - n9;
            System.arraycopy(byArray, n9, byArray, n7 - n17, n17);
            Arrays.fill(byArray, n16, n16 + (n7 - n8), (byte)0);
        }
        try {
            return InetAddress.getByAddress(byArray);
        }
        catch (UnknownHostException unknownHostException) {
            throw new AssertionError();
        }
    }

    private static boolean decodeIpv4Suffix(String string2, int n5, int n6, byte[] byArray, int n7) {
        int n8 = n7;
        while (n5 < n6) {
            char c6;
            int n9;
            if (n8 == byArray.length) {
                return false;
            }
            if (n8 != n7 && string2.charAt(n5) != '.') {
                return false;
            }
            int n10 = n9 = 0;
            for (n9 = ++n5; n9 < n6 && (c6 = string2.charAt(n9)) >= '0' && c6 <= '9'; ++n9) {
                if (n10 == 0 && n5 != n9) {
                    return false;
                }
                if ((n10 = n10 * 10 + c6 - 48) <= 255) continue;
                return false;
            }
            if (n9 - n5 == 0) {
                return false;
            }
            n5 = n8 + 1;
            byArray[n8] = (byte)n10;
            n8 = n5;
            n5 = n9;
        }
        return n8 == n7 + 4;
    }

    private static String inet6AddressToAscii(byte[] byArray) {
        Buffer buffer;
        int n5;
        int n6 = -1;
        int n7 = 0;
        int n8 = 0;
        while (n8 < byArray.length) {
            for (n5 = n8; n5 < 16 && byArray[n5] == 0 && byArray[n5 + 1] == 0; n5 += 2) {
            }
            int n9 = n5 - n8;
            if (n9 > n7 && n9 >= 4) {
                n7 = n9;
                n6 = n8;
            }
            n8 = n5 + 2;
        }
        Buffer buffer2 = buffer;
        buffer = new Buffer();
        n5 = 0;
        while (n5 < byArray.length) {
            if (n5 == n6) {
                buffer2.writeByte(58);
                if ((n5 += n7) != 16) continue;
                buffer2.writeByte(58);
                continue;
            }
            if (n5 > 0) {
                buffer2.writeByte(58);
            }
            buffer2.writeHexadecimalUnsignedLong((byArray[n5] & 0xFF) << 8 | byArray[n5 + 1] & 0xFF);
            n5 += 2;
        }
        return buffer2.readUtf8();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static X509TrustManager platformTrustManager() {
        TrustManager trustManager;
        Object[] objectArray;
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            objectArray = trustManagerFactory.getTrustManagers();
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw Util.assertionError("No System TLS", generalSecurityException);
        }
        {
            if (objectArray.length != 1) throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(objectArray));
            trustManager = objectArray[0];
        }
        if (!(trustManager instanceof X509TrustManager)) throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(objectArray));
        return (X509TrustManager)trustManager;
    }

    public static Headers toHeaders(List<Header> object) {
        Headers.Builder builder;
        Object object2 = object;
        object = builder;
        builder = new Headers.Builder();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            Header header;
            Header header2 = header = (Header)iterator.next();
            String object22 = header2.name.utf8();
            Internal.instance.addLenient((Headers.Builder)object, object22, header2.value.utf8());
        }
        return ((Headers.Builder)object).build();
    }

    static {
        Object object = new byte[]{};
        EMPTY_BYTE_ARRAY = object;
        EMPTY_STRING_ARRAY = new String[0];
        EMPTY_RESPONSE = ResponseBody.create(null, object);
        EMPTY_REQUEST = RequestBody.create(null, object);
        UTF_8_BOM = ByteString.decodeHex("efbbbf");
        UTF_16_BE_BOM = ByteString.decodeHex("feff");
        UTF_16_LE_BOM = ByteString.decodeHex("fffe");
        UTF_32_BE_BOM = ByteString.decodeHex("0000ffff");
        UTF_32_LE_BOM = ByteString.decodeHex("ffff0000");
        UTF_8 = Charset.forName("UTF-8");
        ISO_8859_1 = Charset.forName("ISO-8859-1");
        UTF_16_BE = Charset.forName("UTF-16BE");
        UTF_16_LE = Charset.forName("UTF-16LE");
        UTF_32_BE = Charset.forName("UTF-32BE");
        UTF_32_LE = Charset.forName("UTF-32LE");
        UTC = TimeZone.getTimeZone("GMT");
        NATURAL_ORDER = new Comparator<String>(){

            @Override
            public int compare(String string2, String string3) {
                return string2.compareTo(string3);
            }
        };
        try {
            object = Throwable.class.getDeclaredMethod("addSuppressed", Throwable.class);
        }
        catch (Exception exception) {
            object = null;
        }
        addSuppressedExceptionMethod = object;
        VERIFY_AS_IP_ADDRESS = Pattern.compile("([0-9a-fA-F]*:[0-9a-fA-F:.]*)|([\\d.]+)");
    }
}

