/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okhttp3.internal.http2;

import dc.squareup.okhttp3.internal.Util;
import dc.squareup.okio.ByteString;
import java.io.IOException;

public final class Http2 {
    static final ByteString CONNECTION_PREFACE;
    static final int INITIAL_MAX_FRAME_SIZE = 16384;
    static final byte TYPE_DATA = 0;
    static final byte TYPE_HEADERS = 1;
    static final byte TYPE_PRIORITY = 2;
    static final byte TYPE_RST_STREAM = 3;
    static final byte TYPE_SETTINGS = 4;
    static final byte TYPE_PUSH_PROMISE = 5;
    static final byte TYPE_PING = 6;
    static final byte TYPE_GOAWAY = 7;
    static final byte TYPE_WINDOW_UPDATE = 8;
    static final byte TYPE_CONTINUATION = 9;
    static final byte FLAG_NONE = 0;
    static final byte FLAG_ACK = 1;
    static final byte FLAG_END_STREAM = 1;
    static final byte FLAG_END_HEADERS = 4;
    static final byte FLAG_END_PUSH_PROMISE = 4;
    static final byte FLAG_PADDED = 8;
    static final byte FLAG_PRIORITY = 32;
    static final byte FLAG_COMPRESSED = 32;
    private static final String[] FRAME_NAMES;
    static final String[] FLAGS;
    static final String[] BINARY;

    private Http2() {
    }

    static IllegalArgumentException illegalArgument(String string2, Object ... objectArray) {
        throw new IllegalArgumentException(Util.format(string2, objectArray));
    }

    static IOException ioException(String string2, Object ... objectArray) throws IOException {
        throw new IOException(Util.format(string2, objectArray));
    }

    static String frameLog(boolean bl, int n5, int n6, byte by, byte by2) {
        Object object = FRAME_NAMES;
        if (by < FRAME_NAMES.length) {
            object = object[by];
        } else {
            object = by;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = object;
            object = Util.format("0x%02x", objectArray2);
        }
        String string2 = Http2.formatFlags(by, by2);
        String string3 = "%s 0x%08x %5d %-13s %s";
        String string4 = bl ? "<<" : ">>";
        Integer n7 = n5;
        Integer n8 = n6;
        return Util.format(string3, string4, n7, n8, object, string2);
    }

    static String formatFlags(byte by, byte by2) {
        if (by2 == 0) {
            return "";
        }
        switch (by) {
            default: {
                Object object = FLAGS;
                object = by2 < FLAGS.length ? object[by2] : BINARY[by2];
                if (by == 5 && (by2 & 4) != 0) {
                    return ((String)object).replace("HEADERS", "PUSH_PROMISE");
                }
                if (by == 0 && (by2 & 0x20) != 0) {
                    return ((String)object).replace("PRIORITY", "COMPRESSED");
                }
                return object;
            }
            case 4: 
            case 6: {
                if (by2 == 1) {
                    return "ACK";
                }
                return BINARY[by2];
            }
            case 2: 
            case 3: 
            case 7: 
            case 8: 
        }
        return BINARY[by2];
    }

    static {
        StringBuilder stringBuilder;
        Object object;
        CONNECTION_PREFACE = ByteString.encodeUtf8("PRI * HTTP/2.0\r\n\r\nSM\r\n\r\n");
        FRAME_NAMES = new String[]{"DATA", "HEADERS", "PRIORITY", "RST_STREAM", "SETTINGS", "PUSH_PROMISE", "PING", "GOAWAY", "WINDOW_UPDATE", "CONTINUATION"};
        FLAGS = new String[64];
        BINARY = new String[256];
        int n5 = 0;
        while (true) {
            object = BINARY;
            if (n5 >= BINARY.length) break;
            String[] stringArray = object;
            int n6 = n5++;
            object = Integer.toBinaryString(n6);
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = object;
            stringArray[n6] = Util.format("%8s", objectArray2).replace(' ', '0');
        }
        String[] stringArray = FLAGS;
        String[] stringArray2 = stringArray;
        stringArray[0] = "";
        stringArray[1] = "END_STREAM";
        int[] nArray = new int[1];
        object = nArray;
        object[0] = (String)true;
        stringArray2[8] = "PADDED";
        int n7 = nArray[0];
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder2();
        stringArray[n7 | 8] = stringBuilder.append(stringArray2[n7]).append("|PADDED").toString();
        stringArray[4] = "END_HEADERS";
        stringArray[32] = "PRIORITY";
        Http2.FLAGS[36] = "END_HEADERS|PRIORITY";
        int n8 = 3;
        int[] nArray2 = new int[3];
        int[] nArray3 = nArray2;
        nArray2[0] = 4;
        nArray2[1] = 32;
        nArray2[2] = 36;
        for (int i5 = 0; i5 < n8; ++i5) {
            StringBuilder stringBuilder3;
            StringBuilder stringBuilder4;
            int n9 = nArray3[i5];
            String string2 = object[0];
            String[] stringArray3 = FLAGS;
            int n10 = string2 | n9;
            StringBuilder stringBuilder5 = stringBuilder4;
            stringBuilder5();
            stringArray3[n10] = stringBuilder4.append(stringArray3[string2]).append('|').append(stringArray3[n9]).toString();
            stringBuilder5 = stringBuilder3;
            stringBuilder5();
            FLAGS[n10 | 8] = stringBuilder3.append(stringArray3[string2]).append('|').append(stringArray3[n9]).append("|PADDED").toString();
        }
        n8 = 0;
        while (true) {
            object = FLAGS;
            if (n8 >= FLAGS.length) break;
            if (object[n8] == null) {
                object[n8] = BINARY[n8];
            }
            ++n8;
        }
    }
}

