/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober.distributionanalysis;

public abstract class CharDistributionAnalysis {
    public static final float SURE_NO = 0.01f;
    public static final float SURE_YES = 0.99f;
    public static final int ENOUGH_DATA_THRESHOLD = 1024;
    public static final int MINIMUM_DATA_THRESHOLD = 4;
    private int freqChars;
    private int totalChars;
    protected int[] charToFreqOrder;
    protected float typicalDistributionRatio;

    public CharDistributionAnalysis() {
        CharDistributionAnalysis charDistributionAnalysis = this;
        charDistributionAnalysis.reset();
    }

    public void handleData(byte[] byArray, int n5, int n6) {
    }

    public void handleOneChar(byte[] objectArray, int n5, int n6) {
        int n7 = n6;
        n6 = -1;
        if (n7 == 2) {
            n6 = this.getOrder((byte[])objectArray, n5);
        }
        if (n6 >= 0) {
            CharDistributionAnalysis charDistributionAnalysis = this;
            ++charDistributionAnalysis.totalChars;
            objectArray = charDistributionAnalysis.charToFreqOrder;
            if (n6 < charDistributionAnalysis.charToFreqOrder.length && 512 > objectArray[n6]) {
                ++this.freqChars;
                return;
            }
        }
    }

    public float getConfidence() {
        int n5;
        int n6 = this.totalChars;
        if (n6 > 0 && (n5 = this.freqChars) > 4) {
            if (n6 != n5) {
                float f5;
                float f6 = (float)n5 / ((float)(n6 - n5) * this.typicalDistributionRatio);
                if (f5 < 0.99f) {
                    return f6;
                }
            }
            return 0.99f;
        }
        return 0.01f;
    }

    public void reset() {
        CharDistributionAnalysis charDistributionAnalysis = this;
        charDistributionAnalysis.totalChars = 0;
        charDistributionAnalysis.freqChars = 0;
    }

    public void setOption() {
    }

    public boolean gotEnoughData() {
        return this.totalChars > 1024;
    }

    protected abstract int getOrder(byte[] var1, int var2);
}

