/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import dc.squareup.okio.Buffer;
import dc.squareup.okio.BufferedSink;
import dc.squareup.okio.ByteString;
import dc.squareup.okio.Sink;
import dc.squareup.okio.Source;
import dc.squareup.okio.Timeout;
import dc.squareup.okio.Util;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;

final class RealBufferedSink
implements BufferedSink {
    public final Buffer buffer;
    public final Sink sink;
    boolean closed;

    RealBufferedSink(Sink sink) {
        Buffer buffer;
        Buffer buffer2 = buffer;
        buffer = new Buffer();
        this.buffer = buffer2;
        if (sink != null) {
            this.sink = sink;
            return;
        }
        throw new NullPointerException("sink == null");
    }

    @Override
    public Buffer buffer() {
        return this.buffer;
    }

    @Override
    public void write(Buffer buffer, long l5) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.write(buffer, l5);
            realBufferedSink.emitCompleteSegments();
            return;
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink write(ByteString byteString) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.write(byteString);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink writeUtf8(String string2) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.writeUtf8(string2);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink writeUtf8(String string2, int n5, int n6) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.writeUtf8(string2, n5, n6);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink writeUtf8CodePoint(int n5) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.writeUtf8CodePoint(n5);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink writeString(String string2, Charset charset) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.writeString(string2, charset);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink writeString(String string2, int n5, int n6, Charset charset) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.writeString(string2, n5, n6, charset);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink write(byte[] byArray) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.write(byArray);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink write(byte[] byArray, int n5, int n6) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.write(byArray, n5, n6);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (!this.closed) {
            int n5 = this.buffer.write(byteBuffer);
            this.emitCompleteSegments();
            return n5;
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public long writeAll(Source source) throws IOException {
        if (source != null) {
            long l5;
            long l6 = 0L;
            while ((l5 = source.read(this.buffer, 8192L)) != -1L) {
                l6 += l5;
                this.emitCompleteSegments();
            }
            return l6;
        }
        throw new IllegalArgumentException("source == null");
    }

    @Override
    public BufferedSink write(Source source, long l5) throws IOException {
        while (l5 > 0L) {
            long l6 = source.read(this.buffer, l5);
            if (l6 != -1L) {
                l5 -= l6;
                this.emitCompleteSegments();
                continue;
            }
            throw new EOFException();
        }
        return this;
    }

    @Override
    public BufferedSink writeByte(int n5) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.writeByte(n5);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink writeShort(int n5) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.writeShort(n5);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink writeShortLe(int n5) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.writeShortLe(n5);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink writeInt(int n5) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.writeInt(n5);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink writeIntLe(int n5) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.writeIntLe(n5);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink writeLong(long l5) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.writeLong(l5);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink writeLongLe(long l5) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.writeLongLe(l5);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink writeDecimalLong(long l5) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.writeDecimalLong(l5);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink writeHexadecimalUnsignedLong(long l5) throws IOException {
        if (!this.closed) {
            RealBufferedSink realBufferedSink = this;
            realBufferedSink.buffer.writeHexadecimalUnsignedLong(l5);
            return realBufferedSink.emitCompleteSegments();
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink emitCompleteSegments() throws IOException {
        if (!this.closed) {
            long l5 = this.buffer.completeSegmentByteCount();
            if (l5 > 0L) {
                RealBufferedSink realBufferedSink = this;
                realBufferedSink.sink.write(this.buffer, l5);
                return realBufferedSink;
            }
            return this;
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public BufferedSink emit() throws IOException {
        if (!this.closed) {
            long l5 = this.buffer.size();
            if (l5 > 0L) {
                RealBufferedSink realBufferedSink = this;
                realBufferedSink.sink.write(this.buffer, l5);
                return realBufferedSink;
            }
            return this;
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public OutputStream outputStream() {
        return new OutputStream(){

            @Override
            public void write(int n5) throws IOException {
                RealBufferedSink realBufferedSink = RealBufferedSink.this;
                if (!realBufferedSink.closed) {
                    realBufferedSink.buffer.writeByte((byte)n5);
                    RealBufferedSink.this.emitCompleteSegments();
                    return;
                }
                throw new IOException("closed");
            }

            @Override
            public void write(byte[] byArray, int n5, int n6) throws IOException {
                RealBufferedSink realBufferedSink = RealBufferedSink.this;
                if (!realBufferedSink.closed) {
                    realBufferedSink.buffer.write(byArray, n5, n6);
                    RealBufferedSink.this.emitCompleteSegments();
                    return;
                }
                throw new IOException("closed");
            }

            @Override
            public void flush() throws IOException {
                Closeable closeable = closeable.RealBufferedSink.this;
                if (!((RealBufferedSink)closeable).closed) {
                    ((RealBufferedSink)closeable).flush();
                    return;
                }
            }

            @Override
            public void close() throws IOException {
                RealBufferedSink.this.close();
            }

            public String toString() {
                return RealBufferedSink.this + ".outputStream()";
            }
        };
    }

    @Override
    public void flush() throws IOException {
        if (!this.closed) {
            Buffer buffer = this.buffer;
            long l5 = buffer.size;
            if (l5 > 0L) {
                this.sink.write(buffer, l5);
            }
            this.sink.flush();
            return;
        }
        throw new IllegalStateException("closed");
    }

    @Override
    public boolean isOpen() {
        return this.closed ^ true;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            Throwable throwable;
            block9: {
                block8: {
                    throwable = null;
                    Buffer buffer = this.buffer;
                    long l5 = buffer.size;
                    if (l5 <= 0L) break block8;
                    try {
                        this.sink.write(buffer, l5);
                    }
                    catch (Throwable throwable2) {
                        // empty catch block
                    }
                }
                try {
                    this.sink.close();
                }
                catch (Throwable throwable3) {
                    if (throwable != null) break block9;
                    throwable = throwable3;
                }
            }
            this.closed = true;
            if (throwable != null) {
                Util.sneakyRethrow(throwable);
            }
        }
    }

    @Override
    public Timeout timeout() {
        return this.sink.timeout();
    }

    public String toString() {
        return "buffer(" + this.sink + ")";
    }
}

