/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex_media;

import android.content.Context;
import android.graphics.Canvas;
import android.net.Uri;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bumptech.glide.Glide;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.ui.component.WXComponent;
import io.dcloud.common.util.FileUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.StringUtil;
import io.dcloud.feature.weex.adapter.ScalableViewComponent;
import io.dcloud.feature.weex_media.VideoComponent;
import io.dcloud.feature.weex_media.option.EnumPlayStrategy;
import io.dcloud.media.weex.weex_video.ijkplayer.OnPlayerChangedListener;
import io.dcloud.media.weex.weex_video.ijkplayer.media.AssetsDataSourceProvider;
import io.dcloud.media.weex.weex_video.ijkplayer.media.IjkPlayerView;
import java.util.HashMap;
import java.util.Map;
import tv.danmaku.ijk.media.player.IMediaPlayer;

public class VideoPlayerView
extends FrameLayout
implements IMediaPlayer.OnInfoListener,
OnPlayerChangedListener,
IMediaPlayer.OnBufferingUpdateListener {
    private String mSrc = "";
    private String mHeader = "";
    private boolean autoplay = false;
    private boolean loop = false;
    private String poster = "";
    private float duration = -1.0f;
    private float initialTime = 0.0f;
    private boolean isFinishLayout = false;
    private int seek = 0;
    public IjkPlayerView mPlayerView;
    private VideoComponent mComponent;
    private Context mContext;
    private FrameLayout subViewContainer;
    public boolean mIsFullScreen = false;
    private boolean isCreate = false;
    private boolean isEnableDanmu = false;
    private boolean isEnableDanmuBtn = false;

    public VideoPlayerView(Context context, VideoComponent component) {
        super(context);
        this.mContext = context;
        this.mComponent = component;
        this.subViewContainer = new FrameLayout(context);
        this.addView((View)this.subViewContainer, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.createVideoView();
        this.subViewContainer.bringToFront();
        IOnPlayerViewChangeListener onPlayerViewChangeListener = new IOnPlayerViewChangeListener(){

            @Override
            public void onChanged(boolean isFullScreen) {
                VideoPlayerView.this.mIsFullScreen = isFullScreen;
            }
        };
        this.mPlayerView.setChangeListener(onPlayerViewChangeListener);
        if (component.getInstance().isFrameViewShow()) {
            this.mPlayerView.setVideoVisibility();
        } else {
            component.getInstance().addFrameViewEventListener(new WXSDKInstance.FrameViewEventListener(){

                public void onShowAnimationEnd() {
                    if (VideoPlayerView.this.mPlayerView != null) {
                        VideoPlayerView.this.mPlayerView.setVideoVisibility();
                    }
                    if (VideoPlayerView.this.mComponent != null && VideoPlayerView.this.mComponent.getInstance() != null) {
                        VideoPlayerView.this.mComponent.getInstance().removeFrameViewEventListener((WXSDKInstance.FrameViewEventListener)this);
                    }
                }
            });
        }
    }

    public void createVideoView() {
        if (this.isCreate) {
            return;
        }
        this.isCreate = true;
        this.mPlayerView = new IjkPlayerView(this.mContext, null, this);
        this.mPlayerView.setComponent(this.mComponent);
        this.addView((View)this.mPlayerView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
        this.mPlayerView.init().setPlayerRootView((ViewGroup)this);
        this.mPlayerView.setOnInfoListener(this);
        this.mPlayerView.setOnPlayerChangedListener(this);
        this.mPlayerView.setOnBufferingUpdateListener(this);
    }

    public ViewGroup getPlayerView() {
        return this.subViewContainer;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (PdrUtil.isEmpty((Object)this.mComponent.getStyles().getBackgroundColor())) {
            this.setBackgroundColor(-16777216);
        }
    }

    public synchronized void onLayoutFinished(String willBeSetSrc) {
        if (this.mPlayerView == null) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mSrc) && TextUtils.isEmpty((CharSequence)willBeSetSrc)) {
            return;
        }
        AssetsDataSourceProvider fd = null;
        if (!TextUtils.isEmpty((CharSequence)willBeSetSrc) && !PdrUtil.isNetPath((String)willBeSetSrc)) {
            Uri fileUri;
            willBeSetSrc = this.mComponent.getInstance().rewriteUri(Uri.parse((String)willBeSetSrc), "video").getPath();
            if (willBeSetSrc != null && !PdrUtil.isDeviceRootDir((String)willBeSetSrc)) {
                try {
                    if (this.mComponent.getIApp() != null) {
                        if (!willBeSetSrc.startsWith("/")) {
                            willBeSetSrc = "/" + willBeSetSrc;
                        }
                        willBeSetSrc = this.mComponent.getIApp().checkPrivateDirAndCopy2Temp(willBeSetSrc);
                        willBeSetSrc = this.mComponent.getInstance().rewriteUri(Uri.parse((String)willBeSetSrc), "video").getPath();
                    } else {
                        if (willBeSetSrc.startsWith("/")) {
                            willBeSetSrc = willBeSetSrc.replaceFirst("/", "");
                        }
                        fd = new AssetsDataSourceProvider(this.mComponent.getContext().getAssets().openFd(willBeSetSrc));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!FileUtil.checkPrivatePath((Context)this.getContext(), (String)willBeSetSrc) && (fileUri = FileUtil.getVideoFileUri((Context)this.getContext(), (String)willBeSetSrc)) != null) {
                willBeSetSrc = fileUri.toString();
            }
        }
        if (TextUtils.isEmpty((CharSequence)this.mSrc)) {
            if (fd == null) {
                this.mPlayerView.setVideoPath(willBeSetSrc);
            } else {
                this.mPlayerView.setVideoFileDescriptor(fd);
            }
            this.mPlayerView.clearDanma();
        } else if (!this.mSrc.equalsIgnoreCase(willBeSetSrc)) {
            if (fd == null) {
                this.mPlayerView.switchVideoPath(willBeSetSrc);
            } else {
                this.mPlayerView.switchVideoFileDescriptor(fd);
            }
            this.mPlayerView.clearDanma();
            this.mPlayerView.setMutePlayer(this.mPlayerView.isMutePlayer());
        }
        this.mSrc = willBeSetSrc;
        this.mPlayerView.setDuration((int)this.duration);
        if (this.initialTime > 0.0f) {
            this.mPlayerView.seekTo((int)this.initialTime);
        }
        this.mPlayerView.enableDanmaku(this.isEnableDanmu);
        this.mPlayerView.enableDanmuBtn(this.isEnableDanmuBtn);
        this.isFinishLayout = true;
        if (this.autoplay) {
            this.play();
        }
    }

    public void requestFullScreen(int oritation) {
        if (PdrUtil.isEmpty((Object)oritation)) {
            oritation = 90;
        }
        if (this.mPlayerView != null) {
            this.mPlayerView.fullScreen(oritation);
        }
    }

    public void exitFullScreen() {
        if (this.mPlayerView != null) {
            this.mPlayerView.exitFullScreen();
        }
    }

    public void play() {
        if (this.mPlayerView != null) {
            this.mPlayerView.start();
        }
    }

    public void pause() {
        if (this.mPlayerView != null) {
            this.mPlayerView.pause();
        }
    }

    public void resume() {
        if (this.mPlayerView != null) {
            this.mPlayerView.onResume();
        }
    }

    public void stop() {
        if (this.mPlayerView != null) {
            this.mPlayerView.stop();
        }
    }

    public void seek(int position) {
        if (this.mPlayerView != null) {
            this.seek = position;
            this.mPlayerView.seekTo(this.seek);
        }
    }

    public void sendDanmu(JSONObject danmu) {
        if (this.mPlayerView != null) {
            this.mPlayerView.sendDanmaku(new org.json.JSONObject((Map)danmu), true);
        }
    }

    public void sendPlayBackRate(String rate) {
        if (this.mPlayerView != null) {
            this.mPlayerView.playbackRate(rate);
        }
    }

    public void destory() {
        if (this.mPlayerView != null) {
            this.mPlayerView.onDestroy();
            this.mPlayerView = null;
        }
    }

    public void setSrc(String mSrc) {
        if (TextUtils.isEmpty((CharSequence)mSrc)) {
            return;
        }
        if (this.isFinishLayout) {
            this.onLayoutFinished(mSrc);
        }
    }

    public void setHeader(String header) {
        if (this.mPlayerView != null) {
            this.mPlayerView.setHeader(header);
            if (this.isFinishLayout) {
                this.onLayoutFinished("");
            }
        }
    }

    public void onActivityResume() {
        if (!TextUtils.isEmpty((CharSequence)this.poster)) {
            Glide.with((View)this).load(this.poster).into(this.mPlayerView.mPlayerThumb);
        }
    }

    public void setAutoplay(boolean autoplay) {
        this.autoplay = autoplay;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public void setPoster(String poster) {
        if (this.mPlayerView != null && !TextUtils.isEmpty((CharSequence)poster) && !this.poster.equalsIgnoreCase(poster)) {
            Glide.with((View)this).load(poster).into(this.mPlayerView.mPlayerThumb);
            this.poster = poster;
        }
    }

    public void setProgress(boolean isShow) {
        if (this.mPlayerView != null) {
            this.mPlayerView.setProgressVisibility(isShow);
        }
    }

    public void setPlayBtnVisibility(boolean isshow) {
        if (this.mPlayerView != null) {
            this.mPlayerView.setPlayBntVisibility(isshow);
        }
    }

    public void setMuted(boolean muted) {
        if (this.mPlayerView != null) {
            this.mPlayerView.setMutePlayer(muted);
        }
    }

    public void setControls(boolean controls) {
        if (this.mPlayerView != null) {
            this.mPlayerView.setControls(controls);
        }
    }

    public void setPageGesture(boolean pageGesture) {
        if (this.mPlayerView != null) {
            this.mPlayerView.setPageGesture(pageGesture);
        }
    }

    public void setLockScreen(boolean lockScreen) {
        if (this.mPlayerView != null) {
            this.mPlayerView.setIsShowScreenLockButton(lockScreen);
        }
    }

    public void setEnablePlayGesture(boolean enable) {
        if (this.mPlayerView != null) {
            this.mPlayerView.setmIsDoubleTapEnable(enable);
        }
    }

    public void setFullScreenPageGesture(boolean pageGesture) {
        if (this.mPlayerView != null) {
            this.mPlayerView.setFullScreenPageGesture(pageGesture);
        }
    }

    public void setShowFullScreenBtn(boolean showFullScreenBtn) {
        if (this.mPlayerView != null) {
            this.mPlayerView.setFullscreenBntVisibility(showFullScreenBtn);
        }
    }

    public void setEnableProgressGesture(boolean enableProgressGesture) {
        if (this.mPlayerView != null) {
            this.mPlayerView.setIsEnableProgressGesture(enableProgressGesture);
        }
    }

    public void setDirection(int direction) {
        if (this.mPlayerView != null) {
            this.mPlayerView.setDirection(direction);
        }
    }

    public void setEnableDanmu(boolean enableDanmu) {
        if (this.mPlayerView != null) {
            this.isEnableDanmu = enableDanmu;
            this.mPlayerView.enableDanmaku(enableDanmu);
        }
    }

    public void setDanmuBtn(boolean danmuBtn) {
        if (this.mPlayerView != null) {
            this.isEnableDanmuBtn = danmuBtn;
            this.mPlayerView.enableDanmuBtn(danmuBtn);
        }
    }

    public void setDanmuList(JSONArray danmuList) {
        if (this.mPlayerView != null) {
            this.mPlayerView.setmDanmuList(danmuList.toString());
        }
    }

    public void setObjectFit(String objectFit) {
        if (TextUtils.isEmpty((CharSequence)objectFit)) {
            return;
        }
        if (this.mPlayerView != null) {
            this.mPlayerView.setScaleType(objectFit);
        }
    }

    public void setMuteBtn(boolean isshow) {
        if (this.mPlayerView != null) {
            this.mPlayerView.isMuteBtnShow(isshow);
        }
    }

    public void setTitle(String title) {
        if (PdrUtil.isEmpty((Object)title)) {
            return;
        }
        if (this.mPlayerView != null) {
            this.mPlayerView.setTitle(title);
        }
    }

    public void setHttpCacheEnable(boolean cacheEnable) {
        if (this.mPlayerView != null) {
            this.mPlayerView.setHttpCacheEnable(cacheEnable);
        }
    }

    public void setFlowStrategy(EnumPlayStrategy intFlowStrategy) {
        if (this.mPlayerView != null) {
            this.mPlayerView.setFlowStrategy(intFlowStrategy);
        }
    }

    public void setShowLoading(boolean isShow) {
        if (this.mPlayerView != null) {
            this.mPlayerView.setLoadingVisibility(isShow);
        }
    }

    public void setPlayBtnPosition(String position) {
        if (this.mPlayerView != null) {
            this.mPlayerView.setPlayBtnPosition(position);
        }
    }

    public void setShowCenterPlayBtn(boolean showCenterPlayBtn) {
        if (this.mPlayerView != null) {
            this.mPlayerView.setCenterPlayBtnVisibility(showCenterPlayBtn);
        }
    }

    public void setCodec(String codec) {
        if (this.mPlayerView != null) {
            this.mPlayerView.isUseMediaCodec(codec.equals("hardware"));
        }
    }

    public void setDuration(float duration) {
        if (this.mPlayerView != null) {
            this.duration = duration * 1000.0f;
            if (this.isFinishLayout) {
                this.mPlayerView.setDuration((int)this.duration);
            }
        }
    }

    public void setInitialTime(float initialTime) {
        if (this.mPlayerView != null) {
            if (initialTime <= 0.0f) {
                return;
            }
            this.initialTime = initialTime * 1000.0f;
            if (this.isFinishLayout) {
                this.mPlayerView.seekTo((int)this.initialTime);
            }
        }
    }

    @Override
    public void onChanged(String type, String msg) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (!TextUtils.isEmpty((CharSequence)msg)) {
            try {
                values.put("detail", JSON.parse((String)msg));
            }
            catch (Exception e) {
                values.put("detail", msg);
            }
        }
        this.execCallBack(type, values);
        if (this.mPlayerView == null) {
            return;
        }
        WXComponent child = this.mComponent.getChild(0);
        if (child instanceof ScalableViewComponent && type.equals("fullscreenchange")) {
            if (this.isFullScreen()) {
                this.removeView((View)this.subViewContainer);
                this.mPlayerView.addView((View)this.subViewContainer);
                this.subViewContainer.bringToFront();
            } else {
                this.mPlayerView.removeView((View)this.subViewContainer);
                this.removeView((View)this.subViewContainer);
                this.addView((View)this.subViewContainer);
                this.subViewContainer.bringToFront();
            }
        }
    }

    public boolean isFullScreen() {
        return this.mPlayerView != null && this.mPlayerView.isFullscreen();
    }

    public boolean onBackPress() {
        return this.mPlayerView != null && this.mPlayerView.onBackPressed();
    }

    public boolean onInfo(IMediaPlayer iMediaPlayer, int status, int i1) {
        switch (status) {
            case 336: {
                if (this.loop) {
                    if (this.initialTime > 0.0f) {
                        this.mPlayerView.seekTo((int)this.initialTime);
                    }
                    this.play();
                }
                this.execCallBack("ended", new HashMap<String, Object>());
                break;
            }
            case 334: {
                this.execCallBack("play", new HashMap<String, Object>());
                break;
            }
            case 335: {
                this.execCallBack("pause", new HashMap<String, Object>());
                break;
            }
            case 331: {
                this.execCallBack("error", new HashMap<String, Object>());
                break;
            }
            case 332: 
            case 701: {
                this.execCallBack("waiting", new HashMap<String, Object>());
                break;
            }
            case 337: {
                String detail = StringUtil.format((String)"{'position':%d}", (Object[])new Object[]{this.mPlayerView != null ? this.mPlayerView.getCurPosition() : 0});
                HashMap<String, Object> seekResultMap = new HashMap<String, Object>();
                seekResultMap.put("detail", detail);
                this.execCallBack("seekcomplete", seekResultMap);
            }
        }
        return false;
    }

    private void execCallBack(String type, Map<String, Object> values) {
        if (this.mComponent.getEvents().contains((Object)type)) {
            this.mComponent.fireEvent(type, values);
        }
    }

    public void onBufferingUpdate(IMediaPlayer iMediaPlayer, int i) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        HashMap<String, Integer> detail = new HashMap<String, Integer>();
        detail.put("buffered", i);
        values.put("detail", detail);
        this.execCallBack("progress", values);
    }

    public int getDirection() {
        if (this.mComponent != null && this.mComponent.getAttrs().containsKey((Object)"direction")) {
            try {
                return Integer.parseInt(String.valueOf(this.mComponent.getAttrs().get((Object)"direction")));
            }
            catch (Exception e) {
                return Integer.MIN_VALUE;
            }
        }
        return Integer.MIN_VALUE;
    }

    public static interface IOnPlayerViewChangeListener {
        public void onChanged(boolean var1);
    }
}

