/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.animation;

import android.animation.PropertyValuesHolder;
import android.text.TextUtils;
import android.util.Pair;
import android.util.Property;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.ui.animation.CameraDistanceProperty;
import com.taobao.weex.utils.FunctionParser;
import com.taobao.weex.utils.WXDataStructureUtil;
import com.taobao.weex.utils.WXExceptionUtils;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class TransformParser {
    public static final String WX_TRANSLATE = "translate";
    public static final String WX_TRANSLATE_X = "translateX";
    public static final String WX_TRANSLATE_Y = "translateY";
    public static final String WX_ROTATE = "rotate";
    public static final String WX_ROTATE_X = "rotateX";
    public static final String WX_ROTATE_Y = "rotateY";
    public static final String WX_ROTATE_Z = "rotateZ";
    public static final String WX_SCALE = "scale";
    public static final String WX_SCALE_X = "scaleX";
    public static final String WX_SCALE_Y = "scaleY";
    public static final String BACKGROUND_COLOR = "backgroundColor";
    public static final String WIDTH = "width";
    public static final String HEIGHT = "height";
    public static final String TOP = "top";
    public static final String BOTTOM = "bottom";
    public static final String RIGHT = "right";
    public static final String LEFT = "left";
    public static final String CENTER = "center";
    private static final String HALF = "50%";
    private static final String FULL = "100%";
    private static final String ZERO = "0%";
    private static final String PX = "px";
    private static final String DEG = "deg";
    public static Map<String, List<Property<View, Float>>> wxToAndroidMap = new ArrayMap();

    public static PropertyValuesHolder[] toHolders(Map<Property<View, Float>, Float> propertyValuesHolderArray) {
        propertyValuesHolderArray = new PropertyValuesHolder[propertyValuesHolderArray.size()];
        int n = 0;
        for (Map.Entry entry : propertyValuesHolderArray.entrySet()) {
            float f = ((Float)entry.getValue()).floatValue();
            propertyValuesHolderArray[n] = PropertyValuesHolder.ofFloat((Property)((Property)entry.getKey()), (float[])new float[]{f});
            ++n;
        }
        return propertyValuesHolderArray;
    }

    public static Map<Property<View, Float>, Float> parseTransForm(String object, @Nullable String object2, final int n, final int n2, final float f) {
        block4: {
            FunctionParser.Mapper<Property<View, Float>, Float> mapper;
            FunctionParser functionParser;
            if (TextUtils.isEmpty((CharSequence)object2)) break block4;
            FunctionParser functionParser2 = functionParser;
            FunctionParser functionParser3 = functionParser;
            String string2 = object2;
            object2 = mapper;
            try {
                mapper = new FunctionParser.Mapper<Property<View, Float>, Float>(){

                    private Map<Property<View, Float>, Float> convertParam(int n3, int n22, float f2, @NonNull List<Property<View, Float>> list, @NonNull List<String> list2) {
                        ArrayList<Float> arrayList;
                        List<Property<View, Float>> list3 = list;
                        HashMap<Property<View, Float>, Float> hashMap = WXDataStructureUtil.newHashMapWithExpectedSize(list3.size());
                        ArrayList<Float> arrayList2 = arrayList;
                        arrayList = new ArrayList<Float>(list.size());
                        if (!(list3.contains(View.ROTATION) || list.contains(View.ROTATION_X) || list.contains(View.ROTATION_Y))) {
                            if (!list.contains(View.TRANSLATION_X) && !list.contains(View.TRANSLATION_Y)) {
                                if (!list.contains(View.SCALE_X) && !list.contains(View.SCALE_Y)) {
                                    if (list.contains(CameraDistanceProperty.getInstance())) {
                                        arrayList2.add(this.parseCameraDistance(list2));
                                    }
                                } else {
                                    arrayList2.addAll(this.parseScale(list.size(), list2));
                                }
                            } else {
                                arrayList2.addAll(this.parseTranslation(list, n3, n22, list2, f2));
                            }
                        } else {
                            arrayList2.addAll(this.parseRotationZ(list2));
                        }
                        if (list.size() == arrayList2.size()) {
                            for (int i = 0; i < list.size(); ++i) {
                                Property<View, Float> property = list.get(i);
                                hashMap.put(property, (Float)arrayList2.get(i));
                            }
                        }
                        return hashMap;
                    }

                    private List<Float> parseScale(int n3, @NonNull List<String> list) {
                        ArrayList<Float> arrayList;
                        ArrayList arrayList2;
                        ArrayList arrayList3 = arrayList2;
                        arrayList2 = new ArrayList(list.size() * 2);
                        ArrayList<Float> arrayList4 = arrayList;
                        arrayList = new ArrayList<Float>(list.size());
                        Iterator<String> iterator = list.iterator();
                        while (iterator.hasNext()) {
                            arrayList4.add(Float.valueOf(WXUtils.fastGetFloat(iterator.next())));
                        }
                        arrayList3.addAll(arrayList4);
                        if (n3 != 1 && list.size() == 1) {
                            Object object = arrayList3;
                            object.addAll(arrayList4);
                            return object;
                        }
                        return arrayList3;
                    }

                    @NonNull
                    private List<Float> parseRotationZ(@NonNull List<String> object) {
                        ArrayList arrayList;
                        ArrayList arrayList2 = arrayList;
                        arrayList = new ArrayList(1);
                        object = object.iterator();
                        while (object.hasNext()) {
                            String string2 = (String)object.next();
                            int n3 = string2.lastIndexOf(TransformParser.DEG);
                            if (n3 != -1) {
                                arrayList2.add(Float.valueOf(WXUtils.fastGetFloat(string2.substring(0, n3))));
                                continue;
                            }
                            arrayList2.add(Float.valueOf((float)Math.toDegrees(WXUtils.fastGetFloat(string2))));
                        }
                        return arrayList2;
                    }

                    private List<Float> parseTranslation(List<Property<View, Float>> list, int n3, int n22, @NonNull List<String> list2, float f2) {
                        ArrayList<Float> arrayList;
                        ArrayList<Float> arrayList2 = arrayList;
                        arrayList = new ArrayList<Float>(2);
                        String string2 = list2.get(0);
                        if (list.size() == 1) {
                            this.parseSingleTranslation(list, n3, n22, arrayList2, string2, f2);
                            return arrayList2;
                        }
                        this.parseDoubleTranslation(n3, n22, list2, arrayList2, string2, f2);
                        return arrayList2;
                    }

                    private void parseSingleTranslation(List<Property<View, Float>> list, int n3, int n22, List<Float> list2, String string2, float f2) {
                        if (list.contains(View.TRANSLATION_X)) {
                            list2.add(Float.valueOf(TransformParser.parsePercentOrPx(string2, n3, f2)));
                            return;
                        }
                        if (list.contains(View.TRANSLATION_Y)) {
                            list2.add(Float.valueOf(TransformParser.parsePercentOrPx(string2, n22, f2)));
                            return;
                        }
                    }

                    private void parseDoubleTranslation(int n3, int n22, @NonNull List<String> list, List<Float> list2, String string2, float f2) {
                        String string3 = list.size() == 1 ? string2 : list.get(1);
                        list2.add(Float.valueOf(TransformParser.parsePercentOrPx(string2, n3, f2)));
                        list2.add(Float.valueOf(TransformParser.parsePercentOrPx(string3, n22, f2)));
                    }

                    private Float parseCameraDistance(List<String> list) {
                        float f4 = Float.MAX_VALUE;
                        if (list.size() == 1) {
                            float f2 = WXViewUtils.getRealPxByWidth(WXUtils.getFloat(list.get(0)), f);
                            float f3 = WXEnvironment.getApplication().getResources().getDisplayMetrics().density;
                            if (!Float.isNaN(f2) && f2 > 0.0f) {
                                f4 = f2 * f3;
                            }
                        }
                        return Float.valueOf(f4);
                    }

                    @Override
                    public Map<Property<View, Float>, Float> map(String string2, List<String> list) {
                        if (list != null && !list.isEmpty() && wxToAndroidMap.containsKey(string2)) {
                            1 v0 = this;
                            int n3 = v0.n;
                            int n22 = v0.n2;
                            float f2 = v0.f;
                            List<Property<View, Float>> list2 = wxToAndroidMap.get(string2);
                            return v0.convertParam(n3, n22, f2, list2, list);
                        }
                        return new HashMap<Property<View, Float>, Float>();
                    }
                };
                functionParser2(string2, object2);
                return functionParser3.parse();
            }
            catch (Exception exception) {
                String string3 = object;
                WXLogUtils.e("TransformParser", exception);
                object = WXErrorCode.WX_RENDER_ERR_TRANSITION;
                WXExceptionUtils.commitCriticalExceptionRT(string3, (WXErrorCode)((Object)object), "parse animation transition", ((WXErrorCode)((Object)object)).getErrorMsg() + "parse transition error: " + exception.getMessage(), null);
            }
        }
        return new LinkedHashMap<Property<View, Float>, Float>();
    }

    private static Pair<Float, Float> parsePivot(@Nullable String string2, int n, int n2, float f) {
        int n3;
        if (!TextUtils.isEmpty((CharSequence)string2) && (n3 = string2.indexOf(32)) != -1) {
            int n4;
            for (n4 = n3; n4 < string2.length() && string2.charAt(n4) == ' '; ++n4) {
            }
            if (n4 < string2.length() && string2.charAt(n4) != ' ') {
                ArrayList<String> arrayList;
                ArrayList<String> arrayList2 = arrayList;
                arrayList2(2);
                arrayList2.add(string2.substring(0, n3).trim());
                arrayList2.add(string2.substring(n4, string2.length()).trim());
                return TransformParser.parsePivot(arrayList, n, n2, f);
            }
        }
        return null;
    }

    private static Pair<Float, Float> parsePivot(@NonNull List<String> object, int n, int n2, float f) {
        List<String> list = object;
        object = Float.valueOf(TransformParser.parsePivotX(list.get(0), n, f));
        return new Pair(object, (Object)Float.valueOf(TransformParser.parsePivotY(list.get(1), n2, f)));
    }

    private static float parsePivotX(String string2, int n, float f) {
        if (LEFT.equals(string2)) {
            string2 = ZERO;
        } else if (RIGHT.equals(string2)) {
            string2 = FULL;
        } else if (CENTER.equals(string2)) {
            string2 = HALF;
        }
        return TransformParser.parsePercentOrPx(string2, n, f);
    }

    private static float parsePivotY(String string2, int n, float f) {
        if (TOP.equals(string2)) {
            string2 = ZERO;
        } else if (BOTTOM.equals(string2)) {
            string2 = FULL;
        } else if (CENTER.equals(string2)) {
            string2 = HALF;
        }
        return TransformParser.parsePercentOrPx(string2, n, f);
    }

    private static float parsePercentOrPx(String string2, int n, float f) {
        int n2 = string2.lastIndexOf(37);
        if (n2 != -1) {
            return TransformParser.parsePercent(string2.substring(0, n2), n, 1);
        }
        n = string2.lastIndexOf(PX);
        if (n != -1) {
            return WXViewUtils.getRealPxByWidth(WXUtils.fastGetFloat(string2.substring(0, n), 1.0f), f);
        }
        return WXViewUtils.getRealPxByWidth(WXUtils.fastGetFloat(string2, 1.0f), f);
    }

    private static float parsePercent(String string2, int n, int n2) {
        return WXUtils.fastGetFloat(string2, n2) / 100.0f * (float)n;
    }

    static {
        Property property = View.TRANSLATION_X;
        Property property2 = View.TRANSLATION_Y;
        wxToAndroidMap.put(WX_TRANSLATE, Arrays.asList(property, property2));
        wxToAndroidMap.put(WX_TRANSLATE_X, Collections.singletonList(property));
        wxToAndroidMap.put(WX_TRANSLATE_Y, Collections.singletonList(property2));
        property = View.ROTATION;
        wxToAndroidMap.put(WX_ROTATE, Collections.singletonList(property));
        wxToAndroidMap.put(WX_ROTATE_Z, Collections.singletonList(property));
        wxToAndroidMap.put(WX_ROTATE_X, Collections.singletonList(View.ROTATION_X));
        wxToAndroidMap.put(WX_ROTATE_Y, Collections.singletonList(View.ROTATION_Y));
        property = View.SCALE_X;
        property2 = View.SCALE_Y;
        wxToAndroidMap.put(WX_SCALE, Arrays.asList(property, property2));
        wxToAndroidMap.put(WX_SCALE_X, Collections.singletonList(property));
        wxToAndroidMap.put(WX_SCALE_Y, Collections.singletonList(property2));
        wxToAndroidMap.put("perspective", Collections.singletonList(CameraDistanceProperty.getInstance()));
        wxToAndroidMap = Collections.unmodifiableMap(wxToAndroidMap);
    }
}

