/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.module;

import android.os.Build;
import android.os.LocaleList;
import android.text.TextUtils;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.common.WXModule;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class WXLocaleModule
extends WXModule {
    private String getLanguageImpl() {
        Locale locale = Build.VERSION.SDK_INT >= 24 ? LocaleList.getDefault().get(0) : Locale.getDefault();
        return locale.getLanguage() + "-" + locale.getCountry();
    }

    private String getLanguageTags() {
        Object object = WXEnvironment.getApplication();
        if (object != null && (object = object.getResources()) != null && (object = object.getConfiguration()) != null) {
            if (Build.VERSION.SDK_INT >= 24) {
                return object.getLocales().toLanguageTags();
            }
            object = object.locale;
            if (object != null) {
                return this.toLanguageTag((Locale)object);
            }
        }
        return "";
    }

    private String toLanguageTag(Locale object) {
        StringBuilder stringBuilder;
        if (Build.VERSION.SDK_INT >= 21) {
            return ((Locale)object).toLanguageTag();
        }
        StringBuilder stringBuilder2 = stringBuilder;
        Locale locale = object;
        stringBuilder2();
        object = locale.getLanguage();
        String string2 = locale.getCountry();
        stringBuilder.append((String)object);
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            stringBuilder2.append("-").append(string2);
        }
        return stringBuilder2.toString();
    }

    @JSMethod(uiThread=false)
    public String getLanguageSync() {
        return this.getLanguageImpl();
    }

    @JSMethod(uiThread=false)
    public void getLanguage(JSCallback jSCallback) {
        jSCallback.invoke(this.getLanguageImpl());
    }

    @JSMethod(uiThread=false)
    public List<String> getLanguages() {
        return Arrays.asList(this.getLanguageTags().split(","));
    }

    @JSMethod(uiThread=false)
    public void getLanguages(JSCallback jSCallback) {
        jSCallback.invoke(this.getLanguageTags().split(","));
    }
}

