/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Shader;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.IntRange;
import androidx.annotation.Nullable;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import io.dcloud.common.util.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;

public class BoxShadowUtil {
    private static final String TAG = "BoxShadowUtil";
    private static boolean sBoxShadowEnabled = true;
    private static Pattern sColorPattern;

    public static void setBoxShadowEnabled(boolean bl) {
        sBoxShadowEnabled = bl;
        WXLogUtils.w(TAG, "Switch box-shadow status: " + bl);
    }

    public static boolean isBoxShadowEnabled() {
        return sBoxShadowEnabled;
    }

    public static void setBoxShadow(final View view, String object, float[] fArray, float f, float f2) {
        if (!sBoxShadowEnabled) {
            WXLogUtils.w(TAG, "box-shadow was disabled by config");
            return;
        }
        if (view == null) {
            WXLogUtils.w(TAG, "Target view is null!");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)object) && Build.VERSION.SDK_INT >= 18) {
            view.getOverlay().clear();
            WXLogUtils.d(TAG, "Remove all box-shadow");
            return;
        }
        BoxShadowOptions[] boxShadowOptionsArray = BoxShadowUtil.parseBoxShadows((String)object, f);
        if (boxShadowOptionsArray != null && boxShadowOptionsArray.length != 0) {
            ArrayList<BoxShadowOptions> arrayList;
            ArrayList arrayList2;
            object = arrayList2;
            arrayList2 = new ArrayList();
            ArrayList<BoxShadowOptions> arrayList3 = arrayList;
            arrayList = new ArrayList<BoxShadowOptions>();
            for (BoxShadowOptions boxShadowOptions : boxShadowOptionsArray) {
                if (boxShadowOptions == null) continue;
                if (boxShadowOptions.isInset) {
                    arrayList3.add(0, boxShadowOptions);
                    continue;
                }
                object.add(0, boxShadowOptions);
            }
            if (fArray != null) {
                if (fArray.length != 8) {
                    WXLogUtils.w(TAG, "Length of radii must be 8");
                } else {
                    for (int i = 0; i < fArray.length; ++i) {
                        fArray[i] = WXViewUtils.getRealSubPxByWidth(fArray[i], f);
                    }
                }
            }
            view.post(WXThread.secure(new Runnable(){
                final /* synthetic */ List val$normalShadows;
                final /* synthetic */ float val$quality;
                final /* synthetic */ float[] val$radii;
                final /* synthetic */ List val$insetShadows;
                {
                    this.val$normalShadows = list;
                    this.val$quality = f;
                    this.val$radii = fArray;
                    this.val$insetShadows = list2;
                }

                @Override
                public void run() {
                    if (Build.VERSION.SDK_INT >= 18) {
                        1 v0 = list;
                        v0.view.getOverlay().clear();
                        if (v0.val$normalShadows.size() > 0) {
                            1 v1 = list;
                            List list = v1.val$normalShadows;
                            float f = v1.val$quality;
                            float[] fArray = v1.val$radii;
                            BoxShadowUtil.setNormalBoxShadow(list.view, list, f, fArray);
                        }
                        if (list.val$insetShadows.size() > 0) {
                            1 v2 = list;
                            List list = v2.val$insetShadows;
                            float f = v2.val$quality;
                            float[] fArray = v2.val$radii;
                            BoxShadowUtil.setInsetBoxShadow(list.view, list, f, fArray);
                            return;
                        }
                    }
                }
            }));
            return;
        }
        WXLogUtils.w(TAG, "Failed to parse box-shadow: " + (String)object);
    }

    private static void drawShadow(Canvas canvas, BoxShadowOptions boxShadowOptions) {
        Path path;
        Paint paint;
        Paint paint2;
        float f;
        float f2;
        RectF rectF;
        RectF rectF2 = rectF;
        BoxShadowOptions boxShadowOptions2 = boxShadowOptions;
        float f3 = boxShadowOptions.spread;
        float f4 = (float)boxShadowOptions2.viewWidth + f3 * 2.0f;
        f3 = (float)boxShadowOptions2.viewHeight + f3 * 2.0f;
        rectF = new RectF(0.0f, 0.0f, f4, f3);
        PointF pointF = boxShadowOptions.topLeft;
        if (pointF != null) {
            PointF pointF2 = pointF;
            float f5 = pointF2.x;
            rectF2.offset(f5, pointF2.y);
        }
        BoxShadowOptions boxShadowOptions3 = boxShadowOptions;
        float f6 = boxShadowOptions3.blur;
        f4 = boxShadowOptions3.hShadow;
        f4 = f2 > 0.0f ? f6 + f4 * 2.0f : f6;
        float f7 = boxShadowOptions.vShadow;
        if (f > 0.0f) {
            f6 += f7 * 2.0f;
        }
        rectF2.offset(f4, f6);
        Paint paint3 = paint2 = paint;
        paint3();
        paint3.setAntiAlias(true);
        paint.setColor(boxShadowOptions.color);
        paint.setStyle(Paint.Style.FILL);
        if (boxShadowOptions.blur > 0.0f) {
            BlurMaskFilter blurMaskFilter;
            BlurMaskFilter blurMaskFilter2 = blurMaskFilter;
            blurMaskFilter = new BlurMaskFilter(boxShadowOptions.blur, BlurMaskFilter.Blur.NORMAL);
            paint2.setMaskFilter((MaskFilter)blurMaskFilter2);
        }
        Path path2 = path;
        path = new Path();
        float[] fArray = new float[8];
        int n = 0;
        while (true) {
            float[] fArray2 = boxShadowOptions.radii;
            if (n >= boxShadowOptions.radii.length) break;
            float f8 = fArray2[n];
            fArray[n] = f8 == 0.0f ? 0.0f : f8 + boxShadowOptions.spread;
            ++n;
        }
        Canvas canvas2 = canvas;
        canvas = Path.Direction.CCW;
        path2.addRoundRect(rectF2, fArray, (Path.Direction)canvas);
        canvas2.drawPath(path2, paint2);
    }

    private static void setNormalBoxShadow(View view, List<BoxShadowOptions> canvas, float f, float[] fArray) {
        int n = view.getHeight();
        View view2 = view;
        int n2 = view2.getWidth();
        view2.getLayoutParams();
        if (n != 0 && n2 != 0) {
            if (Build.VERSION.SDK_INT >= 18) {
                Rect rect;
                Point point;
                OverflowBitmapDrawable overflowBitmapDrawable;
                Canvas canvas2;
                int n3 = 0;
                int n4 = 0;
                for (Object object : canvas) {
                    ((BoxShadowOptions)object).viewWidth = n2;
                    ((BoxShadowOptions)object).viewHeight = n;
                    ((BoxShadowOptions)object).radii = fArray;
                    if (n3 < (object = ((BoxShadowOptions)object).getTargetCanvasRect()).width()) {
                        n3 = object.width();
                    }
                    if (n4 >= object.height()) continue;
                    n4 = object.height();
                }
                Bitmap bitmap = Bitmap.createBitmap((int)((int)((float)n3 * f)), (int)((int)((float)n4 * f)), (Bitmap.Config)Bitmap.Config.ARGB_4444);
                if (Build.VERSION.SDK_INT >= 19) {
                    WXLogUtils.d(TAG, "Allocation memory for box-shadow: " + bitmap.getAllocationByteCount() / 1024 + " KB");
                }
                Canvas canvas3 = canvas;
                canvas = canvas2;
                canvas2 = new Canvas(bitmap);
                for (BoxShadowOptions boxShadowOptions : canvas3) {
                    BoxShadowOptions boxShadowOptions2;
                    BoxShadowOptions boxShadowOptions3 = boxShadowOptions2 = boxShadowOptions;
                    boxShadowOptions2 = boxShadowOptions2.getTargetCanvasRect();
                    float f2 = (float)(n3 - boxShadowOptions2.width()) / 2.0f;
                    float f3 = (float)(n4 - boxShadowOptions2.height()) / 2.0f;
                    boxShadowOptions3.topLeft = new PointF(f2, f3);
                    BoxShadowUtil.drawShadow(canvas, boxShadowOptions.scale(f));
                }
                View view3 = view;
                int n5 = (n3 - n2) / 2;
                int n6 = (n4 - n) / 2;
                OverflowBitmapDrawable overflowBitmapDrawable2 = overflowBitmapDrawable;
                Resources resources = view.getResources();
                view = point;
                point = new Point(n5, n6);
                Rect rect2 = rect;
                rect = new Rect(0, 0, n2, n);
                overflowBitmapDrawable = new OverflowBitmapDrawable(resources, bitmap, (Point)view, rect2, fArray);
                view3.getOverlay().add((Drawable)overflowBitmapDrawable2);
                view = view3.getParent();
                if (view != null) {
                    View view4 = view;
                    view4.requestLayout();
                    if (view4 instanceof ViewGroup) {
                        ((ViewGroup)view).invalidate(overflowBitmapDrawable2.getBounds());
                        return;
                    }
                }
                return;
            }
            Log.w((String)TAG, (String)"Call setNormalBoxShadow() requires API level 18 or higher.");
            return;
        }
        Log.w((String)TAG, (String)"Target view is invisible, ignore set shadow.");
    }

    private static void setInsetBoxShadow(View view, List<BoxShadowOptions> list, float f, float[] fArray) {
        if (view != null && list != null) {
            if (view.getWidth() != 0 && view.getHeight() != 0) {
                if (Build.VERSION.SDK_INT >= 18) {
                    LayerDrawable layerDrawable;
                    Drawable[] drawableArray = new Drawable[list.size()];
                    for (int i = 0; i < list.size(); ++i) {
                        InsetShadowDrawable insetShadowDrawable;
                        BoxShadowOptions boxShadowOptions = list.get(i);
                        InsetShadowDrawable insetShadowDrawable2 = insetShadowDrawable;
                        BoxShadowOptions boxShadowOptions2 = boxShadowOptions;
                        View view2 = view;
                        int n = view2.getWidth();
                        int n2 = view2.getHeight();
                        float f2 = boxShadowOptions2.hShadow;
                        float f3 = boxShadowOptions2.vShadow;
                        float f4 = boxShadowOptions2.blur;
                        float f5 = boxShadowOptions2.spread;
                        int n3 = boxShadowOptions2.color;
                        insetShadowDrawable = new InsetShadowDrawable(n, n2, f2, f3, f4, f5, n3, fArray);
                        drawableArray[i] = insetShadowDrawable2;
                    }
                    View view3 = view;
                    view = layerDrawable;
                    layerDrawable = new LayerDrawable(drawableArray);
                    view3.getOverlay().add((Drawable)view);
                    view3.invalidate();
                    return;
                }
                Log.w((String)TAG, (String)"Call setInsetBoxShadow() requires API level 18 or higher.");
                return;
            }
            WXLogUtils.w(TAG, "Target view is invisible, ignore set shadow.");
            return;
        }
        WXLogUtils.w(TAG, "Illegal arguments");
    }

    public static BoxShadowOptions[] parseBoxShadows(String object, float f) {
        if (sColorPattern == null) {
            sColorPattern = Pattern.compile("([rR][gG][bB][aA]?)\\((\\d+\\s*),\\s*(\\d+\\s*),\\s*(\\d+\\s*)(?:,\\s*(\\d+(?:\\.\\d+)?))?\\)");
        }
        BoxShadowOptions[] boxShadowOptionsArray = sColorPattern.matcher((CharSequence)object);
        while (boxShadowOptionsArray.find()) {
            String[] stringArray = object;
            String string2 = boxShadowOptionsArray.group();
            object = Integer.toHexString(WXResourceUtils.getColor(string2, -16777216));
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = object;
            object = stringArray.replace(string2, "#" + StringUtil.format((String)"%8s", (Object[])objectArray2).replaceAll("\\s", "0"));
        }
        if ((object = object.split(",")) != null && ((String[])object).length > 0) {
            boxShadowOptionsArray = new BoxShadowOptions[((String[])object).length];
            for (int i = 0; i < ((String[])object).length; ++i) {
                boxShadowOptionsArray[i] = BoxShadowUtil.parseBoxShadow(object[i], f);
            }
            return boxShadowOptionsArray;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static BoxShadowOptions parseBoxShadow(String string2, float f) {
        ArrayList<String> arrayList;
        BoxShadowOptions boxShadowOptions;
        block10: {
            ArrayList<String> arrayList2;
            BoxShadowOptions boxShadowOptions2;
            boxShadowOptions = boxShadowOptions2;
            boxShadowOptions2 = new BoxShadowOptions(f);
            if (TextUtils.isEmpty((CharSequence)string2)) {
                return null;
            }
            if ((string2 = string2.replaceAll("\\s*,\\s+", ",")).contains("inset")) {
                boxShadowOptions.isInset = true;
                string2 = string2.replace("inset", "");
            }
            string2 = string2.trim();
            arrayList = arrayList2;
            if (!TextUtils.isEmpty((CharSequence)(string2 = (String)arrayList.get(new ArrayList<String>(Arrays.asList(string2.split("\\s+"))).size() - 1))) && (string2.startsWith("#") || string2.startsWith("rgb") || WXResourceUtils.isNamedColor(string2))) {
                ArrayList<String> arrayList3 = arrayList;
                boxShadowOptions.color = WXResourceUtils.getColor(string2, -16777216);
                arrayList3.remove(arrayList3.size() - 1);
            }
            try {
                if (arrayList.size() < 2) {
                    return null;
                }
                if (!TextUtils.isEmpty((CharSequence)((CharSequence)arrayList.get(0)))) {
                    boxShadowOptions.hShadow = WXViewUtils.getRealSubPxByWidth(WXUtils.getFloat(((String)arrayList.get(0)).trim(), Float.valueOf(0.0f)).floatValue(), f);
                }
                if (!TextUtils.isEmpty((CharSequence)((CharSequence)arrayList.get(1)))) {
                    boxShadowOptions.vShadow = WXViewUtils.getRealPxByWidth(WXUtils.getFloat(((String)arrayList.get(1)).trim(), Float.valueOf(0.0f)).floatValue(), f);
                }
                break block10;
            }
            catch (Throwable throwable) {}
            throwable.printStackTrace();
            return boxShadowOptions;
        }
        for (int i = 2; i < arrayList.size(); ++i) {
            int n = i - 2;
            ((BoxShadowOptions.IParser)boxShadowOptions.optionParamParsers.get(n)).parse((String)arrayList.get(i));
        }
        return boxShadowOptions;
    }

    public static class BoxShadowOptions {
        private List<IParser> optionParamParsers;
        private float viewport = 750.0f;
        public float hShadow;
        public float vShadow;
        public float blur = 0.0f;
        public float spread = 0.0f;
        public float[] radii = new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        public int color = -16777216;
        public boolean isInset = false;
        public int viewWidth = 0;
        public int viewHeight = 0;
        public PointF topLeft = null;

        private BoxShadowOptions(float f) {
            IParser iParser;
            IParser iParser2;
            if (750.0f != 0.0f) {
                this.viewport = f;
            }
            BoxShadowOptions boxShadowOptions = this;
            boxShadowOptions.optionParamParsers = new ArrayList<IParser>();
            IParser iParser3 = iParser2;
            iParser2 = new IParser(){

                @Override
                public void parse(String string2) {
                    if (!TextUtils.isEmpty((CharSequence)string2)) {
                        float f = WXUtils.getFloat(string2, Float.valueOf(0.0f)).floatValue();
                        spread = WXViewUtils.getRealSubPxByWidth(f, viewport);
                        WXLogUtils.w(BoxShadowUtil.TAG, "Experimental box-shadow attribute: spread");
                        return;
                    }
                }
            };
            IParser iParser4 = iParser;
            iParser = new IParser(){

                @Override
                public void parse(String string2) {
                    if (!TextUtils.isEmpty((CharSequence)string2)) {
                        float f = WXUtils.getFloat(string2, Float.valueOf(0.0f)).floatValue();
                        blur = WXViewUtils.getRealSubPxByWidth(f, viewport);
                        return;
                    }
                }
            };
            boxShadowOptions.optionParamParsers.add(iParser4);
            boxShadowOptions.optionParamParsers.add(iParser3);
        }

        public BoxShadowOptions scale(float f) {
            if (f > 0.0f && f <= 1.0f) {
                BoxShadowOptions boxShadowOptions;
                BoxShadowOptions boxShadowOptions2 = boxShadowOptions;
                boxShadowOptions2(this.viewport);
                boxShadowOptions2.hShadow = this.hShadow * f;
                boxShadowOptions2.vShadow = this.vShadow * f;
                boxShadowOptions2.blur = this.blur * f;
                boxShadowOptions.spread = this.spread * f;
                int n = 0;
                while (true) {
                    float[] fArray = this.radii;
                    if (n >= this.radii.length) break;
                    boxShadowOptions2.radii[n] = fArray[n] * f;
                    ++n;
                }
                boxShadowOptions2.viewHeight = (int)((float)this.viewHeight * f);
                boxShadowOptions2.viewWidth = (int)((float)this.viewWidth * f);
                if (this.topLeft != null) {
                    PointF pointF;
                    PointF pointF2;
                    PointF pointF3 = pointF2 = pointF;
                    pointF3();
                    boxShadowOptions2.topLeft = pointF3;
                    pointF2 = this.topLeft;
                    pointF.x = pointF2.x * f;
                    pointF.y = pointF2.y * f;
                }
                boxShadowOptions2.color = this.color;
                boxShadowOptions2.isInset = this.isInset;
                WXLogUtils.d(BoxShadowUtil.TAG, "Scaled BoxShadowOptions: [" + f + "] " + boxShadowOptions2);
                return boxShadowOptions2;
            }
            return null;
        }

        public Rect getTargetCanvasRect() {
            BoxShadowOptions boxShadowOptions = this;
            int n = boxShadowOptions.viewWidth + (int)(this.blur + this.spread + Math.abs(this.hShadow)) * 2;
            int n2 = boxShadowOptions.viewHeight + (int)(this.blur + this.spread + Math.abs(this.vShadow)) * 2;
            return new Rect(0, 0, n, n2);
        }

        public String toString() {
            String string2 = "[" + this.radii[0] + "," + this.radii[2] + "," + this.radii[4] + "," + this.radii[6] + "]";
            StringBuffer stringBuffer = new StringBuffer("BoxShadowOptions{");
            stringBuffer.append("h-shadow=").append(this.hShadow);
            stringBuffer.append(", v-shadow=").append(this.vShadow);
            stringBuffer.append(", blur=").append(this.blur);
            stringBuffer.append(", spread=").append(this.spread);
            stringBuffer.append(", corner-radius=").append(string2);
            stringBuffer.append(", color=#").append(Integer.toHexString(this.color));
            stringBuffer.append(", inset=").append(this.isInset);
            stringBuffer.append('}');
            return stringBuffer.toString();
        }

        private static interface IParser {
            public void parse(String var1);
        }
    }

    private static class OverflowBitmapDrawable
    extends BitmapDrawable {
        private int paddingX;
        private int paddingY;
        private Rect viewRect;
        private float[] radii;

        private OverflowBitmapDrawable(Resources resources, Bitmap bitmap, Point point, Rect rect, float[] fArray) {
            super(resources, bitmap);
            int n;
            int n2;
            this.paddingX = n2 = point.x;
            this.paddingY = n = point.y;
            this.viewRect = rect;
            this.radii = fArray;
            n2 = -n2;
            n = -n;
            int n3 = n2;
            Rect rect2 = rect;
            n2 = rect2.width() + this.paddingX;
            int n4 = rect2.height() + this.paddingY;
            this.setBounds(n3, n, n2, n4);
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void draw(Canvas canvas) {
            RectF rectF;
            Rect rect;
            block4: {
                Rect rect2;
                block5: {
                    boolean bl;
                    Rect rect3;
                    rect = canvas.getClipBounds();
                    rect2 = rect3;
                    rect2(rect);
                    rect3.inset(-overflowBitmapDrawable2.paddingX * 2, -overflowBitmapDrawable2.paddingY * 2);
                    try {
                        if (WXEnvironment.sApplication.getApplicationInfo().targetSdkVersion > 26) {
                            bl = canvas.clipRect(rect2);
                            break block4;
                        }
                    }
                    catch (NullPointerException nullPointerException) {
                        break block5;
                    }
                    {
                        bl = canvas.clipRect(rect2, Region.Op.REPLACE);
                        break block4;
                    }
                }
                canvas.clipRect(rect2);
            }
            OverflowBitmapDrawable overflowBitmapDrawable = overflowBitmapDrawable2;
            Canvas canvas2 = canvas;
            Path path = new Path();
            OverflowBitmapDrawable overflowBitmapDrawable2 = rectF;
            rectF = new RectF(rect);
            path.addRoundRect((RectF)overflowBitmapDrawable2, overflowBitmapDrawable2.radii, Path.Direction.CCW);
            canvas.clipPath(path, Region.Op.DIFFERENCE);
            canvas2.translate((float)rect.left, (float)rect.top);
            super.draw(canvas2);
        }
    }

    private static class InsetShadowDrawable
    extends Drawable {
        private static final int LEFT_TO_RIGHT = 0;
        private static final int TOP_TO_BOTTOM = 1;
        private static final int RIGHT_TO_LEFT = 2;
        private static final int BOTTOM_TO_TOP = 3;
        private float blurRadius;
        private int shadowColor;
        private float[] radii;
        private float width;
        private float height;
        private float shadowXSize;
        private float shadowYSize;
        private Shader[] shades;
        private Path[] paths;
        private Paint paint;

        private InsetShadowDrawable(int n, int n2, float f, float f2, float f3, float f4, int n3, float[] fArray) {
            InsetShadowDrawable insetShadowDrawable = this;
            this.shades = new Shader[4];
            this.paths = new Path[4];
            this.blurRadius = f3;
            this.shadowColor = n3;
            this.width = (float)n + f * 2.0f;
            this.height = (float)n2 + f2 * 2.0f;
            this.shadowXSize = f + f4;
            this.shadowYSize = f2 + f4;
            insetShadowDrawable.radii = fArray;
            insetShadowDrawable.setBounds(0, 0, n, n2);
            insetShadowDrawable.prepare();
        }

        private void prepare() {
            Path path;
            Path path2;
            Path path3;
            Path path4;
            LinearGradient linearGradient;
            LinearGradient linearGradient2;
            LinearGradient linearGradient3;
            LinearGradient linearGradient4;
            PointF pointF;
            PointF pointF2;
            PointF pointF3;
            PointF pointF4;
            PointF pointF5;
            PointF pointF6;
            PointF pointF7;
            PointF pointF8;
            InsetShadowDrawable insetShadowDrawable = this;
            PointF pointF9 = pointF8;
            pointF8 = new PointF(0.0f, 0.0f);
            PointF pointF10 = pointF7;
            pointF7 = new PointF(this.width, 0.0f);
            PointF pointF11 = pointF6;
            float f = pointF10.x;
            pointF6 = new PointF(f, this.height);
            PointF pointF12 = pointF5;
            float f2 = pointF9.x;
            pointF5 = new PointF(f2, pointF11.y);
            PointF pointF13 = pointF4;
            InsetShadowDrawable insetShadowDrawable2 = this;
            float f3 = insetShadowDrawable2.shadowXSize;
            pointF4 = new PointF(f3, insetShadowDrawable2.shadowYSize);
            PointF pointF14 = pointF3;
            float f4 = pointF10.x - this.shadowXSize;
            pointF3 = new PointF(f4, pointF13.y);
            PointF pointF15 = pointF2;
            pointF2 = new PointF(pointF14.x, pointF11.y - this.shadowYSize);
            PointF pointF16 = pointF;
            float f5 = pointF13.x;
            pointF = new PointF(f5, pointF15.y);
            LinearGradient linearGradient5 = linearGradient4;
            PointF pointF17 = pointF13;
            float f6 = pointF17.x;
            float f7 = f6 - this.blurRadius;
            float f8 = pointF17.y;
            int n = this.shadowColor;
            Shader.TileMode tileMode = Shader.TileMode.CLAMP;
            linearGradient4 = new LinearGradient(f7, f8, f6, f8, n, 0, tileMode);
            LinearGradient linearGradient6 = linearGradient3;
            PointF pointF18 = pointF13;
            f8 = pointF18.x;
            float f9 = pointF18.y;
            float f10 = f9 - this.blurRadius;
            int n2 = this.shadowColor;
            linearGradient3 = new LinearGradient(f8, f10, f8, f9, n2, 0, tileMode);
            LinearGradient linearGradient7 = linearGradient2;
            PointF pointF19 = pointF15;
            f9 = pointF19.x;
            f10 = f9 + this.blurRadius;
            float f11 = pointF19.y;
            int n3 = this.shadowColor;
            linearGradient2 = new LinearGradient(f10, f11, f9, f11, n3, 0, tileMode);
            LinearGradient linearGradient8 = linearGradient;
            PointF pointF20 = pointF15;
            f10 = pointF20.x;
            f11 = pointF20.y;
            float f12 = f11 + this.blurRadius;
            int n4 = this.shadowColor;
            linearGradient = new LinearGradient(f10, f12, f10, f11, n4, 0, tileMode);
            Shader[] shaderArray = insetShadowDrawable.shades;
            Shader[] shaderArray2 = insetShadowDrawable.shades;
            shaderArray[0] = linearGradient5;
            shaderArray2[1] = linearGradient6;
            shaderArray[2] = linearGradient7;
            shaderArray2[3] = linearGradient8;
            linearGradient5 = path4;
            PointF pointF21 = pointF12;
            PointF pointF22 = pointF16;
            PointF pointF23 = pointF13;
            PointF pointF24 = pointF9;
            linearGradient5();
            float f13 = pointF24.x;
            linearGradient5.moveTo(f13, pointF24.y);
            f13 = pointF23.x;
            linearGradient5.lineTo(f13, pointF23.y);
            f13 = pointF22.x;
            linearGradient5.lineTo(f13, pointF22.y);
            f13 = pointF21.x;
            path4.lineTo(f13, pointF21.y);
            path4.close();
            Path path5 = path3;
            PointF pointF25 = pointF13;
            PointF pointF26 = pointF14;
            PointF pointF27 = pointF10;
            PointF pointF28 = pointF9;
            path5();
            float f14 = pointF28.x;
            path5.moveTo(f14, pointF28.y);
            f14 = pointF27.x;
            path5.lineTo(f14, pointF27.y);
            f14 = pointF26.x;
            path5.lineTo(f14, pointF26.y);
            f14 = pointF25.x;
            path3.lineTo(f14, pointF25.y);
            path3.close();
            Path path6 = path2;
            PointF pointF29 = pointF14;
            PointF pointF30 = pointF15;
            PointF pointF31 = pointF11;
            PointF pointF32 = pointF10;
            path6();
            float f15 = pointF32.x;
            path6.moveTo(f15, pointF32.y);
            f15 = pointF31.x;
            path6.lineTo(f15, pointF31.y);
            f15 = pointF30.x;
            path6.lineTo(f15, pointF30.y);
            f15 = pointF29.x;
            path2.lineTo(f15, pointF29.y);
            path2.close();
            Path path7 = path;
            PointF pointF33 = pointF16;
            PointF pointF34 = pointF15;
            PointF pointF35 = pointF11;
            PointF pointF36 = pointF12;
            path7();
            float f16 = pointF36.x;
            path7.moveTo(f16, pointF36.y);
            f16 = pointF35.x;
            path7.lineTo(f16, pointF35.y);
            f16 = pointF34.x;
            path7.lineTo(f16, pointF34.y);
            f16 = pointF33.x;
            path.lineTo(f16, pointF33.y);
            path.close();
            Path[] pathArray = insetShadowDrawable.paths;
            Path[] pathArray2 = insetShadowDrawable.paths;
            pathArray[0] = linearGradient5;
            pathArray2[1] = path5;
            pathArray[2] = path6;
            pathArray2[3] = path7;
            this.paint = new Paint();
            this.paint.setAntiAlias(true);
            insetShadowDrawable.paint.setStyle(Paint.Style.FILL);
            insetShadowDrawable.paint.setColor(this.shadowColor);
        }

        public void draw(Canvas canvas) {
            RectF rectF;
            Canvas canvas2 = canvas;
            Rect rect = canvas2.getClipBounds();
            Path path = new Path();
            RectF rectF2 = rectF;
            rectF = new RectF(rect);
            path.addRoundRect(rectF2, this.radii, Path.Direction.CCW);
            canvas2.clipPath(path);
            canvas2.translate((float)rect.left, (float)rect.top);
            for (int i = 0; i < 4; ++i) {
                InsetShadowDrawable insetShadowDrawable = this;
                rectF2 = insetShadowDrawable.shades[i];
                Path path2 = insetShadowDrawable.paths[i];
                insetShadowDrawable.paint.setShader((Shader)rectF2);
                canvas.drawPath(path2, insetShadowDrawable.paint);
            }
        }

        public void setAlpha(@IntRange(from=0L, to=255L) int n) {
        }

        public void setColorFilter(@Nullable ColorFilter colorFilter) {
        }

        public int getOpacity() {
            return -1;
        }
    }
}

