/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.component.helper;

import android.os.Handler;
import android.os.Looper;
import androidx.recyclerview.widget.RecyclerView;
import com.taobao.weex.ui.component.DCWXScroller;
import com.taobao.weex.ui.component.WXBaseScroller;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.list.BasicListComponent;
import com.taobao.weex.ui.component.list.ListComponentView;
import com.taobao.weex.ui.component.list.template.WXRecyclerTemplateList;
import com.taobao.weex.ui.view.refresh.wrapper.BounceRecyclerView;
import com.taobao.weex.utils.WXUtils;
import java.util.AbstractCollection;
import java.util.Map;

public class ScrollStartEndHelper
implements Runnable {
    private Handler handler;
    private WXComponent component;
    private boolean hasStart;
    private boolean canStart;
    private long minInterval;
    private int oldState;
    private int x;
    private int y;
    private boolean hasScrollEnd;

    public ScrollStartEndHelper(WXComponent wXComponent) {
        ScrollStartEndHelper scrollStartEndHelper = this;
        this.canStart = false;
        this.oldState = 0;
        scrollStartEndHelper.component = wXComponent;
        scrollStartEndHelper.handler = new Handler(Looper.getMainLooper());
        this.minInterval = WXUtils.getNumberInt(wXComponent.getAttrs().get("minscrolldelayinterval"), 32);
    }

    private Map<String, Object> getScrollEvent(int n, int n2) {
        Object object = ((ScrollStartEndHelper)object).component;
        if (object instanceof BasicListComponent) {
            ListComponentView listComponentView;
            if (((WXComponent)(object = (BasicListComponent)object)).getHostView() instanceof ListComponentView && (listComponentView = (ListComponentView)((WXComponent)object).getHostView()) != null) {
                return ((BasicListComponent)object).getScrollEvent(listComponentView.getInnerView(), n, n2);
            }
        } else {
            if (object instanceof WXRecyclerTemplateList) {
                WXRecyclerTemplateList wXRecyclerTemplateList = (WXRecyclerTemplateList)object;
                return wXRecyclerTemplateList.getScrollEvent((RecyclerView)((BounceRecyclerView)wXRecyclerTemplateList.getHostView()).getInnerView(), n, n2);
            }
            if (object instanceof DCWXScroller) {
                return ((DCWXScroller)object).getScrollEvent(n, n2);
            }
            if (object instanceof WXBaseScroller) {
                return ((WXBaseScroller)object).getScrollEvent(n, n2);
            }
        }
        return null;
    }

    public static boolean isScrollEvent(String string2) {
        if ("scroll".equals(string2)) {
            return true;
        }
        if ("scrollstart".equals(string2)) {
            return true;
        }
        return "scrollend".equals(string2);
    }

    public void onScrolled(int n, int n2) {
        if (!((AbstractCollection)this.component.getEvents()).contains("scrollstart") && !((AbstractCollection)this.component.getEvents()).contains("scrollend")) {
            return;
        }
        this.x = n;
        this.y = n2;
        if (!this.hasStart && this.canStart) {
            Map<String, Object> map;
            if (((AbstractCollection)this.component.getEvents()).contains("scrollstart") && (map = this.getScrollEvent(n, n2)) != null && !map.isEmpty()) {
                this.component.fireEvent("scrollstart", map);
            }
            ScrollStartEndHelper scrollStartEndHelper = this;
            scrollStartEndHelper.hasStart = true;
            scrollStartEndHelper.canStart = false;
        }
        ScrollStartEndHelper scrollStartEndHelper = this;
        scrollStartEndHelper.handler.removeCallbacks((Runnable)this);
        ScrollStartEndHelper scrollStartEndHelper2 = this;
        scrollStartEndHelper.handler.postDelayed((Runnable)scrollStartEndHelper2, scrollStartEndHelper2.minInterval);
    }

    @Override
    public void run() {
        int n;
        if (this.component.isDestoryed() || !this.hasScrollEnd) {
            return;
        }
        if (this.canStart) {
            ScrollStartEndHelper scrollStartEndHelper = this;
            n = scrollStartEndHelper.x;
            this.component.fireEvent("scrollstart", scrollStartEndHelper.getScrollEvent(n, scrollStartEndHelper.y));
            this.canStart = false;
        }
        if (((AbstractCollection)this.component.getEvents()).contains("scrollend")) {
            ScrollStartEndHelper scrollStartEndHelper = this;
            n = scrollStartEndHelper.x;
            this.component.fireEvent("scrollend", scrollStartEndHelper.getScrollEvent(n, scrollStartEndHelper.y));
        }
        ScrollStartEndHelper scrollStartEndHelper = this;
        scrollStartEndHelper.hasStart = false;
        scrollStartEndHelper.hasScrollEnd = false;
    }

    public void onScrollStateChanged(int n) {
        if (this.oldState == 0) {
            this.canStart = true;
        }
        if (n == 0) {
            ScrollStartEndHelper scrollStartEndHelper = this;
            scrollStartEndHelper.hasScrollEnd = true;
            scrollStartEndHelper.handler.removeCallbacks((Runnable)this);
            ScrollStartEndHelper scrollStartEndHelper2 = this;
            scrollStartEndHelper.handler.postDelayed((Runnable)scrollStartEndHelper2, scrollStartEndHelper2.minInterval);
        }
        this.oldState = n;
    }
}

