/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Rect;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.MediaController;
import android.widget.ProgressBar;
import android.widget.VideoView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import com.taobao.weex.utils.WXResourceUtils;

public class WXVideoView
extends VideoView
implements WXGestureObservable {
    private WXGesture wxGesture;
    private VideoPlayListener mVideoPauseListener;

    public WXVideoView(Context context) {
        super(context);
    }

    @Override
    public void registerGestureListener(WXGesture wXGesture) {
        this.wxGesture = wXGesture;
    }

    @Override
    public WXGesture getGestureListener() {
        return this.wxGesture;
    }

    public void setOnVideoPauseListener(VideoPlayListener videoPlayListener) {
        this.mVideoPauseListener = videoPlayListener;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        WXVideoView wXVideoView = this;
        boolean bl = super.onTouchEvent(motionEvent);
        WXGesture wXGesture = wXVideoView.wxGesture;
        if (wXGesture != null) {
            return bl | wXGesture.onTouch((View)this, motionEvent);
        }
        return bl;
    }

    public void start() {
        WXVideoView wXVideoView = videoPlayListener;
        super.start();
        VideoPlayListener videoPlayListener = wXVideoView.mVideoPauseListener;
        if (videoPlayListener != null) {
            videoPlayListener.onStart();
            return;
        }
    }

    public void pause() {
        WXVideoView wXVideoView = videoPlayListener;
        super.pause();
        VideoPlayListener videoPlayListener = wXVideoView.mVideoPauseListener;
        if (videoPlayListener != null) {
            videoPlayListener.onPause();
            return;
        }
    }

    public static interface VideoPlayListener {
        public void onPause();

        public void onStart();
    }

    public static class Wrapper
    extends FrameLayout
    implements ViewTreeObserver.OnGlobalLayoutListener {
        private WXVideoView mVideoView;
        private ProgressBar mProgressBar;
        private MediaController mMediaController;
        private Uri mUri;
        private MediaPlayer.OnPreparedListener mOnPreparedListener;
        private MediaPlayer.OnErrorListener mOnErrorListener;
        private MediaPlayer.OnCompletionListener mOnCompletionListener;
        private VideoPlayListener mVideoPlayListener;
        private boolean mControls;

        public Wrapper(Context context) {
            Wrapper wrapper = this;
            super(context);
            wrapper.mControls = true;
            wrapper.init(context);
        }

        public Wrapper(Context context, AttributeSet attributeSet) {
            Wrapper wrapper = this;
            super(context, attributeSet);
            wrapper.mControls = true;
            wrapper.init(context);
        }

        public Wrapper(Context context, AttributeSet attributeSet, int n) {
            Wrapper wrapper = this;
            super(context, attributeSet, n);
            wrapper.mControls = true;
            wrapper.init(context);
        }

        private void init(Context context) {
            FrameLayout.LayoutParams layoutParams;
            Wrapper wrapper = this;
            wrapper.setBackgroundColor(WXResourceUtils.getColor("#ee000000"));
            wrapper.mProgressBar = new ProgressBar(context);
            context = layoutParams;
            context(-2, -2);
            this.mProgressBar.setLayoutParams((ViewGroup.LayoutParams)context);
            layoutParams.gravity = 17;
            wrapper.addView((View)wrapper.mProgressBar);
            wrapper.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }

        private synchronized void createVideoView() {
            if (this.mVideoView == null) {
                MediaController mediaController;
                WXVideoView wXVideoView;
                Wrapper wrapper = this;
                Context context = wrapper.getContext();
                WXVideoView wXVideoView2 = wXVideoView;
                Wrapper wrapper2 = this;
                WXVideoView wXVideoView3 = wXVideoView2;
                wXVideoView3(context);
                new FrameLayout.LayoutParams(-1, -1).gravity = 17;
                wXVideoView3.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                wrapper2.addView((View)wXVideoView3, 0);
                wXVideoView2.setOnErrorListener(wrapper2.mOnErrorListener);
                wXVideoView2.setOnPreparedListener(this.mOnPreparedListener);
                wXVideoView2.setOnCompletionListener(this.mOnCompletionListener);
                wXVideoView.setOnVideoPauseListener(this.mVideoPlayListener);
                MediaController mediaController2 = mediaController;
                WXVideoView wXVideoView4 = wXVideoView2;
                MediaController mediaController3 = mediaController2;
                mediaController2(context);
                mediaController3.setAnchorView((View)this);
                wXVideoView4.setMediaController(mediaController3);
                mediaController.setMediaPlayer((MediaController.MediaPlayerControl)wXVideoView4);
                if (!wrapper.mControls) {
                    mediaController2.setVisibility(8);
                } else {
                    mediaController2.setVisibility(0);
                }
                Wrapper wrapper3 = this;
                wrapper3.mMediaController = mediaController2;
                wrapper3.mVideoView = wXVideoView2;
                wXVideoView2.setZOrderOnTop(true);
                context = this.mUri;
                if (context != null) {
                    this.setVideoURI((Uri)context);
                    return;
                }
            }
        }

        @SuppressLint(value={"NewApi"})
        private void removeSelfFromViewTreeObserver() {
            if (Build.VERSION.SDK_INT >= 16) {
                this.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                return;
            }
            this.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        }

        public ProgressBar getProgressBar() {
            return this.mProgressBar;
        }

        @Nullable
        public WXVideoView getVideoView() {
            return this.mVideoView;
        }

        @NonNull
        public WXVideoView createIfNotExist() {
            if (this.mVideoView == null) {
                this.createVideoView();
            }
            return this.mVideoView;
        }

        @Nullable
        public MediaController getMediaController() {
            return this.mMediaController;
        }

        public void setVideoURI(Uri uri) {
            object.mUri = uri;
            Object object = object.mVideoView;
            if (object != null) {
                object.setVideoURI(uri);
                return;
            }
        }

        public void start() {
            WXVideoView wXVideoView = ((Wrapper)((Object)wXVideoView)).mVideoView;
            if (wXVideoView != null) {
                wXVideoView.start();
                return;
            }
        }

        public void pause() {
            WXVideoView wXVideoView = ((Wrapper)((Object)wXVideoView)).mVideoView;
            if (wXVideoView != null) {
                wXVideoView.pause();
                return;
            }
        }

        public void stopPlayback() {
            Object object = object.mVideoView;
            if (object != null) {
                object.stopPlayback();
                return;
            }
        }

        public void resume() {
            Object object = object.mVideoView;
            if (object != null) {
                object.resume();
                return;
            }
        }

        public void setOnErrorListener(MediaPlayer.OnErrorListener onErrorListener) {
            object.mOnErrorListener = onErrorListener;
            Object object = object.mVideoView;
            if (object != null) {
                object.setOnErrorListener(onErrorListener);
                return;
            }
        }

        public void setOnPreparedListener(MediaPlayer.OnPreparedListener onPreparedListener) {
            object.mOnPreparedListener = onPreparedListener;
            Object object = object.mVideoView;
            if (object != null) {
                object.setOnPreparedListener(onPreparedListener);
                return;
            }
        }

        public void setOnCompletionListener(MediaPlayer.OnCompletionListener onCompletionListener) {
            object.mOnCompletionListener = onCompletionListener;
            Object object = object.mVideoView;
            if (object != null) {
                object.setOnCompletionListener(onCompletionListener);
                return;
            }
        }

        public void setOnVideoPauseListener(VideoPlayListener videoPlayListener) {
            ((Wrapper)((Object)wXVideoView)).mVideoPlayListener = videoPlayListener;
            WXVideoView wXVideoView = ((Wrapper)((Object)wXVideoView)).mVideoView;
            if (wXVideoView != null) {
                wXVideoView.setOnVideoPauseListener(videoPlayListener);
                return;
            }
        }

        public void setControls(boolean bl) {
            this.mControls = bl;
            if (this.mVideoView != null && (this = this.mMediaController) != null) {
                if (!bl) {
                    this.setVisibility(8);
                    return;
                }
                this.setVisibility(0);
                return;
            }
        }

        public boolean createVideoViewIfVisible() {
            Rect rect;
            Rect rect2 = rect;
            rect = new Rect();
            if (this.mVideoView != null) {
                return true;
            }
            if (this.getGlobalVisibleRect(rect2) && !rect2.isEmpty()) {
                this.createVideoView();
                return true;
            }
            return false;
        }

        public void onGlobalLayout() {
            if (this.createVideoViewIfVisible()) {
                this.removeSelfFromViewTreeObserver();
                return;
            }
        }
    }
}

