/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.refresh.wrapper;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.view.WXLoadingLayout;
import com.taobao.weex.ui.view.WXRefreshLayout;
import com.taobao.weex.ui.view.refresh.core.WXSwipeLayout;
import com.taobao.weex.utils.WXResourceUtils;
import com.taobao.weex.utils.WXUtils;

public abstract class BaseBounceView<T extends View>
extends FrameLayout {
    private int mOrientation;
    protected WXSwipeLayout swipeLayout;
    private T mInnerView;

    public BaseBounceView(Context context, int n) {
        this(context, null, n);
    }

    public BaseBounceView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet);
        this.mOrientation = n;
    }

    private WXSwipeLayout createBounceView(Context object) {
        FrameLayout.LayoutParams layoutParams;
        WXSwipeLayout wXSwipeLayout;
        WXSwipeLayout wXSwipeLayout2 = wXSwipeLayout;
        wXSwipeLayout2((Context)object);
        this.swipeLayout = wXSwipeLayout2;
        wXSwipeLayout2 = layoutParams;
        layoutParams = new FrameLayout.LayoutParams(-1, -1);
        wXSwipeLayout.setLayoutParams((ViewGroup.LayoutParams)wXSwipeLayout2);
        object = this.setInnerView((Context)object);
        this.mInnerView = object;
        if (object == null) {
            return null;
        }
        BaseBounceView baseBounceView = this;
        baseBounceView.swipeLayout.addTargetView((View)object);
        baseBounceView.addView((View)baseBounceView.swipeLayout, -1, -1);
        return baseBounceView.swipeLayout;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public void init(Context context) {
        this.createBounceView(context);
    }

    boolean isVertical() {
        return this.mOrientation == 1;
    }

    public void setOnRefreshListener(WXSwipeLayout.WXOnRefreshListener wXOnRefreshListener) {
        FrameLayout frameLayout = frameLayout.swipeLayout;
        if (frameLayout != null) {
            frameLayout.setOnRefreshListener(wXOnRefreshListener);
            return;
        }
    }

    public void setOnLoadingListener(WXSwipeLayout.WXOnLoadingListener wXOnLoadingListener) {
        FrameLayout frameLayout = frameLayout.swipeLayout;
        if (frameLayout != null) {
            frameLayout.setOnLoadingListener(wXOnLoadingListener);
            return;
        }
    }

    public void finishPullRefresh() {
        FrameLayout frameLayout = frameLayout.swipeLayout;
        if (frameLayout != null) {
            frameLayout.finishPullRefresh();
            return;
        }
    }

    public void finishPullLoad() {
        FrameLayout frameLayout = frameLayout.swipeLayout;
        if (frameLayout != null) {
            frameLayout.finishPullLoad();
            return;
        }
    }

    public T getInnerView() {
        return this.mInnerView;
    }

    public abstract T setInnerView(Context var1);

    public void setHeaderView(WXComponent wXComponent) {
        BaseBounceView baseBounceView = this;
        baseBounceView.setRefreshEnable(true);
        FrameLayout frameLayout = baseBounceView.swipeLayout;
        if (frameLayout != null && (frameLayout = frameLayout.getHeaderView()) != null) {
            if (frameLayout.getParent() == null) {
                FrameLayout.LayoutParams layoutParams;
                FrameLayout.LayoutParams layoutParams2 = layoutParams;
                layoutParams = new FrameLayout.LayoutParams(-1, 0);
                this.swipeLayout.addView((View)frameLayout, (ViewGroup.LayoutParams)layoutParams2);
            }
            if (wXComponent != null) {
                int n;
                int n2 = (int)wXComponent.getLayoutHeight();
                this.swipeLayout.setRefreshHeight(n2);
                String string2 = WXUtils.getString((String)wXComponent.getStyles().get("backgroundColor"), null);
                if (string2 != null && !TextUtils.isEmpty((CharSequence)string2) && (n = WXResourceUtils.getColor(string2)) != 0) {
                    this.swipeLayout.setRefreshBgColor(n);
                }
                frameLayout.setRefreshView((View)wXComponent.getHostView());
                return;
            }
        }
    }

    public void setFooterView(WXComponent wXComponent) {
        BaseBounceView baseBounceView = this;
        baseBounceView.setLoadmoreEnable(true);
        FrameLayout frameLayout = baseBounceView.swipeLayout;
        if (frameLayout != null && (frameLayout = frameLayout.getFooterView()) != null) {
            if (frameLayout.getParent() == null) {
                FrameLayout.LayoutParams layoutParams;
                FrameLayout.LayoutParams layoutParams2 = layoutParams;
                new FrameLayout.LayoutParams((int)-1, (int)0).gravity = 80;
                this.swipeLayout.addView((View)frameLayout, (ViewGroup.LayoutParams)layoutParams2);
            }
            if (wXComponent != null) {
                int n;
                int n2 = (int)wXComponent.getLayoutHeight();
                this.swipeLayout.setLoadingHeight(n2);
                String string2 = WXUtils.getString((String)wXComponent.getStyles().get("backgroundColor"), null);
                if (string2 != null && !TextUtils.isEmpty((CharSequence)string2) && (n = WXResourceUtils.getColor(string2)) != 0) {
                    this.swipeLayout.setLoadingBgColor(n);
                }
                frameLayout.setRefreshView((View)wXComponent.getHostView());
                return;
            }
        }
    }

    public void removeFooterView(WXComponent wXComponent) {
        BaseBounceView baseBounceView = this;
        baseBounceView.setLoadmoreEnable(false);
        WXSwipeLayout wXSwipeLayout = baseBounceView.swipeLayout;
        if (wXSwipeLayout != null && wXSwipeLayout.getFooterView() != null) {
            BaseBounceView baseBounceView2 = this;
            baseBounceView2.swipeLayout.setLoadingHeight(0);
            baseBounceView2.swipeLayout.getFooterView().removeView((View)wXComponent.getHostView());
            baseBounceView2.swipeLayout.finishPullLoad();
            return;
        }
    }

    public void removeHeaderView(WXComponent wXComponent) {
        BaseBounceView baseBounceView = this;
        baseBounceView.setRefreshEnable(false);
        WXSwipeLayout wXSwipeLayout = baseBounceView.swipeLayout;
        if (wXSwipeLayout != null && wXSwipeLayout.getHeaderView() != null) {
            BaseBounceView baseBounceView2 = this;
            baseBounceView2.swipeLayout.setRefreshHeight(0);
            baseBounceView2.swipeLayout.getHeaderView().removeView((View)wXComponent.getHostView());
            baseBounceView2.swipeLayout.finishPullRefresh();
            return;
        }
    }

    public void setRefreshEnable(boolean bl) {
        FrameLayout frameLayout = frameLayout.swipeLayout;
        if (frameLayout != null) {
            frameLayout.setPullRefreshEnable(bl);
            return;
        }
    }

    public void setLoadmoreEnable(boolean bl) {
        FrameLayout frameLayout = frameLayout.swipeLayout;
        if (frameLayout != null) {
            frameLayout.setPullLoadEnable(bl);
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeView(View view) {
        FrameLayout frameLayout;
        if (view instanceof WXLoadingLayout) {
            BaseBounceView baseBounceView = frameLayout;
            baseBounceView.finishPullLoad();
            baseBounceView.setLoadmoreEnable(false);
            frameLayout = baseBounceView.swipeLayout;
            if (frameLayout == null) return;
            FrameLayout frameLayout2 = frameLayout;
            frameLayout2.removeView((View)frameLayout2.getFooterView());
            return;
        }
        if (view instanceof WXRefreshLayout) {
            BaseBounceView baseBounceView = frameLayout;
            baseBounceView.finishPullRefresh();
            baseBounceView.setRefreshEnable(false);
            frameLayout = baseBounceView.swipeLayout;
            if (frameLayout == null) return;
            FrameLayout frameLayout3 = frameLayout;
            frameLayout3.removeView((View)frameLayout3.getHeaderView());
            return;
        }
        super.removeView(view);
    }

    public WXSwipeLayout getSwipeLayout() {
        return this.swipeLayout;
    }

    public abstract void onRefreshingComplete();

    public abstract void onLoadmoreComplete();
}

