/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.uts;

import io.dcloud.uts.DataView;
import io.dcloud.uts.NumberKt;
import io.dcloud.uts.TypedArray;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0004\n\u0002\b\r\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001e\u0010\u0014\u001a\u00020\u00002\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\fJ\u0006\u0010\u0017\u001a\u00020\u0006R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR$\u0010\u0002\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010\u00a8\u0006\u0019"}, d2={"Lio/dcloud/uts/ArrayBuffer;", "", "byteLength", "", "(I)V", "byteBuffer", "Ljava/nio/ByteBuffer;", "getByteBuffer", "()Ljava/nio/ByteBuffer;", "setByteBuffer", "(Ljava/nio/ByteBuffer;)V", "value", "", "getByteLength", "()Ljava/lang/Number;", "setByteLength", "(Ljava/lang/Number;)V", "byteOffset", "getByteOffset", "setByteOffset", "slice", "begin", "end", "toByteBuffer", "Companion", "utsplugin_release"})
public final class ArrayBuffer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Number byteLength = 0;
    @NotNull
    private Number byteOffset = 0;
    @NotNull
    private ByteBuffer byteBuffer;

    @NotNull
    public final Number getByteLength() {
        return this.byteLength;
    }

    public final void setByteLength(@NotNull Number value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.byteLength = value;
        ByteBuffer byteBuffer = ByteBuffer.allocate(value.intValue());
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocate(value.toInt())");
        this.byteBuffer = byteBuffer;
    }

    @NotNull
    public final Number getByteOffset() {
        return this.byteOffset;
    }

    public final void setByteOffset(@NotNull Number number) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"<set-?>");
        this.byteOffset = number;
    }

    @NotNull
    public final ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public final void setByteBuffer(@NotNull ByteBuffer byteBuffer) {
        Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"<set-?>");
        this.byteBuffer = byteBuffer;
    }

    public ArrayBuffer(int byteLength) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.byteLength.intValue());
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"allocate(byteLength.toInt())");
        this.byteBuffer = byteBuffer;
        this.setByteLength(byteLength);
    }

    @NotNull
    public final ByteBuffer toByteBuffer() {
        return this.byteBuffer;
    }

    @NotNull
    public final ArrayBuffer slice(@Nullable Number begin, @Nullable Number end) {
        Number number;
        Number safeBegin;
        Number length = this.byteLength;
        Number number2 = begin;
        if (number2 == null) {
            number2 = safeBegin = (Number)0;
        }
        if ((number = end) == null) {
            number = length;
        }
        Number safeEnd = number;
        Number actualBegin = NumberKt.compareTo(safeBegin, 0) < 0 ? (Number)NumberKt.plus(length, safeBegin) : (Number)safeBegin;
        Number actualEnd = NumberKt.compareTo(safeEnd, 0) < 0 ? (Number)NumberKt.plus(length, safeEnd) : (Number)safeEnd;
        int correctedBegin = RangesKt.coerceIn((int)actualBegin.intValue(), (int)0, (int)length.intValue());
        int correctedEnd = RangesKt.coerceIn((int)actualEnd.intValue(), (int)correctedBegin, (int)length.intValue());
        ArrayBuffer newBuffer = new ArrayBuffer(correctedEnd - correctedBegin);
        for (int i = correctedBegin; i < correctedEnd; ++i) {
            newBuffer.byteBuffer.put(this.byteBuffer.get(i));
        }
        return newBuffer;
    }

    public static /* synthetic */ ArrayBuffer slice$default(ArrayBuffer arrayBuffer, Number number, Number number2, int n, Object object) {
        if ((n & 1) != 0) {
            number = null;
        }
        if ((n & 2) != 0) {
            number2 = null;
        }
        return arrayBuffer.slice(number, number2);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001\u00a8\u0006\n"}, d2={"Lio/dcloud/uts/ArrayBuffer$Companion;", "", "()V", "fromByteBuffer", "Lio/dcloud/uts/ArrayBuffer;", "byteBuffer", "Ljava/nio/ByteBuffer;", "isView", "", "arg", "utsplugin_release"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isView(@NotNull Object arg) {
            Intrinsics.checkNotNullParameter((Object)arg, (String)"arg");
            return arg instanceof TypedArray || arg instanceof DataView;
        }

        @NotNull
        public final ArrayBuffer fromByteBuffer(@NotNull ByteBuffer byteBuffer) {
            Intrinsics.checkNotNullParameter((Object)byteBuffer, (String)"byteBuffer");
            ArrayBuffer arrayBuffer = new ArrayBuffer(byteBuffer.capacity());
            arrayBuffer.setByteBuffer(byteBuffer);
            return arrayBuffer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

