/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.media.weex.weex_video.ijkplayer.utils;

import android.content.Context;
import android.net.Uri;
import java.io.File;

public class VideoCacheUtil {
    private static final String VIDEO_CACHE_FOLDER_NAME = "videoPlayer_CacheFiles";
    private static final int CACHE_FOLDER_MAX_LIMIT = 0x6400000;

    public static Uri cacheHttpUriWrap(Uri uri) {
        return Uri.parse((String)("ijkio:cache:ffio:" + uri.toString()));
    }

    public static String getCacheFilePath(Context appContext, Uri uri) {
        if (appContext == null || uri == null) {
            return null;
        }
        File cacheRootFile = VideoCacheUtil.getCacheRootFile(appContext);
        String cacheFileName = String.valueOf(uri.hashCode()) + ".videoCache";
        String cacheFilePath = cacheRootFile.getPath() + File.separator + cacheFileName;
        return cacheFilePath;
    }

    public static String getCacheMapFilePath(Context appContext, Uri uri) {
        if (appContext == null || uri == null) {
            return null;
        }
        File cacheRootFile = VideoCacheUtil.getCacheRootFile(appContext);
        String cacheFileName = String.valueOf(uri.hashCode()) + ".videoCacheMap";
        String cacheFilePath = cacheRootFile.getPath() + File.separator + cacheFileName;
        return cacheFilePath;
    }

    public static void cleanCacheIfNesscessary(Context appContext) {
        File cacheRootFile = VideoCacheUtil.getCacheRootFile(appContext);
        if (cacheRootFile.canRead()) {
            File[] cacheFiles = cacheRootFile.listFiles();
            long totalCacheSize = 0L;
            boolean needCleanCache = false;
            for (File cacheFile : cacheFiles) {
                if (cacheFile.isFile()) {
                    totalCacheSize += cacheFile.length();
                }
                if (totalCacheSize < 0x6400000L) continue;
                needCleanCache = true;
                break;
            }
            if (needCleanCache) {
                for (File perFileItem : cacheFiles) {
                    perFileItem.delete();
                }
            }
        }
    }

    private static File getCacheRootFile(Context appContext) {
        String cacheRootFolder = appContext.getCacheDir().toString() + File.separator + VIDEO_CACHE_FOLDER_NAME;
        File cacheRootFile = new File(cacheRootFolder);
        if (!cacheRootFile.exists()) {
            cacheRootFile.mkdir();
        }
        return cacheRootFile;
    }
}

