/*
 * Decompiled with CFR 0.152.
 */
package dc.squareup.okio;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.concurrent.TimeUnit;

public class Timeout {
    public static final Timeout NONE = new Timeout(){

        @Override
        public Timeout timeout(long l5, TimeUnit timeUnit) {
            return this;
        }

        @Override
        public Timeout deadlineNanoTime(long l5) {
            return this;
        }

        @Override
        public void throwIfReached() throws IOException {
        }
    };
    private boolean hasDeadline;
    private long deadlineNanoTime;
    private long timeoutNanos;

    static long minTimeout(long l5, long l6) {
        if (l5 != 0L && (l6 == 0L || l5 < l6)) {
            return l5;
        }
        return l6;
    }

    public Timeout timeout(long l5, TimeUnit timeUnit) {
        if (l5 >= 0L) {
            if (timeUnit != null) {
                this.timeoutNanos = timeUnit.toNanos(l5);
                return this;
            }
            throw new IllegalArgumentException("unit == null");
        }
        throw new IllegalArgumentException("timeout < 0: " + l5);
    }

    public long timeoutNanos() {
        return this.timeoutNanos;
    }

    public boolean hasDeadline() {
        return this.hasDeadline;
    }

    public long deadlineNanoTime() {
        if (this.hasDeadline) {
            return this.deadlineNanoTime;
        }
        throw new IllegalStateException("No deadline");
    }

    public Timeout deadlineNanoTime(long l5) {
        this.hasDeadline = true;
        this.deadlineNanoTime = l5;
        return this;
    }

    public final Timeout deadline(long l5, TimeUnit timeUnit) {
        if (l5 > 0L) {
            if (timeUnit != null) {
                return this.deadlineNanoTime(System.nanoTime() + timeUnit.toNanos(l5));
            }
            throw new IllegalArgumentException("unit == null");
        }
        throw new IllegalArgumentException("duration <= 0: " + l5);
    }

    public Timeout clearTimeout() {
        this.timeoutNanos = 0L;
        return this;
    }

    public Timeout clearDeadline() {
        this.hasDeadline = false;
        return this;
    }

    public void throwIfReached() throws IOException {
        if (!Thread.interrupted()) {
            if (this.hasDeadline && this.deadlineNanoTime - System.nanoTime() <= 0L) {
                throw new InterruptedIOException("deadline reached");
            }
            return;
        }
        Thread.currentThread().interrupt();
        throw new InterruptedIOException("interrupted");
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void waitUntilNotified(Object var1_2) throws InterruptedIOException {
        block11: {
            block12: {
                try {
                    var2_3 = this.hasDeadline();
                    var3_4 = this.timeoutNanos();
                    if (var2_3 == 0 && var3_4 == 0L) {
                        var1_2.wait();
                        return;
                    }
                    var5_5 = System.nanoTime();
                    if (var2_3 == 0 || var3_4 == 0L) ** GOTO lbl15
                    v0 = var3_4;
                    v1 = this.deadlineNanoTime();
                }
                catch (InterruptedException v2) {}
                var3_4 = Math.min(v0, v1 - var5_5);
                break block12;
lbl15:
                // 1 sources

                if (var2_3 != 0) {
                    var3_4 = this.deadlineNanoTime() - var5_5;
                }
            }
            var7_6 = 0L;
            if (var3_4 <= 0L) break block11;
            v3 = var1_2;
            v4 = var3_4;
            var0_1 = v4 / 1000000L;
            var2_3 = (int)(v4 - var0_1 * 1000000L);
            v3.wait(var0_1, var2_3);
            var7_6 = System.nanoTime() - var5_5;
        }
        if (var7_6 < var3_4) {
            return;
        }
        throw new InterruptedIOException("timeout");
        Thread.currentThread().interrupt();
        throw new InterruptedIOException("interrupted");
    }
}

