/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.datamatrix.encoder;

import com.dcloud.zxing2.datamatrix.encoder.SymbolInfo;

public final class ErrorCorrection {
    private static final int[] FACTOR_SETS = new int[]{5, 7, 10, 11, 12, 14, 18, 20, 24, 28, 36, 42, 48, 56, 62, 68};
    private static final int[][] FACTORS;
    private static final int MODULO_VALUE = 301;
    private static final int[] LOG;
    private static final int[] ALOG;

    private ErrorCorrection() {
    }

    public static String encodeECC200(String string2, SymbolInfo symbolInfo) {
        if (string2.length() == symbolInfo.getDataCapacity()) {
            StringBuilder stringBuilder;
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2(symbolInfo.getDataCapacity() + symbolInfo.getErrorCodewords());
            stringBuilder.append(string2);
            int n5 = symbolInfo.getInterleavedBlockCount();
            if (n5 == 1) {
                stringBuilder2.append(ErrorCorrection.createECCBlock(string2, symbolInfo.getErrorCodewords()));
            } else {
                int n6;
                int n7 = n5;
                StringBuilder stringBuilder3 = stringBuilder2;
                stringBuilder3.setLength(stringBuilder3.capacity());
                int[] nArray = new int[n7];
                int[] nArray2 = new int[n7];
                int[] nArray3 = new int[n7];
                int n8 = 0;
                while (n8 < n5) {
                    n6 = n8 + 1;
                    nArray[n8] = symbolInfo.getDataLengthForInterleavedBlock(n6);
                    nArray2[n8] = symbolInfo.getErrorLengthForInterleavedBlock(n6);
                    nArray3[n8] = 0;
                    if (n8 > 0) {
                        nArray3[n8] = nArray3[n8 - 1] + nArray[n8];
                    }
                    n8 = n6;
                }
                for (int i5 = 0; i5 < n5; ++i5) {
                    StringBuilder stringBuilder4;
                    CharSequence charSequence = stringBuilder4;
                    stringBuilder4 = new StringBuilder(nArray[i5]);
                    for (n6 = i5; n6 < symbolInfo.getDataCapacity(); n6 += n5) {
                        ((StringBuilder)charSequence).append(string2.charAt(n6));
                    }
                    charSequence = ErrorCorrection.createECCBlock(((StringBuilder)charSequence).toString(), nArray2[i5]);
                    n6 = 0;
                    int n9 = i5;
                    while (n9 < nArray2[i5] * n5) {
                        int n10 = n9;
                        n9 = symbolInfo.getDataCapacity() + n9;
                        stringBuilder2.setCharAt(n9, ((String)charSequence).charAt(n6++));
                        n9 = n10 + n5;
                    }
                }
            }
            return stringBuilder2.toString();
        }
        throw new IllegalArgumentException("The number of codewords does not match the selected symbol");
    }

    private static String createECCBlock(CharSequence charSequence, int n5) {
        CharSequence charSequence2 = charSequence;
        return ErrorCorrection.createECCBlock(charSequence2, 0, charSequence2.length(), n5);
    }

    private static String createECCBlock(CharSequence object, int n5, int n6, int n7) {
        int n8 = -1;
        int n9 = 0;
        while (true) {
            int[] nArray = FACTOR_SETS;
            if (n9 >= FACTOR_SETS.length) break;
            if (nArray[n9] == n7) {
                n8 = n9;
                break;
            }
            ++n9;
        }
        if (n8 >= 0) {
            int n10;
            int[] nArray = FACTORS[n8];
            char[] cArray = new char[n7];
            for (n10 = 0; n10 < n7; ++n10) {
                cArray[n10] = '\u0000';
            }
            for (n10 = n5; n10 < n5 + n6; ++n10) {
                int n11;
                int n12 = cArray[n11] ^ object.charAt(n10);
                for (n11 = n7 - 1; n11 > 0; --n11) {
                    int n13;
                    if (n12 != 0 && (n13 = nArray[n11]) != 0) {
                        int[] nArray2 = LOG;
                        cArray[n11] = (char)(cArray[n11 - 1] ^ ALOG[(LOG[n12] + nArray2[n13]) % 255]);
                        continue;
                    }
                    cArray[n11] = cArray[n11 - 1];
                }
                if (n12 != 0 && (n11 = nArray[0]) != 0) {
                    int[] nArray3 = LOG;
                    cArray[0] = (char)ALOG[(LOG[n12] + nArray3[n11]) % 255];
                    continue;
                }
                cArray[0] = '\u0000';
            }
            object = new char[n7];
            for (n5 = 0; n5 < n7; ++n5) {
                object[n5] = cArray[n7 - n5 - 1];
            }
            return String.valueOf((char[])object);
        }
        throw new IllegalArgumentException("Illegal number of error correction codewords specified: " + n7);
    }

    static {
        int[][] nArrayArray = new int[16][];
        int[] nArray = new int[5];
        int[] nArray2 = nArray;
        nArray[0] = 228;
        nArray[1] = 48;
        nArray[2] = 15;
        nArray[3] = 111;
        nArray[4] = 62;
        nArrayArray[0] = nArray2;
        int[] nArray3 = new int[7];
        nArray2 = nArray3;
        nArray3[0] = 23;
        nArray3[1] = 68;
        nArray3[2] = 144;
        nArray3[3] = 134;
        nArray3[4] = 240;
        nArray3[5] = 92;
        nArray3[6] = 254;
        nArrayArray[1] = nArray2;
        int[] nArray4 = new int[10];
        nArray2 = nArray4;
        nArray4[0] = 28;
        nArray4[1] = 24;
        nArray4[2] = 185;
        nArray4[3] = 166;
        nArray4[4] = 223;
        nArray4[5] = 248;
        nArray4[6] = 116;
        nArray4[7] = 255;
        nArray4[8] = 110;
        nArray4[9] = 61;
        nArrayArray[2] = nArray2;
        int[] nArray5 = new int[11];
        nArray2 = nArray5;
        nArray5[0] = 175;
        nArray5[1] = 138;
        nArray5[2] = 205;
        nArray5[3] = 12;
        nArray5[4] = 194;
        nArray5[5] = 168;
        nArray5[6] = 39;
        nArray5[7] = 245;
        nArray5[8] = 60;
        nArray5[9] = 97;
        nArray5[10] = 120;
        nArrayArray[3] = nArray2;
        int[] nArray6 = new int[12];
        nArray2 = nArray6;
        nArray6[0] = 41;
        nArray6[1] = 153;
        nArray6[2] = 158;
        nArray6[3] = 91;
        nArray6[4] = 61;
        nArray6[5] = 42;
        nArray6[6] = 142;
        nArray6[7] = 213;
        nArray6[8] = 97;
        nArray6[9] = 178;
        nArray6[10] = 100;
        nArray6[11] = 242;
        nArrayArray[4] = nArray2;
        int[] nArray7 = new int[14];
        nArray2 = nArray7;
        nArray7[0] = 156;
        nArray7[1] = 97;
        nArray7[2] = 192;
        nArray7[3] = 252;
        nArray7[4] = 95;
        nArray7[5] = 9;
        nArray7[6] = 157;
        nArray7[7] = 119;
        nArray7[8] = 138;
        nArray7[9] = 45;
        nArray7[10] = 18;
        nArray7[11] = 186;
        nArray7[12] = 83;
        nArray7[13] = 185;
        nArrayArray[5] = nArray2;
        int[] nArray8 = new int[18];
        nArray2 = nArray8;
        nArray8[0] = 83;
        nArray8[1] = 195;
        nArray8[2] = 100;
        nArray8[3] = 39;
        nArray8[4] = 188;
        nArray8[5] = 75;
        nArray8[6] = 66;
        nArray8[7] = 61;
        nArray8[8] = 241;
        nArray8[9] = 213;
        nArray8[10] = 109;
        nArray8[11] = 129;
        nArray8[12] = 94;
        nArray8[13] = 254;
        nArray8[14] = 225;
        nArray8[15] = 48;
        nArray8[16] = 90;
        nArray8[17] = 188;
        nArrayArray[6] = nArray2;
        int[] nArray9 = new int[20];
        nArray2 = nArray9;
        nArray9[0] = 15;
        nArray2[1] = 195;
        nArray2[2] = 244;
        nArray2[3] = 9;
        nArray2[4] = 233;
        nArray2[5] = 71;
        nArray2[6] = 168;
        nArray2[7] = 2;
        nArray2[8] = 188;
        nArray2[9] = 160;
        nArray2[10] = 153;
        nArray2[11] = 145;
        nArray2[12] = 253;
        nArray2[13] = 79;
        nArray2[14] = 108;
        nArray2[15] = 82;
        nArray2[16] = 27;
        nArray2[17] = 174;
        nArray2[18] = 186;
        nArray2[19] = 172;
        nArrayArray[7] = nArray2;
        int[] nArray10 = new int[24];
        nArray2 = nArray10;
        nArray10[0] = 52;
        nArray2[1] = 190;
        nArray2[2] = 88;
        nArray2[3] = 205;
        nArray2[4] = 109;
        nArray2[5] = 39;
        nArray2[6] = 176;
        nArray2[7] = 21;
        nArray2[8] = 155;
        nArray2[9] = 197;
        nArray2[10] = 251;
        nArray2[11] = 223;
        nArray2[12] = 155;
        nArray2[13] = 21;
        nArray2[14] = 5;
        nArray2[15] = 172;
        nArray2[16] = 254;
        nArray2[17] = 124;
        nArray2[18] = 12;
        nArray2[19] = 181;
        nArray2[20] = 184;
        nArray2[21] = 96;
        nArray2[22] = 50;
        nArray2[23] = 193;
        nArrayArray[8] = nArray2;
        int[] nArray11 = new int[28];
        nArray2 = nArray11;
        nArray11[0] = 211;
        nArray2[1] = 231;
        nArray2[2] = 43;
        nArray2[3] = 97;
        nArray2[4] = 71;
        nArray2[5] = 96;
        nArray2[6] = 103;
        nArray2[7] = 174;
        nArray2[8] = 37;
        nArray2[9] = 151;
        nArray2[10] = 170;
        nArray2[11] = 53;
        nArray2[12] = 75;
        nArray2[13] = 34;
        nArray2[14] = 249;
        nArray2[15] = 121;
        nArray2[16] = 17;
        nArray2[17] = 138;
        nArray2[18] = 110;
        nArray2[19] = 213;
        nArray2[20] = 141;
        nArray2[21] = 136;
        nArray2[22] = 120;
        nArray2[23] = 151;
        nArray2[24] = 233;
        nArray2[25] = 168;
        nArray2[26] = 93;
        nArray2[27] = 255;
        nArrayArray[9] = nArray2;
        int[] nArray12 = new int[36];
        nArray2 = nArray12;
        nArray12[0] = 245;
        nArray2[1] = 127;
        nArray2[2] = 242;
        nArray2[3] = 218;
        nArray2[4] = 130;
        nArray2[5] = 250;
        nArray2[6] = 162;
        nArray2[7] = 181;
        nArray2[8] = 102;
        nArray2[9] = 120;
        nArray2[10] = 84;
        nArray2[11] = 179;
        nArray2[12] = 220;
        nArray2[13] = 251;
        nArray2[14] = 80;
        nArray2[15] = 182;
        nArray2[16] = 229;
        nArray2[17] = 18;
        nArray2[18] = 2;
        nArray2[19] = 4;
        nArray2[20] = 68;
        nArray2[21] = 33;
        nArray2[22] = 101;
        nArray2[23] = 137;
        nArray2[24] = 95;
        nArray2[25] = 119;
        nArray2[26] = 115;
        nArray2[27] = 44;
        nArray2[28] = 175;
        nArray2[29] = 184;
        nArray2[30] = 59;
        nArray2[31] = 25;
        nArray2[32] = 225;
        nArray2[33] = 98;
        nArray2[34] = 81;
        nArray2[35] = 112;
        nArrayArray[10] = nArray2;
        int[] nArray13 = new int[42];
        nArray2 = nArray13;
        nArray13[0] = 77;
        nArray2[1] = 193;
        nArray2[2] = 137;
        nArray2[3] = 31;
        nArray2[4] = 19;
        nArray2[5] = 38;
        nArray2[6] = 22;
        nArray2[7] = 153;
        nArray2[8] = 247;
        nArray2[9] = 105;
        nArray2[10] = 122;
        nArray2[11] = 2;
        nArray2[12] = 245;
        nArray2[13] = 133;
        nArray2[14] = 242;
        nArray2[15] = 8;
        nArray2[16] = 175;
        nArray2[17] = 95;
        nArray2[18] = 100;
        nArray2[19] = 9;
        nArray2[20] = 167;
        nArray2[21] = 105;
        nArray2[22] = 214;
        nArray2[23] = 111;
        nArray2[24] = 57;
        nArray2[25] = 121;
        nArray2[26] = 21;
        nArray2[27] = 1;
        nArray2[28] = 253;
        nArray2[29] = 57;
        nArray2[30] = 54;
        nArray2[31] = 101;
        nArray2[32] = 248;
        nArray2[33] = 202;
        nArray2[34] = 69;
        nArray2[35] = 50;
        nArray2[36] = 150;
        nArray2[37] = 177;
        nArray2[38] = 226;
        nArray2[39] = 5;
        nArray2[40] = 9;
        nArray2[41] = 5;
        nArrayArray[11] = nArray2;
        int[] nArray14 = new int[48];
        nArray2 = nArray14;
        nArray14[0] = 245;
        nArray2[1] = 132;
        nArray2[2] = 172;
        nArray2[3] = 223;
        nArray2[4] = 96;
        nArray2[5] = 32;
        nArray2[6] = 117;
        nArray2[7] = 22;
        nArray2[8] = 238;
        nArray2[9] = 133;
        nArray2[10] = 238;
        nArray2[11] = 231;
        nArray2[12] = 205;
        nArray2[13] = 188;
        nArray2[14] = 237;
        nArray2[15] = 87;
        nArray2[16] = 191;
        nArray2[17] = 106;
        nArray2[18] = 16;
        nArray2[19] = 147;
        nArray2[20] = 118;
        nArray2[21] = 23;
        nArray2[22] = 37;
        nArray2[23] = 90;
        nArray2[24] = 170;
        nArray2[25] = 205;
        nArray2[26] = 131;
        nArray2[27] = 88;
        nArray2[28] = 120;
        nArray2[29] = 100;
        nArray2[30] = 66;
        nArray2[31] = 138;
        nArray2[32] = 186;
        nArray2[33] = 240;
        nArray2[34] = 82;
        nArray2[35] = 44;
        nArray2[36] = 176;
        nArray2[37] = 87;
        nArray2[38] = 187;
        nArray2[39] = 147;
        nArray2[40] = 160;
        nArray2[41] = 175;
        nArray2[42] = 69;
        nArray2[43] = 213;
        nArray2[44] = 92;
        nArray2[45] = 253;
        nArray2[46] = 225;
        nArray2[47] = 19;
        nArrayArray[12] = nArray2;
        int[] nArray15 = new int[56];
        nArray2 = nArray15;
        nArray15[0] = 175;
        nArray2[1] = 9;
        nArray2[2] = 223;
        nArray2[3] = 238;
        nArray2[4] = 12;
        nArray2[5] = 17;
        nArray2[6] = 220;
        nArray2[7] = 208;
        nArray2[8] = 100;
        nArray2[9] = 29;
        nArray2[10] = 175;
        nArray2[11] = 170;
        nArray2[12] = 230;
        nArray2[13] = 192;
        nArray2[14] = 215;
        nArray2[15] = 235;
        nArray2[16] = 150;
        nArray2[17] = 159;
        nArray2[18] = 36;
        nArray2[19] = 223;
        nArray2[20] = 38;
        nArray2[21] = 200;
        nArray2[22] = 132;
        nArray2[23] = 54;
        nArray2[24] = 228;
        nArray2[25] = 146;
        nArray2[26] = 218;
        nArray2[27] = 234;
        nArray2[28] = 117;
        nArray2[29] = 203;
        nArray2[30] = 29;
        nArray2[31] = 232;
        nArray2[32] = 144;
        nArray2[33] = 238;
        nArray2[34] = 22;
        nArray2[35] = 150;
        nArray2[36] = 201;
        nArray2[37] = 117;
        nArray2[38] = 62;
        nArray2[39] = 207;
        nArray2[40] = 164;
        nArray2[41] = 13;
        nArray2[42] = 137;
        nArray2[43] = 245;
        nArray2[44] = 127;
        nArray2[45] = 67;
        nArray2[46] = 247;
        nArray2[47] = 28;
        nArray2[48] = 155;
        nArray2[49] = 43;
        nArray2[50] = 203;
        nArray2[51] = 107;
        nArray2[52] = 233;
        nArray2[53] = 53;
        nArray2[54] = 143;
        nArray2[55] = 46;
        nArrayArray[13] = nArray2;
        int[] nArray16 = new int[62];
        nArray2 = nArray16;
        nArray16[0] = 242;
        nArray2[1] = 93;
        nArray2[2] = 169;
        nArray2[3] = 50;
        nArray2[4] = 144;
        nArray2[5] = 210;
        nArray2[6] = 39;
        nArray2[7] = 118;
        nArray2[8] = 202;
        nArray2[9] = 188;
        nArray2[10] = 201;
        nArray2[11] = 189;
        nArray2[12] = 143;
        nArray2[13] = 108;
        nArray2[14] = 196;
        nArray2[15] = 37;
        nArray2[16] = 185;
        nArray2[17] = 112;
        nArray2[18] = 134;
        nArray2[19] = 230;
        nArray2[20] = 245;
        nArray2[21] = 63;
        nArray2[22] = 197;
        nArray2[23] = 190;
        nArray2[24] = 250;
        nArray2[25] = 106;
        nArray2[26] = 185;
        nArray2[27] = 221;
        nArray2[28] = 175;
        nArray2[29] = 64;
        nArray2[30] = 114;
        nArray2[31] = 71;
        nArray2[32] = 161;
        nArray2[33] = 44;
        nArray2[34] = 147;
        nArray2[35] = 6;
        nArray2[36] = 27;
        nArray2[37] = 218;
        nArray2[38] = 51;
        nArray2[39] = 63;
        nArray2[40] = 87;
        nArray2[41] = 10;
        nArray2[42] = 40;
        nArray2[43] = 130;
        nArray2[44] = 188;
        nArray2[45] = 17;
        nArray2[46] = 163;
        nArray2[47] = 31;
        nArray2[48] = 176;
        nArray2[49] = 170;
        nArray2[50] = 4;
        nArray2[51] = 107;
        nArray2[52] = 232;
        nArray2[53] = 7;
        nArray2[54] = 94;
        nArray2[55] = 166;
        nArray2[56] = 224;
        nArray2[57] = 124;
        nArray2[58] = 86;
        nArray2[59] = 47;
        nArray2[60] = 11;
        nArray2[61] = 204;
        nArrayArray[14] = nArray2;
        int[] nArray17 = new int[68];
        nArray2 = nArray17;
        nArray17[0] = 220;
        nArray2[1] = 228;
        nArray2[2] = 173;
        nArray2[3] = 89;
        nArray2[4] = 251;
        nArray2[5] = 149;
        nArray2[6] = 159;
        nArray2[7] = 56;
        nArray2[8] = 89;
        nArray2[9] = 33;
        nArray2[10] = 147;
        nArray2[11] = 244;
        nArray2[12] = 154;
        nArray2[13] = 36;
        nArray2[14] = 73;
        nArray2[15] = 127;
        nArray2[16] = 213;
        nArray2[17] = 136;
        nArray2[18] = 248;
        nArray2[19] = 180;
        nArray2[20] = 234;
        nArray2[21] = 197;
        nArray2[22] = 158;
        nArray2[23] = 177;
        nArray2[24] = 68;
        nArray2[25] = 122;
        nArray2[26] = 93;
        nArray2[27] = 213;
        nArray2[28] = 15;
        nArray2[29] = 160;
        nArray2[30] = 227;
        nArray2[31] = 236;
        nArray2[32] = 66;
        nArray2[33] = 139;
        nArray2[34] = 153;
        nArray2[35] = 185;
        nArray2[36] = 202;
        nArray2[37] = 167;
        nArray2[38] = 179;
        nArray2[39] = 25;
        nArray2[40] = 220;
        nArray2[41] = 232;
        nArray2[42] = 96;
        nArray2[43] = 210;
        nArray2[44] = 231;
        nArray2[45] = 136;
        nArray2[46] = 223;
        nArray2[47] = 239;
        nArray2[48] = 181;
        nArray2[49] = 241;
        nArray2[50] = 59;
        nArray2[51] = 52;
        nArray2[52] = 172;
        nArray2[53] = 25;
        nArray2[54] = 49;
        nArray2[55] = 232;
        nArray2[56] = 211;
        nArray2[57] = 189;
        nArray2[58] = 64;
        nArray2[59] = 54;
        nArray2[60] = 108;
        nArray2[61] = 153;
        nArray2[62] = 132;
        nArray2[63] = 63;
        nArray2[64] = 96;
        nArray2[65] = 103;
        nArray2[66] = 82;
        nArray2[67] = 186;
        nArrayArray[15] = nArray2;
        FACTORS = nArrayArray;
        LOG = new int[256];
        ALOG = new int[255];
        int n5 = 1;
        for (int i5 = 0; i5 < 255; ++i5) {
            ErrorCorrection.ALOG[i5] = n5;
            ErrorCorrection.LOG[n5] = i5;
            if ((n5 *= 2) < 256) continue;
            n5 ^= 0x12D;
        }
    }
}

