/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417.encoder;

import com.dcloud.zxing2.WriterException;
import com.dcloud.zxing2.common.CharacterSetECI;
import com.dcloud.zxing2.pdf417.encoder.Compaction;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;

final class PDF417HighLevelEncoder {
    private static final int TEXT_COMPACTION = 0;
    private static final int BYTE_COMPACTION = 1;
    private static final int NUMERIC_COMPACTION = 2;
    private static final int SUBMODE_ALPHA = 0;
    private static final int SUBMODE_LOWER = 1;
    private static final int SUBMODE_MIXED = 2;
    private static final int SUBMODE_PUNCTUATION = 3;
    private static final int LATCH_TO_TEXT = 900;
    private static final int LATCH_TO_BYTE_PADDED = 901;
    private static final int LATCH_TO_NUMERIC = 902;
    private static final int SHIFT_TO_BYTE = 913;
    private static final int LATCH_TO_BYTE = 924;
    private static final int ECI_USER_DEFINED = 925;
    private static final int ECI_GENERAL_PURPOSE = 926;
    private static final int ECI_CHARSET = 927;
    private static final byte[] TEXT_MIXED_RAW;
    private static final byte[] TEXT_PUNCTUATION_RAW;
    private static final byte[] MIXED;
    private static final byte[] PUNCTUATION;
    private static final Charset DEFAULT_ENCODING;

    private PDF417HighLevelEncoder() {
    }

    static String encodeHighLevel(String string2, Compaction compaction, Charset charset) throws WriterException {
        CharacterSetECI characterSetECI;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(string2.length());
        if (charset == null) {
            charset = DEFAULT_ENCODING;
        } else if (!DEFAULT_ENCODING.equals(charset) && (characterSetECI = CharacterSetECI.getCharacterSetECIByName(charset.name())) != null) {
            PDF417HighLevelEncoder.encodingECI(characterSetECI.getValue(), stringBuilder2);
        }
        int n5 = string2.length();
        int n6 = 0;
        int n7 = 0;
        if (compaction == Compaction.TEXT) {
            PDF417HighLevelEncoder.encodeText(string2, n6, n5, stringBuilder2, n7);
        } else if (compaction == Compaction.BYTE) {
            byte[] byArray = string2.getBytes(charset);
            PDF417HighLevelEncoder.encodeBinary(byArray, n6, byArray.length, 1, stringBuilder2);
        } else if (compaction == Compaction.NUMERIC) {
            stringBuilder2.append('\u0386');
            PDF417HighLevelEncoder.encodeNumeric(string2, n6, n5, stringBuilder2);
        } else {
            int n8 = 0;
            while (n6 < n5) {
                int n9 = PDF417HighLevelEncoder.determineConsecutiveDigitCount(string2, n6);
                if (n9 >= 13) {
                    stringBuilder2.append('\u0386');
                    n8 = 2;
                    n7 = 0;
                    PDF417HighLevelEncoder.encodeNumeric(string2, n6, n9, stringBuilder2);
                    n6 += n9;
                    continue;
                }
                int n10 = PDF417HighLevelEncoder.determineConsecutiveTextCount(string2, n6);
                if (n10 < 5 && n9 != n5) {
                    n9 = PDF417HighLevelEncoder.determineConsecutiveBinaryCount(string2, n6, charset);
                    if (n9 == 0) {
                        n9 = 1;
                    }
                    int n11 = n6;
                    n6 = n11 + n9;
                    byte[] byArray = string2.substring(n11, n6).getBytes(charset);
                    if (byArray.length == 1 && n8 == 0) {
                        PDF417HighLevelEncoder.encodeBinary(byArray, 0, 1, 0, stringBuilder2);
                        continue;
                    }
                    PDF417HighLevelEncoder.encodeBinary(byArray, 0, byArray.length, n8, stringBuilder2);
                    n8 = 1;
                    n7 = 0;
                    continue;
                }
                if (n8 != 0) {
                    stringBuilder2.append('\u0384');
                    n8 = 0;
                    n7 = 0;
                }
                int n12 = n6;
                n6 = PDF417HighLevelEncoder.encodeText(string2, n6, n10, stringBuilder2, n7);
                int n13 = n7 = n12 + n10;
                n7 = n6;
                n6 = n13;
            }
        }
        return stringBuilder2.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int encodeText(CharSequence charSequence, int n5, int n6, StringBuilder stringBuilder, int n7) {
        StringBuilder stringBuilder2;
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder2 = new StringBuilder(n6);
        int n8 = 0;
        while (true) {
            block25: {
                char c6;
                block26: {
                    block27: {
                        int n9 = n5 + n8;
                        c6 = charSequence.charAt(n9);
                        if (n7 == 0) break block26;
                        if (n7 == 1) break block27;
                        if (n7 != 2) {
                            if (PDF417HighLevelEncoder.isPunctuation(c6)) {
                                stringBuilder3.append((char)PUNCTUATION[c6]);
                                break block25;
                            } else {
                                n7 = 0;
                                stringBuilder3.append('\u001d');
                                continue;
                            }
                        }
                        if (PDF417HighLevelEncoder.isMixed(c6)) {
                            stringBuilder3.append((char)MIXED[c6]);
                            break block25;
                        } else {
                            if (PDF417HighLevelEncoder.isAlphaUpper(c6)) {
                                n7 = 0;
                                stringBuilder3.append('\u001c');
                                continue;
                            }
                            if (PDF417HighLevelEncoder.isAlphaLower(c6)) {
                                n7 = 1;
                                stringBuilder3.append('\u001b');
                                continue;
                            }
                            if (++n9 < n6 && PDF417HighLevelEncoder.isPunctuation(charSequence.charAt(n9))) {
                                n7 = 3;
                                stringBuilder3.append('\u0019');
                                continue;
                            }
                            stringBuilder3.append('\u001d');
                            stringBuilder3.append((char)PUNCTUATION[c6]);
                        }
                        break block25;
                    }
                    if (PDF417HighLevelEncoder.isAlphaLower(c6)) {
                        if (c6 == ' ') {
                            stringBuilder3.append('\u001a');
                            break block25;
                        } else {
                            stringBuilder3.append((char)(c6 - 97));
                        }
                        break block25;
                    } else if (PDF417HighLevelEncoder.isAlphaUpper(c6)) {
                        stringBuilder3.append('\u001b');
                        stringBuilder3.append((char)(c6 - 65));
                        break block25;
                    } else {
                        if (PDF417HighLevelEncoder.isMixed(c6)) {
                            n7 = 2;
                            stringBuilder3.append('\u001c');
                            continue;
                        }
                        stringBuilder3.append('\u001d');
                        stringBuilder3.append((char)PUNCTUATION[c6]);
                    }
                    break block25;
                }
                if (PDF417HighLevelEncoder.isAlphaUpper(c6)) {
                    if (c6 == ' ') {
                        stringBuilder3.append('\u001a');
                    } else {
                        stringBuilder3.append((char)(c6 - 65));
                    }
                } else {
                    if (PDF417HighLevelEncoder.isAlphaLower(c6)) {
                        n7 = 1;
                        stringBuilder3.append('\u001b');
                        continue;
                    }
                    if (PDF417HighLevelEncoder.isMixed(c6)) {
                        n7 = 2;
                        stringBuilder3.append('\u001c');
                        continue;
                    }
                    stringBuilder3.append('\u001d');
                    stringBuilder3.append((char)PUNCTUATION[c6]);
                }
            }
            if (++n8 >= n6) break;
        }
        int n10 = 0;
        n5 = stringBuilder3.length();
        for (n6 = 0; n6 < n5; ++n6) {
            if (n6 % 2 != 0) {
                char c7 = (char)(n10 * 30 + stringBuilder3.charAt(n6));
                n10 = c7;
                stringBuilder.append(c7);
                continue;
            }
            n10 = stringBuilder3.charAt(n6);
        }
        if (n5 % 2 != 0) {
            stringBuilder.append((char)(n10 * 30 + 29));
            return n7;
        }
        return n7;
    }

    private static void encodeBinary(byte[] byArray, int n5, int n6, int n7, StringBuilder stringBuilder) {
        int n8;
        if (n6 == 1 && n7 == 0) {
            stringBuilder.append('\u0391');
        } else if (n6 % 6 == 0) {
            stringBuilder.append('\u039c');
        } else {
            stringBuilder.append('\u0385');
        }
        if (n6 >= 6) {
            char[] cArray = new char[5];
            n8 = n5;
            while (n5 + n6 - n8 >= 6) {
                int n9;
                long l5 = 0L;
                for (n9 = 0; n9 < 6; ++n9) {
                    l5 = (l5 << 8) + (long)(byArray[n8 + n9] & 0xFF);
                }
                for (n9 = 0; n9 < 5; ++n9) {
                    cArray[n9] = (char)(l5 % 900L);
                    l5 /= 900L;
                }
                for (int i5 = 4; i5 >= 0; --i5) {
                    stringBuilder.append(cArray[i5]);
                }
                n8 += 6;
            }
        } else {
            n8 = n5;
        }
        while (n8 < n5 + n6) {
            stringBuilder.append((char)(byArray[n8] & 0xFF));
            ++n8;
        }
    }

    private static void encodeNumeric(String string2, int n5, int n6, StringBuilder stringBuilder) {
        int n7;
        StringBuilder stringBuilder2;
        StringBuilder stringBuilder3 = stringBuilder2;
        stringBuilder2 = new StringBuilder(n6 / 3 + 1);
        BigInteger bigInteger = BigInteger.valueOf(900L);
        BigInteger bigInteger2 = BigInteger.valueOf(0L);
        for (int i5 = 0; i5 < n6; i5 += n7) {
            BigInteger bigInteger3;
            stringBuilder3.setLength(0);
            n7 = Math.min(44, n6 - i5);
            int n8 = n5 + i5;
            String string3 = '1' + string2.substring(n8, n8 + n7);
            BigInteger bigInteger4 = bigInteger3;
            bigInteger3 = new BigInteger(string3);
            do {
                stringBuilder3.append((char)bigInteger4.mod(bigInteger).intValue());
            } while (!(bigInteger4 = bigInteger4.divide(bigInteger)).equals(bigInteger2));
            for (int i6 = stringBuilder3.length() - 1; i6 >= 0; --i6) {
                stringBuilder.append(stringBuilder3.charAt(i6));
            }
        }
    }

    private static boolean isDigit(char c6) {
        return c6 >= '0' && c6 <= '9';
    }

    private static boolean isAlphaUpper(char c6) {
        return c6 == ' ' || c6 >= 'A' && c6 <= 'Z';
        {
        }
    }

    private static boolean isAlphaLower(char c6) {
        return c6 == ' ' || c6 >= 'a' && c6 <= 'z';
        {
        }
    }

    private static boolean isMixed(char c6) {
        return MIXED[c6] != -1;
    }

    private static boolean isPunctuation(char c6) {
        return PUNCTUATION[c6] != -1;
    }

    private static boolean isText(char c6) {
        return c6 == '\t' || c6 == '\n' || c6 == '\r' || c6 >= ' ' && c6 <= '~';
        {
        }
    }

    private static int determineConsecutiveDigitCount(CharSequence charSequence, int n5) {
        int n6 = 0;
        int n7 = charSequence.length();
        if (n5 < n7) {
            char c6 = charSequence.charAt(n5);
            while (PDF417HighLevelEncoder.isDigit(c6) && n5 < n7) {
                ++n6;
                if (++n5 >= n7) continue;
                c6 = charSequence.charAt(n5);
            }
            return n6;
        }
        return n6;
    }

    private static int determineConsecutiveTextCount(CharSequence charSequence, int n5) {
        int n6 = charSequence.length();
        int n7 = n5;
        while (n7 < n6) {
            int n8;
            char c6 = charSequence.charAt(n7);
            for (n8 = 0; n8 < 13 && PDF417HighLevelEncoder.isDigit(c6) && n7 < n6; ++n8) {
                if (++n7 >= n6) continue;
                c6 = charSequence.charAt(n7);
            }
            if (n8 >= 13) {
                return n7 - n5 - n8;
            }
            if (n8 > 0) continue;
            if (!PDF417HighLevelEncoder.isText(charSequence.charAt(n7))) break;
            ++n7;
        }
        return n7 - n5;
    }

    private static int determineConsecutiveBinaryCount(String string2, int n5, Charset object) throws WriterException {
        int n6;
        object = ((Charset)object).newEncoder();
        int n7 = string2.length();
        for (n6 = n5; n6 < n7; ++n6) {
            char c6 = string2.charAt(n6);
            int n8 = 0;
            while (n8 < 13 && PDF417HighLevelEncoder.isDigit(c6) && (c6 = n6 + ++n8) < n7) {
                c6 = string2.charAt(c6);
            }
            if (n8 >= 13) {
                return n6 - n5;
            }
            c6 = string2.charAt(n6);
            if (((CharsetEncoder)object).canEncode(c6)) {
                continue;
            }
            throw new WriterException("Non-encodable character detected: " + c6 + " (Unicode: " + c6 + ')');
        }
        return n6 - n5;
    }

    private static void encodingECI(int n5, StringBuilder stringBuilder) throws WriterException {
        if (n5 >= 0 && n5 < 900) {
            stringBuilder.append('\u039f');
            stringBuilder.append((char)n5);
            return;
        }
        if (n5 < 810900) {
            stringBuilder.append('\u039e');
            stringBuilder.append((char)(n5 / 900 - 1));
            stringBuilder.append((char)(n5 % 900));
            return;
        }
        if (n5 < 811800) {
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.append('\u039d');
            stringBuilder2.append((char)(810900 - n5));
            return;
        }
        throw new WriterException("ECI number not in valid range from 0..811799, but was " + n5);
    }

    static {
        byte[] byArray;
        byte[] byArray2 = new byte[30];
        byte[] byArray3 = byArray2;
        byArray2[0] = 48;
        byArray3[1] = 49;
        byArray3[2] = 50;
        byArray3[3] = 51;
        byArray3[4] = 52;
        byArray3[5] = 53;
        byArray3[6] = 54;
        byArray3[7] = 55;
        byArray3[8] = 56;
        byArray3[9] = 57;
        byArray3[10] = 38;
        byArray3[11] = 13;
        byArray3[12] = 9;
        byArray3[13] = 44;
        byArray3[14] = 58;
        byArray3[15] = 35;
        byArray3[16] = 45;
        byArray3[17] = 46;
        byArray3[18] = 36;
        byArray3[19] = 47;
        byArray3[20] = 43;
        byArray3[21] = 37;
        byArray3[22] = 42;
        byArray3[23] = 61;
        byArray3[24] = 94;
        byArray3[25] = 0;
        byArray3[26] = 32;
        byArray3[27] = 0;
        byArray3[28] = 0;
        byArray3[29] = 0;
        TEXT_MIXED_RAW = byArray3;
        byte[] byArray4 = new byte[30];
        byArray3 = byArray4;
        byArray4[0] = 59;
        byArray3[1] = 60;
        byArray3[2] = 62;
        byArray3[3] = 64;
        byArray3[4] = 91;
        byArray3[5] = 92;
        byArray3[6] = 93;
        byArray3[7] = 95;
        byArray3[8] = 96;
        byArray3[9] = 126;
        byArray3[10] = 33;
        byArray3[11] = 13;
        byArray3[12] = 9;
        byArray3[13] = 44;
        byArray3[14] = 58;
        byArray3[15] = 10;
        byArray3[16] = 45;
        byArray3[17] = 46;
        byArray3[18] = 36;
        byArray3[19] = 47;
        byArray3[20] = 34;
        byArray3[21] = 124;
        byArray3[22] = 42;
        byArray3[23] = 40;
        byArray3[24] = 41;
        byArray3[25] = 63;
        byArray3[26] = 123;
        byArray3[27] = 125;
        byArray3[28] = 39;
        byArray3[29] = 0;
        TEXT_PUNCTUATION_RAW = byArray3;
        MIXED = new byte[128];
        PUNCTUATION = new byte[128];
        DEFAULT_ENCODING = Charset.forName("ISO-8859-1");
        Arrays.fill(MIXED, (byte)-1);
        int n5 = 0;
        while (true) {
            byArray = TEXT_MIXED_RAW;
            if (n5 >= TEXT_MIXED_RAW.length) break;
            byte by = byArray[n5];
            if (by > 0) {
                PDF417HighLevelEncoder.MIXED[by] = n5;
            }
            n5 = (byte)(n5 + 1);
        }
        Arrays.fill(PUNCTUATION, (byte)-1);
        n5 = 0;
        while (true) {
            byArray = TEXT_PUNCTUATION_RAW;
            if (n5 >= TEXT_PUNCTUATION_RAW.length) break;
            byte by = byArray[n5];
            if (by > 0) {
                PDF417HighLevelEncoder.PUNCTUATION[by] = n5;
            }
            n5 = (byte)(n5 + 1);
        }
    }
}

