/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex_scroller.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ScrollView;
import androidx.core.view.NestedScrollingChild;
import androidx.core.view.NestedScrollingChildHelper;
import com.taobao.weex.common.WXThread;
import com.taobao.weex.ui.component.DCWXScroller;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.view.IWXScroller;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXReflectionUtils;
import com.taobao.weex.utils.WXViewUtils;
import io.dcloud.common.ui.blur.AppEventForBlurManager;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DCWXScrollView
extends ScrollView
implements Handler.Callback,
IWXScroller,
WXGestureObservable,
NestedScrollingChild {
    private NestedScrollingChildHelper childHelper;
    private float ox;
    private float oy;
    private int[] consumed;
    private int[] offsetInWindow;
    int mScrollX;
    int mScrollY;
    private WXGesture wxGesture;
    private List<WXScrollViewListener> mScrollViewListeners;
    private DCWXScroller mWAScroller;
    private View mCurrentStickyView;
    private boolean mRedirectTouchToStickyView;
    private int mStickyOffset;
    private boolean mHasNotDoneActionDown;
    @SuppressLint(value={"HandlerLeak"})
    private Handler mScrollerTask;
    private int mInitialPosition;
    private int mCheckTime;
    private int[] mStickyP;
    private Rect mScrollRect;
    private int[] stickyScrollerP;
    private int[] stickyViewP;
    private boolean scrollable;
    private Field scroller;
    private boolean isTouch;
    private boolean isExecScrollerTask;
    private float decelerationRate;
    private boolean shouldBeTriggerUpper;
    private boolean shouldBeTriggerLower;
    private float upper;
    private float lowwer;

    public DCWXScrollView(Context context) {
        DCWXScrollView dCWXScrollView = this;
        super(context);
        dCWXScrollView.consumed = new int[2];
        dCWXScrollView.offsetInWindow = new int[2];
        dCWXScrollView.mHasNotDoneActionDown = true;
        dCWXScrollView.mCheckTime = 100;
        dCWXScrollView.mStickyP = new int[2];
        dCWXScrollView.stickyScrollerP = new int[2];
        dCWXScrollView.stickyViewP = new int[2];
        dCWXScrollView.scrollable = true;
        dCWXScrollView.scroller = null;
        dCWXScrollView.isTouch = false;
        dCWXScrollView.isExecScrollerTask = false;
        dCWXScrollView.decelerationRate = 1.0f;
        dCWXScrollView.shouldBeTriggerUpper = true;
        dCWXScrollView.shouldBeTriggerLower = true;
        dCWXScrollView.upper = 50.0f;
        dCWXScrollView.lowwer = 50.0f;
        dCWXScrollView.mScrollViewListeners = new ArrayList<WXScrollViewListener>();
        dCWXScrollView.init();
        try {
            WXReflectionUtils.setValue(dCWXScrollView, "mMinimumVelocity", 5);
            return;
        }
        catch (Exception exception) {
            WXLogUtils.e("[WXScrollView] WXScrollView: ", exception);
            return;
        }
    }

    private void init() {
        Field field;
        DCWXScrollView dCWXScrollView = this;
        dCWXScrollView.setWillNotDraw(false);
        dCWXScrollView.setOverScrollMode(2);
        this.childHelper = new NestedScrollingChildHelper((View)this);
        this.childHelper.setNestedScrollingEnabled(true);
        try {
            field = ScrollView.class.getDeclaredField("mScroller");
        }
        catch (Exception exception) {
            return;
        }
        this.scroller = field;
        ((AccessibleObject)field).setAccessible(true);
    }

    public DCWXScrollView(Context context, AttributeSet attributeSet) {
        DCWXScrollView dCWXScrollView = this;
        super(context, attributeSet);
        dCWXScrollView.consumed = new int[2];
        dCWXScrollView.offsetInWindow = new int[2];
        dCWXScrollView.mHasNotDoneActionDown = true;
        dCWXScrollView.mCheckTime = 100;
        dCWXScrollView.mStickyP = new int[2];
        dCWXScrollView.stickyScrollerP = new int[2];
        dCWXScrollView.stickyViewP = new int[2];
        dCWXScrollView.scrollable = true;
        dCWXScrollView.scroller = null;
        dCWXScrollView.isTouch = false;
        dCWXScrollView.isExecScrollerTask = false;
        dCWXScrollView.decelerationRate = 1.0f;
        dCWXScrollView.shouldBeTriggerUpper = true;
        dCWXScrollView.shouldBeTriggerLower = true;
        dCWXScrollView.upper = 50.0f;
        dCWXScrollView.lowwer = 50.0f;
        dCWXScrollView.init();
    }

    public DCWXScrollView(Context context, AttributeSet attributeSet, int n) {
        DCWXScrollView dCWXScrollView = this;
        super(context, attributeSet, n);
        dCWXScrollView.consumed = new int[2];
        dCWXScrollView.offsetInWindow = new int[2];
        dCWXScrollView.mHasNotDoneActionDown = true;
        dCWXScrollView.mCheckTime = 100;
        dCWXScrollView.mStickyP = new int[2];
        dCWXScrollView.stickyScrollerP = new int[2];
        dCWXScrollView.stickyViewP = new int[2];
        dCWXScrollView.scrollable = true;
        dCWXScrollView.scroller = null;
        dCWXScrollView.isTouch = false;
        dCWXScrollView.isExecScrollerTask = false;
        dCWXScrollView.decelerationRate = 1.0f;
        dCWXScrollView.shouldBeTriggerUpper = true;
        dCWXScrollView.shouldBeTriggerLower = true;
        dCWXScrollView.upper = 50.0f;
        dCWXScrollView.lowwer = 50.0f;
        dCWXScrollView.setOverScrollMode(2);
    }

    private void showStickyView() {
        DCWXScroller dCWXScroller = this.mWAScroller;
        if (dCWXScroller == null) {
            return;
        }
        if ((dCWXScroller = this.procSticky(dCWXScroller.getStickMap())) != null) {
            this.mCurrentStickyView = dCWXScroller;
            return;
        }
        this.mCurrentStickyView = null;
    }

    private View procSticky(Map<String, Map<String, WXComponent>> object) {
        if (object == null) {
            return null;
        }
        if ((object = object.get(this.mWAScroller.getRef())) == null) {
            return null;
        }
        object = object.entrySet().iterator();
        while (object.hasNext()) {
            DCWXScrollView dCWXScrollView = this;
            WXComponent wXComponent = (WXComponent)((Map.Entry)object.next()).getValue();
            dCWXScrollView.getLocationOnScreen(dCWXScrollView.stickyScrollerP);
            WXComponent wXComponent2 = wXComponent;
            wXComponent2.getHostView().getLocationOnScreen(this.stickyViewP);
            int n = 0;
            if (wXComponent2.getParent() != null && wXComponent.getParent().getRealView() != null) {
                n = wXComponent.getParent().getRealView().getHeight();
            }
            int n2 = n;
            n = wXComponent.getHostView().getHeight();
            int n3 = this.stickyScrollerP[1];
            int n4 = -n2 + n3 + n;
            int n5 = this.stickyViewP[1];
            if (n5 <= n3 && n5 >= n4 - n) {
                WXComponent wXComponent3 = wXComponent;
                this.mStickyOffset = n5 - n4;
                wXComponent3.setStickyOffset(n5 - n3);
                return wXComponent3.getHostView();
            }
            wXComponent.setStickyOffset(0);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void stopScroll() {
        AccessibleObject accessibleObject = this.scroller;
        if (accessibleObject == null || this.isTouch) return;
        try {
            accessibleObject = ((Field)accessibleObject).getType().getMethod("abortAnimation", null);
            if (accessibleObject == null) return;
        }
        catch (Exception exception) {}
        ((Method)accessibleObject).setAccessible(true);
        ((Method)accessibleObject).invoke(this.scroller.get(this), null);
        return;
    }

    public void startScrollerTask() {
        if (this.isExecScrollerTask) {
            return;
        }
        this.isExecScrollerTask = true;
        if (this.mScrollerTask == null) {
            this.mScrollerTask = new Handler(WXThread.secure(this));
        }
        DCWXScrollView dCWXScrollView = this;
        dCWXScrollView.mInitialPosition = dCWXScrollView.getScrollY();
        long l = this.mCheckTime;
        dCWXScrollView.mScrollerTask.sendEmptyMessageDelayed(0, l);
    }

    public void addScrollViewListener(WXScrollViewListener wXScrollViewListener) {
        if (!this.mScrollViewListeners.contains(wXScrollViewListener)) {
            this.mScrollViewListeners.add(wXScrollViewListener);
            return;
        }
    }

    public void removeScrollViewListener(WXScrollViewListener wXScrollViewListener) {
        this.mScrollViewListeners.remove(wXScrollViewListener);
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        if (!this.isScrollable()) {
            return false;
        }
        return super.onInterceptTouchEvent(motionEvent);
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        if (motionEvent.getAction() == 0) {
            this.mRedirectTouchToStickyView = true;
        }
        if (this.mRedirectTouchToStickyView) {
            boolean bl = this.mCurrentStickyView != null;
            this.mRedirectTouchToStickyView = bl;
            if (bl) {
                bl = motionEvent.getY() <= (float)this.mCurrentStickyView.getHeight() && motionEvent.getX() >= (float)this.mCurrentStickyView.getLeft() && motionEvent.getX() <= (float)this.mCurrentStickyView.getRight();
                this.mRedirectTouchToStickyView = bl;
            }
        }
        if (this.mRedirectTouchToStickyView) {
            if (this.mScrollRect == null) {
                Rect rect;
                Rect rect2 = rect;
                rect = new Rect();
                this.mScrollRect = rect2;
                this.getGlobalVisibleRect(rect2);
            }
            DCWXScrollView dCWXScrollView = this;
            dCWXScrollView.mCurrentStickyView.getLocationOnScreen(this.stickyViewP);
            motionEvent.offsetLocation(0.0f, (float)(dCWXScrollView.stickyViewP[1] - this.mScrollRect.top));
        }
        DCWXScrollView dCWXScrollView = this;
        boolean bl = super.dispatchTouchEvent(motionEvent);
        WXGesture wXGesture = dCWXScrollView.wxGesture;
        if (wXGesture != null) {
            return bl | wXGesture.onTouch((View)this, motionEvent);
        }
        return bl;
    }

    protected void dispatchDraw(Canvas canvas) {
        DCWXScrollView dCWXScrollView = this;
        super.dispatchDraw(canvas);
        if (dCWXScrollView.mCurrentStickyView != null) {
            DCWXScrollView dCWXScrollView2 = this;
            canvas.save();
            dCWXScrollView2.mCurrentStickyView.getLocationOnScreen(this.mStickyP);
            int n = dCWXScrollView2.mStickyOffset;
            if (n > 0) {
                n = 0;
            }
            DCWXScrollView dCWXScrollView3 = this;
            canvas.translate((float)this.mStickyP[0], (float)(this.getScrollY() + n));
            int n2 = dCWXScrollView3.mCurrentStickyView.getWidth();
            int n3 = dCWXScrollView3.mCurrentStickyView.getHeight();
            canvas.clipRect(0, n, n2, n3);
            this.mCurrentStickyView.draw(canvas);
            canvas.restore();
            return;
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (!this.scrollable) {
            return true;
        }
        int n = motionEvent.getAction();
        if (n != 0) {
            if (n == 1 || n == 3) {
                this.isTouch = false;
            }
        } else {
            this.isTouch = true;
        }
        if (this.mRedirectTouchToStickyView) {
            if (this.mScrollRect == null) {
                Rect rect;
                Rect rect2 = rect;
                rect = new Rect();
                this.mScrollRect = rect2;
                this.getGlobalVisibleRect(rect2);
            }
            this.mCurrentStickyView.getLocationOnScreen(this.stickyViewP);
            motionEvent.offsetLocation(0.0f, (float)(-(this.stickyViewP[1] - this.mScrollRect.top)));
        }
        if (motionEvent.getAction() == 0) {
            this.mHasNotDoneActionDown = false;
        }
        if (this.mHasNotDoneActionDown) {
            MotionEvent motionEvent2 = MotionEvent.obtain((MotionEvent)motionEvent);
            motionEvent2.setAction(0);
            this.mHasNotDoneActionDown = false;
            motionEvent2.recycle();
        }
        if (motionEvent.getAction() == 0) {
            MotionEvent motionEvent3 = motionEvent;
            this.ox = motionEvent3.getX();
            this.oy = motionEvent3.getY();
            this.startNestedScroll(3);
        }
        if (motionEvent.getAction() == 1 || motionEvent.getAction() == 3) {
            this.isExecScrollerTask = false;
            this.mHasNotDoneActionDown = true;
            this.stopNestedScroll();
        }
        if (motionEvent.getAction() == 2 && 19 >= Build.VERSION.SDK_INT) {
            int[] nArray;
            int[] nArray2;
            float f;
            int n2;
            MotionEvent motionEvent4 = motionEvent;
            float f2 = motionEvent4.getX();
            if (this.dispatchNestedPreScroll((int)(this.ox - f2), n2 = (int)(this.oy - (f = motionEvent4.getY())), nArray2 = this.consumed, nArray = this.offsetInWindow)) {
                motionEvent.setLocation(f2 += (float)this.consumed[0], f + (float)this.consumed[1]);
            }
            MotionEvent motionEvent5 = motionEvent;
            this.ox = motionEvent5.getX();
            this.oy = motionEvent5.getY();
        }
        return super.onTouchEvent(motionEvent);
    }

    public void setNestedScrollingEnabled(boolean bl) {
        this.childHelper.setNestedScrollingEnabled(bl);
    }

    public boolean isNestedScrollingEnabled() {
        return this.childHelper.isNestedScrollingEnabled();
    }

    public boolean startNestedScroll(int n) {
        return this.childHelper.startNestedScroll(n);
    }

    public void stopNestedScroll() {
        this.childHelper.stopNestedScroll();
    }

    public boolean hasNestedScrollingParent() {
        return this.childHelper.hasNestedScrollingParent();
    }

    public boolean isScrollable() {
        return this.scrollable;
    }

    public void setScrollable(boolean bl) {
        this.scrollable = bl;
    }

    public boolean dispatchNestedScroll(int n, int n2, int n3, int n4, int[] nArray) {
        return this.childHelper.dispatchNestedScroll(n, n2, n3, n4, nArray);
    }

    public boolean dispatchNestedPreScroll(int n, int n2, int[] nArray, int[] nArray2) {
        return this.childHelper.dispatchNestedPreScroll(n, n2, nArray, nArray2);
    }

    public boolean dispatchNestedFling(float f, float f2, boolean bl) {
        return this.childHelper.dispatchNestedFling(f, f2, bl);
    }

    public boolean dispatchNestedPreFling(float f, float f2) {
        return this.childHelper.dispatchNestedPreFling(f, f2);
    }

    public boolean onNestedPreFling(View view, float f, float f2) {
        return this.dispatchNestedPreFling(f, f2);
    }

    public boolean onNestedFling(View view, float f, float f2, boolean bl) {
        return this.dispatchNestedFling(f, f2, bl);
    }

    public void setRate(float f) {
        this.decelerationRate = f;
    }

    public void fling(int n) {
        DCWXScrollView dCWXScrollView = this;
        super.fling((int)((float)n * this.decelerationRate));
        Handler handler = dCWXScrollView.mScrollerTask;
        if (handler != null) {
            handler.removeMessages(0);
        }
        this.startScrollerTask();
    }

    protected void onScrollChanged(int n, int n2, int n3, int n4) {
        float f;
        float f2;
        int n5;
        AppEventForBlurManager.onScrollChanged((int)n, (int)n2);
        this.startScrollerTask();
        this.mScrollX = this.getScrollX();
        this.mScrollY = n5 = this.getScrollY();
        int n6 = this.mScrollX;
        DCWXScrollView dCWXScrollView = this;
        dCWXScrollView.onScroll(dCWXScrollView, n6, n5);
        View view = this.getChildAt(this.getChildCount() - 1);
        if (view == null) {
            return;
        }
        int n7 = this.mScrollY;
        float f3 = view.getBottom() - (this.getHeight() + n7);
        float f4 = this.lowwer;
        if (f2 <= f && !this.shouldBeTriggerLower) {
            this.shouldBeTriggerLower = true;
            this.onScrollToBottom(this.mScrollX, n7);
        } else if (f3 > f4) {
            this.shouldBeTriggerLower = false;
        }
        if ((float)this.getScrollY() <= this.upper && !this.shouldBeTriggerUpper) {
            this.shouldBeTriggerUpper = true;
            n7 = this.mScrollY;
            this.onScrollToTop(this.mScrollX, n7);
        } else if ((float)this.getScrollY() > this.upper) {
            this.shouldBeTriggerUpper = false;
        }
        List<WXScrollViewListener> list = this.mScrollViewListeners;
        int n8 = list == null ? 0 : list.size();
        for (int i = 0; i < n8; ++i) {
            int n9 = n3 - n;
            int n10 = n4 - n2;
            this.mScrollViewListeners.get(i).onScrollChanged(this, n, n2, n9, n10);
        }
        this.showStickyView();
    }

    public void setUpperLength(float f) {
        this.upper = f;
    }

    public void setLowwerLength(float f) {
        this.lowwer = f;
    }

    protected void onScroll(DCWXScrollView list, int n, int n2) {
        list = this.mScrollViewListeners;
        int n3 = list == null ? 0 : list.size();
        for (int i = 0; i < n3; ++i) {
            this.mScrollViewListeners.get(i).onScroll(this, n, n2);
        }
    }

    protected void onScrollToBottom(int n, int n2) {
        List<WXScrollViewListener> list = this.mScrollViewListeners;
        int n3 = list == null ? 0 : list.size();
        for (int i = 0; i < n3; ++i) {
            this.mScrollViewListeners.get(i).onScrollToBottom(this, n, n2);
        }
    }

    protected void onScrollToTop(int n, int n2) {
        List<WXScrollViewListener> list = this.mScrollViewListeners;
        int n3 = list == null ? 0 : list.size();
        for (int i = 0; i < n3; ++i) {
            this.mScrollViewListeners.get(i).onScrollToTop(this, n, n2);
        }
    }

    public boolean handleMessage(Message message) {
        if (message.what == 0) {
            message = this.mScrollerTask;
            if (message != null) {
                message.removeMessages(0);
            }
            DCWXScrollView dCWXScrollView = this;
            int n = dCWXScrollView.getScrollY();
            if (dCWXScrollView.mInitialPosition - n == 0) {
                DCWXScrollView dCWXScrollView2 = this;
                dCWXScrollView2.isExecScrollerTask = false;
                n = dCWXScrollView2.getScrollX();
                int n2 = dCWXScrollView2.getScrollY();
                dCWXScrollView2.onScrollStopped(this, n, n2);
            } else {
                DCWXScrollView dCWXScrollView3 = this;
                n = dCWXScrollView3.getScrollX();
                dCWXScrollView3.onScroll(dCWXScrollView3, n, dCWXScrollView3.getScrollY());
                dCWXScrollView3.mInitialPosition = dCWXScrollView3.getScrollY();
                Handler handler = dCWXScrollView3.mScrollerTask;
                if (handler != null) {
                    long l = this.mCheckTime;
                    handler.sendEmptyMessageDelayed(0, l);
                }
            }
        }
        return true;
    }

    protected void onScrollStopped(DCWXScrollView list, int n, int n2) {
        list = this.mScrollViewListeners;
        int n3 = list == null ? 0 : list.size();
        for (int i = 0; i < n3; ++i) {
            this.mScrollViewListeners.get(i).onScrollStopped(this, n, n2);
        }
    }

    @Override
    public void destroy() {
        DCWXScrollView dCWXScrollView = dCWXScrollView2;
        dCWXScrollView.mScrollViewListeners.clear();
        DCWXScrollView dCWXScrollView2 = dCWXScrollView.mScrollerTask;
        if (dCWXScrollView2 != null) {
            dCWXScrollView2.removeCallbacksAndMessages(null);
            return;
        }
    }

    @Override
    public void registerGestureListener(WXGesture wXGesture) {
        this.wxGesture = wXGesture;
    }

    @Override
    public WXGesture getGestureListener() {
        return this.wxGesture;
    }

    public Rect getContentFrame() {
        DCWXScrollView dCWXScrollView = this;
        int n = dCWXScrollView.computeHorizontalScrollRange();
        int n2 = dCWXScrollView.computeVerticalScrollRange();
        return new Rect(0, 0, n, n2);
    }

    public void setWAScroller(DCWXScroller dCWXScroller) {
        this.mWAScroller = dCWXScroller;
        this.upper = WXViewUtils.getRealPxByWidth(50.0f, dCWXScroller.getViewPortWidth());
        this.lowwer = WXViewUtils.getRealPxByWidth(50.0f, this.mWAScroller.getViewPortWidth());
    }

    public static interface WXScrollViewListener {
        public void onScrollChanged(DCWXScrollView var1, int var2, int var3, int var4, int var5);

        public void onScrollToBottom(DCWXScrollView var1, int var2, int var3);

        public void onScrollToTop(DCWXScrollView var1, int var2, int var3);

        public void onScrollStopped(DCWXScrollView var1, int var2, int var3);

        public void onScroll(DCWXScrollView var1, int var2, int var3);
    }
}

