/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.graphics.Color;
import android.graphics.LinearGradient;
import android.graphics.Shader;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import com.taobao.weex.utils.SingleFunctionParser;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;

public class WXResourceUtils {
    private static final Map<String, Integer> colorMap;
    private static final int RGB_SIZE = 3;
    private static final int RGBA_SIZE = 4;
    private static final int HEX = 16;
    private static final int COLOR_RANGE = 255;
    private static final String RGB = "rgb";
    private static final String RGBA = "rgba";
    private static final SingleFunctionParser.FlatMapper<Integer> FUNCTIONAL_RGB_MAPPER;
    private static final SingleFunctionParser.NonUniformMapper<Number> FUNCTIONAL_RGBA_MAPPER;

    public static int getColor(String string2) {
        return WXResourceUtils.getColor(string2, Integer.MIN_VALUE);
    }

    public static int getColor(String string2, int n) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return n;
        }
        ColorConvertHandler[] colorConvertHandlerArray = (ColorConvertHandler[])WXUtils.sCache.get((Object)(string2 = string2.trim()));
        if (colorConvertHandlerArray != null) {
            return colorConvertHandlerArray.intValue();
        }
        colorConvertHandlerArray = ColorConvertHandler.values();
        int n2 = colorConvertHandlerArray.length;
        for (int i = 0; i < n2; ++i) {
            Object object = colorConvertHandlerArray[i].handle(string2);
            if (!((Boolean)object.first).booleanValue()) continue;
            object = (Integer)object.second;
            n = object.intValue();
            try {
                WXUtils.sCache.put((Object)string2, object);
            }
            catch (RuntimeException runtimeException) {
                WXLogUtils.v("Color_Parser", WXLogUtils.getStackTrace(runtimeException));
            }
            break;
        }
        return n;
    }

    public static Shader getShader(String object, float f, float f2) {
        if ((object = WXResourceUtils.parseGradientValues((String)object)) != null && object.size() == 3) {
            float[] fArray = WXResourceUtils.parseGradientDirection((String)object.get(0), f, f2);
            Object object2 = object;
            float f3 = fArray[0];
            float f4 = fArray[1];
            f2 = fArray[2];
            float f5 = fArray[3];
            int n = WXResourceUtils.getColor((String)object2.get(1), -1);
            int n2 = WXResourceUtils.getColor((String)object2.get(2), -1);
            Shader.TileMode tileMode = Shader.TileMode.CLAMP;
            return new LinearGradient(f3, f4, f2, f5, n, n2, tileMode);
        }
        return null;
    }

    @NonNull
    private static List<String> parseGradientValues(String string2) {
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        String string3 = string2;
        string3.getClass();
        if (string3.startsWith("linear-gradient")) {
            ArrayList arrayList;
            StringTokenizer stringTokenizer;
            String string4 = string2;
            int n = string4.indexOf("(") + 1;
            Object object = string4.substring(n, string4.lastIndexOf(")"));
            StringTokenizer stringTokenizer2 = stringTokenizer;
            stringTokenizer = new StringTokenizer((String)object, ",");
            object = arrayList;
            arrayList = new ArrayList();
            String string5 = null;
            while (stringTokenizer2.hasMoreTokens()) {
                String string6 = stringTokenizer2.nextToken();
                if (string6.contains("(")) {
                    string5 = string6 + ",";
                    continue;
                }
                if (string6.contains(")")) {
                    object.add(string5 + string6);
                    string5 = null;
                    continue;
                }
                if (string5 != null) {
                    string5 = string5 + string6 + ",";
                    continue;
                }
                object.add(string6);
            }
            return object;
        }
        return null;
    }

    private static float[] parseGradientDirection(String string2, float f, float f2) {
        int n = 0;
        int n2 = 1;
        int n3 = 2;
        int n4 = 3;
        float[] fArray = new float[4];
        float[] fArray2 = fArray;
        fArray[0] = 0.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        fArray[3] = 0.0f;
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            string2 = string2.replaceAll("\\s*", "").toLowerCase(Locale.ENGLISH);
        }
        String string3 = string2;
        string3.getClass();
        int n5 = -1;
        switch (string3.hashCode()) {
            default: {
                break;
            }
            case 1176531318: {
                if (!string2.equals("tobottomright")) break;
                n5 = 5;
                break;
            }
            case 110550266: {
                if (!string2.equals("totop")) break;
                n5 = 4;
                break;
            }
            case -172068863: {
                if (!string2.equals("totopleft")) break;
                n5 = 3;
                break;
            }
            case -868157182: {
                if (!string2.equals("toleft")) break;
                n5 = 2;
                break;
            }
            case -1137407871: {
                if (!string2.equals("toright")) break;
                n5 = 1;
                break;
            }
            case -1352032154: {
                if (!string2.equals("tobottom")) break;
                n5 = 0;
            }
        }
        switch (n5) {
            default: {
                return fArray2;
            }
            case 5: {
                float[] fArray3 = fArray2;
                fArray3[n3] = f;
                fArray3[n4] = f2;
                return fArray2;
            }
            case 4: {
                fArray2[n2] = f2;
                return fArray2;
            }
            case 3: {
                float[] fArray4 = fArray2;
                fArray4[n] = f;
                fArray4[n2] = f2;
                return fArray2;
            }
            case 2: {
                fArray2[n] = f;
                return fArray2;
            }
            case 1: {
                fArray2[n3] = f;
                return fArray2;
            }
            case 0: 
        }
        fArray2[n4] = f2;
        return fArray2;
    }

    public static boolean isNamedColor(String string2) {
        return colorMap.containsKey(string2);
    }

    static {
        HashMap<String, Integer> hashMap;
        HashMap<String, Integer> hashMap2 = hashMap;
        hashMap = new HashMap<String, Integer>();
        colorMap = hashMap2;
        FUNCTIONAL_RGB_MAPPER = new SingleFunctionParser.FlatMapper<Integer>(){

            @Override
            public Integer map(String string2) {
                int n = WXUtils.parseUnitOrPercent(string2, 255);
                if (n < 0) {
                    n = 0;
                } else if (n > 255) {
                    n = 255;
                }
                return n;
            }
        };
        FUNCTIONAL_RGBA_MAPPER = new SingleFunctionParser.NonUniformMapper<Number>(){

            @Override
            public List<Number> map(List<String> list) {
                int n;
                ArrayList arrayList;
                ArrayList arrayList2 = arrayList;
                arrayList = new ArrayList(4);
                for (n = 0; n < 3; ++n) {
                    int n2 = WXUtils.parseUnitOrPercent(list.get(n), 255);
                    if (n2 < 0) {
                        n2 = 0;
                    } else if (n2 > 255) {
                        n2 = 255;
                    }
                    arrayList2.add(n2);
                }
                ArrayList arrayList3 = arrayList2;
                arrayList3.add(Float.valueOf(list.get(n)));
                return arrayList3;
            }
        };
        Integer n = -984833;
        hashMap2.put("aliceblue", n);
        n = -332841;
        hashMap2.put("antiquewhite", n);
        n = -16711681;
        hashMap2.put("aqua", n);
        n = -8388652;
        hashMap2.put("aquamarine", n);
        n = -983041;
        hashMap2.put("azure", n);
        n = -657956;
        hashMap2.put("beige", n);
        n = -6972;
        hashMap2.put("bisque", n);
        n = -16777216;
        hashMap2.put("black", n);
        n = -5171;
        hashMap2.put("blanchedalmond", n);
        n = -16776961;
        hashMap2.put("blue", n);
        n = -7722014;
        hashMap2.put("blueviolet", n);
        n = -5952982;
        hashMap2.put("brown", n);
        n = -2180985;
        hashMap2.put("burlywood", n);
        n = -10510688;
        hashMap2.put("cadetblue", n);
        n = -8388864;
        hashMap2.put("chartreuse", n);
        n = -2987746;
        hashMap2.put("chocolate", n);
        n = -32944;
        hashMap2.put("coral", n);
        n = -10185235;
        hashMap2.put("cornflowerblue", n);
        n = -1828;
        hashMap2.put("cornsilk", n);
        n = -2354116;
        hashMap2.put("crimson", n);
        n = -16711681;
        hashMap2.put("cyan", n);
        n = -16777077;
        hashMap2.put("darkblue", n);
        n = -16741493;
        hashMap2.put("darkcyan", n);
        n = -4684277;
        hashMap2.put("darkgoldenrod", n);
        n = -5658199;
        hashMap2.put("darkgray", n);
        n = -16751616;
        hashMap2.put("darkgreen", n);
        n = -4343957;
        hashMap2.put("darkkhaki", n);
        n = -7667573;
        hashMap2.put("darkmagenta", n);
        n = -11179217;
        hashMap2.put("darkolivegreen", n);
        n = -29696;
        hashMap2.put("darkorange", n);
        n = -6737204;
        hashMap2.put("darkorchid", n);
        n = -7667712;
        hashMap2.put("darkred", n);
        n = -1468806;
        hashMap2.put("darksalmon", n);
        n = -7357297;
        hashMap2.put("darkseagreen", n);
        n = -12042869;
        hashMap2.put("darkslateblue", n);
        n = -13676721;
        hashMap2.put("darkslategray", n);
        n = -13676721;
        hashMap2.put("darkslategrey", n);
        n = -16724271;
        hashMap2.put("darkturquoise", n);
        n = -7077677;
        hashMap2.put("darkviolet", n);
        n = -60269;
        hashMap2.put("deeppink", n);
        n = -16728065;
        hashMap2.put("deepskyblue", n);
        n = -9868951;
        hashMap2.put("dimgray", n);
        n = -9868951;
        hashMap2.put("dimgrey", n);
        n = -14774017;
        hashMap2.put("dodgerblue", n);
        n = -5103070;
        hashMap2.put("firebrick", n);
        n = -1296;
        hashMap2.put("floralwhite", n);
        n = -14513374;
        hashMap2.put("forestgreen", n);
        n = -65281;
        hashMap2.put("fuchsia", n);
        n = -2302756;
        hashMap2.put("gainsboro", n);
        n = -460545;
        hashMap2.put("ghostwhite", n);
        n = -10496;
        hashMap2.put("gold", n);
        n = -2448096;
        hashMap2.put("goldenrod", n);
        n = -8355712;
        hashMap2.put("gray", n);
        n = -8355712;
        hashMap2.put("grey", n);
        n = -16744448;
        hashMap2.put("green", n);
        n = -5374161;
        hashMap2.put("greenyellow", n);
        n = -983056;
        hashMap2.put("honeydew", n);
        n = -38476;
        hashMap2.put("hotpink", n);
        n = -3318692;
        hashMap2.put("indianred", n);
        n = -11861886;
        hashMap2.put("indigo", n);
        n = -16;
        hashMap2.put("ivory", n);
        n = -989556;
        hashMap2.put("khaki", n);
        n = -1644806;
        hashMap2.put("lavender", n);
        n = -3851;
        hashMap2.put("lavenderblush", n);
        n = -8586240;
        hashMap2.put("lawngreen", n);
        n = -1331;
        hashMap2.put("lemonchiffon", n);
        n = -5383962;
        hashMap2.put("lightblue", n);
        n = -1015680;
        hashMap2.put("lightcoral", n);
        n = -2031617;
        hashMap2.put("lightcyan", n);
        n = -329006;
        hashMap2.put("lightgoldenrodyellow", n);
        n = -2894893;
        hashMap2.put("lightgray", n);
        n = -2894893;
        hashMap2.put("lightgrey", n);
        n = -7278960;
        hashMap2.put("lightgreen", n);
        n = -18751;
        hashMap2.put("lightpink", n);
        n = -24454;
        hashMap2.put("lightsalmon", n);
        n = -14634326;
        hashMap2.put("lightseagreen", n);
        n = -7876870;
        hashMap2.put("lightskyblue", n);
        n = -8943463;
        hashMap2.put("lightslategray", n);
        n = -8943463;
        hashMap2.put("lightslategrey", n);
        n = -5192482;
        hashMap2.put("lightsteelblue", n);
        n = -32;
        hashMap2.put("lightyellow", n);
        n = -16711936;
        hashMap2.put("lime", n);
        n = -13447886;
        hashMap2.put("limegreen", n);
        n = -331546;
        hashMap2.put("linen", n);
        n = -65281;
        hashMap2.put("magenta", n);
        n = -8388608;
        hashMap2.put("maroon", n);
        n = -10039894;
        hashMap2.put("mediumaquamarine", n);
        n = -16777011;
        hashMap2.put("mediumblue", n);
        n = -4565549;
        hashMap2.put("mediumorchid", n);
        n = -7114533;
        hashMap2.put("mediumpurple", n);
        n = -12799119;
        hashMap2.put("mediumseagreen", n);
        n = -8689426;
        hashMap2.put("mediumslateblue", n);
        n = -16713062;
        hashMap2.put("mediumspringgreen", n);
        n = -12004916;
        hashMap2.put("mediumturquoise", n);
        n = -3730043;
        hashMap2.put("mediumvioletred", n);
        n = -15132304;
        hashMap2.put("midnightblue", n);
        n = -655366;
        hashMap2.put("mintcream", n);
        n = -6943;
        hashMap2.put("mistyrose", n);
        n = -6987;
        hashMap2.put("moccasin", n);
        n = -8531;
        hashMap2.put("navajowhite", n);
        n = -16777088;
        hashMap2.put("navy", n);
        n = -133658;
        hashMap2.put("oldlace", n);
        n = -8355840;
        hashMap2.put("olive", n);
        n = -9728477;
        hashMap2.put("olivedrab", n);
        n = -23296;
        hashMap2.put("orange", n);
        n = -47872;
        hashMap2.put("orangered", n);
        n = -2461482;
        hashMap2.put("orchid", n);
        n = -1120086;
        hashMap2.put("palegoldenrod", n);
        n = -6751336;
        hashMap2.put("palegreen", n);
        n = -5247250;
        hashMap2.put("paleturquoise", n);
        n = -2396013;
        hashMap2.put("palevioletred", n);
        n = -4139;
        hashMap2.put("papayawhip", n);
        n = -9543;
        hashMap2.put("peachpuff", n);
        n = -3308225;
        hashMap2.put("peru", n);
        n = -16181;
        hashMap2.put("pink", n);
        n = -2252579;
        hashMap2.put("plum", n);
        n = -5185306;
        hashMap2.put("powderblue", n);
        n = -8388480;
        hashMap2.put("purple", n);
        n = -10079335;
        hashMap2.put("rebeccapurple", n);
        n = -65536;
        hashMap2.put("red", n);
        n = -4419697;
        hashMap2.put("rosybrown", n);
        n = -12490271;
        hashMap2.put("royalblue", n);
        n = -7650029;
        hashMap2.put("saddlebrown", n);
        n = -360334;
        hashMap2.put("salmon", n);
        n = -744352;
        hashMap2.put("sandybrown", n);
        n = -13726889;
        hashMap2.put("seagreen", n);
        n = -2578;
        hashMap2.put("seashell", n);
        n = -6270419;
        hashMap2.put("sienna", n);
        n = -4144960;
        hashMap2.put("silver", n);
        n = -7876885;
        hashMap2.put("skyblue", n);
        n = -9807155;
        hashMap2.put("slateblue", n);
        n = -9404272;
        hashMap2.put("slategray", n);
        n = -9404272;
        hashMap2.put("slategrey", n);
        n = -1286;
        hashMap2.put("snow", n);
        n = -16711809;
        hashMap2.put("springgreen", n);
        n = -12156236;
        hashMap2.put("steelblue", n);
        n = -2968436;
        hashMap2.put("tan", n);
        n = -16744320;
        hashMap2.put("teal", n);
        n = -2572328;
        hashMap2.put("thistle", n);
        n = -40121;
        hashMap2.put("tomato", n);
        n = -12525360;
        hashMap2.put("turquoise", n);
        n = -1146130;
        hashMap2.put("violet", n);
        n = -663885;
        hashMap2.put("wheat", n);
        n = -1;
        hashMap2.put("white", n);
        n = -657931;
        hashMap2.put("whitesmoke", n);
        n = -256;
        hashMap2.put("yellow", n);
        n = -6632142;
        hashMap2.put("yellowgreen", n);
        n = 0;
        hashMap2.put("transparent", n);
    }

    static enum ColorConvertHandler {
        NAMED_COLOR_HANDLER{

            @Override
            @NonNull
            Pair<Boolean, Integer> handle(String string2) {
                if (colorMap.containsKey(string2)) {
                    return new Pair((Object)Boolean.TRUE, (Object)((Integer)colorMap.get(string2)));
                }
                return new Pair((Object)Boolean.FALSE, (Object)0);
            }
        }
        ,
        RGB_HANDLER{

            @Override
            @NonNull
            Pair<Boolean, Integer> handle(String string2) {
                if (string2.length() == 4) {
                    String string3 = string2;
                    int n = Integer.parseInt(string3.substring(1, 2), 16);
                    int n2 = Integer.parseInt(string3.substring(2, 3), 16);
                    int n3 = Integer.parseInt(string3.substring(3, 4), 16);
                    int n4 = n;
                    Boolean bl = Boolean.TRUE;
                    int n5 = n3;
                    int n6 = n2;
                    n2 = n6 + (n6 << 4);
                    return new Pair((Object)bl, (Object)Color.rgb((int)(n4 + (n4 << 4)), (int)n2, (int)(n5 + (n5 << 4))));
                }
                if (string2.length() != 7 && string2.length() != 9) {
                    return new Pair((Object)Boolean.FALSE, (Object)0);
                }
                return new Pair((Object)Boolean.TRUE, (Object)Color.parseColor((String)string2));
            }
        }
        ,
        FUNCTIONAL_RGB_HANDLER{

            @Override
            @NonNull
            Pair<Boolean, Integer> handle(String object) {
                List list = new SingleFunctionParser((String)object, FUNCTIONAL_RGB_MAPPER).parse(WXResourceUtils.RGB);
                if (list != null && list.size() == 3) {
                    object = Boolean.TRUE;
                    List list2 = list;
                    int n = (Integer)list2.get(1);
                    return new Pair(object, (Object)Color.rgb((int)((Integer)list.get(0)), (int)n, (int)((Integer)list2.get(2))));
                }
                return new Pair((Object)Boolean.FALSE, (Object)0);
            }
        }
        ,
        FUNCTIONAL_RGBA_HANDLER{

            @Override
            @NonNull
            Pair<Boolean, Integer> handle(String object) {
                List list = new SingleFunctionParser((String)object, FUNCTIONAL_RGBA_MAPPER).parse(WXResourceUtils.RGBA);
                if (list.size() == 4) {
                    object = Boolean.TRUE;
                    List list2 = list;
                    int n = ((Number)list2.get(0)).intValue();
                    int n2 = ((Number)list2.get(1)).intValue();
                    int n3 = ((Number)list2.get(2)).intValue();
                    return new Pair(object, (Object)Color.argb((int)ColorConvertHandler.parseAlpha(((Number)list.get(3)).floatValue()), (int)n, (int)n2, (int)n3));
                }
                return new Pair((Object)Boolean.FALSE, (Object)0);
            }
        };


        private static int parseAlpha(float f) {
            return (int)(f * 255.0f);
        }

        @NonNull
        abstract Pair<Boolean, Integer> handle(String var1);
    }
}

