/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.pdf417.decoder;

import com.dcloud.zxing2.pdf417.decoder.BoundingBox;
import com.dcloud.zxing2.pdf417.decoder.Codeword;
import java.util.Formatter;

class DetectionResultColumn {
    private static final int MAX_NEARBY_DISTANCE = 5;
    private final BoundingBox boundingBox;
    private final Codeword[] codewords;

    DetectionResultColumn(BoundingBox boundingBox) {
        this.boundingBox = new BoundingBox(boundingBox);
        this.codewords = new Codeword[boundingBox.getMaxY() - boundingBox.getMinY() + 1];
    }

    final Codeword getCodewordNearby(int n5) {
        Codeword codeword = this.getCodeword(n5);
        if (codeword != null) {
            return codeword;
        }
        for (int i5 = 1; i5 < 5; ++i5) {
            Codeword codeword2;
            Codeword codeword3;
            int n6 = this.imageRowToCodewordIndex(n5) - i5;
            if (n6 >= 0 && (codeword3 = this.codewords[n6]) != null) {
                return codeword3;
            }
            n6 = this.imageRowToCodewordIndex(n5) + i5;
            Codeword[] codewordArray = this.codewords;
            if (n6 >= this.codewords.length || (codeword2 = codewordArray[n6]) == null) continue;
            return codeword2;
        }
        return null;
    }

    final int imageRowToCodewordIndex(int n5) {
        return n5 - this.boundingBox.getMinY();
    }

    final void setCodeword(int n5, Codeword codeword) {
        this.codewords[this.imageRowToCodewordIndex((int)n5)] = codeword;
    }

    final Codeword getCodeword(int n5) {
        return this.codewords[this.imageRowToCodewordIndex(n5)];
    }

    final BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    final Codeword[] getCodewords() {
        return this.codewords;
    }

    public String toString() {
        Formatter formatter;
        DetectionResultColumn detectionResultColumn = formatter2;
        Formatter formatter2 = formatter;
        formatter = new Formatter();
        int n5 = 0;
        Codeword[] codewordArray = detectionResultColumn.codewords;
        int n6 = detectionResultColumn.codewords.length;
        for (int i5 = 0; i5 < n6; ++i5) {
            Object[] objectArray;
            Object object = codewordArray[i5];
            if (object == null) {
                object = n5++;
                Object[] objectArray2 = new Object[1];
                objectArray = objectArray2;
                objectArray2[0] = object;
                formatter2.format("%3d:    |   %n", objectArray);
                continue;
            }
            Codeword codeword = object;
            object = n5++;
            objectArray = codeword.getRowNumber();
            Integer n7 = codeword.getValue();
            Object[] objectArray3 = new Object[3];
            Object[] objectArray4 = objectArray3;
            objectArray3[0] = object;
            objectArray3[1] = objectArray;
            objectArray3[2] = n7;
            formatter2.format("%3d: %3d|%3d%n", objectArray4);
        }
        String string2 = formatter2.toString();
        formatter2.close();
        return string2;
    }
}

