/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.gesture;

import android.content.Context;
import android.graphics.Point;
import android.graphics.PointF;
import android.graphics.Rect;
import android.os.Handler;
import android.os.Looper;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.NonNull;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.bridge.EventResult;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.basic.WXBasicComponent;
import com.taobao.weex.ui.view.gesture.WXGestureType;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class WXGesture
extends GestureDetector.SimpleOnGestureListener
implements View.OnTouchListener {
    private static final String TAG = "Gesture";
    private static final int CUR_EVENT = -1;
    public static final String START = "start";
    public static final String MOVE = "move";
    public static final String END = "end";
    public static final String UNKNOWN = "unknown";
    public static final String LEFT = "left";
    public static final String RIGHT = "right";
    public static final String UP = "up";
    public static final String DOWN = "down";
    private WXComponent component;
    private GestureDetector mGestureDetector;
    private Rect globalRect;
    private Point globalOffset;
    private Point globalEventOffset;
    private PointF locEventOffset;
    private PointF locLeftTop;
    private long swipeDownTime = -1L;
    private long panDownTime = -1L;
    private WXGestureType mPendingPan = null;
    private int mParentOrientation = -1;
    private boolean mIsPreventMoveEvent = false;
    private boolean mIsTouchEventConsumed = false;
    private boolean requestDisallowInterceptTouchEvent = false;
    private boolean shouldBubbleResult = true;
    private int shouldBubbleInterval = 0;
    private int shouldBubbleCallRemainTimes = 0;
    private final List<View.OnTouchListener> mTouchListeners;

    public WXGesture(WXComponent wXComponent, Context object) {
        GestureHandler gestureHandler;
        GestureDetector gestureDetector;
        PointF pointF;
        PointF pointF2;
        Point point;
        Point point2;
        Rect rect;
        Rect rect2;
        Rect rect3 = rect2;
        rect2 = new LinkedList();
        this.mTouchListeners = rect3;
        this.component = wXComponent;
        rect3 = rect;
        rect = new Rect();
        this.globalRect = rect3;
        rect3 = point2;
        point2 = new Point();
        this.globalOffset = rect3;
        rect3 = point;
        point = new Point();
        this.globalEventOffset = rect3;
        rect3 = pointF2;
        pointF2 = new PointF();
        this.locEventOffset = rect3;
        rect3 = pointF;
        pointF = new PointF();
        this.locLeftTop = rect3;
        rect3 = gestureDetector;
        GestureHandler gestureHandler2 = gestureHandler;
        gestureHandler = new GestureHandler();
        gestureDetector = new GestureDetector((Context)object, (GestureDetector.OnGestureListener)this, (Handler)gestureHandler2);
        this.mGestureDetector = rect3;
        object = wXComponent.getParentScroller();
        if (object != null) {
            this.mParentOrientation = object.getOrientation();
        }
        WXComponent wXComponent2 = wXComponent;
        this.shouldBubbleResult = WXUtils.getBoolean(wXComponent2.getAttrs().get("shouldStopPropagationInitResult"), Boolean.TRUE);
        this.shouldBubbleInterval = WXUtils.getNumberInt(wXComponent2.getAttrs().get("shouldStopPropagationInterval"), 0);
    }

    private boolean isParentScrollable() {
        Object object = ((WXGesture)((Object)object)).component;
        if (object == null) {
            return true;
        }
        return (object = ((WXComponent)object).getParentScroller()) == null || object.isScrollable();
        {
        }
    }

    private boolean hasSameOrientationWithParent() {
        return this.mParentOrientation == 0 && this.component.containsGesture(WXGestureType.HighLevelGesture.HORIZONTALPAN) || this.mParentOrientation == 1 && this.component.containsGesture(WXGestureType.HighLevelGesture.VERTICALPAN);
    }

    public static boolean isStopPropagation(String string2) {
        return "stopPropagation".equals(string2) || "stoppropagation".equals(string2);
        {
        }
    }

    public static boolean hasStopPropagation(WXComponent object) {
        if ((object = ((WXBasicComponent)object).getEvents()) == null) {
            return false;
        }
        int n = ((AbstractCollection)object).size();
        for (int i = 0; i < n && i < ((AbstractCollection)object).size(); ++i) {
            if (!WXGesture.isStopPropagation((String)((AbstractList)object).get(i))) continue;
            return true;
        }
        return false;
    }

    private boolean shouldBubbleTouchEvent(MotionEvent object) {
        if (WXGesture.hasStopPropagation(this.component)) {
            int n;
            if (this.shouldBubbleInterval > 0 && (n = this.shouldBubbleCallRemainTimes) > 0) {
                this.shouldBubbleCallRemainTimes = n - 1;
                return this.shouldBubbleResult;
            }
            Map<String, Object> map = this.createFireEventParam((MotionEvent)object, -1, null);
            map.put("type", "touch");
            if (object.getAction() == 0) {
                map.put("action", START);
            } else if (object.getAction() != 3 && object.getAction() != 1) {
                map.put("action", MOVE);
            } else {
                map.put("action", END);
            }
            object = "stopPropagation";
            if (!((AbstractCollection)this.component.getEvents()).contains("stopPropagation")) {
                object = "stoppropagation";
            }
            if (((EventResult)(object = this.component.fireEventWait((String)object, map))).isSuccess() && ((EventResult)object).getResult() != null) {
                this.shouldBubbleResult = WXUtils.getBoolean(((EventResult)object).getResult(), this.shouldBubbleResult ^ true) ^ true;
            }
            WXGesture wXGesture = this;
            wXGesture.shouldBubbleCallRemainTimes = wXGesture.shouldBubbleInterval;
            return wXGesture.shouldBubbleResult;
        }
        return true;
    }

    private String getPanEventAction(MotionEvent motionEvent) {
        switch (motionEvent.getAction()) {
            default: {
                return UNKNOWN;
            }
            case 3: {
                return END;
            }
            case 2: {
                return MOVE;
            }
            case 1: {
                return END;
            }
            case 0: 
        }
        return START;
    }

    private void finishDisallowInterceptTouchEvent(View view) {
        if (view.getParent() != null) {
            view.getParent().requestDisallowInterceptTouchEvent(false);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private boolean handlePanMotionEvent(MotionEvent motionEvent) {
        WXGestureType wXGestureType = this.mPendingPan;
        if (wXGestureType == null) {
            return false;
        }
        Object object2 = null;
        if (wXGestureType == WXGestureType.HighLevelGesture.HORIZONTALPAN || wXGestureType == WXGestureType.HighLevelGesture.VERTICALPAN) {
            String string2 = this.getPanEventAction(motionEvent);
        }
        if (this.component.containsGesture(this.mPendingPan)) {
            void var3_5;
            if (this.mIsPreventMoveEvent && MOVE.equals(var3_5)) {
                return true;
            }
            for (Map map : this.createMultipleFireEventParam(motionEvent, (String)var3_5)) {
                this.component.fireEvent(this.mPendingPan.toString(), map);
            }
            if (motionEvent.getAction() == 1 || motionEvent.getAction() == 3) {
                this.mPendingPan = null;
            }
            return true;
        }
        return false;
    }

    private boolean handleMotionEvent(WXGestureType wXGestureType, MotionEvent object) {
        if (this.component.getHover() != null) {
            this.component.getHover().handleMotionEvent(wXGestureType, (MotionEvent)object);
        }
        if (this.component.containsGesture(wXGestureType)) {
            for (Map map : this.createMultipleFireEventParam((MotionEvent)object, null)) {
                this.component.fireEvent(wXGestureType.toString(), map);
            }
            return true;
        }
        return false;
    }

    private List<Map<String, Object>> createMultipleFireEventParam(MotionEvent motionEvent, String string2) {
        ArrayList<Map<String, Object>> arrayList;
        ArrayList<Map<String, Object>> arrayList2 = arrayList;
        arrayList2(motionEvent.getHistorySize() + 1);
        arrayList.add(this.createFireEventParam(motionEvent, -1, string2));
        return arrayList;
    }

    private List<Map<String, Object>> getHistoricalEvents(MotionEvent motionEvent) {
        ArrayList<Map<String, Object>> arrayList;
        ArrayList<Map<String, Object>> arrayList2 = arrayList;
        arrayList = new ArrayList<Map<String, Object>>(motionEvent.getHistorySize());
        if (motionEvent.getActionMasked() == 2) {
            for (int i = 0; i < motionEvent.getHistorySize(); ++i) {
                arrayList2.add(this.createFireEventParam(motionEvent, i, null));
            }
        }
        return arrayList2;
    }

    private Map<String, Object> createFireEventParam(MotionEvent motionEvent, int n, String string2) {
        HashMap<String, JSONArray> hashMap;
        JSONArray jSONArray;
        JSONArray jSONArray2 = jSONArray;
        jSONArray = new JSONArray(motionEvent.getPointerCount());
        if (motionEvent.getActionMasked() == 2) {
            for (int i = 0; i < motionEvent.getPointerCount(); ++i) {
                jSONArray2.add((Object)((WXGesture)((Object)hashMap2)).createJSONObject(motionEvent, n, i));
            }
        } else if (((WXGesture)((Object)hashMap2)).isPointerNumChanged(motionEvent)) {
            MotionEvent motionEvent2 = motionEvent;
            jSONArray2.add((Object)((WXGesture)((Object)hashMap2)).createJSONObject(motionEvent2, -1, motionEvent2.getActionIndex()));
        }
        HashMap<String, JSONArray> hashMap2 = hashMap;
        new HashMap<String, JSONArray>().put("changedTouches", jSONArray2);
        if (string2 != null) {
            HashMap<String, JSONArray> hashMap3 = hashMap2;
            hashMap3.put("state", (JSONArray)string2);
            return hashMap3;
        }
        return hashMap2;
    }

    private boolean isPointerNumChanged(MotionEvent motionEvent) {
        return motionEvent.getActionMasked() == 0 || motionEvent.getActionMasked() == 5 || motionEvent.getActionMasked() == 1 || motionEvent.getActionMasked() == 6 || motionEvent.getActionMasked() == 3;
        {
        }
    }

    private boolean containsSimplePan() {
        return this.component.containsGesture(WXGestureType.HighLevelGesture.PAN_START) || this.component.containsGesture(WXGestureType.HighLevelGesture.PAN_MOVE) || this.component.containsGesture(WXGestureType.HighLevelGesture.PAN_END);
        {
        }
    }

    private JSONObject createJSONObject(MotionEvent motionEvent, int n, int n2) {
        float f;
        PointF pointF;
        PointF pointF2;
        if (n == -1) {
            WXGesture wXGesture = wXGesture;
            pointF2 = wXGesture.getEventLocInPageCoordinate(motionEvent, n2);
            pointF = wXGesture.getEventLocInScreenCoordinate(motionEvent, n2);
        } else {
            WXGesture wXGesture = wXGesture;
            pointF = wXGesture.getEventLocInPageCoordinate(motionEvent, n2, n);
            PointF pointF3 = pointF2 = wXGesture.getEventLocInScreenCoordinate(motionEvent, n2, n);
            pointF2 = pointF;
            pointF = pointF3;
        }
        WXGesture wXGesture = wXGesture.createJSONObject(pointF, pointF2, (float)motionEvent.getPointerId(n2));
        float f2 = motionEvent.getPressure();
        if (f > 0.0f && f2 < 1.0f) {
            WXGesture wXGesture2 = wXGesture;
            wXGesture2.put("force", Float.valueOf(motionEvent.getPressure()));
            return wXGesture2;
        }
        return wXGesture;
    }

    @NonNull
    private JSONObject createJSONObject(PointF pointF, PointF pointF2, float f) {
        JSONObject jSONObject;
        WXGesture wXGesture = jSONObject;
        wXGesture();
        wXGesture.put("pageX", Float.valueOf(pointF2.x));
        wXGesture.put("pageY", Float.valueOf(pointF2.y));
        wXGesture.put("screenX", Float.valueOf(pointF.x));
        wXGesture.put("screenY", Float.valueOf(pointF.y));
        jSONObject.put("identifier", (Object)Float.valueOf(f));
        return jSONObject;
    }

    private PointF getEventLocInScreenCoordinate(MotionEvent motionEvent, int n) {
        return this.getEventLocInScreenCoordinate(motionEvent, n, -1);
    }

    private PointF getEventLocInScreenCoordinate(MotionEvent motionEvent, int n, int n2) {
        float f;
        float f2;
        if (n2 == -1) {
            MotionEvent motionEvent2 = motionEvent;
            f2 = motionEvent2.getX(n);
            f = motionEvent2.getY(n);
        } else {
            MotionEvent motionEvent3 = motionEvent;
            f2 = motionEvent3.getHistoricalX(n, n2);
            f = motionEvent3.getHistoricalY(n, n2);
        }
        return this.getEventLocInScreenCoordinate(f2, f);
    }

    @NonNull
    private PointF getEventLocInScreenCoordinate(float f, float f2) {
        WXGesture wXGesture = this;
        wXGesture.globalRect.set(0, 0, 0, 0);
        wXGesture.globalOffset.set(0, 0);
        int n = (int)f;
        wXGesture.globalEventOffset.set(n, (int)f2);
        WXGesture wXGesture2 = this;
        Rect rect = wXGesture2.globalRect;
        wXGesture.component.getRealView().getGlobalVisibleRect(rect, wXGesture2.globalOffset);
        Point point = this.globalOffset;
        int n2 = point.x;
        wXGesture.globalEventOffset.offset(n2, point.y);
        return new PointF(WXViewUtils.getWebPxByWidth((float)this.globalEventOffset.x, this.component.getInstance().getInstanceViewPortWidthWithFloat()), WXViewUtils.getWebPxByWidth((float)this.globalEventOffset.y, this.component.getInstance().getInstanceViewPortWidthWithFloat()));
    }

    private PointF getEventLocInPageCoordinate(MotionEvent motionEvent, int n) {
        return this.getEventLocInPageCoordinate(motionEvent, n, -1);
    }

    private PointF getEventLocInPageCoordinate(MotionEvent motionEvent, int n, int n2) {
        float f;
        float f2;
        if (n2 == -1) {
            MotionEvent motionEvent2 = motionEvent;
            f2 = motionEvent2.getX(n);
            f = motionEvent2.getY(n);
        } else {
            MotionEvent motionEvent3 = motionEvent;
            f2 = motionEvent3.getHistoricalX(n, n2);
            f = motionEvent3.getHistoricalY(n, n2);
        }
        return this.getEventLocInPageCoordinate(f2, f);
    }

    @NonNull
    private PointF getEventLocInPageCoordinate(float f, float f2) {
        WXGesture wXGesture = this;
        wXGesture.locEventOffset.set(f, f2);
        wXGesture.locLeftTop.set(0.0f, 0.0f);
        wXGesture.component.computeVisiblePointInViewCoordinate(this.locLeftTop);
        PointF pointF = this.locLeftTop;
        f = pointF.x;
        wXGesture.locEventOffset.offset(f, pointF.y);
        return new PointF(WXViewUtils.getWebPxByWidth(this.locEventOffset.x, this.component.getInstance().getInstanceViewPortWidthWithFloat()), WXViewUtils.getWebPxByWidth(this.locEventOffset.y, this.component.getInstance().getInstanceViewPortWidthWithFloat()));
    }

    public void setPreventMoveEvent(boolean bl) {
        this.mIsPreventMoveEvent = bl;
    }

    public boolean isTouchEventConsumedByAdvancedGesture() {
        return this.mIsTouchEventConsumed;
    }

    public void addOnTouchListener(View.OnTouchListener onTouchListener) {
        if (onTouchListener != null) {
            this.mTouchListeners.add(onTouchListener);
            return;
        }
    }

    public boolean removeTouchListener(View.OnTouchListener onTouchListener) {
        if (onTouchListener != null) {
            return this.mTouchListeners.remove(onTouchListener);
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    public boolean onTouch(View var1_2, MotionEvent var2_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [6 : 91->95)] java.lang.Exception
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void onLongPress(MotionEvent object) {
        Object object2 = WXGestureType.HighLevelGesture.LONG_PRESS;
        if (object3.component.containsGesture((WXGestureType)object2)) {
            WXGesture wXGesture = object3;
            object = wXGesture.createMultipleFireEventParam((MotionEvent)object, null);
            MotionEvent motionEvent = object;
            Object object3 = object3.component.getRef();
            object = ((WXGestureType.HighLevelGesture)object2).toString();
            object2 = (Map)motionEvent.get(motionEvent.size() - 1);
            wXGesture.component.getInstance().fireEvent((String)object3, (String)object, (Map<String, Object>)object2);
            wXGesture.mIsTouchEventConsumed = true;
            return;
        }
    }

    public boolean onScroll(MotionEvent object, MotionEvent object2, float f, float f2) {
        boolean bl = false;
        if (object != null && object2 != null) {
            WXGestureType.HighLevelGesture highLevelGesture = Math.abs(object2.getX() - object.getX()) > Math.abs(object2.getY() - object.getY()) ? WXGestureType.HighLevelGesture.HORIZONTALPAN : WXGestureType.HighLevelGesture.VERTICALPAN;
            WXGestureType wXGestureType = this.mPendingPan;
            if (wXGestureType != WXGestureType.HighLevelGesture.HORIZONTALPAN && wXGestureType != WXGestureType.HighLevelGesture.VERTICALPAN) {
                if (this.component.containsGesture(highLevelGesture)) {
                    object = this.component.getRealView().getParent();
                    if (object != null) {
                        object.requestDisallowInterceptTouchEvent(true);
                    }
                    if ((object = this.mPendingPan) != null) {
                        this.handleMotionEvent((WXGestureType)object, (MotionEvent)object2);
                    }
                    this.mPendingPan = highLevelGesture;
                    this.component.fireEvent(((Object)highLevelGesture).toString(), this.createFireEventParam((MotionEvent)object2, -1, START));
                    bl = true;
                } else if (this.containsSimplePan()) {
                    if (this.panDownTime != object.getEventTime()) {
                        long l;
                        this.panDownTime = l = object.getEventTime();
                        this.mPendingPan = WXGestureType.HighLevelGesture.PAN_END;
                        this.component.fireEvent(WXGestureType.HighLevelGesture.PAN_START.toString(), this.createFireEventParam((MotionEvent)object, -1, null));
                    } else {
                        this.component.fireEvent(WXGestureType.HighLevelGesture.PAN_MOVE.toString(), this.createFireEventParam((MotionEvent)object2, -1, null));
                    }
                    bl = true;
                } else {
                    highLevelGesture = WXGestureType.HighLevelGesture.SWIPE;
                    if (this.component.containsGesture(highLevelGesture) && this.swipeDownTime != object.getEventTime()) {
                        long l;
                        this.swipeDownTime = l = object.getEventTime();
                        List<Map<String, Object>> list = this.createMultipleFireEventParam((MotionEvent)object2, null);
                        object = list.get(list.size() - 1);
                        if (Math.abs(f) > Math.abs(f2)) {
                            object2 = "direction";
                            String string2 = f > 0.0f ? LEFT : RIGHT;
                            object.put(object2, string2);
                        } else {
                            object2 = "direction";
                            String string3 = f2 > 0.0f ? UP : DOWN;
                            object.put(object2, string3);
                        }
                        object2 = this.component.getRef();
                        this.component.getInstance().fireEvent((String)object2, highLevelGesture.toString(), (Map<String, Object>)object);
                        bl = true;
                    }
                }
            } else {
                bl = this.handlePanMotionEvent((MotionEvent)object2);
            }
            boolean bl2 = this.mIsTouchEventConsumed || bl;
            this.mIsTouchEventConsumed = bl2;
            return bl;
        }
        return false;
    }

    public boolean onDown(MotionEvent motionEvent) {
        return true;
    }

    public boolean isRequestDisallowInterceptTouchEvent() {
        return this.requestDisallowInterceptTouchEvent;
    }

    public void setRequestDisallowInterceptTouchEvent(boolean bl) {
        this.requestDisallowInterceptTouchEvent = bl;
    }

    private static class GestureHandler
    extends Handler {
        public GestureHandler() {
            super(Looper.getMainLooper());
        }
    }
}

