/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.universalchardet.prober.statemachine;

public class PkgInt {
    public static final int INDEX_SHIFT_4BITS = 3;
    public static final int INDEX_SHIFT_8BITS = 2;
    public static final int INDEX_SHIFT_16BITS = 1;
    public static final int SHIFT_MASK_4BITS = 7;
    public static final int SHIFT_MASK_8BITS = 3;
    public static final int SHIFT_MASK_16BITS = 1;
    public static final int BIT_SHIFT_4BITS = 2;
    public static final int BIT_SHIFT_8BITS = 3;
    public static final int BIT_SHIFT_16BITS = 4;
    public static final int UNIT_MASK_4BITS = 15;
    public static final int UNIT_MASK_8BITS = 255;
    public static final int UNIT_MASK_16BITS = 65535;
    private int indexShift;
    private int shiftMask;
    private int bitShift;
    private int unitMask;
    private int[] data;

    public PkgInt(int n5, int n6, int n7, int n8, int[] nArray) {
        this.indexShift = n5;
        this.shiftMask = n6;
        this.bitShift = n7;
        this.unitMask = n8;
        this.data = (int[])nArray.clone();
    }

    public static int pack16bits(int n5, int n6) {
        return n6 << 16 | n5;
    }

    public static int pack8bits(int n5, int n6, int n7, int n8) {
        return PkgInt.pack16bits(n6 << 8 | n5, n8 << 8 | n7);
    }

    public static int pack4bits(int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12) {
        int n13 = n6 << 4 | n5;
        n5 = n8 << 4 | n7;
        n6 = n10 << 4 | n9;
        n7 = n12 << 4 | n11;
        return PkgInt.pack8bits(n13, n5, n6, n7);
    }

    public int unpack(int n5) {
        return this.data[n5 >> this.indexShift] >> ((n5 & this.shiftMask) << this.bitShift) & this.unitMask;
    }
}

