/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view;

import android.content.Context;
import android.graphics.Canvas;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.Nullable;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.common.WXErrorCode;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXDiv;
import com.taobao.weex.ui.view.BaseFrameLayout;
import com.taobao.weex.ui.view.IRenderResult;
import com.taobao.weex.ui.view.IRenderStatus;
import com.taobao.weex.ui.view.gesture.WXGesture;
import com.taobao.weex.ui.view.gesture.WXGestureObservable;
import com.taobao.weex.utils.WXExceptionUtils;
import com.taobao.weex.utils.WXLogUtils;
import io.dcloud.common.adapter.util.PlatformUtil;
import java.lang.ref.WeakReference;
import java.util.HashMap;

public class WXFrameLayout
extends BaseFrameLayout
implements WXGestureObservable,
IRenderStatus<WXDiv>,
IRenderResult<WXDiv> {
    private WeakReference<WXDiv> mWeakReference;
    private WXGesture wxGesture;
    private long downTimeMillis;
    private float downX;
    private float downY;
    private float moveX;
    private float moveY;
    private Object mOnTouchListener;

    public WXFrameLayout(Context context) {
        super(context);
    }

    private void addPan(Object object) {
        this.mOnTouchListener = object;
    }

    private void removePan() {
        this.mOnTouchListener = null;
    }

    private int reportLayerOverFlowError() {
        WXFrameLayout wXFrameLayout = wXErrorCode;
        int n = wXFrameLayout.calLayerDeep((View)wXFrameLayout, 0);
        if (wXFrameLayout.getComponent() != null) {
            String string2 = ((WXFrameLayout)((Object)wXErrorCode)).getComponent().getInstanceId();
            WXErrorCode wXErrorCode = WXErrorCode.WX_RENDER_ERR_LAYER_OVERFLOW;
            WXExceptionUtils.commitCriticalExceptionRT(string2, wXErrorCode, "draw android view", wXErrorCode.getErrorMsg() + "Layer overflow limit error: " + n + " layers!", null);
            return n;
        }
        return n;
    }

    private int calLayerDeep(View view, int n) {
        ++n;
        if (view.getParent() != null && view.getParent() instanceof View) {
            return this.calLayerDeep((View)view.getParent(), n);
        }
        return n;
    }

    @Override
    @Nullable
    public WXDiv getComponent() {
        WeakReference<WXDiv> weakReference = ((WXFrameLayout)((Object)weakReference)).mWeakReference;
        if (weakReference != null) {
            return (WXDiv)weakReference.get();
        }
        return null;
    }

    @Override
    public void holdComponent(WXDiv wXDiv) {
        WeakReference<WXDiv> weakReference;
        WXFrameLayout wXFrameLayout = weakReference2;
        WeakReference<WXDiv> weakReference2 = weakReference;
        weakReference = new WeakReference<WXDiv>(wXDiv);
        wXFrameLayout.mWeakReference = weakReference2;
    }

    @Override
    public void registerGestureListener(WXGesture wXGesture) {
        this.wxGesture = wXGesture;
    }

    @Override
    public WXGesture getGestureListener() {
        return this.wxGesture;
    }

    public boolean dispatchTouchEvent(MotionEvent motionEvent) {
        WXFrameLayout wXFrameLayout = this;
        boolean bl = super.dispatchTouchEvent(motionEvent);
        WXGesture wXGesture = wXFrameLayout.wxGesture;
        if (wXGesture != null) {
            return bl | wXGesture.onTouch((View)this, motionEvent);
        }
        return bl;
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        Class[] classArray = this.mOnTouchListener;
        if (this.mOnTouchListener != null) {
            String string2 = classArray.getClass().getName();
            Class[] classArray2 = new Class[2];
            classArray = classArray2;
            classArray2[0] = View.class;
            classArray2[1] = MotionEvent.class;
            Object[] objectArray = new Object[2];
            Object[] objectArray2 = objectArray;
            objectArray[0] = this;
            objectArray[1] = motionEvent;
            PlatformUtil.invokeMethod((String)string2, (String)"onTouch", (Object)this.mOnTouchListener, (Class[])classArray, (Object[])objectArray2);
            switch (motionEvent.getAction()) {
                default: {
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    this.moveX = motionEvent.getRawX();
                    break;
                }
                case 0: {
                    this.downTimeMillis = System.currentTimeMillis();
                    this.downX = motionEvent.getRawX();
                }
            }
            if (Math.abs(this.moveX - this.downX) > 30.0f && System.currentTimeMillis() - this.downTimeMillis > 200L) {
                return true;
            }
        }
        return super.onInterceptTouchEvent(motionEvent);
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        try {
            super.dispatchDrawInterval(canvas);
            return;
        }
        catch (Throwable throwable) {
            if (this.getComponent() != null) {
                WXSDKInstance wXSDKInstance;
                WXFrameLayout wXFrameLayout = this;
                wXFrameLayout.notifyLayerOverFlow();
                if (wXFrameLayout.getComponent() != null && (wXSDKInstance = WXSDKManager.getInstance().getSDKInstance(this.getComponent().getInstanceId())) != null && wXSDKInstance.getApmForInstance() != null && !wXSDKInstance.getApmForInstance().hasReportLayerOverDraw) {
                    wXSDKInstance.getApmForInstance().hasReportLayerOverDraw = true;
                    this.reportLayerOverFlowError();
                }
            }
            WXLogUtils.e("Layer overflow limit error", WXLogUtils.getStackTrace(throwable));
            return;
        }
    }

    public void notifyLayerOverFlow() {
        if (((WXFrameLayout)this).getComponent() != null && (this = ((WXFrameLayout)this).getComponent().getInstance()) != null && ((WXSDKInstance)this).getLayerOverFlowListeners() != null) {
            for (String string2 : ((WXSDKInstance)this).getLayerOverFlowListeners()) {
                HashMap<String, Object> hashMap;
                HashMap<String, Object> hashMap2;
                WXComponent wXComponent = WXSDKManager.getInstance().getWXRenderManager().getWXComponent(((WXSDKInstance)this).getInstanceId(), string2);
                HashMap<String, Object> hashMap3 = hashMap2 = hashMap;
                hashMap3();
                hashMap3.put("ref", string2);
                hashMap.put("instanceid", wXComponent.getInstanceId());
                wXComponent.fireEvent("layeroverflow", hashMap2);
            }
        }
    }
}

