/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.performance.WXStateRecord;
import com.taobao.weex.utils.LogLevel;
import io.dcloud.feature.uniapp.utils.AbsLogLevel;
import io.dcloud.weex.ConsoleLogUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class WXLogUtils {
    public static final String WEEX_TAG = "weex";
    public static final String WEEX_PERF_TAG = "weex_perf";
    private static final String CLAZZ_NAME_LOG_UTIL = "com.taobao.weex.devtools.common.LogUtil";
    private static StringBuilder builder = new StringBuilder(50);
    private static HashMap<String, Class> clazzMaps = new HashMap<String, Class>(2);
    private static List<JsLogWatcher> jsLogWatcherList;
    private static LogWatcher sLogWatcher;
    private static boolean isDebug;

    public static void setIsDebug(boolean bl) {
        isDebug = bl;
    }

    private static Class loadClass(String string2) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return clazz;
        }
        clazzMaps.put(string2, clazz);
        return clazz;
    }

    public static void renderPerformanceLog(String string2, long l) {
        if (!WXEnvironment.isApkDebugable()) {
            WXEnvironment.isPerf();
            return;
        }
    }

    private static void log(String string2, String string3, AbsLogLevel absLogLevel) {
        if (!TextUtils.isEmpty((CharSequence)string3) && !TextUtils.isEmpty((CharSequence)string2) && absLogLevel != null && !TextUtils.isEmpty((CharSequence)absLogLevel.getName()) && isDebug) {
            if (absLogLevel == LogLevel.ERROR && !TextUtils.isEmpty((CharSequence)string3) && string3.contains("IPCException")) {
                WXStateRecord.getInstance().recordIPCException("ipc", string3);
            }
            ConsoleLogUtils.consoleLog(string2, string3, absLogLevel);
            LogWatcher logWatcher = sLogWatcher;
            if (logWatcher != null) {
                logWatcher.onLog(absLogLevel.getName(), string2, string3);
            }
            if (WXEnvironment.isApkDebugable()) {
                if (absLogLevel.getValue() - WXEnvironment.sLogLevel.getValue() >= 0) {
                    AbsLogLevel absLogLevel2 = absLogLevel;
                    Log.println((int)absLogLevel2.getPriority(), (String)string2, (String)string3);
                    WXLogUtils.writeConsoleLog(absLogLevel2.getName(), string3);
                    return;
                }
            } else if (absLogLevel.getValue() - LogLevel.WARN.getValue() >= 0 && absLogLevel.getValue() - WXEnvironment.sLogLevel.getValue() >= 0) {
                Log.println((int)absLogLevel.getPriority(), (String)string2, (String)string3);
                return;
            }
        }
    }

    public static void v(String string2) {
        WXLogUtils.v(WEEX_TAG, string2);
    }

    public static void d(String string2) {
        WXLogUtils.d(WEEX_TAG, string2);
    }

    public static void d(String string2, byte[] byArray) {
        String string3;
        String string4 = string2;
        string2 = string3;
        string3 = new String(byArray);
        WXLogUtils.d(string4, string2);
    }

    public static void i(String string2) {
        WXLogUtils.i(WEEX_TAG, string2);
    }

    public static void i(String string2, byte[] byArray) {
        String string3;
        String string4 = string2;
        string2 = string3;
        string3 = new String(byArray);
        WXLogUtils.i(string4, string2);
    }

    public static void info(String string2) {
        WXLogUtils.i(WEEX_TAG, string2);
    }

    public static void w(String string2) {
        WXLogUtils.w(WEEX_TAG, string2);
    }

    public static void w(String string2, byte[] byArray) {
        String string3;
        String string4 = string2;
        string2 = string3;
        string3 = new String(byArray);
        WXLogUtils.w(string4, string2);
    }

    public static void e(String string2) {
        WXLogUtils.e(WEEX_TAG, string2);
    }

    public static void e(String string2, byte[] byArray) {
        String string3;
        String string4 = string2;
        string2 = string3;
        string3 = new String(byArray);
        WXLogUtils.e(string4, string2);
    }

    public static void performance(String string2, byte[] byArray) {
    }

    public static void wtf(String string2) {
        WXLogUtils.wtf(WEEX_TAG, string2);
    }

    public static void d(String iterator, String string2) {
        if (!TextUtils.isEmpty((CharSequence)((Object)iterator)) && !TextUtils.isEmpty((CharSequence)string2)) {
            WXLogUtils.log((String)((Object)iterator), string2, LogLevel.DEBUG);
            if (WXEnvironment.isApkDebugable() && "jsLog".equals(iterator) && (iterator = jsLogWatcherList) != null && iterator.size() > 0) {
                for (JsLogWatcher jsLogWatcher : jsLogWatcherList) {
                    if (string2.endsWith("__DEBUG")) {
                        jsLogWatcher.onJsLog(3, string2.replace("__DEBUG", ""));
                        continue;
                    }
                    if (string2.endsWith("__INFO")) {
                        jsLogWatcher.onJsLog(3, string2.replace("__INFO", ""));
                        continue;
                    }
                    if (string2.endsWith("__WARN")) {
                        jsLogWatcher.onJsLog(3, string2.replace("__WARN", ""));
                        continue;
                    }
                    if (string2.endsWith("__ERROR")) {
                        jsLogWatcher.onJsLog(3, string2.replace("__ERROR", ""));
                        continue;
                    }
                    jsLogWatcher.onJsLog(3, string2);
                }
            }
        }
    }

    private static LogLevel getLogLevel(String string2) {
        string2 = string2.trim();
        string2.getClass();
        int n = -1;
        switch (string2.hashCode()) {
            default: {
                break;
            }
            case 1199520264: {
                if (!string2.equals("__ERROR")) break;
                n = 4;
                break;
            }
            case 1198194259: {
                if (!string2.equals("__DEBUG")) break;
                n = 3;
                break;
            }
            case 90640196: {
                if (!string2.equals("__LOG")) break;
                n = 2;
                break;
            }
            case -1484806554: {
                if (!string2.equals("__WARN")) break;
                n = 1;
                break;
            }
            case -1485211506: {
                if (!string2.equals("__INFO")) break;
                n = 0;
            }
        }
        switch (n) {
            default: {
                return LogLevel.DEBUG;
            }
            case 4: {
                return LogLevel.ERROR;
            }
            case 3: {
                return LogLevel.DEBUG;
            }
            case 2: {
                return LogLevel.INFO;
            }
            case 1: {
                return LogLevel.WARN;
            }
            case 0: 
        }
        return LogLevel.INFO;
    }

    public static void i(String string2, String string3) {
        WXLogUtils.log(string2, string3, LogLevel.INFO);
    }

    public static void v(String string2, String string3) {
        WXLogUtils.log(string2, string3, LogLevel.VERBOSE);
    }

    public static void w(String string2, String string3) {
        WXLogUtils.log(string2, string3, LogLevel.WARN);
    }

    public static void e(String string2, String string3) {
        WXLogUtils.log(string2, string3, LogLevel.ERROR);
    }

    public static void wtf(String string2, String string3) {
        WXLogUtils.log(string2, string3, LogLevel.WTF);
    }

    public static void p(String string2) {
        WXLogUtils.d(WEEX_PERF_TAG, string2);
    }

    public static void d(String string2, Throwable throwable) {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d(string2 + WXLogUtils.getStackTrace(throwable));
            return;
        }
    }

    public static void i(String string2, Throwable throwable) {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.info(string2 + WXLogUtils.getStackTrace(throwable));
            return;
        }
    }

    public static void v(String string2, Throwable throwable) {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.v(string2 + WXLogUtils.getStackTrace(throwable));
            return;
        }
    }

    public static void w(String string2, Throwable throwable) {
        WXLogUtils.w(string2 + WXLogUtils.getStackTrace(throwable));
    }

    public static void e(String string2, Throwable throwable) {
        WXLogUtils.e(string2 + WXLogUtils.getStackTrace(throwable));
    }

    public static void wtf(String string2, Throwable throwable) {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.wtf(string2 + WXLogUtils.getStackTrace(throwable));
            return;
        }
    }

    public static void p(String string2, Throwable throwable) {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.p(string2 + WXLogUtils.getStackTrace(throwable));
            return;
        }
    }

    public static void eTag(String string2, Throwable throwable) {
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.e(string2, WXLogUtils.getStackTrace(throwable));
            return;
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getStackTrace(@Nullable Throwable throwable) {
        void var0_4;
        Writer writer;
        Writer writer2;
        block15: {
            Throwable throwable2;
            PrintWriter printWriter;
            StringWriter stringWriter;
            if (throwable == null) {
                return "";
            }
            writer2 = null;
            writer = null;
            StringWriter stringWriter2 = stringWriter;
            try {
                stringWriter = new StringWriter();
            }
            catch (Throwable throwable5) {
                // empty catch block
                break block15;
            }
            writer2 = printWriter;
            try {
                throwable2 = throwable;
                ((PrintWriter)writer2)(stringWriter2);
            }
            catch (Throwable throwable4) {
                writer2 = stringWriter2;
                break block15;
            }
            try {
                throwable2.printStackTrace((PrintWriter)writer2);
                printWriter.flush();
                stringWriter.flush();
            }
            catch (Throwable throwable3) {
                writer = writer2;
                writer2 = stringWriter2;
                break block15;
            }
            try {
                stringWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            ((PrintWriter)writer2).close();
            return stringWriter2.toString();
        }
        if (writer2 != null) {
            try {
                ((StringWriter)writer2).close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (writer != null) {
            writer.close();
        }
        throw var0_4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void writeConsoleLog(String string2, String string3) {
        Class clazz;
        if (!WXEnvironment.isApkDebugable()) return;
        try {
            clazz = clazzMaps.get(CLAZZ_NAME_LOG_UTIL);
            if (clazz == null) return;
        }
        catch (Exception exception) {
            Log.d((String)WEEX_TAG, (String)"LogUtil not found!");
            return;
        }
        Class clazz2 = clazz;
        String string4 = "log";
        Class[] classArray = new Class[2];
        Class[] classArray2 = classArray;
        Class[] classArray3 = classArray;
        Class[] classArray4 = classArray;
        Class<String> clazz3 = String.class;
        classArray3[0] = clazz3;
        classArray4[1] = clazz3;
        clazz2.getMethod(string4, classArray2).invoke((Object)clazz, string2, string3);
    }

    public static void setJsLogWatcher(JsLogWatcher jsLogWatcher) {
        if (!jsLogWatcherList.contains(jsLogWatcher)) {
            jsLogWatcherList.add(jsLogWatcher);
            return;
        }
    }

    public static void setLogWatcher(LogWatcher logWatcher) {
        sLogWatcher = logWatcher;
    }

    static {
        isDebug = true;
        clazzMaps.put(CLAZZ_NAME_LOG_UTIL, WXLogUtils.loadClass(CLAZZ_NAME_LOG_UTIL));
        jsLogWatcherList = new ArrayList<JsLogWatcher>();
    }

    public static interface LogWatcher {
        public void onLog(String var1, String var2, String var3);
    }

    public static interface JsLogWatcher {
        public void onJsLog(int var1, String var2);
    }
}

