/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils.cache;

import com.taobao.weex.bridge.ModuleFactory;
import com.taobao.weex.bridge.WXModuleManager;
import com.taobao.weex.ui.IFComponentHolder;
import com.taobao.weex.ui.WXComponentRegistry;
import com.taobao.weex.ui.config.AutoScanConfigRegister;
import com.taobao.weex.utils.WXLogUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class RegisterCache {
    private static Map<String, ModuleCache> moduleCacheMap = new ConcurrentHashMap<String, ModuleCache>();
    private static Map<String, ComponentCache> componentCacheMap = new ConcurrentHashMap<String, ComponentCache>();
    private static RegisterCache registerCache;
    private boolean enable = false;
    private boolean enableAutoScan = true;
    private volatile boolean finished = false;
    private volatile int doNotCacheSize = Integer.MAX_VALUE;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static RegisterCache getInstance() {
        if (registerCache != null) return registerCache;
        Class<RegisterCache> clazz = RegisterCache.class;
        synchronized (RegisterCache.class) {
            try {
                if (registerCache != null) return registerCache;
                registerCache = new RegisterCache();
                // ** MonitorExit[var0] (shouldn't be in output)
                return registerCache;
            }
            catch (Throwable throwable) {}
            throw throwable;
        }
    }

    private RegisterCache() {
    }

    private boolean enableCache() {
        return this.enable;
    }

    private boolean canCache() {
        return this.enableCache() && !this.finished && this.getDoNotCacheSize() < 1;
    }

    private int getDoNotCacheSize() {
        return this.doNotCacheSize--;
    }

    private void CacheComponentRegister() {
        if (componentCacheMap.isEmpty()) {
            return;
        }
        WXComponentRegistry.registerComponent(componentCacheMap);
    }

    private void CacheModuleRegister() {
        if (moduleCacheMap.isEmpty()) {
            return;
        }
        WXModuleManager.registerModule(moduleCacheMap);
    }

    public void setEnable(boolean bl) {
        this.enable = bl;
    }

    public boolean enableAutoScan() {
        return this.enableAutoScan;
    }

    public void setEnableAutoScan(boolean bl) {
        if (this.enableAutoScan != bl) {
            if (bl) {
                AutoScanConfigRegister.doScanConfig();
            }
            this.enableAutoScan = bl;
            return;
        }
    }

    public void setDoNotCacheSize(int n) {
        this.doNotCacheSize = n;
    }

    public boolean idle(boolean bl) {
        if (this.finished) {
            return true;
        }
        String string2 = bl ? "idle from create instance" : "idle from external";
        RegisterCache registerCache = this;
        WXLogUtils.e(string2 + " cache size is " + (moduleCacheMap.size() + componentCacheMap.size()));
        registerCache.finished = true;
        registerCache.CacheComponentRegister();
        registerCache.CacheModuleRegister();
        return true;
    }

    public boolean cacheModule(String string2, ModuleFactory moduleFactory, boolean bl) {
        ModuleCache moduleCache;
        String string3;
        Map<String, ModuleCache> map;
        if (!this.canCache()) {
            return false;
        }
        try {
            map = moduleCacheMap;
            string3 = string2;
        }
        catch (Exception exception) {
            return false;
        }
        ModuleCache moduleCache2 = moduleCache;
        moduleCache = new ModuleCache(string2, moduleFactory, bl);
        map.put(string3, moduleCache2);
        return true;
    }

    public boolean cacheComponent(String string2, IFComponentHolder iFComponentHolder, Map<String, Object> map) {
        ComponentCache componentCache;
        String string3;
        Map<String, ComponentCache> map2;
        if (!this.canCache()) {
            return false;
        }
        try {
            map2 = componentCacheMap;
            string3 = string2;
        }
        catch (Exception exception) {
            return false;
        }
        ComponentCache componentCache2 = componentCache;
        componentCache = new ComponentCache(string2, iFComponentHolder, map);
        map2.put(string3, componentCache2);
        return true;
    }

    public class ModuleCache {
        public final String name;
        public final ModuleFactory factory;
        public final boolean global;

        ModuleCache(String string2, ModuleFactory moduleFactory, boolean bl) {
            this.name = string2;
            this.factory = moduleFactory;
            this.global = bl;
        }
    }

    public class ComponentCache {
        public final String type;
        public final IFComponentHolder holder;
        public final Map<String, Object> componentInfo;

        ComponentCache(String string2, IFComponentHolder iFComponentHolder, Map<String, Object> map) {
            this.type = string2;
            this.componentInfo = map;
            this.holder = iFComponentHolder;
        }
    }
}

