/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.feature.weex_barcode;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.graphics.YuvImage;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.hardware.Camera;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.os.Vibrator;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsoluteLayout;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.dcloud.zxing2.BarcodeFormat;
import com.dcloud.zxing2.Result;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.ui.component.WXComponent;
import io.dcloud.base.R;
import io.dcloud.common.adapter.util.PermissionUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.ThreadPool;
import io.dcloud.feature.barcode2.camera.CameraManager;
import io.dcloud.feature.barcode2.decoding.CaptureActivityHandler;
import io.dcloud.feature.barcode2.decoding.IBarHandler;
import io.dcloud.feature.barcode2.decoding.InactivityTimer;
import io.dcloud.feature.barcode2.view.DetectorViewConfig;
import io.dcloud.feature.barcode2.view.ViewfinderView;
import java.io.ByteArrayOutputStream;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class BarcodeView
extends AbsoluteLayout
implements IBarHandler,
TextureView.SurfaceTextureListener {
    private static final int ID_ADD_VIEW = 201;
    private static final int ID_UPDATE_VIEW = 202;
    private static final int ID_START_SCAN = 203;
    static final int UNKOWN = -1000;
    static final int QR = 0;
    static final int EAN13 = 1;
    static final int EAN8 = 2;
    static final int AZTEC = 3;
    static final int DATAMATRIX = 4;
    static final int UPCA = 5;
    static final int UPCE = 6;
    static final int CODABAR = 7;
    static final int CODE39 = 8;
    static final int CODE93 = 9;
    static final int CODE128 = 10;
    static final int ITF = 11;
    static final int MAXICODE = 12;
    static final int PDF417 = 13;
    static final int RSS14 = 14;
    static final int RSSEXPANDED = 15;
    private static final float BEEP_VOLUME = 0.8f;
    private static final long VIBRATE_DURATION = 200L;
    private TextureView surfaceView;
    private ViewfinderView viewfinderView;
    private CaptureActivityHandler handler;
    private InactivityTimer inactivityTimer;
    private boolean nopermission;
    private Vector<BarcodeFormat> decodeFormats;
    private boolean hasSurface = false;
    private Context context;
    private String characterSet;
    public String errorMsg = null;
    private boolean playBeep;
    private boolean vibrate;
    private MediaPlayer mediaPlayer;
    private WXComponent component;
    private WXSDKInstance mInstance;
    private boolean mConserve = false;
    private String mFilename;
    private int viewWidth;
    private int viewHeight;
    private boolean isSurfaceAvaliable = false;
    private boolean isVerticalScreen = false;
    public boolean autoDecodeCharset = false;
    @SuppressLint(value={"HandlerLeak"})
    Handler mHandler;
    int mOrientationState;
    private boolean isCancelScan;
    private boolean mRunning;
    private Bitmap lastBiptmap;
    private final MediaPlayer.OnCompletionListener beepListener;

    public BarcodeView(Context context, WXComponent wXComponent, WXSDKInstance wXSDKInstance) {
        super(context);
        InactivityTimer inactivityTimer;
        ViewfinderView viewfinderView;
        TextureView textureView;
        MediaPlayer.OnCompletionListener onCompletionListener;
        Handler handler;
        Object object = handler;
        handler = new Handler(){

            public void handleMessage(Message message) {
                super.handleMessage(message);
                int n = message.what;
                if (n == 201) {
                    message = (AbsoluteLayout.LayoutParams)message.obj;
                    if (BarcodeView.this.surfaceView != null) {
                        if (BarcodeView.this.surfaceView.getParent() != null) {
                            ((ViewGroup)BarcodeView.this.surfaceView.getParent()).removeView((View)BarcodeView.this.surfaceView);
                        }
                        BarcodeView barcodeView = BarcodeView.this;
                        barcodeView.addView((View)barcodeView.surfaceView, (ViewGroup.LayoutParams)message);
                    }
                    BarcodeView barcodeView = BarcodeView.this;
                    barcodeView.addView((View)barcodeView.viewfinderView);
                    return;
                }
                if (n == 202) {
                    if (BarcodeView.this.surfaceView != null && BarcodeView.this.surfaceView.getParent() != null) {
                        1 v2 = this;
                        v2.BarcodeView.this.surfaceView.setLayoutParams((ViewGroup.LayoutParams)((AbsoluteLayout.LayoutParams)message.obj));
                        v2.BarcodeView.this.viewfinderView.drawViewfinder();
                        return;
                    }
                } else if (n == 203 && BarcodeView.this.surfaceView != null && BarcodeView.this.surfaceView.getParent() != null) {
                    1 v3 = this;
                    v3.BarcodeView.this.surfaceView.setLayoutParams((ViewGroup.LayoutParams)((AbsoluteLayout.LayoutParams)message.obj));
                    v3.BarcodeView.this.viewfinderView.drawViewfinder();
                    v3.BarcodeView.this.startP();
                    return;
                }
            }
        };
        this.mHandler = object;
        this.isCancelScan = false;
        this.mRunning = false;
        object = onCompletionListener;
        onCompletionListener = new MediaPlayer.OnCompletionListener(){

            public void onCompletion(MediaPlayer mediaPlayer) {
                mediaPlayer.seekTo(0);
            }
        };
        this.beepListener = object;
        this.component = wXComponent;
        this.mInstance = wXSDKInstance;
        wXComponent = textureView;
        textureView = new TextureView(context);
        this.surfaceView = wXComponent;
        wXComponent = viewfinderView;
        viewfinderView = new ViewfinderView(context, (IBarHandler)this);
        this.viewfinderView = wXComponent;
        wXComponent = inactivityTimer;
        wXSDKInstance = (Activity)context;
        inactivityTimer = new InactivityTimer((Activity)wXSDKInstance);
        this.inactivityTimer = wXComponent;
        this.context = context;
        this.saveOrientationState();
        CameraManager.init((Context)this.context, (boolean)false);
        switch (wXSDKInstance.getWindowManager().getDefaultDisplay().getRotation()) {
            default: {
                break;
            }
            case 3: {
                CameraManager.get().setHorizontalOrientation(true);
                ((Activity)this.context).setRequestedOrientation(8);
                break;
            }
            case 1: {
                CameraManager.get().setHorizontalOrientation(false);
                ((Activity)this.context).setRequestedOrientation(0);
                break;
            }
            case 0: 
            case 2: {
                ((Activity)this.context).setRequestedOrientation(7);
                CameraManager.init((Context)context, (boolean)true);
                this.isVerticalScreen = true;
            }
        }
        this.onResume(false);
        this.hasSurface = false;
    }

    private void saveOrientationState() {
        this.mOrientationState = ((Activity)this.context).getRequestedOrientation();
    }

    private void resumeOrientationState() {
        ((Activity)this.context).setRequestedOrientation(this.mOrientationState);
    }

    private void addBarcodeView() {
        Message message;
        AbsoluteLayout.LayoutParams layoutParams = barcodeView2.setLayoutParams();
        if (layoutParams == null) {
            return;
        }
        BarcodeView barcodeView = barcodeView2;
        BarcodeView barcodeView2 = message;
        barcodeView2();
        ((Message)barcodeView2).what = 201;
        message.obj = layoutParams;
        barcodeView.mHandler.sendMessage((Message)barcodeView2);
    }

    private void initCamera() {
        CaptureActivityHandler captureActivityHandler;
        block3: {
            CaptureActivityHandler captureActivityHandler2;
            BarcodeView barcodeView;
            BarcodeView barcodeView2 = object;
            try {
                CameraManager.get().openDriver(barcodeView2.surfaceView.getSurfaceTexture());
                captureActivityHandler = barcodeView2.handler;
                if (captureActivityHandler != null) break block3;
                barcodeView = object;
            }
            catch (IOException iOException) {
                object.errorMsg = iOException.getMessage();
                return;
            }
            captureActivityHandler = captureActivityHandler2;
            BarcodeView barcodeView3 = object;
            Object object = barcodeView3.decodeFormats;
            String string2 = barcodeView3.characterSet;
            boolean bl = barcodeView3.autoDecodeCharset;
            barcodeView.handler = new CaptureActivityHandler((IBarHandler)barcodeView3, (Vector)object, string2, bl);
            if (barcodeView.mRunning) {
                captureActivityHandler.restartPreviewAndDecode();
                return;
            }
            return;
        }
        captureActivityHandler.resume();
    }

    private Bitmap byte2bitmap(byte[] byArray, Camera camera) {
        Matrix matrix;
        ByteArrayOutputStream byteArrayOutputStream;
        int n;
        Camera camera2;
        BarcodeView barcodeView = null;
        try {
            camera2 = camera = camera.getParameters().getPreviewSize();
            n = 17;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return barcodeView;
        }
        int n2 = camera2.width;
        int n3 = camera2.height;
        YuvImage yuvImage = new YuvImage(byArray, n, n2, n3, null);
        ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream;
        byteArrayOutputStream = new ByteArrayOutputStream();
        Camera camera3 = camera;
        int n4 = 0;
        n2 = 0;
        n3 = camera3.width;
        int n5 = camera3.height;
        yuvImage.compressToJpeg(new Rect(n4, n2, n3, n5), 80, (OutputStream)byteArrayOutputStream2);
        byte[] byArray2 = byteArrayOutputStream2.toByteArray();
        n4 = 0;
        barcodeView = BitmapFactory.decodeByteArray((byte[])byArray2, (int)n4, (int)byteArrayOutputStream2.size());
        byteArrayOutputStream2.close();
        byteArrayOutputStream2 = matrix;
        new Matrix().postRotate(90.0f);
        n4 = 0;
        n2 = 0;
        n3 = barcodeView.getWidth();
        n5 = barcodeView.getHeight();
        return Bitmap.createBitmap((Bitmap)barcodeView, (int)n4, (int)n2, (int)n3, (int)n5, (Matrix)byteArrayOutputStream2, (boolean)true);
    }

    private void startP() {
        BarcodeView barcodeView = this;
        barcodeView.initCamera();
        if (barcodeView.decodeFormats == null) {
            this.initDecodeFormats(null);
        }
        if (!TextUtils.isEmpty((CharSequence)this.errorMsg)) {
            HashMap<String, Object> hashMap;
            HashMap<String, Object> hashMap2;
            HashMap<String, Object> hashMap3 = hashMap2 = hashMap;
            hashMap3();
            hashMap3.put("code", 8);
            hashMap.put("message", this.errorMsg);
            hashMap.put("type", "fail");
            this.fireEvent("error", hashMap2);
            return;
        }
        if (!this.mRunning) {
            BarcodeView barcodeView2 = this;
            barcodeView2.getViewfinderView().startUpdateScreenTimer();
            CaptureActivityHandler captureActivityHandler = barcodeView2.handler;
            if (captureActivityHandler != null) {
                captureActivityHandler.restartPreviewAndDecode();
            } else {
                this.onResume(false);
            }
            if (this.isCancelScan) {
                BarcodeView barcodeView3 = this;
                barcodeView3.surfaceView.setBackgroundDrawable(null);
                captureActivityHandler = barcodeView3.lastBiptmap;
                if (captureActivityHandler != null && !captureActivityHandler.isRecycled()) {
                    this.lastBiptmap.recycle();
                    this.lastBiptmap = null;
                }
                BarcodeView barcodeView4 = this;
                CameraManager.get().clearLastBitmapData();
                barcodeView4.surfaceView.postInvalidate();
                barcodeView4.initCamera();
            }
            BarcodeView barcodeView5 = this;
            barcodeView5.mRunning = true;
            barcodeView5.isCancelScan = false;
            return;
        }
    }

    private AbsoluteLayout.LayoutParams setLayoutParams() {
        int n;
        int n2;
        int n3;
        Rect rect;
        BarcodeView barcodeView = this;
        CameraManager.sScreenWidth = barcodeView.context.getResources().getDisplayMetrics().widthPixels;
        CameraManager.sScreenAllHeight = barcodeView.context.getResources().getDisplayMetrics().heightPixels;
        Rect rect2 = rect = DetectorViewConfig.getInstance().gatherRect;
        rect2.left = 0;
        rect2.top = 0;
        rect.right = this.viewWidth;
        DetectorViewConfig.getInstance().gatherRect.bottom = this.viewHeight;
        rect = barcodeView.isVerticalScreen ? CameraManager.getCR((int)rect.height(), (int)rect.width()) : CameraManager.getCR((int)rect.width(), (int)rect.height());
        if (rect == null) {
            Point point;
            rect = point;
            BarcodeView barcodeView2 = this;
            n3 = barcodeView2.viewWidth;
            point = new Point(n3, barcodeView2.viewHeight);
        }
        n3 = 0;
        int n4 = 0;
        if (this.isVerticalScreen) {
            n2 = this.viewWidth;
            int n5 = rect.x;
            int n6 = rect.y;
            n = this.viewHeight;
            if (n2 * n5 / n6 < n) {
                int n7 = n2;
                n2 = n * n6 / n5;
                DetectorViewConfig.detectorRectOffestLeft = n3 = (n7 - n2) / 2;
                DetectorViewConfig.detectorRectOffestTop = 0;
            } else {
                int n8 = n;
                n = n2 * n5 / n6;
                DetectorViewConfig.detectorRectOffestTop = n4 = (n8 - n) / 2;
                DetectorViewConfig.detectorRectOffestLeft = 0;
            }
        } else {
            n2 = this.viewHeight;
            int n9 = rect.x;
            int n10 = rect.y;
            n = this.viewWidth;
            if (n2 * n9 / n10 < n) {
                n10 = n * n10 / n9;
                DetectorViewConfig.detectorRectOffestTop = n4 = (n2 - n10) / 2;
                DetectorViewConfig.detectorRectOffestLeft = 0;
                int n11 = n;
                n = n10;
                n2 = n11;
            } else {
                int n12 = n;
                n = n2 * n9 / n10;
                DetectorViewConfig.detectorRectOffestLeft = n3 = (n12 - n) / 2;
                DetectorViewConfig.detectorRectOffestTop = 0;
                int n13 = n;
                n = n2;
                n2 = n13;
            }
        }
        AbsoluteLayout.LayoutParams layoutParams = new AbsoluteLayout.LayoutParams(n2, n, n3, n4);
        DetectorViewConfig.getInstance().initSurfaceViewRect(n3, n4, n2, n);
        return layoutParams;
    }

    private BarcodeFormat convertNumToBarcodeFormat(int n) {
        BarcodeView barcodeView = null;
        switch (n) {
            default: {
                return barcodeView;
            }
            case 15: {
                return BarcodeFormat.RSS_EXPANDED;
            }
            case 14: {
                return BarcodeFormat.RSS_14;
            }
            case 13: {
                return BarcodeFormat.PDF_417;
            }
            case 12: {
                return BarcodeFormat.MAXICODE;
            }
            case 11: {
                return BarcodeFormat.ITF;
            }
            case 10: {
                return BarcodeFormat.CODE_128;
            }
            case 9: {
                return BarcodeFormat.CODE_93;
            }
            case 8: {
                return BarcodeFormat.CODE_39;
            }
            case 7: {
                return BarcodeFormat.CODABAR;
            }
            case 6: {
                return BarcodeFormat.UPC_E;
            }
            case 5: {
                return BarcodeFormat.UPC_A;
            }
            case 4: {
                return BarcodeFormat.DATA_MATRIX;
            }
            case 3: {
                return BarcodeFormat.AZTEC;
            }
            case 2: {
                return BarcodeFormat.EAN_8;
            }
            case 1: {
                return BarcodeFormat.EAN_13;
            }
            case 0: 
        }
        return BarcodeFormat.QR_CODE;
    }

    private int convertTypestrToNum(BarcodeFormat barcodeFormat) {
        if (barcodeFormat == BarcodeFormat.QR_CODE) {
            return 0;
        }
        if (barcodeFormat == BarcodeFormat.EAN_13) {
            return 1;
        }
        if (barcodeFormat == BarcodeFormat.EAN_8) {
            return 2;
        }
        if (barcodeFormat == BarcodeFormat.AZTEC) {
            return 3;
        }
        if (barcodeFormat == BarcodeFormat.DATA_MATRIX) {
            return 4;
        }
        if (barcodeFormat == BarcodeFormat.UPC_A) {
            return 5;
        }
        if (barcodeFormat == BarcodeFormat.UPC_E) {
            return 6;
        }
        if (barcodeFormat == BarcodeFormat.CODABAR) {
            return 7;
        }
        if (barcodeFormat == BarcodeFormat.CODE_39) {
            return 8;
        }
        if (barcodeFormat == BarcodeFormat.CODE_93) {
            return 9;
        }
        if (barcodeFormat == BarcodeFormat.CODE_128) {
            return 10;
        }
        if (barcodeFormat == BarcodeFormat.ITF) {
            return 11;
        }
        if (barcodeFormat == BarcodeFormat.MAXICODE) {
            return 12;
        }
        if (barcodeFormat == BarcodeFormat.PDF_417) {
            return 13;
        }
        if (barcodeFormat == BarcodeFormat.RSS_14) {
            return 14;
        }
        if (barcodeFormat == BarcodeFormat.RSS_EXPANDED) {
            return 15;
        }
        return -1000;
    }

    private void cancel() {
        if (this.mRunning) {
            CaptureActivityHandler captureActivityHandler = this.handler;
            if (captureActivityHandler != null) {
                captureActivityHandler.stopDecode();
            }
            this.getViewfinderView().stopUpdateScreenTimer();
            this.mRunning = false;
            return;
        }
    }

    private void initBeepSound() {
        if (this.mediaPlayer == null) {
            AssetFileDescriptor assetFileDescriptor;
            BarcodeView barcodeView = this;
            ((Activity)barcodeView.context).setVolumeControlStream(3);
            this.mediaPlayer = new MediaPlayer();
            this.mediaPlayer.setAudioStreamType(3);
            barcodeView.mediaPlayer.setOnCompletionListener(this.beepListener);
            try {
                assetFileDescriptor = barcodeView.context.getResources().getAssets().openFd("res/dcloud_beep.ogg");
            }
            catch (IOException iOException) {
                this.mediaPlayer = null;
                return;
            }
            MediaPlayer mediaPlayer = this.mediaPlayer;
            AssetFileDescriptor assetFileDescriptor2 = assetFileDescriptor;
            AssetFileDescriptor assetFileDescriptor3 = assetFileDescriptor;
            FileDescriptor fileDescriptor = assetFileDescriptor.getFileDescriptor();
            long l = assetFileDescriptor3.getStartOffset();
            long l2 = assetFileDescriptor2.getLength();
            mediaPlayer.setDataSource(fileDescriptor, l, l2);
            assetFileDescriptor.close();
            barcodeView.mediaPlayer.setVolume(0.8f, 0.8f);
            barcodeView.mediaPlayer.prepare();
            return;
        }
    }

    private void playBeepSoundAndVibrate() {
        MediaPlayer mediaPlayer;
        if (this.playBeep && (mediaPlayer = this.mediaPlayer) != null) {
            mediaPlayer.start();
        }
        if (this.vibrate) {
            try {
                ((Vibrator)this.context.getSystemService("vibrator")).vibrate(200L);
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }
    }

    private void fireEvent(String string2, Map<String, Object> map) {
        if (object.component.containsEvent(string2)) {
            HashMap<String, Map<String, Object>> hashMap;
            BarcodeView barcodeView = object;
            Object object = hashMap;
            new HashMap<String, Map<String, Object>>().put("detail", map);
            barcodeView.component.fireEvent(string2, (Map<String, Object>)object);
            return;
        }
    }

    static /* synthetic */ boolean access$602(BarcodeView barcodeView, boolean bl) {
        barcodeView.nopermission = bl;
        return bl;
    }

    public void initBarcodeView(int n, int n2) {
        this.viewWidth = n;
        this.viewHeight = n2;
        ThreadPool.self().addThreadTask(new Runnable(){

            @Override
            public void run() {
                BarcodeView.this.addBarcodeView();
            }
        });
    }

    public void updateStyles(int n, int n2) {
        if (this.viewHeight == n2 && this.viewWidth == n) {
            return;
        }
        this.viewWidth = n;
        this.viewHeight = n2;
        ThreadPool.self().addThreadTask(new Runnable(){

            @Override
            public void run() {
                Message message;
                AbsoluteLayout.LayoutParams layoutParams = this_.BarcodeView.this.setLayoutParams();
                if (layoutParams == null) {
                    return;
                }
                3 v0 = this_;
                3 this_ = message;
                this_();
                ((Message)this_).what = 202;
                message.obj = layoutParams;
                v0.BarcodeView.this.mHandler.sendMessage((Message)this_);
            }
        });
    }

    public void setFrameColor(int n) {
        if (n == -1) {
            n = DetectorViewConfig.laserColor;
        }
        DetectorViewConfig.cornerColor = n;
    }

    public void setAutoDecodeCharset(boolean bl) {
        this.autoDecodeCharset = bl;
    }

    public void setAutoZoom(boolean bl) {
        CaptureActivityHandler.isAutoZoom = bl;
    }

    public void setBackground(int n) {
        if (n == -1) {
            n = DetectorViewConfig.laserColor;
        }
        this.setBackgroundColor(n);
    }

    public void setScanBarColor(int n) {
        if (n == -1) {
            n = DetectorViewConfig.laserColor;
        }
        DetectorViewConfig.laserColor = n;
    }

    public void setPlayBeep(boolean bl) {
        this.playBeep = bl;
    }

    public void setVibrate(boolean bl) {
        this.vibrate = bl;
    }

    public void setConserve(boolean bl) {
        this.mConserve = bl;
    }

    public void setFilename(String string2) {
        this.mFilename = string2;
    }

    public void setFlash(boolean bl) {
        CameraManager.get().setFlashlight(bl);
    }

    public void cancelScan() {
        if (this.mRunning) {
            Object object = this.handler;
            if (object != null) {
                object.quitSynchronously();
                this.handler = null;
            }
            this.getViewfinderView().stopUpdateScreenTimer();
            CameraManager.get().removeAutoFocus();
            CameraManager.get().stopPreview();
            byte[] byArray = CameraManager.get().getLastBitmapData();
            object = byArray;
            Camera camera = CameraManager.get().getCameraHandler();
            if (byArray != null && camera != null) {
                this.lastBiptmap = this.byte2bitmap((byte[])object, camera);
            }
            BarcodeView barcodeView = this;
            CameraManager.get().closeDriver();
            barcodeView.mRunning = false;
            barcodeView.isCancelScan = true;
            return;
        }
    }

    public void closeScan() {
        BarcodeView barcodeView = this;
        barcodeView.onPause();
        CameraManager.get().closeDriver();
        DetectorViewConfig.clearData();
        barcodeView.surfaceView = null;
        Bitmap bitmap = barcodeView.lastBiptmap;
        if (bitmap != null && !bitmap.isRecycled()) {
            this.lastBiptmap.recycle();
            this.lastBiptmap = null;
        }
        CameraManager.get().clearLastBitmapData();
        System.gc();
    }

    public void onPause() {
        CaptureActivityHandler captureActivityHandler = this.handler;
        if (captureActivityHandler != null) {
            captureActivityHandler.quitSynchronously();
            this.handler = null;
        }
        if (!this.nopermission) {
            CameraManager.get().closeDriver();
        }
        BarcodeView barcodeView = this;
        boolean bl = barcodeView.mRunning;
        barcodeView.cancel();
        barcodeView.mRunning = bl;
    }

    public void onDestory() {
        BarcodeView barcodeView = this;
        barcodeView.resumeOrientationState();
        barcodeView.inactivityTimer.shutdown();
        barcodeView.hasSurface = false;
        barcodeView.decodeFormats = null;
        barcodeView.characterSet = null;
    }

    public void start() {
        PermissionUtil.Request request;
        PermissionUtil.Request request2 = request;
        request = new PermissionUtil.Request(){

            public void onGranted(String string2) {
                long l = BarcodeView.this.isSurfaceAvaliable ? 0L : 200L;
                BarcodeView.this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Message message;
                        if (!this_.BarcodeView.this.isSurfaceAvaliable) {
                            this_.BarcodeView.this.postDelayed(this_, 100L);
                            return;
                        }
                        AbsoluteLayout.LayoutParams layoutParams = this_.BarcodeView.this.setLayoutParams();
                        if (layoutParams == null) {
                            return;
                        }
                        1 v0 = this_;
                        1 this_ = message;
                        this_();
                        ((Message)this_).what = 203;
                        message.obj = layoutParams;
                        v0.BarcodeView.this.mHandler.sendMessage((Message)this_);
                    }
                }, l);
            }

            public void onDenied(String string2) {
                4 v0 = this;
                BarcodeView.access$602(v0.BarcodeView.this, true);
                v0.BarcodeView.this.setBackground(-16777216);
                v0.BarcodeView.this.invalidate();
            }
        };
        PermissionUtil.useSystemPermissions((Activity)((Activity)this.context), (String[])new String[]{"android.permission.CAMERA"}, (PermissionUtil.Request)request2);
    }

    public void onResume(boolean bl) {
        if (this.lastBiptmap != null && this.isCancelScan && bl) {
            BarcodeView barcodeView = this;
            Resources resources = barcodeView.context.getResources();
            this.surfaceView.setBackgroundDrawable((Drawable)new BitmapDrawable(resources, barcodeView.lastBiptmap));
        }
        if (!this.hasSurface) {
            this.surfaceView.setSurfaceTextureListener((TextureView.SurfaceTextureListener)this);
        }
        if (((AudioManager)this.context.getSystemService("audio")).getRingerMode() != 2) {
            this.playBeep = false;
        }
        this.initBeepSound();
        if (bl && this.mRunning) {
            this.mRunning = false;
            this.start();
            return;
        }
    }

    public void initDecodeFormats(JSONArray jSONArray) {
        Vector vector;
        Vector vector2 = vector;
        vector = new Vector();
        this.decodeFormats = vector2;
        if (jSONArray != null && jSONArray.size() != 0) {
            int n = jSONArray.size();
            for (int i = 0; i < n; ++i) {
                int n2 = -1;
                try {
                    n2 = jSONArray.getInteger(i);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                if (n2 == -1) continue;
                this.decodeFormats.add(this.convertNumToBarcodeFormat(n2));
            }
            return;
        }
        BarcodeView barcodeView = this;
        barcodeView.decodeFormats.add(BarcodeFormat.EAN_13);
        barcodeView.decodeFormats.add(BarcodeFormat.EAN_8);
        barcodeView.decodeFormats.add(BarcodeFormat.QR_CODE);
    }

    public ViewfinderView getViewfinderView() {
        return this.viewfinderView;
    }

    public void autoFocus() {
        this.handler.autoFocus();
    }

    public void handleDecode(Result result, Bitmap bitmap) {
        HashMap<String, Object> hashMap;
        BarcodeView barcodeView = this;
        barcodeView.inactivityTimer.onActivity();
        barcodeView.playBeepSoundAndVibrate();
        boolean bl = false;
        String string2 = null;
        if (barcodeView.mConserve) {
            if (!(PdrUtil.isEmpty((Object)this.mFilename) || PdrUtil.isDeviceRootDir((String)this.mFilename) || this.mFilename.startsWith("_doc"))) {
                this.mFilename = "_doc" + this.mFilename;
            }
            string2 = this.mInstance.rewriteUri(Uri.parse((String)this.mFilename), "image").getPath();
            bl = PdrUtil.saveBitmapToFile((Bitmap)bitmap, (String)string2);
        }
        int n = this.convertTypestrToNum(result.getBarcodeFormat());
        HashMap<String, Object> hashMap2 = hashMap;
        hashMap2();
        hashMap2.put("code", n);
        hashMap.put("message", result.getText());
        if (bl && !PdrUtil.isEmpty((Object)string2)) {
            hashMap2.put("file", string2);
        }
        BarcodeView barcodeView2 = this;
        hashMap2.put("type", "success");
        hashMap2.put("charSet", result.textCharset);
        barcodeView2.fireEvent("marked", hashMap2);
        barcodeView2.cancelScan();
    }

    public void drawViewfinder() {
        this.viewfinderView.drawViewfinder();
    }

    public boolean isRunning() {
        return this.mRunning;
    }

    public Handler getHandler() {
        return this.handler;
    }

    public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
        this.isSurfaceAvaliable = true;
        if (!this.hasSurface) {
            this.hasSurface = true;
            return;
        }
    }

    public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
    }

    public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
        this.hasSurface = false;
        return false;
    }

    public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
    }

    protected void onDraw(Canvas canvas) {
        BarcodeView barcodeView = object;
        super.onDraw(canvas);
        if (barcodeView.nopermission) {
            String string2;
            TextPaint textPaint;
            TextPaint textPaint2;
            BarcodeView barcodeView2 = object;
            TextPaint textPaint3 = textPaint2 = textPaint;
            textPaint3();
            textPaint3.setColor(-1);
            textPaint.setTextSize((float)PdrUtil.pxFromDp((float)18.0f, (DisplayMetrics)object.context.getResources().getDisplayMetrics()));
            textPaint.setTextAlign(Paint.Align.CENTER);
            Paint.FontMetrics fontMetrics = textPaint.getFontMetrics();
            float f = fontMetrics.top;
            float f2 = fontMetrics.bottom;
            int n = (int)((float)barcodeView2.viewHeight / 2.0f - f / 2.0f - f2 / 2.0f);
            int n2 = barcodeView2.viewWidth / 2;
            if (Build.VERSION.SDK_INT >= 24) {
                BarcodeView barcodeView3 = object;
                string2 = barcodeView3.getResources().getConfiguration().getLocales().get(0).getLanguage();
                barcodeView3.getResources().getConfiguration().getLocales().get(0).getScript();
            } else {
                BarcodeView barcodeView4 = object;
                string2 = barcodeView4.getResources().getConfiguration().locale.getLanguage();
                barcodeView4.getResources().getConfiguration().getLocales().get(0).getScript();
            }
            Object object = object.getResources().getString(R.string.dcloud_scan_no_permission_text);
            if (string2.equalsIgnoreCase("ja")) {
                float f3 = n2;
                float f4 = n;
                canvas.drawText("\u30ab\u30e1\u30e9\u6a29\u9650\u304c\u3042\u308a\u307e\u305b\u3093", f3, f4, (Paint)textPaint2);
                return;
            }
            if (string2.equalsIgnoreCase("ru")) {
                float f5 = n2;
                float f6 = n;
                canvas.drawText("\u0422\u0440\u0435\u0431\u0443\u0435\u0442\u0441\u044f \u0440\u0430\u0437\u0440\u0435\u0448\u0435\u043d\u0438\u0435 \u043a\u0430\u043c\u0435\u0440\u044b.", f5, f6, (Paint)textPaint2);
                return;
            }
            float f7 = n2;
            float f8 = n;
            canvas.drawText((String)object, f7, f8, (Paint)textPaint2);
            return;
        }
    }
}

