/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.android.widget;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.NinePatchDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import io.dcloud.base.R;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.ICallBack;
import io.dcloud.common.ui.blur.DCBlurDraweeView;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.language.LanguageUtil;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import pl.droidsonroids.gif.AnimationListener;
import pl.droidsonroids.gif.GifDrawable;

public class TabView
extends FrameLayout {
    private Context mContext;
    private LinearLayout mTabBar;
    private JSONObject mStyleJson;
    private String mTextColor;
    private String mDefaultTextColor = "#7A7E83";
    private String mDefaultSelectedTextColor = "#3cc51f";
    private String mDefaultBorderColor = "#000000";
    private String mDefaultBackgroundColor = "#FFFFFF";
    private String mDefaultMaskBackgroundColor = "#00000000";
    private String mSelectedColor;
    private String mBackgroundColor;
    private String mBackgroundImage;
    private String mBorderStyle;
    private JSONArray mCommonList;
    private String mCommonSelectedIndex;
    private int mTabHeight;
    private JSONObject mMidButton;
    private ArrayList<RelativeLayout> mTabItemViews;
    private RelativeLayout mMidButtonView;
    private ICallBack mISingleCallback;
    private ICallBack mIMaskCallback;
    private ICallBack mIDoubleCallback;
    private ICallBack mIMidCallback;
    private float mScale;
    private IApp mWebApp;
    private String mImageSize = "24px";
    private String mTextTop = "3px";
    private String mTextSize = "10px";
    private String mTabHeightStr;
    private LinearLayout mMask;
    private View mBorderView;
    private int redDotColor = -65536;
    private String repeatType;
    private String mBlurEffect = "none";
    private DCBlurDraweeView mBlurDraweeView;
    private String mIconfontPath;
    private View.OnTouchListener mMidTouchListener;
    private View.OnClickListener mOnClickListener;
    private View.OnClickListener mOnMaskClickListener;
    private int mMidIndex;

    public TabView(Context object, View view, JSONObject object2, float f5, IApp iApp) {
        super(object);
        ViewGroup.LayoutParams layoutParams;
        LinearLayout linearLayout;
        FrameLayout.LayoutParams layoutParams2;
        View view2;
        ArrayList arrayList;
        View.OnClickListener onClickListener;
        View.OnClickListener onClickListener2;
        View.OnTouchListener onTouchListener;
        Object object3 = onTouchListener;
        onTouchListener = new View.OnTouchListener(){
            long downTime = 0L;
            float X = 0.0f;
            float Y = 0.0f;
            boolean downInMid = false;

            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (TabView.this.mMidButtonView != null && TabView.this.mMidButtonView.getParent() != null) {
                    int n5 = motionEvent.getAction();
                    if (n5 != 0) {
                        if (n5 == 1 && this.downInMid && System.currentTimeMillis() - this.downTime < 500L && Math.abs(motionEvent.getY() - this.Y) < 70.0f && Math.abs(motionEvent.getX() - this.X) < 70.0f && TabView.this.mIMidCallback != null) {
                            TabView.this.mIMidCallback.onCallBack(0, null);
                        }
                    } else {
                        RelativeLayout relativeLayout = TabView.this.mMidButtonView;
                        if (relativeLayout != null && relativeLayout.getVisibility() == 0) {
                            RelativeLayout relativeLayout2 = relativeLayout;
                            int n6 = relativeLayout2.getLeft();
                            int n7 = relativeLayout2.getTop() + TabView.this.mTabBar.getTop();
                            int n8 = relativeLayout2.getRight();
                            this.downInMid = new Rect(n6, n7, n8, relativeLayout.getBottom() + TabView.this.mTabBar.getTop()).contains((int)motionEvent.getX(), (int)motionEvent.getY());
                        } else {
                            this.downInMid = false;
                        }
                        this.downTime = System.currentTimeMillis();
                        this.X = motionEvent.getX();
                        this.Y = motionEvent.getY();
                    }
                } else {
                    this.downInMid = false;
                }
                return this.downInMid;
            }
        };
        this.mMidTouchListener = object3;
        object3 = onClickListener2;
        onClickListener2 = new View.OnClickListener(){

            public void onClick(View view) {
                4 v02 = this;
                int n5 = (Integer)view.getTag();
                v02.TabView.this.switchTab(n5);
                if (v02.TabView.this.mISingleCallback != null) {
                    TabView.this.mISingleCallback.onCallBack(n5, null);
                    return;
                }
            }
        };
        this.mOnClickListener = object3;
        object3 = onClickListener;
        onClickListener = new View.OnClickListener(){

            public void onClick(View view) {
                if (TabView.this.mIMaskCallback != null) {
                    TabView.this.mIMaskCallback.onCallBack(0, null);
                    return;
                }
            }
        };
        this.mOnMaskClickListener = object3;
        this.mMidIndex = 0;
        this.mContext = object;
        this.mScale = f5;
        this.mWebApp = iApp;
        this.setClipChildren(false);
        this.mStyleJson = object2;
        if (object2 == null) {
            JSONObject jSONObject;
            object3 = jSONObject;
            jSONObject = new JSONObject();
            this.mStyleJson = object3;
        }
        if (object2.containsKey((Object)"iconfontSrc") && !PdrUtil.isNetPath((String)(object2 = object2.getString("iconfontSrc")))) {
            this.mIconfontPath = this.mWebApp.convert2AbsFullPath((String)object2);
        }
        this.mTextColor = this.mStyleJson.getString("color");
        this.mSelectedColor = this.mStyleJson.getString("selectedColor");
        this.mBackgroundColor = this.mStyleJson.getString("backgroundColor");
        this.mBackgroundImage = this.mStyleJson.getString("backgroundImage");
        this.repeatType = this.mStyleJson.getString("backgroundRepeat");
        if (this.mStyleJson.containsKey((Object)"blurEffect")) {
            this.mBlurEffect = this.mStyleJson.getString("blurEffect");
        }
        if (this.mStyleJson.containsKey((Object)"redDotColor") && !PdrUtil.isEmpty(object2 = this.mStyleJson.getString("redDotColor"))) {
            this.redDotColor = PdrUtil.stringToColor((String)object2);
        }
        this.mBorderStyle = this.mStyleJson.getString("borderStyle");
        if (this.mStyleJson.containsKey((Object)"fontSize")) {
            this.mTextSize = this.mStyleJson.getString("fontSize");
        }
        if (this.mStyleJson.containsKey((Object)"iconWidth")) {
            this.mImageSize = this.mStyleJson.getString("iconWidth");
        }
        object2 = this.getResources().getDisplayMetrics();
        float f6 = TypedValue.applyDimension((int)1, (float)72.0f, (DisplayMetrics)object2);
        object3 = !this.mStyleJson.containsKey((Object)"height") ? "50px" : this.mStyleJson.getString("height");
        this.mTabHeightStr = object3;
        if (this.mStyleJson.containsKey((Object)"spacing")) {
            this.mTextTop = this.mStyleJson.getString("spacing");
        }
        this.mTabHeight = (int)PdrUtil.parseFloat(this.mTabHeightStr, 0.0f, f6, f5);
        Object object4 = this.mStyleJson.getString("selected") == null ? "0" : this.mStyleJson.getString("selected");
        this.mCommonSelectedIndex = object4;
        this.mCommonList = this.mStyleJson.getJSONArray("list");
        this.mMidButton = this.mStyleJson.getJSONObject("midButton");
        object4 = arrayList;
        arrayList = new ArrayList();
        this.mTabItemViews = object4;
        object4 = view2;
        view2 = new View(object);
        this.mBorderView = object4;
        object4 = layoutParams2;
        new FrameLayout.LayoutParams((int)-1, (int)1).bottomMargin = this.mTabHeight;
        new FrameLayout.LayoutParams((int)-1, (int)1).gravity = 80;
        this.addView(this.mBorderView, (ViewGroup.LayoutParams)object4);
        object4 = linearLayout;
        this.mTabBar = object4;
        new LinearLayout(object).setOrientation(0);
        this.mTabBar.setGravity(80);
        this.mTabBar.setClipChildren(false);
        if (this.mBlurEffect.equals("light") || this.mBlurEffect.equals("dark") || this.mBlurEffect.equals("extralight")) {
            FrameLayout.LayoutParams layoutParams3;
            DCBlurDraweeView dCBlurDraweeView;
            this.mDefaultBackgroundColor = "#00FFFFFF";
            object = dCBlurDraweeView;
            dCBlurDraweeView = new DCBlurDraweeView((Context)iApp.getActivity(), true, "semi-automatic");
            this.mBlurDraweeView = object;
            object = layoutParams3;
            new FrameLayout.LayoutParams((int)-1, (int)this.mTabHeight).gravity = 80;
            this.mBlurDraweeView.setDownscaleFactor(0.3f);
            this.mBlurDraweeView.setBlurRadius(20);
            this.mBlurDraweeView.setBlurEffect(this.mBlurEffect);
            this.mBlurDraweeView.setGravityType(80);
            this.addView((View)this.mBlurDraweeView, (ViewGroup.LayoutParams)object);
            this.mBlurDraweeView.setBlur(true);
            this.mBlurDraweeView.setRootView(view);
            this.mBlurDraweeView.setBlurLayoutChangeCallBack(new DCBlurDraweeView.BlurLayoutChangeCallBack(){

                @Override
                public void setVisibility(int n5) {
                    if (TabView.this.mTabBar != null) {
                        TabView.this.mTabBar.setVisibility(n5);
                        return;
                    }
                }
            });
        }
        object = layoutParams;
        layoutParams = new ViewGroup.LayoutParams(-1, this.mTabHeight);
        this.addView((View)this.mTabBar, (ViewGroup.LayoutParams)object);
        this.initTabStyle();
        this.initTabItemStyle();
        this.setSelectedStyle();
        this.setOnTouchListener(this.mMidTouchListener);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setDotBadgeMarginTop(ViewGroup viewGroup, View view) {
        float f5;
        View view2 = viewGroup.findViewById(R.id.tabIV);
        float f6 = (float)view.getHeight() / this.mScale;
        float f7 = ((float)viewGroup.getHeight() / this.mScale - (float)viewGroup.findViewById(R.id.contentWrapper).getHeight() / this.mScale) / 2.0f;
        float f8 = 2.0f;
        if (view2.getVisibility() == 0) {
            f6 /= 2.0f;
        }
        float f9 = f7 - f6;
        if (!(f5 > f8)) {
            f6 = f7 > f6 && f9 < f8 || f7 < f6 && f7 > f8 ? f7 - f8 : 0.0f;
        }
        RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams)view.getLayoutParams();
        ((RelativeLayout.LayoutParams)view.getLayoutParams()).topMargin = (int)(-f6 * this.mScale);
        if (view2.getVisibility() == 0) {
            f6 = 0.0f;
            if (view.getId() == R.id.itemDot) {
                f6 = this.mScale * -5.0f;
            } else if (view.getId() == R.id.itemBadge) {
                f6 = this.mScale * -9.0f;
            }
            layoutParams.leftMargin = (int)(f6 - (float)((viewGroup.findViewById(R.id.contentWrapper).getWidth() - view2.getWidth()) / 2));
        }
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setSelectedStyle() {
        var1_1 = 0;
        while (true) {
            block17: {
                block18: {
                    block15: {
                        block16: {
                            block19: {
                                if (var1_1 >= this.mTabItemViews.size()) {
                                    return;
                                }
                                var2_2 = this.mCommonSelectedIndex;
                                if (var2_2 == null) break block17;
                                v0 = Integer.parseInt(var2_2);
                                v1 = (ViewGroup)this.mTabItemViews.get(var1_1);
                                var2_2 = (TextView)v1.findViewById(R.id.tabTV);
                                var3_3 = (ImageView)v1.findViewById(R.id.tabIV);
                                var4_4 = (TextView)v1.findViewById(R.id.iconfontTV);
                                var5_5 = (JSONObject)var2_2.getTag();
                                var6_6 = var5_5.getJSONObject("iconfont");
                                if (v0 != var1_1) break block18;
                                var2_2.setTextColor(TabView.optColor(this.mSelectedColor, this.mDefaultSelectedTextColor));
                                if (var6_6 == null) break block19;
                                if (var6_6.containsKey((Object)"selectedText")) {
                                    var4_4.setText((CharSequence)var6_6.getString("selectedText"));
                                }
                                if (var6_6.containsKey((Object)"selectedColor")) {
                                    var4_4.setTextColor(PdrUtil.stringToColor(var6_6.getString("selectedColor")));
                                }
                                break block17;
                            }
                            var2_2 = var5_5.getString("selectedIconPath");
                            try {
                                var4_4 = this.getIconPath(var2_2);
                            }
                            catch (Exception v2) {
                                break block15;
                            }
                            {
                                if (!var4_4.startsWith("file:///android_asset/")) break block16;
                                var4_4 = var4_4.replace("file:///android_asset/", "");
                            }
                            var5_5 = v3;
                            {
                                v3 = new GifDrawable(this.mContext.getAssets(), (String)var4_4);
                                ** GOTO lbl39
                            }
                        }
                        var5_5 = v4;
                        {
                            v5 = var4_4;
                            var4_4 = this.getContext().getContentResolver();
                            v4 = new GifDrawable((ContentResolver)var4_4, Uri.parse((String)v5));
lbl39:
                            // 2 sources

                            v6 = var3_3;
                            v7 = var5_5;
                            v8 = v7;
                            v7.setLoopCount(1);
                        }
                        var4_4 = v9;
                        {
                            v9 = new AnimationListener(){

                                public void onAnimationCompleted(int n5) {
                                    Drawable drawable = var3_3.getDrawable();
                                    if (drawable instanceof GifDrawable) {
                                        GifDrawable gifDrawable = (GifDrawable)drawable;
                                        gifDrawable.seekToFrame(gifDrawable.getNumberOfFrames());
                                        gifDrawable.removeAnimationListener((AnimationListener)this);
                                        return;
                                    }
                                }
                            };
                            v8.addAnimationListener((AnimationListener)var4_4);
                            v6.setImageDrawable((Drawable)var5_5);
                            break block17;
                        }
                    }
                    this.placeholder(var2_2, var3_3);
                    break block17;
                }
                var2_2.setTextColor(TabView.optColor(this.mTextColor, this.mDefaultTextColor));
                if (var6_6 != null) {
                    if (var6_6.containsKey((Object)"text")) {
                        var4_4.setText((CharSequence)var6_6.getString("text"));
                    }
                    if (var6_6.containsKey((Object)"color")) {
                        var4_4.setTextColor(TabView.optColor(var6_6.getString("color"), this.mDefaultTextColor));
                    }
                } else {
                    this.placeholder(var5_5.getString("iconPath"), var3_3);
                }
            }
            ++var1_1;
        }
    }

    private void initTabStyle() {
        Object object;
        if (this.mTabBar.getBackground() instanceof BackGroundDrawable) {
            object = (BackGroundDrawable)this.mTabBar.getBackground();
        } else {
            BackGroundDrawable backGroundDrawable;
            object = backGroundDrawable;
            backGroundDrawable = new BackGroundDrawable();
            this.mTabBar.setBackground((Drawable)object);
        }
        TabView tabView = this;
        BackGroundDrawable backGroundDrawable = object;
        BackGroundDrawable backGroundDrawable2 = object;
        BackGroundDrawable backGroundDrawable3 = object;
        TabView tabView2 = this;
        object = tabView2.repeatType;
        backGroundDrawable3.setBackgroundRepeat((String)object, tabView2.mBackgroundImage);
        int n5 = TabView.optColor(this.mBackgroundColor, this.mDefaultBackgroundColor);
        backGroundDrawable2.setBackgroundColor(n5);
        backGroundDrawable.setBackgroundImage(this.mBackgroundImage);
        tabView.changeNavigationBarColor(n5);
        FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams)tabView.mTabBar.getLayoutParams();
        layoutParams.gravity = 80;
        ((FrameLayout.LayoutParams)tabView.mTabBar.getLayoutParams()).height = this.mTabHeight;
        tabView.mTabBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        tabView.mBorderView.setBackgroundColor(TabView.optColor(this.mBorderStyle, this.mDefaultBorderColor));
    }

    private void initTabItemStyle() {
        for (int i5 = 0; i5 < this.mCommonList.size(); ++i5) {
            this.setCommonItemStyle(i5, (JSONObject)this.mCommonList.get(i5));
        }
        this.updateMidItemStyle();
    }

    private void setTabItemStyle() {
        this.initTabItemStyle();
    }

    private void updateMidItemStyle() {
        LinearLayout.LayoutParams layoutParams;
        TextView textView;
        float f5;
        float f6;
        float f7;
        JSONObject jSONObject;
        block25: {
            block24: {
                block23: {
                    boolean bl = true;
                    JSONObject jSONObject2 = this.mMidButton;
                    if (jSONObject2 != null && jSONObject2.containsKey((Object)"visible")) {
                        bl = this.mMidButton.getBooleanValue("visible");
                    }
                    if (bl) {
                        bl = this.canMidButtonShowDisplayed();
                    }
                    if (bl) break block23;
                    RelativeLayout relativeLayout = this.mMidButtonView;
                    if (relativeLayout != null && relativeLayout.getParent() != null) {
                        this.mTabBar.removeView((View)this.mMidButtonView);
                        return;
                    }
                    break block24;
                }
                jSONObject = this.mMidButton;
                if (jSONObject != null) break block25;
            }
            return;
        }
        if (jSONObject.getString("height") != null) {
            f7 = this.mScale;
            f7 = PdrUtil.parseFloat(this.mMidButton.getString("height"), 0.0f, 0.0f, f7);
        } else {
            f7 = -1.0f;
        }
        if (this.mMidButton.getString("width") != null) {
            f6 = this.mScale;
            f6 = PdrUtil.parseFloat(this.mMidButton.getString("width"), 0.0f, 0.0f, f6);
        } else {
            f6 = -1.0f;
        }
        String string2 = this.mMidButton.getString("text");
        JSONObject jSONObject3 = this.mMidButton.getJSONObject("textLocales");
        if (jSONObject3 != null) {
            string2 = LanguageUtil.getString(jSONObject3, string2);
        }
        if (this.mMidButton.getString("iconWidth") != null) {
            f5 = this.mScale;
            f5 = PdrUtil.parseFloat(this.mMidButton.getString("iconWidth"), 0.0f, 0.0f, f5);
        } else {
            f5 = this.mScale;
            f5 = PdrUtil.parseFloat(this.mImageSize, 0.0f, 0.0f, f5);
        }
        String string3 = this.mMidButton.getString("iconPath");
        String string4 = this.mMidButton.getString("backgroundImage");
        JSONObject jSONObject4 = this.mMidButton.getJSONObject("iconfont");
        RelativeLayout relativeLayout = this.mMidButtonView;
        if (relativeLayout == null) {
            this.mMidButtonView = relativeLayout = (RelativeLayout)LayoutInflater.from((Context)this.mContext).inflate(R.layout.dcloud_tabbar_mid, null);
        }
        RelativeLayout relativeLayout2 = relativeLayout;
        ((GradientDrawable)((ImageView)relativeLayout2.findViewById(R.id.itemDot)).getDrawable()).setColor(this.redDotColor);
        float f8 = this.mScale;
        f8 = (int)PdrUtil.parseFloat(this.mImageSize, 0.0f, 0.0f, f8);
        float f9 = this.mScale;
        f9 = (int)PdrUtil.parseFloat(this.mTextTop, 0.0f, 0.0f, f9);
        float f10 = this.mScale;
        f10 = (int)PdrUtil.parseFloat(this.mTextSize, 0.0f, 0.0f, f10);
        ImageView imageView = (ImageView)relativeLayout2.findViewById(R.id.tabIV);
        TextView textView2 = (TextView)relativeLayout2.findViewById(R.id.tabIconTV);
        if (jSONObject4 != null) {
            imageView.setVisibility(8);
            this.updateIconfont(textView2, jSONObject4, f5, false);
        } else if (!TextUtils.isEmpty((CharSequence)string3)) {
            int n5;
            ImageView imageView2 = imageView;
            textView2.setVisibility(8);
            ((RelativeLayout.LayoutParams)imageView2.getLayoutParams()).height = n5 = (int)f5;
            ((RelativeLayout.LayoutParams)imageView2.getLayoutParams()).width = n5;
            imageView2.setLayoutParams((ViewGroup.LayoutParams)((RelativeLayout.LayoutParams)imageView2.getLayoutParams()));
            this.placeholder(string3, imageView);
            imageView2.setVisibility(0);
        } else {
            textView2.setVisibility(8);
            imageView.setVisibility(8);
        }
        TextView textView3 = textView = (TextView)relativeLayout.findViewById(R.id.tabTV);
        float f11 = this.mScale;
        textView3.setTextSize(0, PdrUtil.parseFloat(this.mTextSize, 0.0f, 0.0f, f11));
        textView3.setTextColor(TabView.optColor(this.mTextColor, this.mDefaultTextColor));
        textView.setText((CharSequence)string2);
        ((RelativeLayout.LayoutParams)textView.getLayoutParams()).bottomMargin = (int)(((float)this.mTabHeight - (f8 + f9 + f10)) / 2.0f);
        textView.setLayoutParams((ViewGroup.LayoutParams)((RelativeLayout.LayoutParams)textView.getLayoutParams()));
        if (TextUtils.isEmpty((CharSequence)string2)) {
            textView.setVisibility(8);
        } else {
            textView.setVisibility(0);
        }
        ImageView imageView3 = (ImageView)relativeLayout.findViewById(R.id.bgImg);
        this.placeholder(string4, imageView3);
        imageView3 = layoutParams;
        int n6 = (int)f6;
        layoutParams = new LinearLayout.LayoutParams(n6, (int)f7);
        if (f6 == -1.0f) {
            imageView3.weight = 1.0f;
        }
        if (this.mMidButtonView.getParent() != null) {
            this.mTabBar.removeView((View)this.mMidButtonView);
        }
        this.mTabBar.addView((View)this.mMidButtonView, this.mMidIndex, (ViewGroup.LayoutParams)imageView3);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setCommonItemStyle(int n5, JSONObject jSONObject) {
        RelativeLayout relativeLayout;
        boolean bl;
        int n6;
        String string2;
        block19: {
            TextView textView;
            block23: {
                ImageView imageView;
                Object object;
                block21: {
                    String string3;
                    block22: {
                        JSONObject jSONObject2;
                        block17: {
                            GifDrawable gifDrawable;
                            block16: {
                                GifDrawable gifDrawable2;
                                block20: {
                                    block18: {
                                        JSONObject jSONObject3 = jSONObject;
                                        jSONObject3.getString("pagePath");
                                        string2 = jSONObject3.getString("text");
                                        object = jSONObject3.getJSONObject("textLocales");
                                        if (object != null) {
                                            string2 = LanguageUtil.getString((JSONObject)object, string2);
                                        }
                                        JSONObject jSONObject4 = jSONObject;
                                        object = jSONObject4.getString("iconPath");
                                        string3 = jSONObject4.getString("selectedIconPath");
                                        jSONObject2 = jSONObject4.getJSONObject("iconfont");
                                        n6 = Integer.parseInt(this.mCommonSelectedIndex);
                                        bl = true;
                                        if (jSONObject4.containsKey((Object)"visible")) {
                                            bl = jSONObject.getBooleanValue("visible");
                                        }
                                        if (this.mTabItemViews.size() - 1 < n5) {
                                            LinearLayout.LayoutParams layoutParams;
                                            relativeLayout = (RelativeLayout)LayoutInflater.from((Context)this.mContext).inflate(R.layout.dcloud_tabbar_item, null);
                                            relativeLayout.setTag((Object)n5);
                                            relativeLayout.setOnClickListener(this.mOnClickListener);
                                            imageView = layoutParams;
                                            new LinearLayout.LayoutParams((int)-1, (int)-1).weight = 1.0f;
                                            this.mTabBar.addView((View)relativeLayout, (ViewGroup.LayoutParams)imageView);
                                            this.mTabItemViews.add(relativeLayout);
                                        } else {
                                            relativeLayout = this.mTabItemViews.get(n5);
                                        }
                                        RelativeLayout relativeLayout2 = relativeLayout;
                                        imageView = (ImageView)relativeLayout2.findViewById(R.id.tabIV);
                                        textView = (TextView)relativeLayout2.findViewById(R.id.iconfontTV);
                                        if (jSONObject2 == null) break block18;
                                        imageView.setVisibility(8);
                                        float f5 = this.mScale;
                                        f5 = PdrUtil.parseFloat(this.mImageSize, 0.0f, 0.0f, f5);
                                        boolean bl2 = n6 == n5;
                                        this.updateIconfont(textView, jSONObject2, f5, bl2);
                                        break block19;
                                    }
                                    if (!PdrUtil.isEmpty(object) || !PdrUtil.isEmpty(string3)) break block20;
                                    imageView.setVisibility(8);
                                    textView.setVisibility(8);
                                    break block19;
                                }
                                if (PdrUtil.isEmpty(string3) || n6 != n5) break block21;
                                ImageView imageView2 = imageView;
                                imageView2.setVisibility(0);
                                float f6 = this.mScale;
                                ((LinearLayout.LayoutParams)imageView2.getLayoutParams()).height = (int)PdrUtil.parseFloat(this.mImageSize, 0.0f, 0.0f, f6);
                                f6 = this.mScale;
                                ((LinearLayout.LayoutParams)imageView2.getLayoutParams()).width = (int)PdrUtil.parseFloat(this.mImageSize, 0.0f, 0.0f, f6);
                                imageView2.setLayoutParams((ViewGroup.LayoutParams)((LinearLayout.LayoutParams)imageView2.getLayoutParams()));
                                object = this.getIconPath(string3);
                                try {
                                    if (!((String)object).startsWith("file:///android_asset/")) break block16;
                                    object = ((String)object).replace("file:///android_asset/", "");
                                }
                                catch (Exception exception) {}
                                jSONObject2 = gifDrawable2;
                                gifDrawable2 = new GifDrawable(this.mContext.getAssets(), (String)object);
                                break block17;
                            }
                            jSONObject2 = gifDrawable;
                            Object object2 = object;
                            object = this.getContext().getContentResolver();
                            gifDrawable = new GifDrawable((ContentResolver)object, Uri.parse((String)object2));
                            break block22;
                        }
                        jSONObject2.setLoopCount(1);
                        imageView.setImageDrawable((Drawable)jSONObject2);
                        break block23;
                    }
                    this.placeholder(string3, imageView);
                    break block23;
                }
                if (!PdrUtil.isEmpty(object)) {
                    ImageView imageView3 = imageView;
                    imageView3.setVisibility(0);
                    float f7 = this.mScale;
                    ((LinearLayout.LayoutParams)imageView3.getLayoutParams()).height = (int)PdrUtil.parseFloat(this.mImageSize, 0.0f, 0.0f, f7);
                    f7 = this.mScale;
                    ((LinearLayout.LayoutParams)imageView3.getLayoutParams()).width = (int)PdrUtil.parseFloat(this.mImageSize, 0.0f, 0.0f, f7);
                    imageView3.setLayoutParams((ViewGroup.LayoutParams)((LinearLayout.LayoutParams)imageView3.getLayoutParams()));
                    this.placeholder((String)object, imageView);
                } else {
                    imageView.setVisibility(8);
                }
            }
            textView.setVisibility(8);
        }
        RelativeLayout relativeLayout3 = relativeLayout;
        TextView textView = (TextView)relativeLayout3.findViewById(R.id.tabTV);
        textView.setTag((Object)jSONObject);
        ((GradientDrawable)((ImageView)relativeLayout3.findViewById(R.id.itemDot)).getDrawable()).setColor(this.redDotColor);
        if (!PdrUtil.isEmpty(string2)) {
            TextView textView2 = textView;
            textView2.setVisibility(0);
            float f8 = this.mScale;
            ((LinearLayout.LayoutParams)textView2.getLayoutParams()).topMargin = (int)PdrUtil.parseFloat(this.mTextTop, 0.0f, 0.0f, f8);
            textView2.setLayoutParams((ViewGroup.LayoutParams)((LinearLayout.LayoutParams)textView2.getLayoutParams()));
            f8 = this.mScale;
            textView2.setTextSize(0, PdrUtil.parseFloat(this.mTextSize, 0.0f, 0.0f, f8));
            if (n6 != n5) {
                textView.setTextColor(TabView.optColor(this.mTextColor, this.mDefaultTextColor));
            } else {
                textView.setTextColor(TabView.optColor(this.mSelectedColor, this.mDefaultSelectedTextColor));
            }
            textView.setText((CharSequence)string2);
        } else {
            textView.setVisibility(8);
        }
        if (bl) {
            relativeLayout.setVisibility(0);
            return;
        }
        relativeLayout.setVisibility(8);
    }

    private String getIconPath(String string2) {
        Object object = ((TabView)((Object)object)).mWebApp.convert2AbsFullPath(string2);
        if (object != null && PdrUtil.isDeviceRootDir((String)object)) {
            return "file://" + (String)object;
        }
        if (object != null && ((String)object).startsWith("/") && ((String)object).length() > 1) {
            object = ((String)object).substring(1);
        }
        if (object != null && ((String)object).startsWith("android_asset/")) {
            object = ((String)object).replace("android_asset/", "");
        }
        return "file:///android_asset/" + (String)object;
    }

    private void setCommonItemJson(int n5, String string2, String object, String string3, JSONObject jSONObject, boolean bl) {
        if (n5 >= this.mCommonList.size()) {
            return;
        }
        JSONObject jSONObject2 = this.mCommonList.getJSONObject(n5);
        if (string2 != null) {
            jSONObject2.put("text", (Object)string2);
        }
        if (object != null) {
            jSONObject2.put("iconPath", object);
        }
        if (string3 != null) {
            jSONObject2.put("selectedIconPath", (Object)string3);
        }
        if (jSONObject != null) {
            if (jSONObject2.containsKey((Object)"iconfont")) {
                string2 = jSONObject2.getJSONObject("iconfont");
                if (string2 != null && (object = jSONObject.keySet().iterator()) != null) {
                    while (object.hasNext()) {
                        string3 = (String)object.next();
                        string2.put(string3, (Object)jSONObject.getString(string3));
                    }
                }
            } else {
                jSONObject2.put("iconfont", (Object)jSONObject);
            }
        }
        jSONObject2.put("visible", (Object)bl);
        this.setCommonItemStyle(n5, jSONObject2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private static int optColor(String string2, String string3) {
        if (string2 != null) return PdrUtil.stringToColor(string2);
        try {
            return PdrUtil.stringToColor(string3);
        }
        catch (Exception exception) {
            return PdrUtil.stringToColor(string3);
        }
    }

    private ViewGroup getCommonItemByIndex(int n5) {
        if (this.mTabItemViews.size() - 1 >= n5) {
            return (ViewGroup)this.mTabItemViews.get(n5);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void placeholder(String string2, ImageView imageView) {
        try {
            if (TextUtils.isEmpty((CharSequence)string2)) return;
        }
        catch (Throwable throwable) {}
        ((RequestBuilder)((RequestBuilder)Glide.with((Context)this.getContext()).load(this.getIconPath(string2)).dontAnimate()).placeholder(imageView.getDrawable())).into(imageView);
        return;
        throwable.printStackTrace();
    }

    private void changeNavigationBarColor(final int n5) {
        if (Build.VERSION.SDK_INT >= 26 && this.mContext != null) {
            new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                @Override
                public void run() {
                    6 v02 = this;
                    Window window = ((Activity)v02.TabView.this.mContext).getWindow();
                    window.setNavigationBarColor(n5);
                    int n52 = window.getDecorView().getSystemUiVisibility();
                    n52 = PdrUtil.isLightColor(v02.n5) ? (n52 |= 0x10) : (n52 &= 0xFFFFFFEF);
                    window.getDecorView().setSystemUiVisibility(n52);
                }
            }, 400L);
            return;
        }
    }

    public void setSingleCallbackListener(ICallBack iCallBack) {
        this.mISingleCallback = iCallBack;
    }

    public void setMaskCallbackListener(ICallBack iCallBack) {
        this.mIMaskCallback = iCallBack;
    }

    public void setDoubleCallbackListener(ICallBack iCallBack) {
        this.mIDoubleCallback = iCallBack;
    }

    public void setMidCallbackListener(ICallBack iCallBack) {
        this.mIMidCallback = iCallBack;
    }

    public void switchTab(int n5) {
        TabView tabView = frameLayout;
        tabView.mCommonSelectedIndex = String.valueOf(n5);
        tabView.setSelectedStyle();
        FrameLayout frameLayout = tabView.mBlurDraweeView;
        if (frameLayout != null) {
            frameLayout.postInvalidate(1000L);
            return;
        }
    }

    public void showTabBarRedDot(JSONObject jSONObject) {
        if ((jSONObject = this.getCommonItemByIndex(jSONObject.getInteger("index"))) != null) {
            ImageView imageView = (ImageView)jSONObject.findViewById(R.id.itemDot);
            JSONObject jSONObject2 = jSONObject;
            ((TextView)jSONObject2.findViewById(R.id.itemBadge)).setVisibility(4);
            this.setDotBadgeMarginTop((ViewGroup)jSONObject2, (View)imageView);
            imageView.setVisibility(0);
            return;
        }
    }

    public void hideTabBarRedDot(JSONObject jSONObject) {
        if ((this = this.getCommonItemByIndex(jSONObject.getInteger("index"))) != null) {
            ((ImageView)this.findViewById(R.id.itemDot)).setVisibility(4);
            return;
        }
    }

    public void setTabBarBadge(JSONObject jSONObject) {
        JSONObject jSONObject2 = jSONObject;
        int n5 = jSONObject2.getInteger("index");
        String string2 = jSONObject2.getString("text");
        ViewGroup viewGroup = this.getCommonItemByIndex(n5);
        if (viewGroup != null) {
            ViewGroup viewGroup2 = viewGroup;
            ImageView imageView = (ImageView)viewGroup2.findViewById(R.id.itemDot);
            TextView textView = (TextView)viewGroup2.findViewById(R.id.itemBadge);
            imageView.setVisibility(4);
            textView.setText((CharSequence)string2);
            this.setDotBadgeMarginTop(viewGroup, (View)textView);
            textView.setVisibility(0);
            return;
        }
    }

    public void removeTabBarBadge(JSONObject jSONObject) {
        if ((this = this.getCommonItemByIndex(jSONObject.getInteger("index"))) != null) {
            ((TextView)this.findViewById(R.id.itemBadge)).setVisibility(4);
            return;
        }
    }

    public void setTabBarStyle(JSONObject object) {
        int n5;
        if (object.containsKey((Object)"color")) {
            this.mTextColor = object.getString("color");
        }
        if (object.containsKey((Object)"selectedColor")) {
            this.mSelectedColor = object.getString("selectedColor");
        }
        if (object.containsKey((Object)"backgroundColor")) {
            this.mBackgroundColor = object.getString("backgroundColor");
        }
        if (object.containsKey((Object)"backgroundImage")) {
            this.mBackgroundImage = object.getString("backgroundImage");
        }
        if (object.containsKey((Object)"borderStyle")) {
            this.mBorderStyle = object.getString("borderStyle");
        }
        if (object.containsKey((Object)"height")) {
            String string2;
            this.mTabHeightStr = string2 = object.getString("height");
            float f5 = this.mScale;
            this.mTabHeight = (int)PdrUtil.parseFloat(string2, 0.0f, 0.0f, f5);
        }
        if (object.containsKey((Object)"midButton")) {
            this.mMidButton = object.getJSONObject("midButton");
        }
        if (object.containsKey((Object)"fontSize")) {
            this.mTextSize = object.getString("fontSize");
        }
        if (object.containsKey((Object)"iconWidth")) {
            this.mImageSize = object.getString("iconWidth");
        }
        if (object.containsKey((Object)"backgroundRepeat")) {
            this.repeatType = object.getString("backgroundRepeat");
        }
        TabView tabView = this;
        tabView.initTabStyle();
        tabView.setTabItemStyle();
        tabView.setSelectedStyle();
        if (object.containsKey((Object)"redDotColor") && !PdrUtil.isEmpty(object = object.getString("redDotColor")) && this.redDotColor != (n5 = PdrUtil.stringToColor((String)object))) {
            this.redDotColor = PdrUtil.stringToColor((String)object);
            for (int i5 = 0; i5 < this.mTabItemViews.size(); ++i5) {
                ViewGroup viewGroup = (ViewGroup)this.mTabItemViews.get(i5);
                if (viewGroup == null) continue;
                ((GradientDrawable)((ImageView)viewGroup.findViewById(R.id.itemDot)).getDrawable()).setColor(this.redDotColor);
            }
        }
    }

    public void setTabBarItem(JSONObject jSONObject) {
        JSONObject jSONObject2 = jSONObject;
        int n5 = jSONObject2.getInteger("index");
        String string2 = jSONObject2.getString("text");
        String string3 = jSONObject2.getString("iconPath");
        String string4 = jSONObject2.getString("selectedIconPath");
        boolean bl = true;
        if (jSONObject2.containsKey((Object)"visible")) {
            bl = jSONObject.getBooleanValue("visible");
        }
        JSONObject jSONObject3 = null;
        if (jSONObject.containsKey((Object)"iconfont")) {
            jSONObject3 = jSONObject.getJSONObject("iconfont");
        }
        this.setCommonItemJson(n5, string2, string3, string4, jSONObject3, bl);
    }

    public int getTabHeight() {
        DCBlurDraweeView dCBlurDraweeView = this.mBlurDraweeView;
        if (dCBlurDraweeView != null && dCBlurDraweeView.checkBlurEffect(this.mBlurEffect)) {
            return 0;
        }
        return this.mTabHeight;
    }

    public String getTabHeightStr() {
        DCBlurDraweeView dCBlurDraweeView = this.mBlurDraweeView;
        if (dCBlurDraweeView != null && dCBlurDraweeView.checkBlurEffect(this.mBlurEffect)) {
            return "0";
        }
        return this.mTabHeightStr;
    }

    public int getMidHeight() {
        JSONObject jSONObject = this.mMidButton;
        if (jSONObject == null) {
            return 0;
        }
        float f5 = this.mScale;
        return (int)PdrUtil.parseFloat(jSONObject.getString("height"), 0.0f, 0.0f, f5);
    }

    public void setMask(JSONObject jSONObject) {
        String string2 = null;
        if (jSONObject != null && jSONObject.containsKey((Object)"color")) {
            string2 = jSONObject.getString("color");
        }
        if (!"none".equals(string2)) {
            if (this.mMask == null) {
                LinearLayout linearLayout;
                TabView tabView = this;
                JSONObject jSONObject2 = jSONObject = linearLayout;
                jSONObject2(this.mContext);
                this.mMask = jSONObject2;
                linearLayout.setOnClickListener(this.mOnMaskClickListener);
                tabView.mMask.setBackgroundColor(TabView.optColor(string2, this.mDefaultMaskBackgroundColor));
                ((FrameLayout)tabView.getParent()).addView((View)this.mMask, new ViewGroup.LayoutParams(-1, -1));
                return;
            }
        } else if (this.mMask != null) {
            ((FrameLayout)this.getParent()).removeView((View)this.mMask);
            this.mMask = null;
            return;
        }
    }

    public void bringMaskToFront() {
        TabView tabView = tabView.mMask;
        if (tabView != null) {
            tabView.bringToFront();
            return;
        }
    }

    public void updateIconfont(TextView textView, JSONObject object, float f5, boolean bl) {
        if (tabView.mWebApp != null && textView != null && object != null && !TextUtils.isEmpty((CharSequence)tabView.mIconfontPath)) {
            int n5;
            JSONObject jSONObject = object;
            textView.setVisibility(0);
            byte by = tabView.mWebApp.obtainRunningAppMode();
            String string2 = jSONObject.getString("text");
            if (jSONObject.containsKey((Object)"fontSize")) {
                float f6 = tabView.mScale;
                textView.setTextSize(0, (float)((int)PdrUtil.parseFloat(object.getString("fontSize"), 0.0f, 0.0f, f6)));
            }
            if (bl && object.containsKey((Object)"selectedColor")) {
                textView.setTextColor(PdrUtil.stringToColor(object.getString("selectedColor")));
            } else if (object.containsKey((Object)"color")) {
                textView.setTextColor(PdrUtil.stringToColor(object.getString("color")));
            }
            if (!tabView.mIconfontPath.startsWith("/storage") && by == 1) {
                try {
                    textView.setTypeface(Typeface.createFromAsset((AssetManager)tabView.getContext().getAssets(), (String)tabView.mIconfontPath));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                File file;
                object = file;
                if (new File(tabView.mIconfontPath).exists()) {
                    textView.setTypeface(Typeface.createFromFile((File)object));
                }
            }
            TextView textView2 = textView;
            TabView tabView = textView2.getLayoutParams();
            textView2.getLayoutParams().height = n5 = (int)f5;
            textView2.getLayoutParams().width = n5;
            textView2.setLayoutParams((ViewGroup.LayoutParams)tabView);
            textView2.setText((CharSequence)string2);
            textView2.setVisibility(0);
            return;
        }
    }

    public void updateMidButton(JSONObject jSONObject) {
        if (jSONObject != null) {
            this.mMidButton = jSONObject;
        }
        this.updateMidItemStyle();
    }

    public int getTabItemDisplayedSize() {
        int n5 = 0;
        for (int i5 = 0; i5 < this.mCommonList.size(); ++i5) {
            JSONObject jSONObject = this.mCommonList.getJSONObject(i5);
            if (jSONObject == null || jSONObject.containsKey((Object)"visible") && !jSONObject.getBoolean("visible").booleanValue()) continue;
            ++n5;
        }
        return n5;
    }

    public boolean canMidButtonShowDisplayed() {
        int n5 = this.getTabItemDisplayedSize();
        boolean bl = n5 % 2 == 0;
        if (bl) {
            int n6 = n5;
            n5 = 0;
            int n7 = n6 / 2;
            for (int i5 = 0; i5 < this.mCommonList.size(); ++i5) {
                JSONObject jSONObject = this.mCommonList.getJSONObject(i5);
                if (jSONObject == null) continue;
                if (!jSONObject.containsKey((Object)"visible") || jSONObject.getBoolean("visible").booleanValue()) {
                    ++n5;
                }
                if (n5 != n7) continue;
                this.mMidIndex = i5 + 1;
            }
        }
        return bl;
    }

    public void dispose() {
        this.mTabItemViews.clear();
        this.mMidButtonView = null;
    }

    public void setIWebViewFocusable(boolean bl) {
        DCBlurDraweeView dCBlurDraweeView = this.mBlurDraweeView;
        if (dCBlurDraweeView != null && dCBlurDraweeView.checkBlurEffect(this.mBlurEffect)) {
            this.mBlurDraweeView.setContentFocusable(bl);
            return;
        }
    }

    class BackGroundDrawable
    extends Drawable {
        private Shader mBackgroundBitmap = null;
        private String bitmapPath = null;
        private String repeat = "no-repeat";
        private int mBackgroundColor = 0;
        private Rect bound;
        private Paint colorPaint;
        private Paint mPaint;

        BackGroundDrawable() {
        }

        private Bitmap scaleBitmap(Bitmap bitmap, int n5, int n6) {
            Matrix matrix;
            if (bitmap == null) {
                return null;
            }
            if (this.repeat.equals("repeat")) {
                return bitmap;
            }
            int n7 = n6;
            int n8 = n5;
            Bitmap bitmap2 = bitmap;
            n5 = bitmap2.getHeight();
            n6 = bitmap2.getWidth();
            float f5 = (float)n8 / (float)n6;
            float f6 = (float)n7 / (float)n5;
            Matrix matrix2 = matrix;
            matrix = new Matrix();
            if (this.repeat.equals("repeat-x")) {
                matrix2.preScale(1.0f, f6);
            } else if (this.repeat.equals("repeat-y")) {
                matrix2.preScale(f5, 1.0f);
            } else {
                matrix2.preScale(f5, f6);
            }
            return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n6, (int)n5, (Matrix)matrix2, (boolean)false);
        }

        private Shader getShader(List<String> list, float object, float object2) {
            float[] fArray = object3.parseGradientDirection(list.get(0).trim(), (float)object, (float)object2);
            Object object3 = fArray;
            if (fArray == null) {
                return null;
            }
            List<String> list2 = list;
            Object object4 = object3;
            BackGroundDrawable backGroundDrawable = object4[0];
            BackGroundDrawable backGroundDrawable2 = object4[1];
            object = (Object)object4[2];
            object2 = (Object)object4[3];
            int n5 = PdrUtil.stringToColor(list2.get(1).trim());
            int n6 = PdrUtil.stringToColor(list2.get(2).trim());
            Shader.TileMode tileMode = Shader.TileMode.CLAMP;
            return new LinearGradient((float)backGroundDrawable, (float)backGroundDrawable2, object, object2, n5, n6, tileMode);
        }

        private float[] parseGradientDirection(String string2, float f5, float f6) {
            int n5 = 0;
            int n6 = 1;
            int n7 = 2;
            int n8 = 3;
            float[] fArray = new float[4];
            float[] fArray2 = fArray;
            fArray[0] = 0.0f;
            fArray[1] = 0.0f;
            fArray[2] = 0.0f;
            fArray[3] = 0.0f;
            if (!TextUtils.isEmpty((CharSequence)string2)) {
                string2 = string2.replaceAll("\\s*", "").toLowerCase(Locale.ENGLISH);
            }
            String string3 = string2;
            string3.getClass();
            int n9 = -1;
            switch (string3.hashCode()) {
                default: {
                    break;
                }
                case 1176531318: {
                    if (!string2.equals("tobottomright")) break;
                    n9 = 5;
                    break;
                }
                case 110550266: {
                    if (!string2.equals("totop")) break;
                    n9 = 4;
                    break;
                }
                case -172068863: {
                    if (!string2.equals("totopleft")) break;
                    n9 = 3;
                    break;
                }
                case -868157182: {
                    if (!string2.equals("toleft")) break;
                    n9 = 2;
                    break;
                }
                case -1137407871: {
                    if (!string2.equals("toright")) break;
                    n9 = 1;
                    break;
                }
                case -1352032154: {
                    if (!string2.equals("tobottom")) break;
                    n9 = 0;
                }
            }
            switch (n9) {
                default: {
                    return null;
                }
                case 5: {
                    float[] fArray3 = fArray2;
                    fArray3[n7] = f5;
                    fArray3[n8] = f6;
                    return fArray2;
                }
                case 4: {
                    fArray2[n6] = f6;
                    return fArray2;
                }
                case 3: {
                    float[] fArray4 = fArray2;
                    fArray4[n5] = f5;
                    fArray4[n6] = f6;
                    return fArray2;
                }
                case 2: {
                    fArray2[n5] = f5;
                    return fArray2;
                }
                case 1: {
                    fArray2[n7] = f5;
                    return fArray2;
                }
                case 0: 
            }
            fArray2[n8] = f6;
            return fArray2;
        }

        /*
         * Exception decompiling
         */
        private List<String> parseGradientValues(String var1_3) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 11[TRYBLOCK] [11 : 115->121)] java.lang.Exception
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void setBackgroundColor(int n5) {
            if (this.mBackgroundBitmap != null) {
                this.setAlpha(Color.alpha((int)n5));
            } else {
                this.mBackgroundColor = n5;
            }
            this.invalidateSelf();
        }

        public void setBackgroundRepeat(String string2, String string3) {
            if (!(PdrUtil.isEmpty(string2) || string2.equals(this.repeat) || TextUtils.isEmpty((CharSequence)string3))) {
                this.repeat = string2;
                this.mBackgroundBitmap = null;
                this.setBackgroundImage(string3);
                return;
            }
        }

        public void setBackgroundImage(String object) {
            Object object2 = this.bound;
            if (object2 != null && object2.width() != 0) {
                if (object == null) {
                    return;
                }
                object2 = this.parseGradientValues((String)object);
                if (object2 != null && object2.size() == 3) {
                    BackGroundDrawable backGroundDrawable = this;
                    float f5 = backGroundDrawable.bound.width();
                    this.mBackgroundBitmap = this.getShader((List<String>)object2, f5, backGroundDrawable.bound.height());
                } else {
                    object = TabView.this.getIconPath((String)object);
                    object2 = null;
                    if (((String)object).startsWith("file:///android_asset/")) {
                        object = ((String)object).replace("file:///android_asset/", "");
                        try {
                            object2 = BitmapFactory.decodeStream((InputStream)TabView.this.getContext().getAssets().open((String)object));
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    } else if (((String)object).startsWith("file://")) {
                        object2 = BitmapFactory.decodeFile((String)((String)object).replace("file://", ""));
                    }
                    if (object2 == null) {
                        this.mBackgroundBitmap = null;
                        this.bitmapPath = null;
                        this.invalidateSelf();
                        return;
                    }
                    byte[] byArray = object2.getNinePatchChunk();
                    object = byArray;
                    if (byArray != null && NinePatch.isNinePatchChunk((byte[])object)) {
                        Canvas canvas;
                        Rect rect;
                        Object object3 = object;
                        object = rect;
                        rect = new Rect();
                        NinePatchDrawable ninePatchDrawable = new NinePatchDrawable((Bitmap)object2, (byte[])object3, (Rect)object, null);
                        object = Bitmap.createBitmap((int)this.bound.width(), (int)this.bound.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
                        object2 = canvas;
                        int n5 = new Canvas((Bitmap)object).getWidth();
                        int n6 = object2.getHeight();
                        ninePatchDrawable.setBounds(0, 0, n5, n6);
                        ninePatchDrawable.draw((Canvas)object2);
                    } else {
                        BackGroundDrawable backGroundDrawable = this;
                        int n7 = backGroundDrawable.bound.width();
                        object = this.scaleBitmap((Bitmap)object2, n7, backGroundDrawable.bound.height());
                    }
                    if (object == null) {
                        this.mBackgroundBitmap = null;
                    } else {
                        BitmapShader bitmapShader;
                        object2 = bitmapShader;
                        Shader.TileMode tileMode = Shader.TileMode.REPEAT;
                        bitmapShader = new BitmapShader((Bitmap)object, tileMode, tileMode);
                        this.mBackgroundBitmap = object2;
                    }
                }
                this.invalidateSelf();
                return;
            }
            this.bitmapPath = object;
        }

        public void draw(Canvas canvas) {
            if (this.bound == null) {
                this.bound = this.getBounds();
            }
            if (this.mBackgroundBitmap != null) {
                this.getPaint().setShader(this.mBackgroundBitmap);
                this.getBackgroundColorPaint().setColor(Color.argb((int)this.getBackgroundColorPaint().getAlpha(), (int)255, (int)255, (int)255));
                canvas.drawRect(this.bound, this.getBackgroundColorPaint());
            } else {
                String string2 = this.bitmapPath;
                if (string2 != null) {
                    this.setBackgroundImage(string2);
                    this.bitmapPath = null;
                    this.getBackgroundColorPaint().setColor(Color.argb((int)this.getBackgroundColorPaint().getAlpha(), (int)255, (int)255, (int)255));
                    canvas.drawRect(this.bound, this.getBackgroundColorPaint());
                    this.getPaint().setShader(this.mBackgroundBitmap);
                } else {
                    this.getPaint().setColor(this.mBackgroundColor);
                }
            }
            canvas.drawRect(this.bound, this.getPaint());
            if (this.mBackgroundBitmap != null) {
                this.getPaint().setShader(null);
                return;
            }
        }

        public void setAlpha(int n5) {
            if (this.mBackgroundBitmap == null && this.bitmapPath == null) {
                return;
            }
            BackGroundDrawable backGroundDrawable = this;
            backGroundDrawable.getPaint().setAlpha(n5);
            backGroundDrawable.getBackgroundColorPaint().setAlpha(n5);
        }

        public void setColorFilter(ColorFilter colorFilter) {
        }

        public Paint getBackgroundColorPaint() {
            if (this.colorPaint == null) {
                Paint paint;
                Paint paint2 = paint;
                paint = new Paint();
                this.colorPaint = paint2;
            }
            return this.colorPaint;
        }

        public int getOpacity() {
            return 0;
        }

        public Paint getPaint() {
            if (this.mPaint == null) {
                Paint paint;
                Paint paint2 = paint;
                paint = new Paint(1);
                this.mPaint = paint2;
            }
            return this.mPaint;
        }
    }
}

