/*
 * Decompiled with CFR 0.152.
 */
package com.dcloud.zxing2.common;

import com.dcloud.zxing2.common.BitArray;
import java.util.Arrays;

public final class BitMatrix
implements Cloneable {
    private final int width;
    private final int height;
    private final int rowSize;
    private final int[] bits;

    public BitMatrix(int n5) {
        int n6 = n5;
        this(n6, n6);
    }

    public BitMatrix(int n5, int n6) {
        if (n5 >= 1 && n6 >= 1) {
            this.width = n5;
            this.height = n6;
            this.rowSize = n5 = (n5 + 31) / 32;
            this.bits = new int[n5 * n6];
            return;
        }
        throw new IllegalArgumentException("Both dimensions must be greater than 0");
    }

    private BitMatrix(int n5, int n6, int n7, int[] nArray) {
        this.width = n5;
        this.height = n6;
        this.rowSize = n7;
        this.bits = nArray;
    }

    public static BitMatrix parse(String object, String string2, String string3) {
        if (object != null) {
            BitMatrix bitMatrix;
            boolean[] blArray = new boolean[((String)object).length()];
            int n5 = 0;
            int n6 = 0;
            int n7 = -1;
            int n8 = 0;
            int n9 = 0;
            while (n9 < ((String)object).length()) {
                if (((String)object).charAt(n9) != '\n' && ((String)object).charAt(n9) != '\r') {
                    int n10 = n9;
                    if (((String)object).substring(n10, n10 + string2.length()).equals(string2)) {
                        n9 += string2.length();
                        blArray[n5] = true;
                        ++n5;
                        continue;
                    }
                    int n11 = n9;
                    if (((String)object).substring(n11, n11 + string3.length()).equals(string3)) {
                        n9 += string3.length();
                        blArray[n5] = false;
                        ++n5;
                        continue;
                    }
                    throw new IllegalArgumentException("illegal character encountered: " + ((String)object).substring(n9));
                }
                if (n5 > n6) {
                    if (n7 == -1) {
                        n7 = n5 - n6;
                    } else if (n5 - n6 != n7) {
                        throw new IllegalArgumentException("row lengths do not match");
                    }
                    n8 = n6 = n8 + 1;
                    n6 = n5;
                }
                ++n9;
            }
            if (n5 > n6) {
                if (n7 == -1) {
                    n7 = n5 - n6;
                } else if (n5 - n6 != n7) {
                    throw new IllegalArgumentException("row lengths do not match");
                }
                ++n8;
            }
            object = bitMatrix;
            bitMatrix = new BitMatrix(n7, n8);
            for (int i5 = 0; i5 < n5; ++i5) {
                if (!blArray[i5]) continue;
                int n12 = i5;
                int n13 = n12 % n7;
                ((BitMatrix)object).set(n13, n12 / n7);
            }
            return object;
        }
        throw new IllegalArgumentException();
    }

    public boolean get(int n5, int n6) {
        int n7 = n6 * this.rowSize + n5 / 32;
        return (this.bits[n7] >>> (n5 & 0x1F) & 1) != 0;
    }

    public void set(int n5, int n6) {
        int n7 = n6 * this.rowSize + n5 / 32;
        this.bits[n7] = this.bits[n7] | 1 << (n5 & 0x1F);
    }

    public void unset(int n5, int n6) {
        int n7 = n6 * this.rowSize + n5 / 32;
        this.bits[n7] = this.bits[n7] & ~(1 << (n5 & 0x1F));
    }

    public void flip(int n5, int n6) {
        int n7 = n6 * this.rowSize + n5 / 32;
        this.bits[n7] = this.bits[n7] ^ 1 << (n5 & 0x1F);
    }

    public void xor(BitMatrix bitMatrix) {
        if (this.width == bitMatrix.getWidth() && this.height == bitMatrix.getHeight() && this.rowSize == bitMatrix.getRowSize()) {
            BitArray bitArray;
            BitArray bitArray2 = bitArray;
            bitArray = new BitArray(this.width / 32 + 1);
            for (int i5 = 0; i5 < this.height; ++i5) {
                int n5 = i5;
                int n6 = n5 * this.rowSize;
                int[] nArray = bitMatrix.getRow(n5, bitArray2).getBitArray();
                for (int i6 = 0; i6 < this.rowSize; ++i6) {
                    int n7 = n6 + i6;
                    this.bits[n7] = this.bits[n7] ^ nArray[i6];
                }
            }
            return;
        }
        throw new IllegalArgumentException("input matrix dimensions do not match");
    }

    public void clear() {
        int n5 = this.bits.length;
        for (int i5 = 0; i5 < n5; ++i5) {
            this.bits[i5] = 0;
        }
    }

    public void setRegion(int n5, int n6, int n7, int n8) {
        if (n6 >= 0 && n5 >= 0) {
            if (n8 >= 1 && n7 >= 1) {
                n7 = n5 + n7;
                if ((n8 = n6 + n8) <= this.height && n7 <= this.width) {
                    while (n6 < n8) {
                        int n9 = n6 * this.rowSize;
                        for (int i5 = n5; i5 < n7; ++i5) {
                            int n10 = n9 + i5 / 32;
                            this.bits[n10] = this.bits[n10] | 1 << (i5 & 0x1F);
                        }
                        ++n6;
                    }
                    return;
                }
                throw new IllegalArgumentException("The region must fit inside the matrix");
            }
            throw new IllegalArgumentException("Height and width must be at least 1");
        }
        throw new IllegalArgumentException("Left and top must be nonnegative");
    }

    public BitArray getRow(int n5, BitArray bitArray) {
        if (bitArray != null && bitArray.getSize() >= this.width) {
            bitArray.clear();
        } else {
            BitArray bitArray2;
            bitArray = bitArray2;
            bitArray2 = new BitArray(this.width);
        }
        n5 *= this.rowSize;
        for (int i5 = 0; i5 < this.rowSize; ++i5) {
            bitArray.setBulk(i5 * 32, this.bits[n5 + i5]);
        }
        return bitArray;
    }

    public void setRow(int n5, BitArray bitArray) {
        int n6 = n5;
        BitMatrix bitMatrix = object;
        Object object = bitMatrix.bits;
        n5 = bitMatrix.rowSize;
        int n7 = n6 * n5;
        System.arraycopy(bitArray.getBitArray(), 0, object, n7, n5);
    }

    public void rotate180() {
        BitArray bitArray;
        BitArray bitArray2;
        BitMatrix bitMatrix = this;
        int n5 = bitMatrix.getWidth();
        int n6 = bitMatrix.getHeight();
        BitArray bitArray3 = bitArray2;
        bitArray2 = new BitArray(n5);
        BitArray bitArray4 = bitArray;
        bitArray = new BitArray(n5);
        for (n5 = 0; n5 < (n6 + 1) / 2; ++n5) {
            BitMatrix bitMatrix2 = this;
            bitArray3 = this.getRow(n5, bitArray3);
            int n7 = n6 - 1 - n5;
            bitArray4 = this.getRow(n7, bitArray4);
            bitArray3.reverse();
            bitArray4.reverse();
            bitMatrix2.setRow(n5, bitArray4);
            bitMatrix2.setRow(n7, bitArray3);
        }
    }

    public BitMatrix rotate90() {
        BitMatrix bitMatrix;
        BitMatrix bitMatrix2 = this;
        int n5 = bitMatrix2.getHeight();
        int n6 = bitMatrix2.getWidth();
        BitMatrix bitMatrix3 = bitMatrix;
        bitMatrix = new BitMatrix(n5, n6);
        if (bitMatrix2.width > 0 && this.height > 0) {
            for (n5 = 0; n5 < this.width; ++n5) {
                BitArray bitArray;
                BitArray bitArray2 = bitArray;
                bitArray = new BitArray(this.height);
                for (int i5 = 0; i5 < this.height; ++i5) {
                    if (!this.get(n5, i5)) continue;
                    bitArray2.set(i5);
                }
                bitMatrix3.setRow(this.width - n5 - 1, bitArray2);
            }
            return bitMatrix3;
        }
        return this;
    }

    public int[] getEnclosingRectangle() {
        BitMatrix bitMatrix = this;
        int n5 = bitMatrix.width;
        int n6 = bitMatrix.height;
        int n7 = -1;
        int n8 = -1;
        for (int i5 = 0; i5 < this.height; ++i5) {
            int n9;
            for (int i6 = 0; i6 < (n9 = this.rowSize); ++i6) {
                int n10;
                int n11;
                if ((n9 = this.bits[i5 * n9 + i6]) == 0) continue;
                if (i5 < n6) {
                    n6 = i5;
                }
                if (i5 > n8) {
                    n8 = i5;
                }
                if ((n11 = i6 * 32) < n5) {
                    n10 = 0;
                    while (n9 << 31 - n10 == 0) {
                        ++n10;
                    }
                    if ((n10 = n11 + n10) < n5) {
                        n5 = n10;
                    }
                }
                if (n11 + 31 <= n7) continue;
                n10 = 31;
                while (n9 >>> n10 == 0) {
                    --n10;
                }
                n9 = n11 + n10;
                if (n9 <= n7) continue;
                n7 = n9;
            }
        }
        int n12 = n7 - n5;
        n7 = n8 - n6;
        if (n12 >= 0 && n7 >= 0) {
            return new int[]{n5, n6, n12, n7};
        }
        return null;
    }

    public int[] getTopLeftOnBit() {
        int[] nArray;
        int n5 = 0;
        while (true) {
            nArray = this.bits;
            if (n5 >= this.bits.length || nArray[n5] != 0) break;
            ++n5;
        }
        if (n5 == nArray.length) {
            return null;
        }
        int n6 = n5;
        int n7 = this.rowSize;
        n5 = n6 / n7;
        n7 = n6 % n7 * 32;
        int n8 = nArray[n6];
        int n9 = 0;
        while (n8 << 31 - n9 == 0) {
            ++n9;
        }
        return new int[]{n7 += n9, n5};
    }

    public int[] getBottomRightOnBit() {
        int n5;
        for (n5 = this.bits.length - 1; n5 >= 0 && this.bits[n5] == 0; --n5) {
        }
        if (n5 < 0) {
            return null;
        }
        int n6 = n5;
        int n7 = this.rowSize;
        int n8 = n6 / n7;
        n7 = n6 % n7 * 32;
        n5 = this.bits[n5];
        int n9 = 31;
        while (n5 >>> n9 == 0) {
            --n9;
        }
        return new int[]{n7 += n9, n8};
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getRowSize() {
        return this.rowSize;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BitMatrix)) {
            return false;
        }
        object = (BitMatrix)object;
        return this.width == ((BitMatrix)object).width && this.height == ((BitMatrix)object).height && this.rowSize == ((BitMatrix)object).rowSize && Arrays.equals(this.bits, ((BitMatrix)object).bits);
    }

    public int hashCode() {
        int n5 = this.width;
        return (((n5 * 31 + n5) * 31 + this.height) * 31 + this.rowSize) * 31 + Arrays.hashCode(this.bits);
    }

    public String toString() {
        return this.toString("X ", "  ");
    }

    public String toString(String string2, String string3) {
        return this.toString(string2, string3, "\n");
    }

    @Deprecated
    public String toString(String string2, String string3, String string4) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(this.height * (this.width + 1));
        for (int i5 = 0; i5 < this.height; ++i5) {
            for (int i6 = 0; i6 < this.width; ++i6) {
                String string5 = this.get(i6, i5) ? string2 : string3;
                stringBuilder2.append(string5);
            }
            stringBuilder2.append(string4);
        }
        return stringBuilder2.toString();
    }

    public BitMatrix clone() {
        BitMatrix bitMatrix = object;
        int n5 = bitMatrix.width;
        int n6 = bitMatrix.height;
        int n7 = bitMatrix.rowSize;
        Object object = (int[])((BitMatrix)object).bits.clone();
        return new BitMatrix(n5, n6, n7, (int[])object);
    }
}

