/*
 * Decompiled with CFR 0.152.
 */
package master.flame.danmaku.ui.widget;

import android.graphics.RectF;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import master.flame.danmaku.controller.IDanmakuView;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.IDanmakuIterator;
import master.flame.danmaku.danmaku.model.IDanmakus;
import master.flame.danmaku.danmaku.model.android.Danmakus;

public class DanmakuTouchHelper {
    private final GestureDetector mTouchDelegate;
    private IDanmakuView danmakuView;
    private RectF mDanmakuBounds;
    private final GestureDetector.OnGestureListener mOnGestureListener = new GestureDetector.SimpleOnGestureListener(){

        public boolean onDown(MotionEvent event) {
            IDanmakuView.OnDanmakuClickListener onDanmakuClickListener;
            return DanmakuTouchHelper.this.danmakuView != null && (onDanmakuClickListener = DanmakuTouchHelper.this.danmakuView.getOnDanmakuClickListener()) != null;
        }

        public boolean onSingleTapConfirmed(MotionEvent event) {
            IDanmakus clickDanmakus = DanmakuTouchHelper.this.touchHitDanmaku(event.getX(), event.getY());
            boolean isEventConsumed = false;
            if (null != clickDanmakus && !clickDanmakus.isEmpty()) {
                isEventConsumed = DanmakuTouchHelper.this.performDanmakuClick(clickDanmakus);
            }
            if (!isEventConsumed) {
                isEventConsumed = DanmakuTouchHelper.this.performViewClick();
            }
            return isEventConsumed;
        }
    };

    private DanmakuTouchHelper(IDanmakuView danmakuView) {
        this.danmakuView = danmakuView;
        this.mDanmakuBounds = new RectF();
        this.mTouchDelegate = new GestureDetector(((View)danmakuView).getContext(), this.mOnGestureListener);
    }

    public static synchronized DanmakuTouchHelper instance(IDanmakuView danmakuView) {
        return new DanmakuTouchHelper(danmakuView);
    }

    public boolean onTouchEvent(MotionEvent event) {
        return this.mTouchDelegate.onTouchEvent(event);
    }

    private boolean performDanmakuClick(IDanmakus danmakus) {
        IDanmakuView.OnDanmakuClickListener onDanmakuClickListener = this.danmakuView.getOnDanmakuClickListener();
        if (onDanmakuClickListener != null) {
            return onDanmakuClickListener.onDanmakuClick(danmakus);
        }
        return false;
    }

    private boolean performViewClick() {
        IDanmakuView.OnDanmakuClickListener onDanmakuClickListener = this.danmakuView.getOnDanmakuClickListener();
        if (onDanmakuClickListener != null) {
            return onDanmakuClickListener.onViewClick(this.danmakuView);
        }
        return false;
    }

    private IDanmakus touchHitDanmaku(float x, float y) {
        Danmakus hitDanmakus = new Danmakus();
        this.mDanmakuBounds.setEmpty();
        IDanmakus danmakus = this.danmakuView.getCurrentVisibleDanmakus();
        if (null != danmakus && !danmakus.isEmpty()) {
            IDanmakuIterator iterator = danmakus.iterator();
            while (iterator.hasNext()) {
                BaseDanmaku danmaku = iterator.next();
                if (null == danmaku) continue;
                this.mDanmakuBounds.set(danmaku.getLeft(), danmaku.getTop(), danmaku.getRight(), danmaku.getBottom());
                if (!this.mDanmakuBounds.contains(x, y)) continue;
                hitDanmakus.addItem(danmaku);
            }
        }
        return hitDanmakus;
    }
}

