/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.tracing;

import android.os.Looper;
import android.util.SparseArray;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.adapter.ITracingAdapter;
import com.taobao.weex.utils.WXLogUtils;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public class WXTracing {
    private static final AtomicInteger sIdGenerator = new AtomicInteger(0);

    public static int nextId() {
        return sIdGenerator.getAndIncrement();
    }

    public static boolean isAvailable() {
        return WXEnvironment.isApkDebugable();
    }

    public static synchronized void submit(TraceEvent traceEvent) {
        ITracingAdapter iTracingAdapter = WXSDKManager.getInstance().getTracingAdapter();
        if (iTracingAdapter != null) {
            iTracingAdapter.submitTracingEvent(traceEvent);
            return;
        }
    }

    public static String currentThreadName() {
        String string2 = Thread.currentThread().getName();
        if ("WeexJSBridgeThread".equals(string2)) {
            return "JSThread";
        }
        if ("WeeXDomThread".equals(string2)) {
            return "DOMThread";
        }
        if (Looper.getMainLooper() == Looper.myLooper()) {
            return "UIThread";
        }
        return string2;
    }

    public static TraceEvent newEvent(String string2, String string3, int n) {
        TraceEvent traceEvent;
        TraceEvent traceEvent2;
        TraceEvent traceEvent3 = traceEvent2 = traceEvent;
        traceEvent2();
        traceEvent2.fname = string2;
        traceEvent3.iid = string3;
        traceEvent3.traceId = WXTracing.nextId();
        traceEvent.parentId = n;
        return traceEvent;
    }

    public static class TraceEvent {
        public String fname;
        public String tname;
        public String ph;
        public int traceId;
        public long ts = System.currentTimeMillis();
        public String iid;
        public String ref;
        public String parentRef;
        public String name;
        public String classname;
        public int parentId = -1;
        public double duration;
        public SparseArray<TraceEvent> subEvents;
        public String payload;
        public double parseJsonTime;
        public boolean isSegment;
        public Map<String, Object> extParams;
        public boolean firstScreenFinish;
        private boolean submitted;

        public TraceEvent() {
            this.traceId = WXTracing.nextId();
            this.tname = WXTracing.currentThreadName();
        }

        public void submit() {
            if (!this.submitted) {
                this.submitted = true;
                WXTracing.submit(this);
                return;
            }
            WXLogUtils.w("WXTracing", "Event " + this.traceId + " has been submitted.");
        }
    }

    public static class TraceInfo {
        public int rootEventId;
        public long domQueueTime;
        public long uiQueueTime;
        public long domThreadStart = -1L;
        public long domThreadNanos;
        public long uiThreadStart = -1L;
        public long uiThreadNanos;
    }
}

