/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.animation;

import android.animation.PropertyValuesHolder;
import android.text.TextUtils;
import android.util.Pair;
import android.util.Property;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArrayMap;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.ui.animation.CameraDistanceProperty;
import com.taobao.weex.ui.animation.TransformParser;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class WXAnimationBean {
    public static final String LINEAR = "linear";
    public static final String EASE_IN_OUT = "ease-in-out";
    public static final String EASE_IN = "ease-in";
    public static final String EASE_OUT = "ease-out";
    public static final String CUBIC_BEZIER = "cubic-bezier";
    public static final int NUM_CUBIC_PARAM = 4;
    public long delay;
    public long duration;
    public String timingFunction;
    @Nullable
    public Style styles;
    public boolean needLayout;

    public static class Style {
        public static final String WX_TRANSLATE = "translate";
        public static final String WX_TRANSLATE_X = "translateX";
        public static final String WX_TRANSLATE_Y = "translateY";
        public static final String WX_ROTATE = "rotate";
        public static final String WX_SCALE_X = "scaleX";
        public static final String WX_SCALE_Y = "scaleY";
        public static final String WX_SCALE = "scale";
        public static final String WX_ROTATE_X = "rotateX";
        public static final String WX_ROTATE_Y = "rotateY";
        public static final String BACKGROUND_COLOR = "backgroundColor";
        public static final String WIDTH = "width";
        public static final String HEIGHT = "height";
        public static final String TOP = "top";
        public static final String BOTTOM = "bottom";
        public static final String RIGHT = "right";
        public static final String LEFT = "left";
        public static final String CENTER = "center";
        private static final String HALF = "50%";
        private static final String FULL = "100%";
        private static final String ZERO = "0%";
        private static final String PX = "px";
        private static final String DEG = "deg";
        public static Map<String, List<Property<View, Float>>> wxToAndroidMap = new ArrayMap();
        private static Map<Property<View, Float>, Float> defaultMap = new ArrayMap();
        public String opacity;
        public String backgroundColor;
        public String width;
        public String height;
        public String transform;
        public String transformOrigin;
        private Map<Property<View, Float>, Float> transformMap;
        private Pair<Float, Float> pivot;
        private List<PropertyValuesHolder> holders;
        private float cameraDistance;

        public Style() {
            LinkedList linkedList;
            LinkedHashMap linkedHashMap;
            Object object = linkedHashMap;
            linkedHashMap = new LinkedHashMap();
            v1.transformMap = object;
            object = linkedList;
            linkedList = new LinkedList();
            v1.holders = object;
            v1.cameraDistance = Float.MAX_VALUE;
        }

        private static Pair<Float, Float> parsePivot(@Nullable String string2, int n, int n2, float f) {
            int n3;
            if (!TextUtils.isEmpty((CharSequence)string2) && (n3 = string2.indexOf(32)) != -1) {
                int n4;
                for (n4 = n3; n4 < string2.length() && string2.charAt(n4) == ' '; ++n4) {
                }
                if (n4 < string2.length() && string2.charAt(n4) != ' ') {
                    ArrayList<String> arrayList;
                    ArrayList<String> arrayList2 = arrayList;
                    arrayList2(2);
                    arrayList2.add(string2.substring(0, n3).trim());
                    arrayList2.add(string2.substring(n4, string2.length()).trim());
                    return Style.parsePivot(arrayList, n, n2, f);
                }
            }
            return null;
        }

        private static Pair<Float, Float> parsePivot(@NonNull List<String> object, int n, int n2, float f) {
            List<String> list = object;
            object = Float.valueOf(Style.parsePivotX(list.get(0), n, f));
            return new Pair(object, (Object)Float.valueOf(Style.parsePivotY(list.get(1), n2, f)));
        }

        private static float parsePivotX(String string2, int n, float f) {
            if (LEFT.equals(string2)) {
                string2 = ZERO;
            } else if (RIGHT.equals(string2)) {
                string2 = FULL;
            } else if (CENTER.equals(string2)) {
                string2 = HALF;
            }
            return Style.parsePercentOrPx(string2, n, f);
        }

        private static float parsePivotY(String string2, int n, float f) {
            if (TOP.equals(string2)) {
                string2 = ZERO;
            } else if (BOTTOM.equals(string2)) {
                string2 = FULL;
            } else if (CENTER.equals(string2)) {
                string2 = HALF;
            }
            return Style.parsePercentOrPx(string2, n, f);
        }

        private static float parsePercentOrPx(String string2, int n, float f) {
            int n2 = string2.lastIndexOf(37);
            if (n2 != -1) {
                return Style.parsePercent(string2.substring(0, n2), n, 1.0f);
            }
            n = string2.lastIndexOf(PX);
            if (n != -1) {
                return WXViewUtils.getRealPxByWidth(WXUtils.fastGetFloat(string2.substring(0, n), 1.0f), f);
            }
            return WXViewUtils.getRealPxByWidth(WXUtils.fastGetFloat(string2, 1.0f), f);
        }

        private static float parsePercent(String string2, int n, float f) {
            return WXUtils.fastGetFloat(string2, f) / 100.0f * (float)n;
        }

        private void resetToDefaultIfAbsent() {
            for (Map.Entry<Property<View, Float>, Float> entry : defaultMap.entrySet()) {
                if (this.transformMap.containsKey(entry.getKey())) continue;
                this.transformMap.put(entry.getKey(), entry.getValue());
            }
        }

        private void initHolders() {
            for (Map.Entry<Property<View, Float>, Float> entry : this.transformMap.entrySet()) {
                float f = entry.getValue().floatValue();
                this.holders.add(PropertyValuesHolder.ofFloat(entry.getKey(), (float[])new float[]{f}));
            }
            if (!TextUtils.isEmpty((CharSequence)this.opacity)) {
                float f = WXUtils.fastGetFloat(this.opacity, 3.0f);
                this.holders.add(PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{f}));
                return;
            }
        }

        static {
            Property property = View.TRANSLATION_X;
            Property property2 = View.TRANSLATION_Y;
            wxToAndroidMap.put(WX_TRANSLATE, Arrays.asList(property, property2));
            wxToAndroidMap.put(WX_TRANSLATE_X, Collections.singletonList(property));
            wxToAndroidMap.put(WX_TRANSLATE_Y, Collections.singletonList(property2));
            Property property3 = View.ROTATION;
            wxToAndroidMap.put(WX_ROTATE, Collections.singletonList(property3));
            Property property4 = View.ROTATION_X;
            wxToAndroidMap.put(WX_ROTATE_X, Collections.singletonList(property4));
            Property property5 = View.ROTATION_Y;
            wxToAndroidMap.put(WX_ROTATE_Y, Collections.singletonList(property5));
            Property property6 = View.SCALE_X;
            Property property7 = View.SCALE_Y;
            wxToAndroidMap.put(WX_SCALE, Arrays.asList(property6, property7));
            wxToAndroidMap.put(WX_SCALE_X, Collections.singletonList(property6));
            wxToAndroidMap.put(WX_SCALE_Y, Collections.singletonList(property7));
            wxToAndroidMap.put("perspective", Collections.singletonList(CameraDistanceProperty.getInstance()));
            wxToAndroidMap = Collections.unmodifiableMap(wxToAndroidMap);
            defaultMap.put((Property<View, Float>)property, Float.valueOf(0.0f));
            defaultMap.put((Property<View, Float>)property2, Float.valueOf(0.0f));
            defaultMap.put((Property<View, Float>)property6, Float.valueOf(1.0f));
            defaultMap.put((Property<View, Float>)property7, Float.valueOf(1.0f));
            defaultMap.put((Property<View, Float>)property3, Float.valueOf(0.0f));
            defaultMap.put((Property<View, Float>)property4, Float.valueOf(0.0f));
            defaultMap.put((Property<View, Float>)property5, Float.valueOf(0.0f));
        }

        @Nullable
        public Pair<Float, Float> getPivot() {
            return this.pivot;
        }

        public void init(@Nullable String string2, @Nullable String string3, int n, int n2, float f, WXSDKInstance wXSDKInstance) {
            Style style = this;
            style.pivot = Style.parsePivot(string2, n, n2, f);
            style.transformMap.putAll(TransformParser.parseTransForm(wXSDKInstance.getInstanceId(), string3, n, n2, f));
            style.resetToDefaultIfAbsent();
            if (style.transformMap.containsKey(CameraDistanceProperty.getInstance())) {
                this.cameraDistance = this.transformMap.remove(CameraDistanceProperty.getInstance()).floatValue();
            }
            this.initHolders();
        }

        public void init(@NonNull Map<Property<View, Float>, Pair<Float, Float>> object) {
            object = object.entrySet().iterator();
            while (object.hasNext()) {
                Map.Entry entry;
                Map.Entry entry2 = entry = (Map.Entry)object.next();
                float f = ((Float)((Pair)entry2.getValue()).first).floatValue();
                float f2 = ((Float)((Pair)entry2.getValue()).second).floatValue();
                this.holders.add(PropertyValuesHolder.ofFloat((Property)((Property)entry.getKey()), (float[])new float[]{f, f2}));
            }
        }

        public List<PropertyValuesHolder> getHolders() {
            return this.holders;
        }

        public float getCameraDistance() {
            return this.cameraDistance;
        }
    }
}

