/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.ui.view.refresh.circlebar;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.Transformation;
import androidx.annotation.NonNull;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;

class MaterialProgressDrawable
extends Drawable
implements Animatable {
    private static final Interpolator LINEAR_INTERPOLATOR = new LinearInterpolator();
    private static final Interpolator MATERIAL_INTERPOLATOR = new FastOutSlowInInterpolator();
    private static final float FULL_ROTATION = 1080.0f;
    static final int LARGE = 0;
    static final int DEFAULT = 1;
    private static final int CIRCLE_DIAMETER = 40;
    private static final float CENTER_RADIUS = 15.5f;
    private static final float STROKE_WIDTH = 2.5f;
    private static final int CIRCLE_DIAMETER_LARGE = 56;
    private static final float CENTER_RADIUS_LARGE = 12.5f;
    private static final float STROKE_WIDTH_LARGE = 3.0f;
    private static final float COLOR_START_DELAY_OFFSET = 0.75f;
    private static final float END_TRIM_START_DELAY_OFFSET = 0.5f;
    private static final float START_TRIM_DURATION_OFFSET = 0.5f;
    private static final int ANIMATION_DURATION = 1332;
    private static final float NUM_POINTS = 5.0f;
    private static final int ARROW_WIDTH = 10;
    private static final int ARROW_HEIGHT = 5;
    private static final float ARROW_OFFSET_ANGLE = 5.0f;
    private static final int ARROW_WIDTH_LARGE = 12;
    private static final int ARROW_HEIGHT_LARGE = 6;
    private static final float MAX_PROGRESS_ARC = 0.8f;
    private final int[] COLORS;
    private final ArrayList<Animation> mAnimators;
    private final Ring mRing;
    private float mRotation;
    private Resources mResources;
    private View mParent;
    private Animation mAnimation;
    private float mRotationCount;
    private double mWidth;
    private double mHeight;
    boolean mFinishing;
    private final Drawable.Callback mCallback;

    public MaterialProgressDrawable(Context object, View object2) {
        Ring ring;
        Ring ring2;
        Drawable.Callback callback;
        MaterialProgressDrawable materialProgressDrawable = this;
        Context context = object;
        View view = object2;
        int[] nArray = new int[1];
        object = nArray;
        nArray[0] = -16777216;
        this.COLORS = nArray;
        this.mAnimators = new ArrayList();
        object2 = callback;
        this.mCallback = new Drawable.Callback(){

            public void invalidateDrawable(Drawable drawable2) {
                MaterialProgressDrawable.this.invalidateSelf();
            }

            public void scheduleDrawable(Drawable drawable2, Runnable runnable, long l) {
                MaterialProgressDrawable.this.scheduleSelf(runnable, l);
            }

            public void unscheduleDrawable(Drawable drawable2, Runnable runnable) {
                MaterialProgressDrawable.this.unscheduleSelf(runnable);
            }
        };
        this.mParent = view;
        materialProgressDrawable.mResources = context.getResources();
        Ring ring3 = ring2 = ring;
        ring3((Drawable.Callback)object2);
        this.mRing = ring3;
        ring.setColors((int[])object);
        materialProgressDrawable.updateSizes(1);
        materialProgressDrawable.setupAnimators();
    }

    private void setSizeParameters(double d, double d2, double d3, double d4, float f, float f2) {
        Ring ring;
        Ring ring2 = ring = this.mRing;
        float f3 = this.mResources.getDisplayMetrics().density;
        double d5 = f3;
        this.mWidth = d * d5;
        this.mHeight = d2 * d5;
        ring.setStrokeWidth((float)d4 * f3);
        ring2.setCenterRadius(d3 * d5);
        ring2.setColorIndex(0);
        float f4 = f * f3;
        ring.setArrowDimensions(f4, f2 * f3);
        ring.setInsets((int)this.mWidth, (int)this.mHeight);
    }

    private float getRotation() {
        return this.mRotation;
    }

    private float getMinProgressArc(Ring ring) {
        return (float)Math.toRadians((double)ring.getStrokeWidth() / (ring.getCenterRadius() * (Math.PI * 2)));
    }

    private int evaluateColorChange(float f, int n, int n2) {
        int n3 = n >> 24 & 0xFF;
        int n4 = n3;
        int n5 = n;
        n = n5 >> 16 & 0xFF;
        int n6 = n5 >> 8 & 0xFF;
        int n7 = n5 & 0xFF;
        int n8 = n2 >> 24 & 0xFF;
        int n9 = n4;
        int n10 = n2;
        n4 = n10 >> 16 & 0xFF;
        n2 = n10 >> 8 & 0xFF;
        int n11 = n10 & 0xFF;
        return n3 + (int)(f * (float)(n8 - n9)) << 24 | n + (int)(f * (float)(n4 - n)) << 16 | n6 + (int)(f * (float)(n2 - n6)) << 8 | n7 + (int)(f * (float)(n11 - n7));
    }

    private void updateRingColor(float f, Ring ring) {
        if (f > 0.75f) {
            Ring ring2 = ring;
            float f2 = (f - 0.75f) / 0.25f;
            int n = ring2.getStartingColor();
            int n2 = ring2.getNextColor();
            ring.setColor(this.evaluateColorChange(f2, n, n2));
            return;
        }
    }

    private void applyFinishTranslation(float f, Ring ring) {
        Ring ring2 = ring;
        Ring ring3 = ring;
        this.updateRingColor(f, ring);
        float f2 = (float)(Math.floor(ring3.getStartingRotation() / 0.8f) + 1.0);
        float f3 = this.getMinProgressArc(ring3);
        ring2.setStartTrim(ring2.getStartingStartTrim() + (ring.getStartingEndTrim() - f3 - ring.getStartingStartTrim()) * f);
        ring2.setEndTrim(ring2.getStartingEndTrim());
        ring2.setRotation(ring2.getStartingRotation() + (f2 - ring.getStartingRotation()) * f);
    }

    private void setupAnimators() {
        final Ring ring = this.mRing;
        Animation animation = new Animation(){

            public void applyTransformation(float f, Transformation object) {
                object = MaterialProgressDrawable.this;
                if (object.mFinishing) {
                    ((MaterialProgressDrawable)((Object)object)).applyFinishTranslation(f, ring);
                    return;
                }
                1 v0 = this;
                float f2 = ((MaterialProgressDrawable)((Object)object)).getMinProgressArc(ring);
                float f3 = v0.ring.getStartingEndTrim();
                float f4 = v0.ring.getStartingStartTrim();
                float f5 = v0.ring.getStartingRotation();
                v0.MaterialProgressDrawable.this.updateRingColor(f, ring);
                if (f <= 0.5f) {
                    float f6 = f4;
                    f4 = f / 0.5f;
                    f4 = f6 + (0.8f - f2) * MATERIAL_INTERPOLATOR.getInterpolation(f4);
                    ring.setStartTrim(f4);
                }
                if (f > 0.5f) {
                    f2 = f3 + (0.8f - f2) * MATERIAL_INTERPOLATOR.getInterpolation((f - 0.5f) / 0.5f);
                    ring.setEndTrim(f2);
                }
                float f7 = f;
                f = f5 + f * 0.25f;
                ring.setRotation(f);
                float f8 = f7 * 216.0f + MaterialProgressDrawable.this.mRotationCount / 5.0f * 1080.0f;
                MaterialProgressDrawable.this.setRotation(f8);
            }
        };
        animation.setRepeatCount(-1);
        animation.setRepeatMode(1);
        animation.setInterpolator(LINEAR_INTERPOLATOR);
        animation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
                MaterialProgressDrawable.access$402(MaterialProgressDrawable.this, 0.0f);
            }

            public void onAnimationEnd(Animation animation) {
            }

            public void onAnimationRepeat(Animation animation) {
                2 v0 = this;
                v0.ring.storeOriginals();
                v0.ring.goToNextColor();
                Ring ring2 = v0.ring;
                ring2.setStartTrim(ring2.getEndTrim());
                MaterialProgressDrawable materialProgressDrawable = v0.MaterialProgressDrawable.this;
                if (materialProgressDrawable.mFinishing) {
                    materialProgressDrawable.mFinishing = false;
                    animation.setDuration(1332L);
                    ring.setShowArrow(false);
                    return;
                }
                MaterialProgressDrawable materialProgressDrawable2 = materialProgressDrawable;
                MaterialProgressDrawable.access$402(materialProgressDrawable2, (materialProgressDrawable2.mRotationCount + 1.0f) % 5.0f);
            }
        });
        this.mAnimation = animation;
    }

    static /* synthetic */ float access$402(MaterialProgressDrawable materialProgressDrawable, float f) {
        materialProgressDrawable.mRotationCount = f;
        return f;
    }

    public void updateSizes(@ProgressDrawableSize int n) {
        if (n == 0) {
            this.setSizeParameters(56.0, 56.0, 12.5, 3.0, 12.0f, 6.0f);
            return;
        }
        this.setSizeParameters(40.0, 40.0, 15.5, 2.5, 10.0f, 5.0f);
    }

    public void showArrow(boolean bl) {
        this.mRing.setShowArrow(bl);
    }

    public void setArrowScale(float f) {
        this.mRing.setArrowScale(f);
    }

    public void setStartEndTrim(float f, float f2) {
        MaterialProgressDrawable materialProgressDrawable = this;
        materialProgressDrawable.mRing.setStartTrim(f);
        materialProgressDrawable.mRing.setEndTrim(f2);
    }

    public void setProgressRotation(float f) {
        this.mRing.setRotation(f);
    }

    public void setBackgroundColor(int n) {
        this.mRing.setBackgroundColor(n);
    }

    public void setColorSchemeColors(int ... nArray) {
        MaterialProgressDrawable materialProgressDrawable = this;
        materialProgressDrawable.mRing.setColors(nArray);
        materialProgressDrawable.mRing.setColorIndex(0);
    }

    public int getIntrinsicHeight() {
        return (int)this.mHeight;
    }

    public int getIntrinsicWidth() {
        return (int)this.mWidth;
    }

    public void draw(Canvas canvas) {
        Canvas canvas2 = canvas;
        Rect rect = this.getBounds();
        int n = canvas.save();
        float f = this.mRotation;
        float f2 = rect.exactCenterX();
        float f3 = rect.exactCenterY();
        canvas2.rotate(f, f2, f3);
        this.mRing.draw(canvas, rect);
        canvas2.restoreToCount(n);
    }

    public void setAlpha(int n) {
        this.mRing.setAlpha(n);
    }

    public int getAlpha() {
        return this.mRing.getAlpha();
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.mRing.setColorFilter(colorFilter);
    }

    void setRotation(float f) {
        this.mRotation = f;
        this.invalidateSelf();
    }

    public int getOpacity() {
        return -3;
    }

    public boolean isRunning() {
        ArrayList<Animation> arrayList = ((MaterialProgressDrawable)((Object)arrayList)).mAnimators;
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            Animation animation = (Animation)arrayList.get(i);
            if (!animation.hasStarted() || animation.hasEnded()) continue;
            return true;
        }
        return false;
    }

    public void start() {
        MaterialProgressDrawable materialProgressDrawable = this;
        materialProgressDrawable.mAnimation.reset();
        materialProgressDrawable.mRing.storeOriginals();
        if (materialProgressDrawable.mRing.getEndTrim() != this.mRing.getStartTrim()) {
            MaterialProgressDrawable materialProgressDrawable2 = this;
            materialProgressDrawable2.mFinishing = true;
            materialProgressDrawable2.mAnimation.setDuration(666L);
            materialProgressDrawable2.mParent.startAnimation(this.mAnimation);
            return;
        }
        MaterialProgressDrawable materialProgressDrawable3 = this;
        materialProgressDrawable3.mRing.setColorIndex(0);
        materialProgressDrawable3.mRing.resetOriginals();
        materialProgressDrawable3.mAnimation.setDuration(1332L);
        materialProgressDrawable3.mParent.startAnimation(this.mAnimation);
    }

    public void stop() {
        MaterialProgressDrawable materialProgressDrawable = this;
        materialProgressDrawable.mParent.clearAnimation();
        materialProgressDrawable.setRotation(0.0f);
        materialProgressDrawable.mRing.setShowArrow(false);
        materialProgressDrawable.mRing.setColorIndex(0);
        materialProgressDrawable.mRing.resetOriginals();
    }

    private static class Ring {
        private final RectF mTempBounds = new RectF();
        private final Paint mPaint;
        private final Paint mArrowPaint;
        private final Drawable.Callback mCallback;
        private float mStartTrim;
        private float mEndTrim;
        private float mRotation;
        private float mStrokeWidth;
        private float mStrokeInset;
        private int[] mColors;
        private int mColorIndex;
        private float mStartingStartTrim;
        private float mStartingEndTrim;
        private float mStartingRotation;
        private boolean mShowArrow;
        private Path mArrow;
        private float mArrowScale;
        private double mRingCenterRadius;
        private int mArrowWidth;
        private int mArrowHeight;
        private int mAlpha;
        private final Paint mCirclePaint;
        private int mBackgroundColor;
        private int mCurrentColor;

        public Ring(Drawable.Callback callback) {
            Paint paint;
            Paint paint2;
            Paint paint3 = paint2;
            this.mPaint = new Paint();
            Paint paint4 = paint;
            Paint paint5 = paint3;
            Ring ring = this;
            Paint paint6 = paint4;
            paint6();
            ring.mArrowPaint = paint6;
            ring.mStartTrim = 0.0f;
            ring.mEndTrim = 0.0f;
            ring.mRotation = 0.0f;
            ring.mStrokeWidth = 5.0f;
            ring.mStrokeInset = 2.5f;
            ring.mCirclePaint = new Paint(1);
            this.mCallback = callback;
            paint5.setStrokeCap(Paint.Cap.SQUARE);
            paint5.setAntiAlias(true);
            paint5.setStyle(Paint.Style.STROKE);
            paint.setStyle(Paint.Style.FILL);
            paint.setAntiAlias(true);
        }

        private void drawTriangle(Canvas canvas, float f, float f2, Rect rect) {
            if (this.mShowArrow) {
                Path path = this.mArrow;
                if (path == null) {
                    this.mArrow = new Path();
                    this.mArrow.setFillType(Path.FillType.EVEN_ODD);
                } else {
                    path.reset();
                }
                Ring ring = this;
                Rect rect2 = rect;
                float f3 = f;
                float f4 = f2;
                Ring ring2 = this;
                float f5 = (float)(ring2.mRingCenterRadius * Math.cos(0.0) + (double)rect.exactCenterX());
                f = (float)(ring2.mRingCenterRadius * Math.sin(0.0) + (double)rect.exactCenterY());
                ring2.mArrow.moveTo(0.0f, 0.0f);
                ring2.mArrow.lineTo((float)this.mArrowWidth * this.mArrowScale, 0.0f);
                f2 = this.mArrowScale;
                ring2.mArrow.lineTo((float)this.mArrowWidth * f2 / 2.0f, (float)this.mArrowHeight * f2);
                ring2.mArrow.offset(f5 - (float)(this.mArrowWidth / 2), f);
                ring2.mArrow.close();
                ring2.mArrowPaint.setColor(this.mCurrentColor);
                float f6 = f3 + f4 - 5.0f;
                f5 = rect2.exactCenterX();
                f = rect2.exactCenterY();
                canvas.rotate(f6, f5, f);
                Path path2 = ring.mArrow;
                canvas.drawPath(path2, ring.mArrowPaint);
                return;
            }
        }

        private int getNextColorIndex() {
            return (this.mColorIndex + 1) % this.mColors.length;
        }

        private void invalidateSelf() {
            this.mCallback.invalidateDrawable(null);
        }

        public void setBackgroundColor(int n) {
            this.mBackgroundColor = n;
        }

        public void setArrowDimensions(float f, float f2) {
            this.mArrowWidth = (int)f;
            this.mArrowHeight = (int)f2;
        }

        public void draw(Canvas canvas, Rect rect) {
            Ring ring = this;
            Canvas canvas2 = canvas;
            Ring ring2 = this;
            RectF rectF = ring2.mTempBounds;
            rectF.set(rect);
            float f = this.mStrokeInset;
            rectF.inset(f, f);
            float f2 = this.mRotation;
            float f3 = (ring2.mStartTrim + f2) * 360.0f;
            f2 = (ring2.mEndTrim + f2) * 360.0f - f3;
            ring2.mPaint.setColor(this.mCurrentColor);
            Paint paint = ring2.mPaint;
            canvas2.drawArc(rectF, f3, f2, false, paint);
            ring.drawTriangle(canvas2, f3, f2, rect);
            if (ring.mAlpha < 255) {
                Rect rect2 = rect;
                Ring ring3 = this;
                ring3.mCirclePaint.setColor(this.mBackgroundColor);
                ring3.mCirclePaint.setAlpha(255 - this.mAlpha);
                float f4 = rect2.exactCenterX();
                float f5 = rect2.exactCenterY();
                float f6 = rect2.width() / 2;
                rectF = this.mCirclePaint;
                canvas.drawCircle(f4, f5, f6, (Paint)rectF);
                return;
            }
        }

        public void setColors(@NonNull int[] nArray) {
            this.mColors = nArray;
            this.setColorIndex(0);
        }

        public void setColor(int n) {
            this.mCurrentColor = n;
        }

        public void setColorIndex(int n) {
            this.mColorIndex = n;
            this.mCurrentColor = this.mColors[n];
        }

        public int getNextColor() {
            return this.mColors[this.getNextColorIndex()];
        }

        public void goToNextColor() {
            Ring ring = this;
            ring.setColorIndex(ring.getNextColorIndex());
        }

        public void setColorFilter(ColorFilter colorFilter) {
            Ring ring = this;
            ring.mPaint.setColorFilter(colorFilter);
            ring.invalidateSelf();
        }

        public void setAlpha(int n) {
            this.mAlpha = n;
        }

        public int getAlpha() {
            return this.mAlpha;
        }

        public void setStrokeWidth(float f) {
            Ring ring = this;
            ring.mStrokeWidth = f;
            ring.mPaint.setStrokeWidth(f);
            ring.invalidateSelf();
        }

        public float getStrokeWidth() {
            return this.mStrokeWidth;
        }

        public void setStartTrim(float f) {
            this.mStartTrim = f;
            this.invalidateSelf();
        }

        public float getStartTrim() {
            return this.mStartTrim;
        }

        public float getStartingStartTrim() {
            return this.mStartingStartTrim;
        }

        public float getStartingEndTrim() {
            return this.mStartingEndTrim;
        }

        public int getStartingColor() {
            return this.mColors[this.mColorIndex];
        }

        public void setEndTrim(float f) {
            this.mEndTrim = f;
            this.invalidateSelf();
        }

        public float getEndTrim() {
            return this.mEndTrim;
        }

        public void setRotation(float f) {
            this.mRotation = f;
            this.invalidateSelf();
        }

        public float getRotation() {
            return this.mRotation;
        }

        public void setInsets(int n, int n2) {
            float f = Math.min(n, n2);
            double d = this.mRingCenterRadius;
            f = !(d <= 0.0) && !(f < 0.0f) ? (float)((double)(f / 2.0f) - d) : (float)Math.ceil(this.mStrokeWidth / 2.0f);
            this.mStrokeInset = f;
        }

        public float getInsets() {
            return this.mStrokeInset;
        }

        public void setCenterRadius(double d) {
            this.mRingCenterRadius = d;
        }

        public double getCenterRadius() {
            return this.mRingCenterRadius;
        }

        public void setShowArrow(boolean bl) {
            if (this.mShowArrow != bl) {
                this.mShowArrow = bl;
                this.invalidateSelf();
                return;
            }
        }

        public void setArrowScale(float f) {
            if (f != this.mArrowScale) {
                this.mArrowScale = f;
                this.invalidateSelf();
                return;
            }
        }

        public float getStartingRotation() {
            return this.mStartingRotation;
        }

        public void storeOriginals() {
            Ring ring = this;
            ring.mStartingStartTrim = ring.mStartTrim;
            ring.mStartingEndTrim = ring.mEndTrim;
            ring.mStartingRotation = ring.mRotation;
        }

        public void resetOriginals() {
            Ring ring = this;
            ring.mStartingStartTrim = 0.0f;
            ring.mStartingEndTrim = 0.0f;
            ring.mStartingRotation = 0.0f;
            ring.setStartTrim(0.0f);
            ring.setEndTrim(0.0f);
            ring.setRotation(0.0f);
        }
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface ProgressDrawableSize {
    }
}

