/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.weex.utils;

import android.content.Context;
import android.graphics.Typeface;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Base64;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.utils.WXFileUtils;
import com.taobao.weex.utils.WXLogUtils;
import java.io.File;

public class FontDO {
    public static final int STATE_INVALID = -1;
    public static final int STATE_INIT = 0;
    public static final int STATE_LOADING = 1;
    public static final int STATE_SUCCESS = 2;
    public static final int STATE_FAILED = 3;
    public static final int TYPE_UNKNOWN = 0;
    public static final int TYPE_NETWORK = 1;
    public static final int TYPE_FILE = 2;
    public static final int TYPE_LOCAL = 3;
    public static final int TYPE_NATIVE = 4;
    public static final int TYPE_BASE64 = 5;
    private final String mFontFamilyName;
    private String mUrl;
    private String mFilePath;
    private int mType;
    private Typeface mTypeface;
    private int mState;

    public FontDO(String string2, String string3, WXSDKInstance wXSDKInstance) {
        FontDO fontDO = this;
        fontDO.mUrl = "";
        fontDO.mType = 1;
        fontDO.mState = -1;
        fontDO.mFontFamilyName = string2;
        fontDO.parseSrc(string3, wXSDKInstance);
    }

    public FontDO(String string2, Typeface typeface) {
        this.mUrl = "";
        this.mFontFamilyName = string2;
        this.mTypeface = typeface;
        this.mType = 4;
        this.mState = 2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseSrc(String string2, WXSDKInstance object) {
        block24: {
            block22: {
                Exception exception2;
                block23: {
                    block18: {
                        block17: {
                            block19: {
                                File file;
                                long l;
                                block21: {
                                    File file2;
                                    File file3;
                                    Object object2;
                                    block20: {
                                        File file4;
                                        String string3;
                                        string2 = string2 != null ? string2.trim() : "";
                                        if (object != null && ((WXSDKInstance)object).getCustomFontNetworkHandler() != null && !TextUtils.isEmpty((CharSequence)(string3 = ((WXSDKInstance)object).getCustomFontNetworkHandler().fetchLocal(string2)))) {
                                            string2 = string3;
                                        }
                                        if (string2.isEmpty()) {
                                            this.mState = -1;
                                            WXLogUtils.e("TypefaceUtil", "font src is empty.");
                                            return;
                                        }
                                        if (!string2.matches("^url\\((('.*')|(\".*\"))\\)$")) break block22;
                                        String string4 = string2;
                                        string3 = Uri.parse((String)string4.substring(5, string4.length() - 2));
                                        if (object != null) {
                                            string3 = ((WXSDKInstance)object).rewriteUri((Uri)string3, "font");
                                        }
                                        this.mUrl = string3.toString();
                                        try {
                                            object = string3.getScheme();
                                            if ("http".equals(object) || "https".equals(object)) break block17;
                                            if ("file".equals(object)) {
                                                this.mType = 2;
                                                this.mUrl = string3.getEncodedSchemeSpecificPart();
                                                break block18;
                                            }
                                            if ("local".equals(object)) {
                                                this.mType = 3;
                                                break block18;
                                            }
                                            if (!"data".equals(object)) break block19;
                                            l = System.currentTimeMillis();
                                            object = this.mUrl.split(",");
                                            if (object == null || ((Object)object).length != 2 || TextUtils.isEmpty((CharSequence)(object2 = object[0])) || !((String)object2).endsWith("base64")) break block18;
                                            object = object[1];
                                        }
                                        catch (Exception exception2) {}
                                        if (TextUtils.isEmpty((CharSequence)object)) break block18;
                                        object2 = WXFileUtils.md5((String)object);
                                        file3 = file4;
                                        if (new File(WXEnvironment.getApplication().getCacheDir(), "font-family").exists()) break block20;
                                        file3.mkdirs();
                                    }
                                    file = file2;
                                    if (new File(file3, (String)object2).exists()) break block21;
                                    File file5 = file;
                                    File file6 = file5;
                                    file5.createNewFile();
                                    WXFileUtils.saveFile(file6.getPath(), Base64.decode((String)object, (int)0), (Context)WXEnvironment.getApplication());
                                }
                                FontDO fontDO = this;
                                fontDO.mUrl = file.getPath();
                                fontDO.mType = 5;
                                String string5 = "TypefaceUtil";
                                StringBuilder stringBuilder = new StringBuilder().append("Parse base64 font cost ");
                                long l2 = System.currentTimeMillis();
                                WXLogUtils.d(string5, stringBuilder.append(l2 - l).append(" ms").toString());
                                break block18;
                                break block23;
                            }
                            WXLogUtils.e("TypefaceUtil", "Unknown scheme for font url: " + this.mUrl);
                            this.mType = 0;
                            break block18;
                        }
                        this.mType = 1;
                    }
                    this.mState = 0;
                    break block24;
                }
                this.mType = -1;
                WXLogUtils.e("TypefaceUtil", "URI.create(mUrl) failed mUrl: " + this.mUrl + "\n" + WXLogUtils.getStackTrace(exception2));
                break block24;
            }
            FontDO fontDO = this;
            fontDO.mUrl = string2;
            fontDO.mState = -1;
        }
        if (WXEnvironment.isApkDebugable()) {
            WXLogUtils.d("TypefaceUtil", "src:" + string2 + ", mUrl:" + this.mUrl + ", mType:" + this.mType);
        }
    }

    public String getFontFamilyName() {
        return this.mFontFamilyName;
    }

    public String getUrl() {
        return this.mUrl;
    }

    public int getType() {
        return this.mType;
    }

    public Typeface getTypeface() {
        return this.mTypeface;
    }

    public void setTypeface(Typeface typeface) {
        this.mTypeface = typeface;
    }

    public int getState() {
        return this.mState;
    }

    public void setState(int n) {
        this.mState = n;
    }

    public String getFilePath() {
        return this.mFilePath;
    }

    public void setFilePath(String string2) {
        this.mFilePath = string2;
    }
}

