/*
 * Decompiled with CFR 0.152.
 */
package io.dcloud.media.weex.weex_video.ijkplayer.media;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.drawable.LayerDrawable;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.SparseArray;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.OrientationEventListener;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import com.dcloud.android.annotation.IntDef;
import com.dcloud.android.v4.view.MotionEventCompat;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.utils.WXDataStructureUtil;
import com.taobao.weex.utils.WXViewUtils;
import io.dcloud.application.DCLoudApplicationImpl;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.StringUtil;
import io.dcloud.feature.ui.navigator.QueryNotchTool;
import io.dcloud.feature.weex_media.R;
import io.dcloud.feature.weex_media.VideoPlayerView;
import io.dcloud.feature.weex_media.option.EnumPlayStrategy;
import io.dcloud.media.weex.weex_video.ijkplayer.OnPlayerChangedListener;
import io.dcloud.media.weex.weex_video.ijkplayer.VideoR;
import io.dcloud.media.weex.weex_video.ijkplayer.danmaku.BaseDanmakuConverter;
import io.dcloud.media.weex.weex_video.ijkplayer.danmaku.BiliDanmukuParser;
import io.dcloud.media.weex.weex_video.ijkplayer.danmaku.OnDanmakuListener;
import io.dcloud.media.weex.weex_video.ijkplayer.danmaku.StandardDanmaKuParser;
import io.dcloud.media.weex.weex_video.ijkplayer.media.AssetsDataSourceProvider;
import io.dcloud.media.weex.weex_video.ijkplayer.media.IjkVideoView;
import io.dcloud.media.weex.weex_video.ijkplayer.utils.MotionEventUtils;
import io.dcloud.media.weex.weex_video.ijkplayer.utils.NetWorkUtils;
import io.dcloud.media.weex.weex_video.ijkplayer.utils.StringUtils;
import io.dcloud.media.weex.weex_video.ijkplayer.widgets.MarqueeTextView;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import master.flame.danmaku.controller.DrawHandler;
import master.flame.danmaku.controller.IDanmakuView;
import master.flame.danmaku.danmaku.loader.ILoader;
import master.flame.danmaku.danmaku.loader.IllegalDataException;
import master.flame.danmaku.danmaku.loader.android.DanmakuLoaderFactory;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.DanmakuTimer;
import master.flame.danmaku.danmaku.model.android.DanmakuContext;
import master.flame.danmaku.danmaku.model.android.Danmakus;
import master.flame.danmaku.danmaku.parser.BaseDanmakuParser;
import master.flame.danmaku.danmaku.parser.IDataSource;
import org.json.JSONObject;
import tv.danmaku.ijk.media.player.IMediaPlayer;
import tv.danmaku.ijk.media.player.IjkMediaPlayer;

public class IjkPlayerView
extends FrameLayout
implements View.OnClickListener {
    private static final int MAX_VIDEO_SEEK = 1000;
    private static final int DEFAULT_HIDE_TIMEOUT = 5000;
    private static final int MSG_UPDATE_SEEK = 10086;
    private static final int MSG_UPDATE_TIME = 10099;
    private static final int MSG_ENABLE_ORIENTATION = 10087;
    private static final int MSG_TRY_RELOAD = 10088;
    private static final int INVALID_VALUE = -1;
    private static final int INTERVAL_TIME = 1000;
    private IjkVideoView mVideoView;
    public ImageView mPlayerThumb;
    private ProgressBar mLoadingView;
    private TextView mTvVolume;
    private TextView mTvBrightness;
    private TextView mTvFastForward;
    private FrameLayout mFlTouchLayout;
    private ImageView mIvBack;
    private MarqueeTextView mTvTitle;
    private LinearLayout mFullscreenTopBar;
    private ImageView mIvPlay;
    private ImageView mIvPlayCircle;
    private TextView mTvCurTime;
    private SeekBar mPlayerSeek;
    private TextView mTvEndTime;
    private ImageView mIvFullscreen;
    private LinearLayout mLlBottomBar;
    private FrameLayout mFlVideoBox;
    private TextView mTvRecoverScreen;
    private ImageView mIVMute;
    private ImageView mIvPlayCenter;
    private Activity mAttachActivity;
    private WXVContainer component;
    private VideoPlayerView parentView;
    private ImageView mIvScreenLock;
    private VideoPlayerView.IOnPlayerViewChangeListener changeListener;
    @SuppressLint(value={"HandlerLeak"})
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            if (msg.what == 10086) {
                int pos = IjkPlayerView.this._setProgress();
                if (!IjkPlayerView.this.mIsSeeking && IjkPlayerView.this.mIsShowBar && IjkPlayerView.this.mVideoView.isPlaying()) {
                    msg = this.obtainMessage(10086);
                    this.sendMessageDelayed(msg, 1000 - pos % 1000);
                }
            } else if (msg.what == 10087) {
                if (IjkPlayerView.this.mOrientationListener != null) {
                    IjkPlayerView.this.mOrientationListener.enable();
                }
            } else if (msg.what == 10088) {
                if (IjkPlayerView.this.mIsNetConnected) {
                    IjkPlayerView.this.reload();
                }
                msg = this.obtainMessage(10088);
                this.sendMessageDelayed(msg, 3000L);
            } else if (msg.what == 10099) {
                IjkPlayerView.this.progressCallBack();
                msg = this.obtainMessage(10099);
                this.sendMessageDelayed(msg, 250L);
            }
        }
    };
    private AudioManager mAudioManager;
    private GestureDetector mGestureDetector;
    private int mMaxVolume;
    private boolean mIsForbidTouch = false;
    private boolean mIsDoubleTapEnable = false;
    private boolean mIsShowBar = true;
    private boolean mIsFullscreen;
    private boolean mIsPlayComplete = false;
    private boolean mIsSeeking;
    private long mTargetPosition = -1L;
    private int mCurPosition = -1;
    private int mCurVolume = -1;
    private float mCurBrightness = -1.0f;
    private int mInitHeight;
    private int mWidthPixels;
    private int mScreenUiVisibility;
    private OrientationEventListener mOrientationListener;
    private boolean mIsNeverPlay = true;
    private IMediaPlayer.OnInfoListener mOutsideInfoListener;
    private IMediaPlayer.OnCompletionListener mCompletionListener;
    private boolean mIsForbidOrientation = true;
    private boolean mIsAlwaysFullScreen = false;
    private long mExitTime = 0L;
    private Matrix mVideoMatrix = new Matrix();
    private Matrix mSaveMatrix = new Matrix();
    private boolean mIsNeedRecoverScreen = false;
    private int mAspectOptionsHeight;
    private int mInterruptPosition;
    private boolean mIsReady = false;
    private boolean isRtmpUri = false;
    private boolean isPageGesture = false;
    private boolean isFullScreenPageGesture = true;
    private boolean isShowScreenLockButton = false;
    private boolean isProgressGesture = true;
    private ViewGroup mRootLayout;
    Runnable screenLockHideRunnable = new Runnable(){

        @Override
        public void run() {
            IjkPlayerView.this.mIvScreenLock.setVisibility(8);
        }
    };
    private float defaultScreenBrightness;
    private boolean isPlayBtnCenter = false;
    private final SeekBar.OnSeekBarChangeListener mSeekListener = new SeekBar.OnSeekBarChangeListener(){
        private long curPosition;

        public void onStartTrackingTouch(SeekBar bar) {
            IjkPlayerView.this.mIsSeeking = true;
            IjkPlayerView.this._showControlBar(3600000);
            IjkPlayerView.this.mHandler.removeMessages(10086);
            this.curPosition = IjkPlayerView.this.mVideoView.getCurrentPosition();
        }

        public void onProgressChanged(SeekBar bar, int progress, boolean fromUser) {
            if (!fromUser) {
                return;
            }
            long duration = IjkPlayerView.this.getDuration();
            IjkPlayerView.this.mTargetPosition = duration * (long)progress / 1000L;
            int deltaTime = (int)((IjkPlayerView.this.mTargetPosition - this.curPosition) / 1000L);
            String desc = IjkPlayerView.this.mTargetPosition > this.curPosition ? StringUtils.generateTime(IjkPlayerView.this.mTargetPosition) + "/" + StringUtils.generateTime(duration) + "\n+" + deltaTime + DCLoudApplicationImpl.self().getContext().getString(R.string.dcloud_feature_weex_video_second_unit) : StringUtils.generateTime(IjkPlayerView.this.mTargetPosition) + "/" + StringUtils.generateTime(duration) + "\n" + deltaTime + DCLoudApplicationImpl.self().getContext().getString(R.string.dcloud_feature_weex_video_second_unit);
            IjkPlayerView.this._setFastForward(desc);
        }

        public void onStopTrackingTouch(SeekBar bar) {
            IjkPlayerView.this._hideTouchView();
            IjkPlayerView.this.mIsSeeking = false;
            IjkPlayerView.this.seekTo((int)IjkPlayerView.this.mTargetPosition);
            IjkPlayerView.this.mTargetPosition = -1L;
            IjkPlayerView.this._setProgress();
            IjkPlayerView.this._showControlBar(5000);
        }
    };
    private Runnable mHideBarRunnable = new Runnable(){

        @Override
        public void run() {
            IjkPlayerView.this._hideAllView(false);
        }
    };
    private boolean controlShowEnable = false;
    private boolean isShowProgress = true;
    private boolean isPlayBtnVisibility = true;
    private boolean isCenterPlayBtnVisibility = true;
    String fullCallFormat = "{fullScreen:%b, direction:'%s'}";
    private ViewGroup.LayoutParams mRawParams;
    private int mOrientation = -90;
    private int originOrientation;
    public int orientation = 90;
    private int defaultSystemUI = 0;
    private int defaultDisplayCutoutMode = 0;
    String[] rates = new String[]{"0.5", "0.8", "1.0", "1.25", "1.5", "2.0"};
    private GestureDetector.OnGestureListener mPlayerGestureListener = new GestureDetector.SimpleOnGestureListener(){
        private boolean isDownTouch;
        private boolean isVolume;
        private boolean isLandscape;
        private boolean isRecoverFromDanmaku;

        public boolean onDown(MotionEvent e) {
            this.isDownTouch = true;
            this.isRecoverFromDanmaku = IjkPlayerView.this.recoverFromEditVideo();
            return super.onDown(e);
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            if (!IjkPlayerView.this.mIsForbidTouch && !IjkPlayerView.this.mIsNeverPlay) {
                float mOldX = e1.getX();
                float mOldY = e1.getY();
                float deltaY = mOldY - e2.getY();
                float deltaX = mOldX - e2.getX();
                if (this.isDownTouch) {
                    this.isLandscape = Math.abs(distanceX) >= Math.abs(distanceY);
                    this.isVolume = mOldX > (float)IjkPlayerView.this.getResources().getDisplayMetrics().widthPixels * 0.5f;
                    this.isDownTouch = false;
                }
                if (this.isLandscape) {
                    IjkPlayerView.this._onProgressSlide(-deltaX / (float)IjkPlayerView.this.mVideoView.getWidth());
                } else {
                    float percent = deltaY / (float)IjkPlayerView.this.mVideoView.getHeight();
                    if (this.isVolume) {
                        IjkPlayerView.this._onVolumeSlide(percent);
                    } else {
                        IjkPlayerView.this._onBrightnessSlide(percent);
                    }
                }
            }
            return super.onScroll(e1, e2, distanceX, distanceY);
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            if (IjkPlayerView.this.component != null && IjkPlayerView.this.component.getInstance() != null && IjkPlayerView.this.component.getEvents().contains((Object)"click")) {
                HashMap param = WXDataStructureUtil.newHashMapWithExpectedSize((int)1);
                HashMap position = WXDataStructureUtil.newHashMapWithExpectedSize((int)4);
                position.put("x", Float.valueOf(WXViewUtils.getWebPxByWidth((float)0.0f, (int)IjkPlayerView.this.component.getInstance().getInstanceViewPortWidth())));
                position.put("y", Float.valueOf(WXViewUtils.getWebPxByWidth((float)0.0f, (int)IjkPlayerView.this.component.getInstance().getInstanceViewPortWidth())));
                position.put("width", Float.valueOf(WXViewUtils.getWebPxByWidth((float)IjkPlayerView.this.component.getLayoutWidth(), (int)IjkPlayerView.this.component.getInstance().getInstanceViewPortWidth())));
                position.put("height", Float.valueOf(WXViewUtils.getWebPxByWidth((float)IjkPlayerView.this.component.getLayoutHeight(), (int)IjkPlayerView.this.component.getInstance().getInstanceViewPortWidth())));
                param.put("position", position);
                IjkPlayerView.this.component.fireEvent("click", (Map)param);
            }
            if (IjkPlayerView.this.isFullscreen() && IjkPlayerView.this.component != null && IjkPlayerView.this.component.getInstance() != null) {
                JSONObject object = new JSONObject();
                try {
                    object.put("screenX", (double)WXViewUtils.getWebPxByWidth((float)e.getX(), (int)IjkPlayerView.this.component.getInstance().getInstanceViewPortWidth()));
                    object.put("screenY", (double)WXViewUtils.getWebPxByWidth((float)e.getY(), (int)IjkPlayerView.this.component.getInstance().getInstanceViewPortWidth()));
                    object.put("screenWidth", (double)WXViewUtils.getWebPxByWidth((float)IjkPlayerView.this.getWidth(), (int)IjkPlayerView.this.component.getInstance().getInstanceViewPortWidth()));
                    object.put("screenHeight", (double)WXViewUtils.getWebPxByWidth((float)IjkPlayerView.this.getHeight(), (int)IjkPlayerView.this.component.getInstance().getInstanceViewPortWidth()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                IjkPlayerView.this.mOnPlayerChangedListener.onChanged("fullscreenclick", object.toString());
            }
            if (this.isRecoverFromDanmaku) {
                return true;
            }
            IjkPlayerView.this._toggleControlBar();
            if (IjkPlayerView.this.mIsFullscreen) {
                IjkPlayerView.this.showScreenLockView();
            }
            return true;
        }

        public boolean onDoubleTap(MotionEvent e) {
            if (IjkPlayerView.this.mIsNeverPlay || this.isRecoverFromDanmaku) {
                return true;
            }
            if (!IjkPlayerView.this.mIsForbidTouch && IjkPlayerView.this.mIsDoubleTapEnable) {
                IjkPlayerView.this._refreshHideRunnable();
                IjkPlayerView.this._togglePlayStatus();
            }
            return true;
        }
    };
    private Runnable mHideTouchViewRunnable = new Runnable(){

        @Override
        public void run() {
            IjkPlayerView.this._hideTouchView();
        }
    };
    private View.OnTouchListener mPlayerTouchListener = new View.OnTouchListener(){
        private static final int NORMAL = 1;
        private static final int INVALID_POINTER = 2;
        private static final int ZOOM_AND_ROTATE = 3;
        private int mode = 1;
        private PointF midPoint = new PointF(0.0f, 0.0f);
        private float degree = 0.0f;
        private int fingerFlag = -1;
        private float oldDist;
        private float scale;

        public boolean onTouch(View v, MotionEvent event) {
            switch (MotionEventCompat.getActionMasked((MotionEvent)event)) {
                case 0: {
                    this.mode = 1;
                    IjkPlayerView.this.mHandler.removeCallbacks(IjkPlayerView.this.mHideBarRunnable);
                    break;
                }
                case 5: {
                    if (event.getPointerCount() == 3 && IjkPlayerView.this.mIsFullscreen) {
                        IjkPlayerView.this._hideTouchView();
                        this.mode = 3;
                        MotionEventUtils.midPoint(this.midPoint, event);
                        this.fingerFlag = MotionEventUtils.calcFingerFlag(event);
                        this.degree = MotionEventUtils.rotation(event, this.fingerFlag);
                        this.oldDist = MotionEventUtils.calcSpacing(event, this.fingerFlag);
                        IjkPlayerView.this.mSaveMatrix = IjkPlayerView.this.mVideoView.getVideoTransform();
                        break;
                    }
                    this.mode = 2;
                    break;
                }
                case 2: {
                    if (this.mode != 3) break;
                    float newRotate = MotionEventUtils.rotation(event, this.fingerFlag);
                    IjkPlayerView.this.mVideoView.setVideoRotation((int)(newRotate - this.degree));
                    IjkPlayerView.this.mVideoMatrix.set(IjkPlayerView.this.mSaveMatrix);
                    float newDist = MotionEventUtils.calcSpacing(event, this.fingerFlag);
                    this.scale = newDist / this.oldDist;
                    IjkPlayerView.this.mVideoMatrix.postScale(this.scale, this.scale, this.midPoint.x, this.midPoint.y);
                    IjkPlayerView.this.mVideoView.setVideoTransform(IjkPlayerView.this.mVideoMatrix);
                    break;
                }
                case 6: {
                    if (this.mode == 3) {
                        IjkPlayerView.this.mIsNeedRecoverScreen = IjkPlayerView.this.mVideoView.adjustVideoView(this.scale);
                        if (IjkPlayerView.this.mIsNeedRecoverScreen && IjkPlayerView.this.mIsShowBar) {
                            IjkPlayerView.this.mTvRecoverScreen.setVisibility(0);
                        }
                    }
                    this.mode = 2;
                }
            }
            if (this.mode == 1) {
                if (IjkPlayerView.this.mGestureDetector.onTouchEvent(event)) {
                    return true;
                }
                if (MotionEventCompat.getActionMasked((MotionEvent)event) == 1) {
                    IjkPlayerView.this._endGesture();
                }
            }
            return true;
        }
    };
    String timeUpdateF = "{currentTime:%f,duration:%f}";
    int duration = -1;
    private boolean isLoadingVisibility = true;
    private boolean isMutePlayer = false;
    private boolean mIsRenderingStart = false;
    private boolean mIsBufferingStart = false;
    private IMediaPlayer.OnInfoListener mInfoListener = new IMediaPlayer.OnInfoListener(){

        public boolean onInfo(IMediaPlayer iMediaPlayer, int status, int extra) {
            IjkPlayerView.this._switchStatus(status);
            if (IjkPlayerView.this.mOutsideInfoListener != null) {
                IjkPlayerView.this.mOutsideInfoListener.onInfo(iMediaPlayer, status, extra);
            }
            return true;
        }
    };
    private OnPlayerChangedListener mOnPlayerChangedListener;
    private IMediaPlayer.OnBufferingUpdateListener bufferingUpdateListener;
    private IMediaPlayer.OnBufferingUpdateListener onBufferingUpdateListener = new IMediaPlayer.OnBufferingUpdateListener(){

        public void onBufferingUpdate(IMediaPlayer iMediaPlayer, int i) {
            if (IjkPlayerView.this.bufferingUpdateListener != null) {
                IjkPlayerView.this.bufferingUpdateListener.onBufferingUpdate(iMediaPlayer, i);
            }
        }
    };
    private SparseArray<String> mVideoSource = new SparseArray();
    private static final int NORMAL_STATUS = 501;
    private static final int INTERRUPT_WHEN_PLAY = 502;
    private static final int INTERRUPT_WHEN_PAUSE = 503;
    private int mVideoStatus = 501;
    private static final int DANMAKU_TAG_BILI = 701;
    private static final int DANMAKU_TAG_ACFUN = 702;
    private static final int DANMAKU_TAG_CUSTOM = 703;
    private int mDanmakuTag = 701;
    private IDanmakuView mDanmakuView;
    private TextView mIvDanmakuControl;
    private DanmakuContext mDanmakuContext;
    private BaseDanmakuParser mDanmakuParser;
    private ILoader mDanmakuLoader;
    private BaseDanmakuConverter mDanmakuConverter;
    private OnDanmakuListener mDanmakuListener;
    private boolean mIsEnableDanmaku = false;
    private int mDanmakuTextColor = -1;
    private float mDanmakuTextSize = -1.0f;
    private int mDanmakuType = 1;
    private int mBasicOptionsWidth = -1;
    private int mMoreOptionsWidth = -1;
    private long mDanmakuTargetPosition = -1L;
    private String mDanmuList = "";
    private ScreenBroadcastReceiver mScreenReceiver;
    private NetBroadcastReceiver mNetReceiver;
    private boolean mIsScreenLocked = false;
    private boolean mIsNetConnected;

    public void setChangeListener(VideoPlayerView.IOnPlayerViewChangeListener viewChangeListener) {
        this.changeListener = viewChangeListener;
    }

    public IjkPlayerView(Context context) {
        this(context, null);
    }

    public IjkPlayerView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this._initView(context);
    }

    public IjkPlayerView(Context context, AttributeSet attrs, VideoPlayerView parentView) {
        this(context, attrs);
        this.parentView = parentView;
    }

    public void setComponent(WXVContainer container) {
        this.component = container;
    }

    private void _initView(Context context) {
        if (!(context instanceof Activity)) {
            throw new IllegalArgumentException("Context must be Activity");
        }
        this.mAttachActivity = (Activity)context;
        View.inflate((Context)context, (int)VideoR.VIDEO_IJK_LAYOUT_PLAYER_VIEW, (ViewGroup)this);
        this.mVideoView = (IjkVideoView)this.findViewById(VideoR.VIDEO_IJK_ID_VIDEO_VIEW);
        this.mPlayerThumb = (ImageView)this.findViewById(VideoR.VIDEO_IJK_ID_IV_THUMB);
        this.mLoadingView = (ProgressBar)this.findViewById(VideoR.VIDEO_IJK_ID_PD_LOADING);
        this.mTvVolume = (TextView)this.findViewById(VideoR.VIDEO_IJK_ID_TV_VOLUME);
        this.mTvBrightness = (TextView)this.findViewById(VideoR.VIDEO_IJK_ID_TV_BRIGHTNESS);
        this.mTvFastForward = (TextView)this.findViewById(VideoR.VIDEO_IJK_ID_TV_FAST_FORWARD);
        this.mFlTouchLayout = (FrameLayout)this.findViewById(VideoR.VIDEO_IJK_ID_FL_TOUCH_LAYOUT);
        this.mIvBack = (ImageView)this.findViewById(VideoR.VIDEO_IJK_ID_IV_BACK);
        this.mTvTitle = (MarqueeTextView)this.findViewById(VideoR.VIDEO_IJK_ID_TV_TITLE);
        this.mFullscreenTopBar = (LinearLayout)this.findViewById(VideoR.VIDEO_IJK_ID_FULLSCREEN_TOP_BAR);
        this.mIvPlay = (ImageView)this.findViewById(VideoR.VIDEO_IJK_ID_IV_PLAY);
        this.mTvCurTime = (TextView)this.findViewById(VideoR.VIDEO_IJK_ID_TV_CUR_TIME);
        this.mPlayerSeek = (SeekBar)this.findViewById(VideoR.VIDEO_IJK_ID_PLAYER_SEEK);
        this.mTvEndTime = (TextView)this.findViewById(VideoR.VIDEO_IJK_ID_TV_END_TIME);
        this.mIvFullscreen = (ImageView)this.findViewById(VideoR.VIDEO_IJK_ID_IV_FULLSCREEN);
        this.mLlBottomBar = (LinearLayout)this.findViewById(VideoR.VIDEO_IJK_ID_LL_BOTTOM_BAR);
        this.mFlVideoBox = (FrameLayout)this.findViewById(VideoR.VIDEO_IJK_ID_FL_VIDEO_BOX);
        this.mIvPlayCircle = (ImageView)this.findViewById(VideoR.VIDEO_IJK_ID_IV_PLAY_CIRCLE);
        this.mTvRecoverScreen = (TextView)this.findViewById(VideoR.VIDEO_IJK_ID_TV_RECOVER_SCREEN);
        this.mIvDanmakuControl = (TextView)this.findViewById(VideoR.VIDEO_IJK_ID_IV_DANMAKU_CONTROL);
        this.mIVMute = (ImageView)this.findViewById(VideoR.VIDEO_IJK_ID_IV_MUTE);
        this.mIvPlayCenter = (ImageView)this.findViewById(VideoR.VIDEO_IJK_ID_IV_PLAY_CENTER);
        this.mIvScreenLock = (ImageView)this.findViewById(VideoR.VIDEO_IJK_ID_IV_SCREEN_LOCK);
        this.mAspectOptionsHeight = this.getResources().getDimensionPixelSize(VideoR.VIDEO_IJK_DIMEN_ASPECT_BNT_SIZE) * 4;
        this._initReceiver();
        this.mIvPlay.setOnClickListener((View.OnClickListener)this);
        this.mIvBack.setOnClickListener((View.OnClickListener)this);
        this.mIvFullscreen.setOnClickListener((View.OnClickListener)this);
        this.mIvPlayCircle.setOnClickListener((View.OnClickListener)this);
        this.mTvRecoverScreen.setOnClickListener((View.OnClickListener)this);
        this.mIVMute.setOnClickListener((View.OnClickListener)this);
        this.mIvPlayCenter.setOnClickListener((View.OnClickListener)this);
        this.setOnClickListener(this);
        this.mIvScreenLock.setOnClickListener((View.OnClickListener)this);
        if (this.mIsForbidTouch) {
            this.mIvScreenLock.setImageResource(R.drawable.video_screen_lock);
            this.mIvScreenLock.setTag((Object)1);
        } else {
            this.mIvScreenLock.setImageResource(R.drawable.video_screen_unlock);
            this.mIvScreenLock.setTag((Object)0);
        }
    }

    public void setVideoVisibility() {
        if (this.mVideoView != null) {
            this.mVideoView.setVisibility(0);
        }
    }

    public void setIsShowScreenLockButton(boolean showScreenLockButton) {
        this.isShowScreenLockButton = showScreenLockButton;
    }

    public void showScreenLockView() {
        if (this.isShowScreenLockButton) {
            this.mIvScreenLock.setVisibility(0);
            this.getHandler().removeCallbacks(this.screenLockHideRunnable);
            this.getHandler().postDelayed(this.screenLockHideRunnable, 5000L);
        } else {
            this.mIvScreenLock.setVisibility(8);
        }
    }

    public void setmIsDoubleTapEnable(boolean mIsDoubleTapEnable) {
        this.mIsDoubleTapEnable = mIsDoubleTapEnable;
    }

    private void setSeekBarColor() {
        LayerDrawable drawable2 = (LayerDrawable)this.mPlayerSeek.getProgressDrawable();
        drawable2.findDrawableByLayerId(0x1020000).setColorFilter(Color.parseColor((String)"#ff00ff"), PorterDuff.Mode.SRC_ATOP);
        drawable2.findDrawableByLayerId(16908303).setColorFilter(Color.parseColor((String)"#ffff00"), PorterDuff.Mode.SRC_ATOP);
        drawable2.findDrawableByLayerId(16908301).setColorFilter(Color.parseColor((String)"#00ffff"), PorterDuff.Mode.SRC_ATOP);
        this.mPlayerSeek.getThumb().setColorFilter(Color.parseColor((String)"#0000ff"), PorterDuff.Mode.SRC_ATOP);
    }

    private void _initMediaPlayer() {
        IjkMediaPlayer.loadLibrariesOnce(null);
        IjkMediaPlayer.native_profileBegin((String)"libijkplayer.so");
        this.mAudioManager = (AudioManager)this.mAttachActivity.getSystemService("audio");
        this.mMaxVolume = this.mAudioManager.getStreamMaxVolume(3);
        WindowManager.LayoutParams lp = this.mAttachActivity.getWindow().getAttributes();
        this.defaultScreenBrightness = lp.screenBrightness;
        this.mPlayerSeek.setMax(1000);
        this.mPlayerSeek.setOnSeekBarChangeListener(this.mSeekListener);
        this.mVideoView.setOnInfoListener(this.mInfoListener);
        this.mVideoView.setOnBufferingUpdateListener(this.onBufferingUpdateListener);
        this.mGestureDetector = new GestureDetector((Context)this.mAttachActivity, this.mPlayerGestureListener);
        this.mFlVideoBox.setClickable(true);
        this.mFlVideoBox.setOnTouchListener(this.mPlayerTouchListener);
        if (!this.mIsForbidOrientation) {
            this.initOrientationEventListener();
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (this.mInitHeight == 0) {
            this.mInitHeight = this.getHeight();
            this.mWidthPixels = this.getResources().getDisplayMetrics().widthPixels;
        }
    }

    public void onResume() {
        if (this.mIsScreenLocked) {
            this.mIsScreenLocked = false;
        }
        this.mVideoView.setRender(2);
        this.mVideoView.resume();
        if (!this.mIsForbidTouch && !this.mIsForbidOrientation) {
            this.mOrientationListener.enable();
        }
        if (this.mCurPosition != -1) {
            this.seekTo(this.mCurPosition);
            this.mCurPosition = -1;
        }
    }

    public void onPause() {
        this.mCurPosition = this.mVideoView.getCurrentPosition();
        this.mVideoView.pause();
        this.mIvPlay.setSelected(false);
        this.mIvPlayCenter.setSelected(false);
        if (this.mOrientationListener != null) {
            this.mOrientationListener.disable();
        }
        this._pauseDanmaku();
    }

    public int onDestroy() {
        int curPosition = this.mVideoView.getCurrentPosition();
        this.mVideoView.destroy();
        IjkMediaPlayer.native_profileEnd();
        if (this.mDanmakuView != null) {
            this.mDanmakuView.release();
            this.mDanmakuView = null;
        }
        if (this.mTvTitle != null) {
            this.mTvTitle.stopMotion();
        }
        this.mHandler.removeMessages(10088);
        this.mHandler.removeMessages(10086);
        this.mHandler.removeMessages(10099);
        this.mAttachActivity.unregisterReceiver((BroadcastReceiver)this.mScreenReceiver);
        this.mAttachActivity.unregisterReceiver((BroadcastReceiver)this.mNetReceiver);
        this.mAttachActivity.getWindow().clearFlags(128);
        this.setMutePlayer(false);
        this.mAudioManager.abandonAudioFocus(null);
        WindowManager.LayoutParams lp = this.mAttachActivity.getWindow().getAttributes();
        lp.screenBrightness = this.defaultScreenBrightness;
        this.mAttachActivity.getWindow().setAttributes(lp);
        return curPosition;
    }

    public boolean handleVolumeKey(int keyCode) {
        if (keyCode == 24) {
            this._setVolume(true);
            return true;
        }
        if (keyCode == 25) {
            this._setVolume(false);
            return true;
        }
        return false;
    }

    public boolean onBackPressed() {
        if (this.recoverFromEditVideo()) {
            return true;
        }
        if (this.mIsAlwaysFullScreen) {
            return true;
        }
        if (this.mIsFullscreen) {
            this.exitFullScreen();
            if (this.mIsForbidTouch) {
                this.mIsForbidTouch = false;
                this._setControlBarVisible(this.mIsShowBar);
            }
            return true;
        }
        return false;
    }

    public IjkPlayerView init() {
        this._initMediaPlayer();
        return this;
    }

    public IjkPlayerView switchVideoPath(String url) {
        return this.switchVideoPath(Uri.parse((String)url));
    }

    public IjkPlayerView switchVideoPath(Uri uri) {
        this.reset();
        this._setControlBarVisible(true);
        this.duration = -1;
        return this.setVideoPath(uri);
    }

    public IjkPlayerView setVideoPath(String url) {
        return this.setVideoPath(Uri.parse((String)url));
    }

    public IjkPlayerView setPlayerRootView(ViewGroup rootView) {
        this.mRootLayout = rootView;
        return this;
    }

    public IjkPlayerView setVideoPath(Uri uri) {
        if (uri.toString().startsWith("rtmp:")) {
            this.isRtmpUri = true;
            this.mPlayerSeek.setEnabled(false);
            this.mPlayerSeek.setVisibility(4);
            this.mTvEndTime.setVisibility(4);
            this.mTvCurTime.setVisibility(4);
        } else {
            this.isRtmpUri = false;
            this.mPlayerSeek.setEnabled(true);
            this.mPlayerSeek.setVisibility(this.isShowProgress ? 0 : 4);
            this.mTvEndTime.setVisibility(0);
            this.mTvCurTime.setVisibility(0);
        }
        if (this.mCurPosition != -1) {
            this.seekTo(this.mCurPosition);
            this.mCurPosition = -1;
        } else {
            this.seekTo(0);
        }
        this.mVideoView.setVideoURI(uri);
        return this;
    }

    public IjkPlayerView setVideoFileDescriptor(AssetsDataSourceProvider fd) {
        if (this.mCurPosition != -1) {
            this.seekTo(this.mCurPosition);
            this.mCurPosition = -1;
        } else {
            this.seekTo(0);
        }
        this.mVideoView.setVideoFileDescriptor(fd);
        return this;
    }

    public IjkPlayerView switchVideoFileDescriptor(AssetsDataSourceProvider fd) {
        this.reset();
        this._setControlBarVisible(true);
        this.duration = -1;
        return this.setVideoFileDescriptor(fd);
    }

    public IjkPlayerView setTitle(String title) {
        this.mTvTitle.setText(title);
        return this;
    }

    public IjkPlayerView setHttpCacheEnable(boolean cacheEnable) {
        if (this.mVideoView != null) {
            this.mVideoView.setIsHttpCacheOpen(cacheEnable);
        }
        return this;
    }

    public IjkPlayerView setHeader(String header) {
        if (this.mVideoView != null) {
            this.mVideoView.setHeaderInfo(header);
        }
        return this;
    }

    public IjkPlayerView setFlowStrategy(EnumPlayStrategy intFlowStrategy) {
        if (this.mVideoView != null) {
            this.mVideoView.setFlowStrategy(intFlowStrategy);
        }
        return this;
    }

    public void isMuteBtnShow(boolean isShow) {
        if (isShow) {
            this.mIVMute.setVisibility(0);
        } else {
            this.mIVMute.setVisibility(8);
        }
    }

    public void setPlayBtnPosition(String position) {
        this.isPlayBtnCenter = position.equals("center");
        if (this.isPlayBtnCenter) {
            this.mIvPlay.setVisibility(8);
        } else if (this.isPlayBtnVisibility) {
            this.mIvPlayCenter.setVisibility(8);
            this.mIvPlay.setVisibility(0);
        }
    }

    public IjkPlayerView alwaysFullScreen() {
        this.mIsAlwaysFullScreen = true;
        this.fullScreen(this.mOrientation);
        this.mIvFullscreen.setVisibility(8);
        return this;
    }

    public void start() {
        if (this.mIsPlayComplete) {
            if (this.mDanmakuView != null && this.mDanmakuView.isPrepared()) {
                this.mDanmakuView.seekTo(Long.valueOf(0L));
                this.mDanmakuView.pause();
            }
            this.mIsPlayComplete = false;
        }
        if (!this.mVideoView.isPlaying()) {
            this.mIvPlay.setSelected(true);
            this.mIvPlayCenter.setSelected(true);
            this.mVideoView.start();
            this.mHandler.sendEmptyMessage(10086);
            this.mHandler.sendEmptyMessage(10099);
        }
        this.mIvPlayCircle.setVisibility(8);
        if (this.mIsNeverPlay) {
            this.mIsNeverPlay = false;
            if (this.mVideoView.getCurrentState() != 331) {
                this.setLoadingVisibility(0);
            }
            this.mIsShowBar = false;
            this._loadDanmaku();
        }
        this.mAttachActivity.getWindow().addFlags(128);
    }

    public void hiddenLoaded(boolean isHidden) {
    }

    /*
     * Enabled aggressive block sorting
     */
    public void reload() {
        block5: {
            block4: {
                this.setLoadingVisibility(0);
                if (!this.mIsReady) break block4;
                if (NetWorkUtils.isNetworkAvailable((Context)this.mAttachActivity)) {
                    this.mVideoView.reload();
                    this.mVideoView.start();
                    if (this.mInterruptPosition > 0) {
                        this.seekTo(this.mInterruptPosition);
                        this.mInterruptPosition = 0;
                    }
                    break block5;
                } else {
                    if (null != this.mOnPlayerChangedListener) {
                        this.mOnPlayerChangedListener.onChanged("error", "network error");
                        this.setLoadingVisibility(8);
                    }
                    return;
                }
            }
            this.mVideoView.release(false);
            this.mVideoView.setRender(2);
            this.start();
        }
        this.mHandler.removeMessages(10086);
        this.mHandler.sendEmptyMessage(10086);
        this.mHandler.removeMessages(10099);
        this.mHandler.sendEmptyMessage(10099);
    }

    public boolean isPlaying() {
        return this.mVideoView.isPlaying();
    }

    public void pause() {
        this.mCurPosition = this.mVideoView.getCurrentPosition();
        this.mIvPlay.setSelected(false);
        this.mIvPlayCenter.setSelected(false);
        if (this.mVideoView.isPlaying()) {
            this.mVideoView.pause();
        }
        this.mHandler.removeMessages(10099);
        this._pauseDanmaku();
        this.mAttachActivity.getWindow().clearFlags(128);
    }

    public void seekTo(int position) {
        if (this.isRtmpUri) {
            return;
        }
        this.mVideoView.seekTo(position);
        this.mDanmakuTargetPosition = position;
    }

    public void stop() {
        this.pause();
        this.mVideoView.stopPlayback();
    }

    public void reset() {
        if (this.mIsEnableDanmaku && this.mDanmakuView != null) {
            this.mDanmakuView.release();
            this.mDanmakuView = null;
            this.mIsEnableDanmaku = false;
        }
        this.mIsNeverPlay = true;
        this.mCurPosition = 0;
        this.stop();
        this.mVideoView.setRender(2);
    }

    private void _hideAllView(boolean isTouchLock) {
        this.mFlTouchLayout.setVisibility(8);
        this.mFullscreenTopBar.setVisibility(8);
        this.mTvTitle.stopMotion();
        this.mIvPlayCenter.setVisibility(8);
        if (this.mLlBottomBar.getVisibility() == 0) {
            this.mOnPlayerChangedListener.onChanged("controlstoggle", "{'show':false}");
        }
        this.mLlBottomBar.setVisibility(8);
        if (!isTouchLock) {
            this.mIsShowBar = false;
        }
        if (this.mIsNeedRecoverScreen) {
            this.mTvRecoverScreen.setVisibility(8);
        }
        if (this.mIvScreenLock.getVisibility() == 0) {
            this.mIvScreenLock.setVisibility(8);
        }
    }

    private void _setControlBarVisible(boolean isShowBar) {
        if (!this.controlShowEnable) {
            this.mLlBottomBar.setVisibility(8);
            this.mFullscreenTopBar.setVisibility(8);
            this.mTvTitle.stopMotion();
            if (this.mIsNeedRecoverScreen) {
                this.mTvRecoverScreen.setVisibility(8);
            }
        } else if (this.mIsNeverPlay) {
            if (this.mIvPlayCircle.getVisibility() != 0) {
                this.mLlBottomBar.setVisibility(isShowBar ? 0 : 8);
            }
        } else if (!this.mIsForbidTouch) {
            this.mLlBottomBar.setVisibility(isShowBar ? 0 : 8);
            if (this.isPlayBtnCenter && this.isPlayBtnVisibility) {
                this.mIvPlayCenter.setVisibility(isShowBar ? 0 : 8);
            }
            if (this.mIsFullscreen) {
                this.mFullscreenTopBar.setVisibility(isShowBar ? 0 : 8);
                if (isShowBar) {
                    this.mTvTitle.startMotion();
                } else {
                    this.mTvTitle.stopMotion();
                }
                if (this.mIsNeedRecoverScreen) {
                    this.mTvRecoverScreen.setVisibility(isShowBar ? 0 : 8);
                }
            } else {
                this.mFullscreenTopBar.setVisibility(8);
                this.mTvTitle.stopMotion();
                if (this.mIsNeedRecoverScreen) {
                    this.mTvRecoverScreen.setVisibility(8);
                }
            }
        }
    }

    private void _toggleControlBar() {
        this.mIsShowBar = !this.mIsShowBar;
        this.mOnPlayerChangedListener.onChanged("controlstoggle", "{'show':" + this.mIsShowBar + "}");
        this._setControlBarVisible(this.mIsShowBar);
        this.mHandler.removeCallbacks(this.mHideBarRunnable);
        if (this.mIsShowBar) {
            this.mHandler.postDelayed(this.mHideBarRunnable, 5000L);
            this.mHandler.sendEmptyMessage(10086);
        }
    }

    private void _showControlBar(int timeout) {
        if (!this.mIsShowBar) {
            this._setProgress();
            this.mIsShowBar = true;
        }
        this._setControlBarVisible(true);
        this.mHandler.removeMessages(10086);
        this.mHandler.sendEmptyMessage(10086);
        this.mHandler.removeCallbacks(this.mHideBarRunnable);
        if (timeout != 0) {
            this.mHandler.postDelayed(this.mHideBarRunnable, (long)timeout);
        }
    }

    private void _togglePlayStatus() {
        if (this.mVideoView.isPlaying()) {
            this.pause();
        } else {
            this.start();
        }
    }

    private void _refreshHideRunnable() {
        this.mHandler.removeCallbacks(this.mHideBarRunnable);
        this.mHandler.postDelayed(this.mHideBarRunnable, 5000L);
    }

    private void _togglePlayerLock() {
        boolean bl = this.mIsForbidTouch = !this.mIsForbidTouch;
        if (this.mIsForbidTouch) {
            if (this.mOrientationListener != null) {
                this.mOrientationListener.disable();
            }
            this._hideAllView(true);
        } else {
            if (!this.mIsForbidOrientation) {
                this.mOrientationListener.enable();
            }
            this.mFullscreenTopBar.setVisibility(0);
            if (this.controlShowEnable) {
                this.mLlBottomBar.setVisibility(0);
            }
            if (this.mIsNeedRecoverScreen) {
                this.mTvRecoverScreen.setVisibility(0);
            }
        }
    }

    public void setControls(boolean controlEnable) {
        this.controlShowEnable = controlEnable;
        this.mIsShowBar = controlEnable;
        this.mOnPlayerChangedListener.onChanged("controlstoggle", "{'show':" + this.mIsShowBar + "}");
        this._setControlBarVisible(this.mIsShowBar);
        if (this.mIsShowBar) {
            this.mHandler.sendEmptyMessage(10086);
        }
    }

    public void setPageGesture(boolean isPageGesture) {
        this.isPageGesture = isPageGesture;
    }

    public void setFullScreenPageGesture(boolean fullScreenPageGesture) {
        this.isFullScreenPageGesture = fullScreenPageGesture;
    }

    public void setProgressVisibility(boolean isShow) {
        if (this.mPlayerSeek != null && !this.isRtmpUri) {
            this.isShowProgress = isShow;
            int v = isShow ? 0 : 4;
            this.mPlayerSeek.setVisibility(v);
        }
    }

    public void setFullscreenBntVisibility(boolean isShow) {
        if (this.mIvFullscreen != null) {
            int v = isShow ? 0 : 4;
            this.mIvFullscreen.setVisibility(v);
        }
    }

    public void setPlayBntVisibility(boolean isShow) {
        if (this.mIvPlay != null) {
            int v;
            this.isPlayBtnVisibility = isShow;
            int n = v = isShow ? 0 : 4;
            if (this.isPlayBtnCenter) {
                this.mIvPlayCenter.setVisibility(v);
            } else {
                this.mIvPlay.setVisibility(v);
            }
        }
    }

    public void setCenterPlayBtnVisibility(boolean isShow) {
        if (this.mIsNeverPlay && !this.isPlaying() && this.mIvPlayCircle != null) {
            this.isCenterPlayBtnVisibility = isShow;
            int v = isShow ? 0 : 8;
            this.mIvPlayCircle.setVisibility(v);
        }
    }

    public void setIsEnableProgressGesture(boolean isProgressGesture) {
        this.isProgressGesture = isProgressGesture;
    }

    public void onClick(View v) {
        this._refreshHideRunnable();
        int id2 = v.getId();
        if (id2 == VideoR.VIDEO_IJK_ID_IV_BACK) {
            this.onBackPressed();
        } else if (id2 == VideoR.VIDEO_IJK_ID_IV_PLAY || id2 == VideoR.VIDEO_IJK_ID_IV_PLAY_CIRCLE || id2 == VideoR.VIDEO_IJK_ID_IV_PLAY_CENTER) {
            this._togglePlayStatus();
        } else if (id2 == VideoR.VIDEO_IJK_ID_IV_FULLSCREEN) {
            this._toggleFullScreen();
        } else if (id2 == VideoR.VIDEO_IJK_ID_IV_DANMAKU_CONTROL) {
            this._toggleDanmakuShow();
        } else if (id2 == VideoR.VIDEO_IJK_ID_TV_RECOVER_SCREEN) {
            this.mVideoView.resetVideoView(true);
            this.mIsNeedRecoverScreen = false;
            this.mTvRecoverScreen.setVisibility(8);
        } else if (id2 == VideoR.VIDEO_IJK_ID_IV_MUTE) {
            this.isMutePlayer = !this.isMutePlayer;
            this.setMutePlayer(this.isMutePlayer);
            this.mIVMute.setSelected(this.isMutePlayer);
        } else if (id2 == VideoR.VIDEO_IJK_ID_IV_SCREEN_LOCK) {
            if (!this.isShowScreenLockButton) {
                return;
            }
            Integer lockTag = (Integer)this.mIvScreenLock.getTag();
            if (lockTag == 1) {
                this.mIvScreenLock.setTag((Object)0);
                this.mIvScreenLock.setImageResource(R.drawable.video_screen_unlock);
                this.mIsForbidTouch = true;
            } else {
                this.mIvScreenLock.setTag((Object)1);
                this.mIvScreenLock.setImageResource(R.drawable.video_screen_lock);
                this.mIsForbidTouch = false;
            }
            this._togglePlayerLock();
            this.mIvScreenLock.setVisibility(0);
            this.getHandler().removeCallbacks(this.screenLockHideRunnable);
            this.getHandler().postDelayed(this.screenLockHideRunnable, 5000L);
        } else if (v == this && this.component != null && this.component.getEvents().contains((Object)"click")) {
            HashMap param = WXDataStructureUtil.newHashMapWithExpectedSize((int)1);
            HashMap position = WXDataStructureUtil.newHashMapWithExpectedSize((int)4);
            int[] location = new int[2];
            v.getLocationOnScreen(location);
            position.put("x", Float.valueOf(WXViewUtils.getWebPxByWidth((float)location[0], (float)this.component.getInstance().getInstanceViewPortWidthWithFloat())));
            position.put("y", Float.valueOf(WXViewUtils.getWebPxByWidth((float)location[1], (float)this.component.getInstance().getInstanceViewPortWidthWithFloat())));
            position.put("width", Float.valueOf(WXViewUtils.getWebPxByWidth((float)this.component.getLayoutWidth(), (float)this.component.getInstance().getInstanceViewPortWidthWithFloat())));
            position.put("height", Float.valueOf(WXViewUtils.getWebPxByWidth((float)this.component.getLayoutHeight(), (float)this.component.getInstance().getInstanceViewPortWidthWithFloat())));
            param.put("position", position);
            this.component.fireEvent("click", (Map)param);
        }
    }

    public IjkPlayerView enableOrientation() {
        this.mIsForbidOrientation = false;
        if (this.mOrientationListener == null) {
            this.initOrientationEventListener();
        }
        this.mOrientationListener.enable();
        return this;
    }

    private void _toggleFullScreen() {
        if (this.isFullscreen()) {
            this.exitFullScreen();
        } else {
            if (this.parentView != null) {
                int ori = this.parentView.getDirection();
                if (ori == Integer.MIN_VALUE && this.mVideoView != null) {
                    ori = this.mVideoView.getVideoHeight() > this.mVideoView.getVideoWidth() ? 0 : -90;
                }
                this.mOrientation = ori;
            }
            this.fullScreen(this.mOrientation);
        }
    }

    private void _setFullScreen(boolean isFullscreen) {
        this.mIsFullscreen = isFullscreen;
        this.mIvFullscreen.setSelected(isFullscreen);
        if (this.mOnPlayerChangedListener != null) {
            String msg = null;
            msg = isFullscreen ? StringUtil.format((String)this.fullCallFormat, (Object[])new Object[]{true, "horizontal"}) : StringUtil.format((String)this.fullCallFormat, (Object[])new Object[]{false, "vertical"});
            String finalMsg = msg;
            this.mOnPlayerChangedListener.onChanged("fullscreenchange", finalMsg);
        }
        this._showControlBar(5000);
        if (this.mIsNeedRecoverScreen) {
            if (isFullscreen) {
                this.mVideoView.adjustVideoView(1.0f);
                this.mTvRecoverScreen.setVisibility(this.mIsShowBar ? 0 : 8);
            } else {
                this.mVideoView.resetVideoView(false);
                this.mTvRecoverScreen.setVisibility(8);
            }
        }
    }

    private void _handleOrientation(int orientation) {
        if (this.mIsNeverPlay) {
            return;
        }
        if (this.mIsFullscreen && !this.mIsAlwaysFullScreen) {
            if (orientation >= 0 && orientation <= 30 || orientation >= 330) {
                this.mAttachActivity.setRequestedOrientation(1);
            }
        } else if (orientation >= 60 && orientation <= 120) {
            this.mAttachActivity.setRequestedOrientation(8);
        } else if (orientation >= 240 && orientation <= 300) {
            this.mAttachActivity.setRequestedOrientation(0);
        }
    }

    private void _refreshOrientationEnable() {
        if (!this.mIsForbidOrientation) {
            this.mOrientationListener.disable();
            this.mHandler.removeMessages(10087);
            this.mHandler.sendEmptyMessageDelayed(10087, 3000L);
        }
    }

    private void initOrientationEventListener() {
        this.mOrientationListener = new OrientationEventListener((Context)this.mAttachActivity){

            public void onOrientationChanged(int orientation) {
                IjkPlayerView.this._handleOrientation(orientation);
            }
        };
    }

    public boolean isFullscreen() {
        return this.mIsFullscreen;
    }

    public void fullScreen(int orientation) {
        if (this.changeListener != null) {
            this.changeListener.onChanged(true);
        }
        this._refreshOrientationEnable();
        if (!this.mIsFullscreen) {
            RelativeLayout.LayoutParams fullParams;
            this.originOrientation = this.mAttachActivity.getRequestedOrientation();
            this.orientation = orientation;
            if (orientation == 0) {
                if (this.mAttachActivity.getRequestedOrientation() != 1) {
                    this.mAttachActivity.setRequestedOrientation(1);
                }
            } else if (orientation == 90) {
                if (this.mAttachActivity.getRequestedOrientation() != 8) {
                    this.mAttachActivity.setRequestedOrientation(8);
                }
            } else if (orientation == -90 && this.mAttachActivity.getRequestedOrientation() != 0) {
                this.mAttachActivity.setRequestedOrientation(0);
            }
            this.setNavigationBar(true);
            DisplayMetrics metrics = new DisplayMetrics();
            this.mAttachActivity.getWindowManager().getDefaultDisplay().getMetrics(metrics);
            this.mRawParams = this.getLayoutParams();
            if (this.mRawParams instanceof RelativeLayout.LayoutParams) {
                fullParams = new RelativeLayout.LayoutParams(metrics.widthPixels, metrics.heightPixels);
            } else if (this.mRawParams instanceof LinearLayout.LayoutParams) {
                fullParams = new LinearLayout.LayoutParams(metrics.widthPixels, metrics.heightPixels);
            } else if (this.mRawParams instanceof FrameLayout.LayoutParams) {
                fullParams = new FrameLayout.LayoutParams(metrics.widthPixels, metrics.heightPixels);
            } else {
                new AlertDialog.Builder(this.getContext()).setMessage((CharSequence)"nonsupport parent layout, please do it by yourself").setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int whichButton) {
                    }
                }).setCancelable(false).show();
                return;
            }
            this.setLayoutParams((ViewGroup.LayoutParams)fullParams);
            ViewGroup rootGroup = (ViewGroup)this.mAttachActivity.getWindow().getDecorView().findViewById(0x1020002);
            if (rootGroup instanceof FrameLayout && this.getParent() != rootGroup) {
                ((ViewGroup)this.getParent()).removeView((View)this);
                rootGroup.addView((View)this, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            }
            this._setFullScreen(true);
            if (Build.VERSION.SDK_INT >= 28 && QueryNotchTool.hasNotchInScreen((Activity)this.mAttachActivity)) {
                int statusBarHeight = DeviceInfo.getStatusHeight((Context)this.getContext()) - PdrUtil.pxFromDp((float)10.0f, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics());
                if (orientation == 0) {
                    this.mFullscreenTopBar.setPadding(0, statusBarHeight, 0, 0);
                } else {
                    this.mLlBottomBar.setPadding(statusBarHeight, 0, statusBarHeight, 0);
                    this.mFullscreenTopBar.setPadding(statusBarHeight, 0, statusBarHeight, 0);
                }
            }
        }
    }

    public void exitFullScreen() {
        this._refreshOrientationEnable();
        if (this.changeListener != null) {
            this.changeListener.onChanged(false);
        }
        if (this.mIsFullscreen) {
            if (this.mAttachActivity.getRequestedOrientation() != this.originOrientation) {
                this.mAttachActivity.setRequestedOrientation(this.originOrientation);
            }
            this.setNavigationBar(false);
            this.setLayoutParams(this.mRawParams);
            if (this.getParent() != this.mRootLayout) {
                ((ViewGroup)this.getParent()).removeView((View)this);
                this.mRootLayout.addView((View)this, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            }
            this._setFullScreen(false);
            if (Build.VERSION.SDK_INT >= 28 && QueryNotchTool.hasNotchInScreen((Activity)this.mAttachActivity)) {
                this.mLlBottomBar.setPadding(0, 0, 0, 0);
                this.mFullscreenTopBar.setPadding(0, 0, 0, 0);
            }
        }
    }

    private void setNavigationBar(boolean show) {
        Window window = this.mAttachActivity.getWindow();
        View decorView = window.getDecorView();
        WindowManager.LayoutParams param = window.getAttributes();
        if (!show) {
            decorView.setSystemUiVisibility(this.defaultSystemUI);
            if (QueryNotchTool.hasNotchInScreen((Activity)this.mAttachActivity) && Build.VERSION.SDK_INT >= 28) {
                window.getAttributes().layoutInDisplayCutoutMode = this.defaultDisplayCutoutMode;
            }
        } else {
            this.defaultSystemUI = decorView.getSystemUiVisibility();
            this.mAttachActivity.getWindow().getDecorView().setSystemUiVisibility(5894);
            if (QueryNotchTool.hasNotchInScreen((Activity)this.mAttachActivity) && Build.VERSION.SDK_INT >= 28) {
                this.defaultDisplayCutoutMode = param.layoutInDisplayCutoutMode;
                param.layoutInDisplayCutoutMode = 1;
            }
        }
        window.setAttributes(param);
    }

    public void setScaleType(String aspect) {
        if (this.mVideoView != null) {
            switch (aspect) {
                case "contain": {
                    this.mVideoView.setAspectRatio(0);
                    this.mPlayerThumb.setScaleType(ImageView.ScaleType.FIT_CENTER);
                    break;
                }
                case "fill": {
                    this.mVideoView.setAspectRatio(3);
                    this.mPlayerThumb.setScaleType(ImageView.ScaleType.FIT_XY);
                    break;
                }
                case "cover": {
                    this.mVideoView.setAspectRatio(1);
                    this.mPlayerThumb.setScaleType(ImageView.ScaleType.CENTER_CROP);
                }
            }
        }
    }

    public void playbackRate(String speed) {
        if (this.mVideoView != null) {
            int value = Arrays.binarySearch(this.rates, speed);
            if (value >= 0) {
                this.mVideoView.setSpeed(Float.parseFloat(speed));
            } else {
                this.mVideoView.setSpeed(1.0f);
            }
        }
    }

    private int _setProgress() {
        if (this.mVideoView == null || this.mIsSeeking) {
            return 0;
        }
        int position = Math.max(this.mVideoView.getCurrentPosition(), this.mInterruptPosition);
        int duration = this.getDuration();
        if (duration > 0) {
            long pos = 1000L * (long)position / (long)duration;
            this.mPlayerSeek.setProgress((int)pos);
        }
        int percent = this.mVideoView.getBufferPercentage();
        this.mPlayerSeek.setSecondaryProgress(percent * 10);
        this.mTvCurTime.setText((CharSequence)StringUtils.generateTime(position));
        this.mTvEndTime.setText((CharSequence)StringUtils.generateTime(duration));
        return position;
    }

    private void progressCallBack() {
        if (this.mVideoView == null || this.mIsSeeking || this.mIsBufferingStart) {
            return;
        }
        if (this.mOnPlayerChangedListener != null) {
            float position = Math.max(this.mVideoView.getCurrentPosition(), this.mInterruptPosition);
            float duration = this.getDuration();
            String msg = StringUtil.format((String)this.timeUpdateF, (Object[])new Object[]{Float.valueOf(position / 1000.0f), Float.valueOf(duration / 1000.0f)});
            this.mOnPlayerChangedListener.onChanged("timeupdate", msg);
        }
    }

    private void _setFastForward(String time) {
        if (this.mFlTouchLayout.getVisibility() == 8) {
            this.mFlTouchLayout.setVisibility(0);
        }
        if (this.mTvFastForward.getVisibility() == 8) {
            this.mTvFastForward.setVisibility(0);
        }
        this.mTvFastForward.setText((CharSequence)time);
    }

    private void _hideTouchView() {
        if (this.mFlTouchLayout.getVisibility() == 0) {
            this.mTvFastForward.setVisibility(8);
            this.mTvVolume.setVisibility(8);
            this.mTvBrightness.setVisibility(8);
            this.mFlTouchLayout.setVisibility(8);
        }
    }

    private void _onProgressSlide(float percent) {
        if (this.isRtmpUri) {
            return;
        }
        if (!this.isProgressGesture) {
            return;
        }
        int position = this.mVideoView.getCurrentPosition();
        long duration = this.getDuration();
        long deltaMax = Math.min(100000L, duration / 2L);
        long delta = (long)((float)deltaMax * percent);
        this.mTargetPosition = delta + (long)position;
        if (this.mTargetPosition > duration) {
            this.mTargetPosition = duration;
        } else if (this.mTargetPosition <= 0L) {
            this.mTargetPosition = 0L;
        }
        int deltaTime = (int)((this.mTargetPosition - (long)position) / 1000L);
        String desc = this.mTargetPosition > (long)position ? StringUtils.generateTime(this.mTargetPosition) + "/" + StringUtils.generateTime(duration) : StringUtils.generateTime(this.mTargetPosition) + "/" + StringUtils.generateTime(duration);
        this._setFastForward(desc);
    }

    private void _setVolumeInfo(int volume) {
        if (this.mFlTouchLayout.getVisibility() == 8) {
            this.mFlTouchLayout.setVisibility(0);
        }
        if (this.mTvVolume.getVisibility() == 8) {
            this.mTvVolume.setVisibility(0);
        }
        this.mTvVolume.setText((CharSequence)(volume * 100 / this.mMaxVolume + "%"));
    }

    public void setDuration(int duration) {
        if (this.mIsNeverPlay && !this.isPlaying()) {
            this.duration = duration > 0 ? duration : -1;
        }
    }

    public int getDuration() {
        if (this.duration <= -1) {
            this.duration = this.mVideoView.getDuration();
        }
        return this.duration;
    }

    private void _onVolumeSlide(float percent) {
        int index;
        if (this.isMutePlayer) {
            return;
        }
        if (!this.mIsFullscreen && !this.isPageGesture) {
            return;
        }
        if (this.mIsFullscreen && !this.isFullScreenPageGesture) {
            return;
        }
        if (this.mCurVolume == -1) {
            this.mCurVolume = this.mAudioManager.getStreamVolume(3);
            if (this.mCurVolume < 0) {
                this.mCurVolume = 0;
            }
        }
        if ((index = (int)(percent * (float)this.mMaxVolume) + this.mCurVolume) > this.mMaxVolume) {
            index = this.mMaxVolume;
        } else if (index < 0) {
            index = 0;
        }
        this.mAudioManager.setStreamVolume(3, index, 0);
        this._setVolumeInfo(index);
    }

    public void setLoadingVisibility(boolean visible) {
        this.isLoadingVisibility = visible;
    }

    private void setLoadingVisibility(int visible) {
        this.mLoadingView.setVisibility(this.isLoadingVisibility ? visible : 8);
    }

    public void isUseMediaCodec(boolean isUse) {
        if (this.mVideoView != null) {
            this.mVideoView.setmIsUsingMediaCodec(isUse);
        }
    }

    public void setMutePlayer(boolean isMute) {
        this.isMutePlayer = isMute;
        this.mIVMute.setSelected(this.isMutePlayer);
        this.mVideoView.setvolume(isMute ? 0.0f : 1.0f);
    }

    public boolean isMutePlayer() {
        return this.isMutePlayer;
    }

    private void _setVolume(boolean isIncrease) {
        if (this.isMutePlayer) {
            return;
        }
        int curVolume = this.mAudioManager.getStreamVolume(3);
        curVolume = isIncrease ? (curVolume += this.mMaxVolume / 15) : (curVolume -= this.mMaxVolume / 15);
        if (curVolume > this.mMaxVolume) {
            curVolume = this.mMaxVolume;
        } else if (curVolume < 0) {
            curVolume = 0;
        }
        this.mAudioManager.setStreamVolume(3, curVolume, 0);
        this._setVolumeInfo(curVolume);
        this.mHandler.removeCallbacks(this.mHideTouchViewRunnable);
        this.mHandler.postDelayed(this.mHideTouchViewRunnable, 1000L);
    }

    private void _setBrightnessInfo(float brightness) {
        if (this.mFlTouchLayout.getVisibility() == 8) {
            this.mFlTouchLayout.setVisibility(0);
        }
        if (this.mTvBrightness.getVisibility() == 8) {
            this.mTvBrightness.setVisibility(0);
        }
        this.mTvBrightness.setText((CharSequence)(Math.ceil(brightness * 100.0f) + "%"));
    }

    private void _onBrightnessSlide(float percent) {
        if (!this.mIsFullscreen && !this.isPageGesture) {
            return;
        }
        if (this.mIsFullscreen && !this.isFullScreenPageGesture) {
            return;
        }
        if (this.mCurBrightness < 0.0f) {
            this.mCurBrightness = this.mAttachActivity.getWindow().getAttributes().screenBrightness;
            if (this.mCurBrightness < 0.0f) {
                this.mCurBrightness = 0.5f;
            } else if (this.mCurBrightness < 0.01f) {
                this.mCurBrightness = 0.01f;
            }
        }
        WindowManager.LayoutParams attributes = this.mAttachActivity.getWindow().getAttributes();
        attributes.screenBrightness = this.mCurBrightness + percent;
        if (attributes.screenBrightness > 1.0f) {
            attributes.screenBrightness = 1.0f;
        } else if (attributes.screenBrightness < 0.01f) {
            attributes.screenBrightness = 0.01f;
        }
        this._setBrightnessInfo(attributes.screenBrightness);
        this.mAttachActivity.getWindow().setAttributes(attributes);
    }

    private void _endGesture() {
        if (this.mTargetPosition >= 0L && this.mTargetPosition != (long)this.mVideoView.getCurrentPosition() && this.getDuration() > 0) {
            this.seekTo((int)this.mTargetPosition);
            this.mPlayerSeek.setProgress((int)(this.mTargetPosition * 1000L / (long)this.getDuration()));
            this.mTargetPosition = -1L;
        }
        this._hideTouchView();
        this._refreshHideRunnable();
        this.mCurVolume = -1;
        this.mCurBrightness = -1.0f;
    }

    private void _switchStatus(int status) {
        Log.i((String)"IjkPlayerView", (String)("status " + status));
        switch (status) {
            case 332: 
            case 701: {
                this.mIsBufferingStart = true;
                this._pauseDanmaku();
                if (!this.mIsNeverPlay) {
                    this.setLoadingVisibility(0);
                }
                this.mHandler.removeMessages(10088);
                break;
            }
            case 333: {
                this.mIsReady = true;
                break;
            }
            case 3: {
                this.mIsRenderingStart = true;
            }
            case 702: {
                this.mIsBufferingStart = false;
                this.setLoadingVisibility(8);
                this.mPlayerThumb.setVisibility(8);
                if (this.mLlBottomBar.getVisibility() == 0 && !this.mIsShowBar) {
                    this.mIsShowBar = true;
                }
                this.mHandler.removeMessages(10086);
                this.mHandler.sendEmptyMessage(10086);
                if (!this.mVideoView.isPlaying() || !this.mIsNetConnected) break;
                this.mInterruptPosition = 0;
                this._resumeDanmaku();
                if (this.mIvPlay.isSelected()) break;
                this.mVideoView.start();
                this.mIvPlay.setSelected(true);
                this.mIvPlayCenter.setSelected(true);
                break;
            }
            case 334: {
                this.mHandler.removeMessages(10088);
                if (!this.mIsRenderingStart || this.mIsBufferingStart || this.mVideoView.getCurrentPosition() <= 0) break;
                this._resumeDanmaku();
                break;
            }
            case 331: {
                this.mInterruptPosition = Math.max(this.mVideoView.getInterruptPosition(), this.mInterruptPosition);
                this.pause();
                if (this.mVideoView.getDuration() == -1 && !this.mIsReady) {
                    this.setLoadingVisibility(8);
                    this.mPlayerThumb.setVisibility(8);
                    this.mIvPlayCircle.setVisibility(8);
                    break;
                }
                this.setLoadingVisibility(0);
                this.mHandler.sendEmptyMessage(10088);
                break;
            }
            case 336: {
                this.pause();
                if (this.mVideoView.getDuration() == -1 || this.mVideoView.getInterruptPosition() + 1000 < this.mVideoView.getDuration()) {
                    this.mInterruptPosition = Math.max(this.mVideoView.getInterruptPosition(), this.mInterruptPosition);
                    if (null == this.mOnPlayerChangedListener) break;
                    this.mOnPlayerChangedListener.onChanged("error", "network error");
                    break;
                }
                this.mIsPlayComplete = true;
                if (this.mCompletionListener == null) break;
                this.mCompletionListener.onCompletion(this.mVideoView.getMediaPlayer());
            }
        }
    }

    public void setOnPreparedListener(IMediaPlayer.OnPreparedListener l) {
        this.mVideoView.setOnPreparedListener(l);
    }

    public void setOnCompletionListener(IMediaPlayer.OnCompletionListener l) {
        this.mCompletionListener = l;
    }

    public void setOnErrorListener(IMediaPlayer.OnErrorListener l) {
        this.mVideoView.setOnErrorListener(l);
    }

    public void setOnInfoListener(IMediaPlayer.OnInfoListener l) {
        this.mOutsideInfoListener = l;
    }

    public IjkPlayerView setDanmakuListener(OnDanmakuListener danmakuListener) {
        this.mDanmakuListener = danmakuListener;
        return this;
    }

    public void setOnPlayerChangedListener(OnPlayerChangedListener listener) {
        this.mOnPlayerChangedListener = listener;
    }

    public void setOnBufferingUpdateListener(IMediaPlayer.OnBufferingUpdateListener bufferingUpdateListener) {
        this.bufferingUpdateListener = bufferingUpdateListener;
    }

    public int getCurPosition() {
        return this.mVideoView.getCurrentPosition();
    }

    public void setDirection(int orientation) {
        this.mOrientation = orientation;
    }

    public void setmDanmuList(String mDanmuList) {
        this.mDanmuList = mDanmuList;
    }

    private void _initDanmaku() {
        this.mDanmakuView = (IDanmakuView)this.findViewById(VideoR.VIDEO_IJK_ID_SV_DANMAKU);
        this.mIvDanmakuControl.setOnClickListener((View.OnClickListener)this);
        int oneBtnWidth = this.getResources().getDimensionPixelOffset(VideoR.VIDEO_IJK_DIMEN_DANMAKU_INPUT_BTN_SIZE);
        this.mMoreOptionsWidth = oneBtnWidth * 12;
    }

    private void _loadDanmaku() {
        if (this.mIsEnableDanmaku) {
            this.mDanmakuContext = DanmakuContext.create();
            if (this.mDanmakuParser == null) {
                this.mDanmakuParser = new BaseDanmakuParser(){

                    protected Danmakus parse() {
                        return new Danmakus();
                    }
                };
            }
            try {
                ByteArrayInputStream is = new ByteArrayInputStream(this.mDanmuList.getBytes("utf-8"));
                this.setDanmakuSource(is);
            }
            catch (UnsupportedEncodingException e) {
                return;
            }
            this.mDanmakuView.setCallback(new DrawHandler.Callback(){

                public void prepared() {
                    if (IjkPlayerView.this.mVideoView.isPlaying() && !IjkPlayerView.this.mIsBufferingStart) {
                        IjkPlayerView.this.mDanmakuView.start();
                    }
                }

                public void updateTimer(DanmakuTimer timer) {
                }

                public void danmakuShown(BaseDanmaku danmaku) {
                }

                public void drawingFinished() {
                }
            });
            this.mDanmakuView.enableDanmakuDrawingCache(true);
            this.mDanmakuView.prepare(this.mDanmakuParser, this.mDanmakuContext);
        }
    }

    public IjkPlayerView enableDanmaku() {
        this.mIsEnableDanmaku = true;
        this._initDanmaku();
        return this;
    }

    public void enableDanmaku(boolean isEnable) {
        this.mIsEnableDanmaku = isEnable;
        if (this.mIsEnableDanmaku) {
            this._initDanmaku();
        } else {
            this.mIvDanmakuControl.setVisibility(8);
        }
    }

    public void enableDanmuBtn(boolean isEnable) {
        if (this.mIsEnableDanmaku) {
            if (isEnable) {
                this.mIvDanmakuControl.setVisibility(0);
            } else {
                this.mIvDanmakuControl.setVisibility(8);
            }
        } else {
            this.mIvDanmakuControl.setVisibility(8);
        }
    }

    public IjkPlayerView setDanmakuSource(InputStream stream) {
        if (stream == null) {
            return this;
        }
        if (!this.mIsEnableDanmaku) {
            throw new RuntimeException("Danmaku is disable, use enableDanmaku() first");
        }
        if (this.mDanmakuLoader == null) {
            this.mDanmakuLoader = DanmakuLoaderFactory.create((String)DanmakuLoaderFactory.TAG_ACFUN);
        }
        try {
            this.mDanmakuLoader.load(stream);
        }
        catch (IllegalDataException e) {
            e.printStackTrace();
        }
        IDataSource dataSource = this.mDanmakuLoader.getDataSource();
        this.mDanmakuParser = new StandardDanmaKuParser();
        this.mDanmakuParser.load(dataSource);
        return this;
    }

    public IjkPlayerView setDanmakuSource(String uri) {
        if (TextUtils.isEmpty((CharSequence)uri)) {
            return this;
        }
        if (!this.mIsEnableDanmaku) {
            throw new RuntimeException("Danmaku is disable, use enableDanmaku() first");
        }
        if (this.mDanmakuLoader == null) {
            this.mDanmakuLoader = DanmakuLoaderFactory.create((String)DanmakuLoaderFactory.TAG_BILI);
        }
        try {
            this.mDanmakuLoader.load(uri);
        }
        catch (IllegalDataException e) {
            e.printStackTrace();
        }
        IDataSource dataSource = this.mDanmakuLoader.getDataSource();
        this.mDanmakuParser = new BiliDanmukuParser();
        this.mDanmakuParser.load(dataSource);
        return this;
    }

    public IjkPlayerView setDanmakuCustomParser(BaseDanmakuParser parser, ILoader loader, BaseDanmakuConverter converter) {
        this.mDanmakuParser = parser;
        this.mDanmakuLoader = loader;
        this.mDanmakuConverter = converter;
        return this;
    }

    public IjkPlayerView showOrHideDanmaku(boolean isShow) {
        if (isShow) {
            this.mIvDanmakuControl.setSelected(false);
            this.mDanmakuView.show();
        } else {
            this.mIvDanmakuControl.setSelected(true);
            this.mDanmakuView.hide();
        }
        return this;
    }

    public void sendDanmaku(JSONObject text, boolean isLive) {
        if (!this.mIsEnableDanmaku) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)text.optString("text"))) {
            return;
        }
        if (!this.mDanmakuView.isPrepared()) {
            return;
        }
        BaseDanmaku danmaku = this.mDanmakuContext.mDanmakuFactory.createDanmaku(this.mDanmakuType);
        if (danmaku == null || this.mDanmakuView == null) {
            return;
        }
        if (this.mDanmakuTextSize == -1.0f) {
            this.mDanmakuTextSize = 25.0f * (this.mDanmakuParser.getDisplayer().getDensity() - 0.6f);
        }
        danmaku.text = text.optString("text", "....");
        danmaku.padding = 5;
        danmaku.isLive = isLive;
        danmaku.priority = 0;
        danmaku.textSize = this.mDanmakuTextSize;
        danmaku.textColor = Color.parseColor((String)text.optString("color", "#ffffff"));
        danmaku.setTime(this.mDanmakuView.getCurrentTime() + 500L);
        this.mDanmakuView.addDanmaku(danmaku);
        if (this.mDanmakuListener != null) {
            if (this.mDanmakuConverter != null) {
                this.mDanmakuListener.onDataObtain(this.mDanmakuConverter.convertDanmaku(danmaku));
            } else {
                this.mDanmakuListener.onDataObtain(danmaku);
            }
        }
    }

    public void editVideo() {
        if (this.mVideoView.isPlaying()) {
            this.pause();
            this.mVideoStatus = 502;
        } else {
            this.mVideoStatus = 503;
        }
        this._hideAllView(false);
    }

    public boolean recoverFromEditVideo() {
        if (this.mVideoStatus == 501) {
            return false;
        }
        if (this.mIsFullscreen) {
            this._recoverScreen();
        }
        if (this.mVideoStatus == 502) {
            this.start();
        }
        this.mVideoStatus = 501;
        return true;
    }

    public void clearDanma() {
        if (this.mDanmakuView != null && this.mDanmakuView.isPrepared()) {
            this.mDanmakuView.clearDanmakusOnScreen();
        }
    }

    private void _resumeDanmaku() {
        if (this.mDanmakuView != null && this.mDanmakuView.isPrepared() && this.mDanmakuView.isPaused()) {
            if (this.mDanmakuTargetPosition != -1L) {
                this.mDanmakuView.seekTo(Long.valueOf(this.mDanmakuTargetPosition));
                this.mDanmakuTargetPosition = -1L;
            } else {
                this.mDanmakuView.resume();
            }
        }
    }

    private void _pauseDanmaku() {
        if (this.mDanmakuView != null && this.mDanmakuView.isPrepared()) {
            this.mDanmakuView.pause();
        }
    }

    private void _toggleDanmakuShow() {
        if (this.mIvDanmakuControl.isSelected()) {
            this.showOrHideDanmaku(true);
        } else {
            this.showOrHideDanmaku(false);
        }
    }

    protected void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mOnPlayerChangedListener.onChanged("onConfigurationChanged", null);
    }

    private void _recoverScreen() {
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.isFullscreen() && this.mIsForbidTouch && this.mIvPlayCircle.getVisibility() != 0) {
            return true;
        }
        return super.onInterceptTouchEvent(ev);
    }

    private void _toggleMoreColorOptions() {
    }

    private void _initReceiver() {
        this.mScreenReceiver = new ScreenBroadcastReceiver();
        this.mNetReceiver = new NetBroadcastReceiver();
        this.mAttachActivity.registerReceiver((BroadcastReceiver)this.mScreenReceiver, new IntentFilter("android.intent.action.SCREEN_OFF"));
        this.mAttachActivity.registerReceiver((BroadcastReceiver)this.mNetReceiver, new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE"));
    }

    private class ScreenBroadcastReceiver
    extends BroadcastReceiver {
        private ScreenBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.SCREEN_OFF".equals(intent.getAction())) {
                IjkPlayerView.this.mIsScreenLocked = true;
            }
        }
    }

    public class NetBroadcastReceiver
    extends BroadcastReceiver {
        public void onReceive(Context context, Intent intent) {
            if ("android.net.conn.CONNECTIVITY_CHANGE".equals(intent.getAction())) {
                IjkPlayerView.this.mIsNetConnected = NetWorkUtils.isNetworkAvailable((Context)IjkPlayerView.this.mAttachActivity);
            }
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @Target(value={ElementType.FIELD, ElementType.PARAMETER})
    @IntDef(value={701L, 702L, 703L})
    public static @interface DanmakuTag {
    }
}

